/* TAPE/PVM %W% %G% */

#include <sys/time.h>
#include <stdio.h>
#include "pvm3.h"

#include "tape.h"
#include "tapetask_globals.h"
#include "tape_tags.h"
#include "insert.h"

void usleep(unsigned useconds);


void horloge_reference(struct res_somme **table_machine,int nbh,int nb_ping_pong,
		       int temps_attente, int wsize)

/* table_machine : table with (pointers to) per-machine clock statistics
   nbh           : number of machines (i.e. size of the table)
   nb_ping_pong  : number of message exchanges
   temps_attente : delay in s between 2 successive exchanges
   wsize         : size of smoothing window
*/

{
int i,j;
double X_double,DELTA_double,Y_double;
struct timeval Y_tv, DELTA_tv; 
struct point p;

/* echange de dates entre le host de reference et les autres */
for (i=0;i<nb_ping_pong+wsize-1;i++)
  { 
  for (j=0;j<nbh;j++)
     {
      if (table_machine[j]->dtid != htid)
         {

	 /* do ping-pong with pvm_hostsync */
	 pvm_hostsync(table_machine[j]->dtid,&Y_tv,&DELTA_tv);
	 Y_double=(double)(Y_tv.tv_sec-base_s);
	 Y_double+=((double)Y_tv.tv_usec)/1000000.0;
	 DELTA_double=(double)DELTA_tv.tv_sec;
	 DELTA_double+=((double)DELTA_tv.tv_usec)/1000000.0;
	 X_double=Y_double+DELTA_double;

         /* construct the new sample point */
         p.X=X_double;
         p.Y=Y_double;

         /* smooth the sample by the running median method */
         /* (cf. functions in insert.c)                    */

         if(i<wsize) /* window is not full yet */
            insert_sort(wsize,
                        table_machine[j]->win,
                        table_machine[j]->rnk,
                        p,i);
         else
           insert_point(wsize,       
                        table_machine[j]->win,
                        table_machine[j]->rnk,
                        p);
         if(i>=wsize-1) {
            get_median_point(wsize,table_machine[j]->win,&p);
            /* add median point to statistics */
            table_machine[j]->SX+=p.X;
            table_machine[j]->SY+=p.Y;
            table_machine[j]->SXY+=p.X*p.Y;
            table_machine[j]->SXX+=p.X*p.X; 
            table_machine[j]->SYY+=p.Y*p.Y;
         }     
       }
    }
  usleep(temps_attente*1000000);
  }
}


