/* TAPE/PVM %W% %G% */

/* 260895/maillet: added 'nocompcorrection' function - equivalent to 'correction'
 *                 but for non-compressed buffers
 */

#include "tape.h"

#include <stdio.h>
#include <string.h>
#include <stdlib.h>


/* special event fields */
#define SEC_FIELD_NO 5
#define USEC_FIELD_NO 6

void car_suiv(char *buffer,int *indbf,int *indcar,unsigned char *demi_car,unsigned char *car_cour)
      {
      if((*indcar)++)
         {
	 *demi_car=*car_cour&0xf;
	 *indcar=0;
	 }
      else
	 *demi_car=(unsigned)((*car_cour=buffer[(*indbf)++])&0xf0)>>4;
      }

void champ_suiv(char *buffer,char *champ,int *reel,int *cdc,unsigned char *demi_car,unsigned char *car_cour,int *indcar,int *indbf)
      {
      char C[4];

      strcpy(champ,"");
      *reel=0;
      *cdc=0;
      while(*demi_car<0xe)
         {
         switch(*demi_car)
            {
            case 0:
            printf("Erreur de codage\n");
            break;
            case 3:/* chaine de caracteres */
	    (*cdc)++;
	    *indcar=0;
	    while(buffer[*indbf]!='/'||buffer[*indbf+1]=='/')
	       {
	       int flag;
	       flag=1;
	       if(buffer[*indbf]=='/')
		  flag=2;
	       strncat(champ,(char *)buffer+*indbf,1);
	       *indbf+=flag;
	       }
	    (*indbf)++;
            break;
            case 2:/* reel */
            (*reel)++;
            case 1:/* signe moins */
            default:/* chiffre */
	    *C=*demi_car+',';
	    strncat(champ,C,1);
            }
         car_suiv(buffer,indbf,indcar,demi_car,car_cour);
         }
      }

void correction(char *precevent, char *buffer,int lg,double a,double b,int end_sba1,FILE *F)
   {

     /* precevent: text of last read event. We need this, because the first field
      * of each event is the measured instrumentation delay (in usecs) of the previous
      * event. When writing the events to file, each event is written with its own
      * instrumentation delay
      *
      * buffer: the nibble-encoded event buffer
      * a,b: global clock coefficients
      * F: trace file
      */ 

   int indbf,indev,indcar;
   int reel,cdc;
   unsigned char demi_car,car_cour;
   char champ[300];
   int sec,usec;

   indbf=0;
   indcar=0;
   indev=0;

   while(indbf<lg)
      {
      car_suiv(buffer,&indbf,&indcar,&demi_car,&car_cour);
      champ_suiv(buffer,champ,&reel,&cdc,&demi_car,&car_cour,&indcar,&indbf);

      switch(indev++)
	 {

	 case 0: /* intstrumentation delay of preceeding event */

	   if(strlen(precevent)>0) {
	     fprintf(F,"%ld %s\n", atoi(champ), precevent);
	     precevent[0]='\0';
	   }
	   break;

	 case SEC_FIELD_NO: /* second field of timestamp */

	 if(!reel&&!cdc)
	    sec=atoi(champ);
	 else
	    fprintf(stderr,"Warning: bad format in field 5 (micro seconds).\n");
	 break;

	 case USEC_FIELD_NO: /* usecond field of timestamp */

	 if(!reel&&!cdc)
	    {
	    char timestamp[25];
	    usec=atoi(champ);
	    date_absolue(a,b,&sec,&usec,end_sba1);
	    sprintf(timestamp,"%ld %ld ",sec,usec);
	    strcat(precevent,timestamp);
	    }
	 else
	    fprintf(stderr,"Warning: bad format in field 6 (micro seconds).\n");
	 break;

	 default:  /* any other field */

	 /* fprintf(F,"%s ",champ); */
	 strcat(precevent,champ);
	 strcat(precevent," ");

	 } /* switch */

      if(demi_car==0xf)
	 {
	 /* fputc('\n',F); */
	 indev=0;
	 }
      else
	 if(demi_car!=0xe)
	    fprintf(stderr,"Warning: bad event format.\n");
      }
   }


#define SEPSTR   ":;"           /* field and event separators */
#define INTSTR   "1234567890"   /* characters permitted in integer field */

void nocompcorrection(char *precevent, char *buffer,int lg,double a,double b,int end_sba1,FILE *F)
{
  register int i,fn=0;
  char sep;
  char intflag;  /* flag for integer field */
  int sec,usec; /* seconds and microseconds of event */

  /* if not at end of buffer, fetch next field */

  while(*buffer!='\0') {

    if(!(i=strcspn(buffer,SEPSTR)))
       fprintf(stderr,"Warning: bad event format.\n");

    sep=buffer[i];  /* separator : or ; */
    buffer[i]='\0'; /* nom i = strlen(buffer) */

    intflag=(strspn(buffer,INTSTR)==i);

    switch(fn++) {

    case 0: /* intstrumentation delay of preceeding event */
      
      if(strlen(precevent)>0) {
	fprintf(F,"%ld %s\n", atoi(buffer), precevent);
	precevent[0]='\0';
      }
      break;
      
    case SEC_FIELD_NO:
      /* Field 4: seconds field */
      if(intflag)
	sec=(long)atoi(buffer);
      else
	fprintf(stderr,"Warning: bad format in field 5 (micro seconds).\n");
      break;

    case USEC_FIELD_NO:
      /* Field 5: microseconds field */
      if(intflag) {
	char timestamp[25];
	usec=(long)atoi(buffer);
	date_absolue(a,b,&sec,&usec,end_sba1);
	sprintf(timestamp,"%ld %ld ",sec,usec);
	strcat(precevent,timestamp);
      }
      else
	fprintf(stderr,"Warning: bad format in field 6 (micro seconds).\n");
      break;

    default:
      /* other fields require no transformation and are printed as is */
      /* fprintf(F,"%s ",buffer); */
      strcat(precevent,buffer);
      strcat(precevent," ");

    } /* switch */

    if(sep==';') {  /* end of event */
      /* fputc('\n',F); */
      fn=0;
    }

    buffer+=(i+1); /* goto start of next field */
  } 
}
