/* TAPE/PVM %W% %G% */

#include <stdio.h>
#include <math.h>

#include "tape_clockstats.h"
#include "tapetask_globals.h"
#define dabs(x) ((x)>0 ? (x) : -(x))

#define CLOCKFILENAME "clockstats"

static double STUTAB[] = {
12.706,4.303,3.182,2.776,2.571,2.447,2.365,2.306,2.262,2.228,2.201,
2.179,2.160,2.145,2.131,2.120,2.110,2.101,2.093,2.086,2.080,2.074,
2.069,2.064,2.060,2.056,2.052,2.048,2.045,2.042 
};

double STUDENT(int n)
  /* return t, where P(|Tn|>t)=0.05 */
{
  if(n<=30)
	return STUTAB[n-1];
  else if (n>=30 && n<40)
	return 2.042-(n-30)*0.0021;
  else if (n>=40 && n<80)
	return 2.021-(n-40)*0.000525;
  else if (n>=80 && n<=120)
	return 2.000-(n-80)*0.0005;
  else 
	return 1.960;
}

void calcul_coef_lin (struct res_somme **table_machine,int taille_echant,
                     int nb_host,int tid,int nb_pingpong,int temps_att, int wsize)

/* table_machine : table with (pointer to) per-machine cumulative clock statistics
   taille_echant : number of samples accumulated in res_somme
   nb_host       : number of machines (i.e. size of the table)
   tid           : tid of control task (not used)
   nb_pingpong   : number of message exchanges
   temps_att     : delay in s between 2 successive exchanges
   wsize         : size of smoothing window

   condition     : the data of 'taille_echant' hosts is accumulated in 'table_machine'
   result        : 'table_coef_corel' contains the results of the per-machine
                   clock statistics
*/

{
int i,ref;
char nom[80];
FILE *F;

/* For every machine we compute slope, offset and variances from the
   records in table_machine, the results being stored in table_coef_corel.
   (on the fly least squares regression analysis)
*/

for (i=0;i<nb_host;i++)
  {
  if ( table_machine[i]->dtid != htid )
     /* this is not the reference machine */
  {
  table_coef_corel[i].dtid=table_machine[i]->dtid;
  table_coef_corel[i].pente=(table_machine[i]->SXY
	-table_machine[i]->SX*table_machine[i]->SY/(double) taille_echant)
      /(table_machine[i]->SXX
	-table_machine[i]->SX*table_machine[i]->SX/(double) taille_echant);

  table_coef_corel[i].origine=(table_machine[i]->SY
        -table_coef_corel[i].pente*table_machine[i]->SX)/(double) taille_echant;

  table_coef_corel[i].sigma2=(table_machine[i]->SYY
	 -2*table_coef_corel[i].origine*table_machine[i]->SY
	 -2*table_coef_corel[i].pente*table_machine[i]->SXY
	 +taille_echant*table_coef_corel[i].origine*table_coef_corel[i].origine
	 +2*table_coef_corel[i].pente*table_coef_corel[i].origine*table_machine[i]->SX
	 +table_coef_corel[i].pente*table_coef_corel[i].pente*table_machine[i]->SXX)
      /(double)taille_echant;

  table_coef_corel[i].var_pente=table_coef_corel[i].sigma2
      /(table_machine[i]->SXX
	 -table_machine[i]->SX*table_machine[i]->SX/(double)taille_echant);

  table_coef_corel[i].var_origine=table_coef_corel[i].sigma2
      *(1/(double)taille_echant
	 +((table_machine[i]->SX*table_machine[i]->SX
	    /((double)taille_echant*taille_echant))
            /(table_machine[i]->SXX
	       -table_machine[i]->SX*table_machine[i]->SX/(double)taille_echant)));
  }
  else
     /* this is the reference machine whose clock is perfect */
  {
  table_coef_corel[i].dtid=htid;
  table_coef_corel[i].pente=1.0;
  table_coef_corel[i].origine=0.0;
  table_coef_corel[i].sigma2=0.0;
  table_coef_corel[i].var_pente=0.0;
  table_coef_corel[i].var_origine=0.0;
  ref=i;
  }
}
 
/* store clock statistics into a file */
/* current directory has been set to the tape directory (see tape_control.c) */

if(!(F=fopen(CLOCKFILENAME,"w"))) {
 fprintf(stderr,"[tape_control] warning, cannot open %s, using stdout instead\n",
         CLOCKFILENAME);
 F=stdout;
}

  /* write header */
fprintf(F,"********************* TAPE/PVM - SBA Clock Statistics *******************************\n\n");
fprintf(F,"Reference machine         : %s\n",table_machine[ref]->name);
fprintf(F,"Length of sample period   : %d secs\n",temps_att*(nb_pingpong+wsize-2));
fprintf(F,"Size of sample            : %d\n",nb_pingpong);
fprintf(F,"Window size for r. median : %d\n\n",wsize);
fprintf(F,"Machine   |    Slope    | 95%% ConfInt | %%Err  |   Offset     | 95%% ConfInt |   %%Err |\n");
fprintf(F,"-------------------------------------------------------------------------------------\n");

  /* write per-host statistics */

for(i=0;i<nb_host;i++)
   {

   if(i==ref) /* reference machine */
     fprintf(F,"%-9.9s | %11.8f | %11.8f | %5.2f |  %11.6f | %11.6f | %6.2f |\n",
       table_machine[i]->name,1.0,0.0,0.0,0.0,0.0,0.0);
   else {

     double pente_conf95   /* 95% confidence interval on slope */

	= STUDENT(taille_echant-2)*sqrt(table_coef_corel[i].sigma2)*taille_echant
                                            /
          (taille_echant*table_machine[i]->SXX-pow(table_machine[i]->SX/taille_echant,2.0));

     double origine_conf95 /* 95% confidence interval on offset */

	= STUDENT(taille_echant-2)*sqrt(table_coef_corel[i].sigma2)*
          sqrt( 1.0/taille_echant +
                taille_echant*pow(table_machine[i]->SX/taille_echant,2.0)
                                         /
                (taille_echant*table_machine[i]->SXX-pow(table_machine[i]->SX/taille_echant,2.0))
              );

     fprintf(F,"%-9.9s | %11.8f | %11.8f | %5.2f |  %11.6f | %11.6f | %6.2f |\n",
       table_machine[i]->name,
       table_coef_corel[i].pente,
       pente_conf95, 
       (pente_conf95/table_coef_corel[i].pente)*100, 
       table_coef_corel[i].origine, 
       origine_conf95,
       (origine_conf95/dabs(table_coef_corel[i].origine))*100);
    }
   }
fprintf(F,"\n");
if(F!=stdout) fclose(F);
}
