
#include "pvm3.h"
#include "Tpvm3.h"
#include "pvm_consts.h"

void
FUNCTION(tpvmfaddhost) ARGS(`file, line, masc, STRING_ARG(host), info')
STRING_ARG_DECL(host);
int *info;
int *file, *line, *masc;
{
	int  dtid;
	char thost[MAX_HOST_NAME + 1];
	char *ptr = thost;

	/*
	 * Copy the host name to make sure there's
	 * a NUL at the end.
	 */
	if (ftocstr(thost, sizeof(thost), STRING_PTR(host), STRING_LEN(host))) {
		*info = PvmBadParam;
		return;
	}

	*info = Tpvm_addhosts(*file, *line, *masc, &ptr, 1, &dtid);
	if (*info >= 0)
		*info = dtid;
}

