/* Fortran interface for the TAPE/PVM utility routines routines */
/* For phase names, conditions are the same than for PVM group names */

#include "pvm3.h"
#include "pvm_consts.h"

#include "tape.h"

void
FUNCTION(tapefopenphase) ARGS(`file, line, mask, STRING_ARG(name), phase')
STRING_ARG_DECL(name);
int *file, *line, *mask, *phase;
{
        char tgroup[MAX_GRP_NAME + 1];
 
        /*
         * Copy the group name to make sure there's
         * a NUL at the end.
         */
        if (ftocstr(tgroup, sizeof(tgroup), STRING_PTR(name), STRING_LEN(name))){
                *phase = PvmBadParam;
                return;
      }

	*phase = tape_open_phase(*file,*line,*mask,tgroup);
}

void
FUNCTION(tapefclosephase) ARGS(`file, line, mask, phase, res')
int *file, *line, *mask, *phase, *res;
{
	*res = tape_close_phase(*file, *line, *mask, *phase);
}

void
FUNCTION(tapefsetmask) ARGS(`file, line, mask, STRING_ARG(n_mask),ret')
STRING_ARG_DECL(n_mask);
int *file, *line, *mask, *ret;
{
        char tgroup[MAX_GRP_NAME + 1];
 
        /*
         * Copy the group name to make sure there's
         * a NUL at the end.
         */
        if (ftocstr(tgroup, sizeof(tgroup), STRING_PTR(n_mask), STRING_LEN(n_mask))){
                return;
      }

	*ret=tape_set_mask(*file, *line, *mask, tgroup);
}

void
FUNCTION(tapefgetmask) ARGS(`mask')
char *mask;
{
	tape_get_mask( mask );
}

