/* TAPE/PVM %W% %G% */

/* 9505 maillet added Tpvm_trecv
   9506 maillet added Tpvm_precv
   9506 maillet added Tpvm_psend
 */

#include <sys/time.h>

#include "pvm3.h"

#include "tape.h"
#include "tape_globals.h"
#include "tape_events.h"
#include "tape_classes.h"

#define masc_pvm classe_msg

/* pvm_recv: when tracing pvm_recv, we want to know from the resulting
   event whether the message has already arrived or not. Therefore 
   we first call pvm_nrecv.
 */

int Tpvm_recv(int numfile, int numline, int masc, int tid, int code)
{
int ret;
int bytes=0;
int arrived=0;
struct timeval tp,tp2, tp3;

if((masc&(mselect>>nb_classe))&&(masc_pvm&mselect))
   {
     tape_clock(&tp);

     ret = pvm_nrecv(tid,code);
     if(ret==0)
       ret = pvm_recv(tid,code);
     else
       arrived=1;

     tape_clock(&tp2); tape_clock(&tp3);
     tape_clockdiff(&tp2,&tp);

     if(ret>0)
       pvm_bufinfo(ret,&bytes,&code,&tid);
     
     tape_event(event_recv,taskid,numfile,numline,tp.tv_sec-base_s,tp.tv_usec,
		"%d %d %d %d %d %d %d",ret,arrived,tp2.tv_sec,tp2.tv_usec,
		tid,code,bytes);
     tape_clock(&tp2);
     tape_clockdiff(&tp2,&tp3);
     tape_perturb=tp2.tv_sec*1000000+tp2.tv_usec+tape_minpert;
   }
else
  ret = pvm_recv(tid,code);

return ret;
}

/* pvm_precv: generates the same event as pvm_recv. I use
   pvm_probe to test if message present before the blocking
   call.
 */

int Tpvm_precv(int numfile, int numline, int masc, 
               int tid, int code, char *buf, int len, int datatype,
	       int *atid, int *atag, int *alen)
{
int ret;
int bytes=0;
int arrived;
struct timeval tp,tp2;

if((masc&(mselect>>nb_classe))&&(masc_pvm&mselect))
   {

     tape_clock(&tp);

     /* the following two statements should execute atomically */

     arrived = ( pvm_probe(tid,code)>0 ? 1 : 0 );
     ret = pvm_precv(tid,code,buf,len,datatype,atid,atag,alen);

     tape_clock(&tp2);
     tape_clockdiff(&tp2,&tp);

     tape_event(event_precv,taskid,numfile,numline,tp.tv_sec-base_s,tp.tv_usec,
		"%d %d %d %d %d %d %d",ret,arrived,tp2.tv_sec,tp2.tv_usec,
		*atid,*atag,*alen);
   }
else
  ret = pvm_precv(tid,code,buf,len,datatype,atid,atag,alen);

return ret;
}

int Tpvm_send (int numfile, int numline, int masc, int tid, int code)
{
struct timeval tp,tp2,tp3;
int ret;
int bytes;
int bufid;

if((masc&(mselect>>nb_classe))&&(masc_pvm&mselect)) 
  {
    tape_clock(&tp);
    
    ret=pvm_send(tid,code); 
    
    tape_clock(&tp2); tape_clock(&tp3);
    tape_clockdiff(&tp2,&tp);
    
    bufid = pvm_getsbuf();
    pvm_bufinfo(bufid,&bytes,0,0);
    
    tape_event(event_send,taskid,numfile,numline,tp.tv_sec-base_s,tp.tv_usec,
	       "%d %d %d %d %d %d",ret,tid,tp2.tv_sec,tp2.tv_usec,code,bytes);
    tape_clock(&tp2);
    tape_clockdiff(&tp2,&tp3);
    tape_perturb=tp2.tv_sec*1000000+tp2.tv_usec+tape_minpert;
  }
else
  ret=pvm_send(tid,code); 

return(ret); 
}

/* pvm_psend: generates the same event as pvm_send */ 

int Tpvm_psend (int numfile, int numline, int masc,
                int tid, int code, char *buf, int len, int datatype)
{
struct timeval tp,tp2;
int ret;
int bytes;
int bufid;

if((masc&(mselect>>nb_classe))&&(masc_pvm&mselect)) 
  {
    tape_clock(&tp);
    
    ret=pvm_psend(tid,code,buf,len,datatype); 
    
    tape_clock(&tp2);
    tape_clockdiff(&tp2,&tp);
    
    bufid = pvm_getsbuf();
    pvm_bufinfo(bufid,&bytes,0,0);
    
    tape_event(event_send,taskid,numfile,numline,tp.tv_sec-base_s,tp.tv_usec,
	       "%d %d %d %d %d %d",ret,tid,tp2.tv_sec,tp2.tv_usec,code,bytes);
  }
else
  ret=pvm_psend(tid,code,buf,len,datatype); 

return(ret); 
}

int Tpvm_mcast( int numfile, int numline, int masc, int *tids, 
                int count, int code)
{
  struct timeval tp, tp2;
  struct tableau table;
  int ret;
  int bytes;
  int bufid;
  
  if((masc&(mselect>>nb_classe))&&(masc_pvm&mselect))
    {
      tape_clock(&tp);

      ret = pvm_mcast (tids,count,code);

      tape_clock(&tp2);
      tape_clockdiff(&tp2,&tp);
      
      table.num = count;
      table.tab = tids;
      bufid = pvm_getsbuf();
      pvm_bufinfo(bufid,&bytes,0,0); 
      tape_event(event_mcast,taskid,numfile,numline,
		 tp.tv_sec-base_s,tp.tv_usec,
		 "%d %d %d %d %d %d %t",
		 ret,tp2.tv_sec,tp2.tv_usec,code,bytes,count,&table);
    }
  else
    ret = pvm_mcast (tids,count,code);

  return(ret);
}

int Tpvm_nrecv( int numfile, int numline, int masc, int tid, int code )
{
struct timeval tp, tp2;
int ret;
int bytes;

if((masc&(mselect>>nb_classe))&&(masc_pvm&mselect)) {

  tape_clock(&tp);
  ret = pvm_nrecv (tid,code);
  tape_clock(&tp2);
  tape_clockdiff(&tp2,&tp);

  if(ret<=0) { /* error or msg not arrived */
    bytes=0;
  }
  else {
    pvm_bufinfo(ret,&bytes,&code,&tid);
  }
  tape_event(event_nrecv,taskid,numfile,numline,tp.tv_sec-base_s,tp.tv_usec,
	     "%d %d %d %d %d %d",ret,tp2.tv_sec,tp2.tv_usec,tid,code,bytes);
}
else
  ret = pvm_nrecv (tid,code);

return(ret);
}

#ifndef pvm3_2_6
int Tpvm_trecv( int numfile, int numline, int masc, int tid, int code,
                struct timeval *tmout )
{
struct timeval tp, tp2;
int ret;
int bytes;

if((masc&(mselect>>nb_classe))&&(masc_pvm&mselect)) {

  tape_clock(&tp);
  ret = pvm_trecv (tid,code,tmout);
  tape_clock(&tp2);
  tape_clockdiff(&tp2,&tp);

  if(ret<=0) { /* error or time-out */
    bytes=0;
  }
  else {
    pvm_bufinfo(ret,&bytes,&code,&tid);
  }
  tape_event(event_trecv,taskid,numfile,numline,tp.tv_sec-base_s,tp.tv_usec,
	     "%d %d %d %d %d %d",ret,tp2.tv_sec,tp2.tv_usec,tid,code,bytes);
}
else
  ret = pvm_trecv (tid,code,tmout);

return(ret);
}
#endif

#ifdef pvm3_2_6
int Tpvm_serror(int numfile,int numline,int masc,int how)
{
int ret;
struct timeval tp;

if((masc&(mselect>>nb_classe))&&(masc_pvm&mselect)) {

  tape_clock(&tp);
  ret = pvm_serror(how);
  
  tape_event(event_serror,taskid,numfile,numline,tp.tv_sec-base_s,tp.tv_usec,
	     "%d %d",ret,how);
}
else
  ret = pvm_serror(how);

return ret;
}
#endif

#ifndef SP1
int (*Tpvm_recvf(int numfile,int numline,int masc,int (*newf)(int, int, int)))()
{
int (*ret)();
struct timeval tp;

if ((masc&(mselect>>nb_classe))&&(masc_pvm&mselect)) {

  tape_clock(&tp);
  ret=pvm_recvf(newf);

  tape_event(event_recvf,taskid,numfile,numline,tp.tv_sec-base_s,tp.tv_usec,
	     NULL);
}
else
  ret=pvm_recvf(newf);

return(ret);
}
#endif

int Tpvm_probe(int numfile,int numline,int masc,int tid, int code)
{
struct timeval tp;
int ret;

if ((masc&(mselect>>nb_classe))&&(masc_pvm&mselect)) {

  tape_clock(&tp);
  ret=pvm_probe(tid,code);
  
  tape_event(event_probe,taskid,numfile,numline,tp.tv_sec-base_s,tp.tv_usec,
	     "%d %d %d",ret,tid,code);
}
else
  ret=pvm_probe(tid,code);

return(ret);
}
