/* TAPE/PVM %W% %G% */

#include <sys/time.h>

#include "pvm3.h"

#include "tape.h"
#include "tape_globals.h"
#include "tape_events.h"
#include "tape_classes.h"

#define masc_pvm classe_inconnu

int Tpvm_getfds(int numfile,int numline,int masc,int **fds)
{
int ret;
struct timeval tp;

if((masc&(mselect>>nb_classe))&&(masc_pvm&mselect)) {
  
  tape_clock(&tp);
  ret=pvm_getfds(fds);

  tape_event(event_getfds,taskid,numfile,numline,tp.tv_sec-base_s,tp.tv_usec,
	     "%d",ret);
}
else
  ret=pvm_getfds(fds);

return ret;
}

int Tpvm_insert(int numfile,int numline,int masc,char *name,int req,int data)
{
int ret;
struct timeval tp;

if((masc&(mselect>>nb_classe))&&(masc_pvm&mselect)) {

  tape_clock(&tp);
  ret=pvm_insert(name,req,data);

  tape_event(event_insert,taskid,numfile,numline,tp.tv_sec-base_s,tp.tv_usec,
	     "%d %d %d",ret,req,data);
}
else
  ret=pvm_insert(name,req,data);

return ret;
}

int Tpvm_delete(int numfile,int numline,int masc,char *name,int req )
{
int ret;
struct timeval tp;

if((masc&(mselect>>nb_classe))&&(masc_pvm&mselect)) {

  tape_clock(&tp);
  ret=pvm_delete(name,req);

  tape_event(event_delete,taskid,numfile,numline,tp.tv_sec-base_s,tp.tv_usec,
	     "%d %d",ret,req);
}
else
  ret=pvm_delete(name,req);

return ret;
}

int Tpvm_halt(int numfile,int numline,int masc)
{
int ret;
struct timeval tp;

if((masc&(mselect>>nb_classe))&&(masc_pvm&mselect)) {

  tape_clock(&tp);
  ret=pvm_halt();

  tape_event(event_halt,taskid,numfile,numline,tp.tv_sec-base_s,tp.tv_usec,
	     "%d",ret);
}
else
  ret=pvm_halt();

return ret;
}

int Tpvm_lookup(int numfile,int numline,int masc,char *name,int req,int *datap)
{
int ret;
struct timeval tp;

if((masc&(mselect>>nb_classe))&&(masc_pvm&mselect)) {

  tape_clock(&tp);
  ret=pvm_lookup(name,req,datap);

  tape_event(event_lookup,taskid,numfile,numline,tp.tv_sec-base_s,tp.tv_usec,
	     "%d %d",ret,req);
}
else
  ret=pvm_lookup(name,req,datap);

return ret;
}

int Tpvm_mstat(int numfile,int numline,int masc,char *host)
{
int ret;
struct timeval tp;

if((masc&(mselect>>nb_classe))&&(masc_pvm&mselect)) {

  tape_clock(&tp);
  ret=pvm_mstat(host);

  tape_event(event_mstat,taskid,numfile,numline,tp.tv_sec-base_s,tp.tv_usec,
	     "%d",ret);
}
else
  ret=pvm_mstat(host);

return ret;
}

#ifdef pvm3_2_6
int Tpvm_setdebug(int numfile,int numline,int masc,int mask)
{
int ret;
struct timeval tp;

if((masc&(mselect>>nb_classe))&&(masc_pvm&mselect)) {

  tape_clock(&tp);
  ret = pvm_setdebug(mask);

  tape_event(event_setdebug,taskid,numfile,numline,tp.tv_sec-base_s,tp.tv_usec,
	     "%d %d",ret,mask);
}
else
  ret = pvm_setdebug(mask);

return ret;
}
#endif

int Tpvm_setopt(int numfile,int numline,int masc, int opt, int val)
{
  int ret;
  struct timeval tp;
  
  if((masc&(mselect>>nb_classe))&&(masc_pvm&mselect)) {
    
    tape_clock(&tp);
    ret = pvm_setopt(opt, val);

    tape_event(event_setopt,taskid,numfile,numline,tp.tv_sec-base_s,tp.tv_usec,
	       "%d %d %d",ret,opt,val); 
  }
  else
    ret = pvm_setopt(opt, val);

  return ret;
}

int Tpvm_start_pvmd(int numfile,int numline,int masc,int argc,char **argv,int block)
{
int ret;
struct timeval tp;

if((masc&(mselect>>nb_classe))&&(masc_pvm&mselect)) {

  tape_clock(&tp);
  ret = pvm_start_pvmd(argc,argv,block);

  tape_event(event_start_pvmd,taskid,numfile,numline,tp.tv_sec-base_s,tp.tv_usec,
	     "%d %d",ret,block);
}
else
  ret = pvm_start_pvmd(argc,argv,block);

return ret;
}

int Tpvm_tickle(int numfile,int numline,int masc,int narg, int *argp,int *nresp,int *resp)
{
int ret;
struct timeval tp;

if((masc&(mselect>>nb_classe))&&(masc_pvm&mselect)) {

  tape_clock(&tp);
  ret = pvm_tickle(narg,argp,nresp,resp);

  tape_event(event_tickle,taskid,numfile,numline,tp.tv_sec-base_s,tp.tv_usec,
	     "%d %d %d",ret,narg,*nresp);
}
else
  ret = pvm_tickle(narg,argp,nresp,resp);

return ret;
}

char *Tpvm_version(int numfile,int numline,int masc)
{
char *ret;
struct timeval tp;

if((masc&(mselect>>nb_classe))&&(masc_pvm&mselect)) {

  tape_clock(&tp);
  ret = pvm_version();

  tape_event(event_version,taskid,numfile,numline,tp.tv_sec-base_s,tp.tv_usec,
	     "%d",ret);
}
else
  ret = pvm_version();

return ret;
}

