/* TAPE/PVM %W% %G% */

#include <sys/time.h>
#include <stdlib.h>
#include <string.h>

#include "pvm3.h"

#include "tape.h"
#include "tape_globals.h"
#include "tape_events.h"
#include "tape_classes.h"
#include "tape_tags.h"

#define masc_pvm classe_control

/* probe always active */

int Tpvm_mytid(int numfile, int numline, int masc)
{
int ret;
struct timeval tp;

tape_clock(&tp);
/* init_tid(&ret); */
ret=taskid;
tape_event(event_mytid,taskid,numfile,numline,tp.tv_sec-base_s,tp.tv_usec,
	   "%d",ret);
return ret;
}

/* probe always active */

int Tpvm_spawn(int numfile, int numline, int masc, char *task, char **argv,
	int flag, char *where, int ntask, int *tids)
{
int ret,i;
struct timeval tp;
char *file;
struct tableau table;

if(pvm_actif)
{
tape_clock(&tp);

 /* spawn instrumented executable */

if( ! ( file = malloc(strlen(task)+2) ) )
  fatalMallocFailure(__FILE__, __LINE__);
strcpy(file,task);
if (strcmp(file + strlen(file) - 2, "_t")) {
    strcpy(file+strlen(task),"_t");
}
ret = pvm_spawn(file,argv,flag,where,ntask,tids);
free(file);

 /* send TAPE/PVM operating parameters to new tasks */

for(i=0;i<ret;i++)
  tape_send_params(tids[i],
		   buffer_size,
		   max_phase,
		   base_s,
		   control,
		   mselect,
		   tape_compact);

 /* inform tape_control about new successful spawns */

if(ret>0)
  tape_notify_control(ret);

if((masc&(mselect>>nb_classe))&&(masc_pvm&mselect))
   {
   table.num=ntask;
   table.tab=tids;
   tape_event(event_spawn,taskid,numfile,numline,tp.tv_sec-base_s,tp.tv_usec,
	      "%d %d %d %t",ret,flag,ntask,&table);
   }
return ret;
}
else return 0;
}

int Tpvm_kill(int numfile, int numline, int masc, int tid)
{
int ret;
struct timeval tp;
int buf,oldbuf;

if(pvm_actif)
{
tape_clock(&tp);
buf=pvm_mkbuf(0);
oldbuf=pvm_setsbuf(buf);
pvm_send(control,msgtag_kill);
pvm_freebuf(buf);
pvm_setsbuf(oldbuf);
ret = pvm_kill(tid);
if((masc&(mselect>>nb_classe))&&(masc_pvm&mselect))
   tape_event(event_kill,taskid,numfile,numline,tp.tv_sec-base_s,tp.tv_usec,
	      "%d %d",ret,tid);
return ret;
}
else return 0;
}

/* probe always active */

int Tpvm_exit(int numfile, int numline, int masc)
{
struct timeval tp;
int pvma=pvm_actif;

tape_clock(&tp);
/* if((masc&(mselect>>nb_classe))&&(masc_pvm&mselect)) */
   tape_event(event_exit,taskid,numfile,numline,tp.tv_sec-base_s,tp.tv_usec,NULL);

/* 
 * numfile==SIGHANDLER <=> we are called by the signal handler
 */

tape_end(numfile);

#ifdef DEBUG
printf("tape_end finished\n");
#endif

if(pvm_parent()<0 && pvma) { 

  /* master prints name of tracefile */

  printf("\n");
  printf("[tape] Events have been collected by control task %x.\n", control );

}

return(pvm_exit());
}

int Tpvm_notify(int numfile, int numline, int masc,int what,int code,int count,int *vals)
{
int ret;
struct timeval tp;

if((masc&(mselect>>nb_classe))&&(masc_pvm&mselect)) {

  tape_clock(&tp);
  ret=pvm_notify(what,code,count,vals);

  tape_event(event_notify,taskid,numfile,numline,tp.tv_sec-base_s,tp.tv_usec,
	     "%d %d %d %d",ret,what,code,count);
}
else
  ret=pvm_notify(what,code,count,vals);

return ret;
}

int Tpvm_sendsig(int numfile, int numline, int masc,int tid,int signum)
{
int ret;
struct timeval tp;

if((masc&(mselect>>nb_classe))&&(masc_pvm&mselect)) {

  tape_clock(&tp);
  ret=pvm_sendsig(tid,signum);

  tape_event(event_sendsig,taskid,numfile,numline,tp.tv_sec-base_s,tp.tv_usec,
	     "%d",ret);
}
else
  ret=pvm_sendsig(tid,signum);

return ret;
}

