/* TAPE/PVM %W% %G% */

#include <sys/time.h>
/* #include <stdarg.h> */
#include "pvm3.h"

#include "tape.h"
#include "tape_globals.h"
#include "tape_events.h"
#include "tape_classes.h"

#define masc_pvm classe_buffer

/* BEGIN: NOT SUPPORTED
int Tpvm_unpackf(int numfile,int numline,int masc,char *cp, int nitem, int stride)
{
struct timeval tp;
int ret;

tape_clock(&tp);
ret=pvm_upkbyte(cp,nitem,stride);
if((masc&(mselect>>nb_classe))&&(masc_pvm&mselect))
   tape_event(event_upkbyte,taskid,numfile,numline,tp.tv_sec-base_s,tp.tv_usec,
              "%d %d %d",ret,nitem,stride);
return(ret);
}
END: NOT SUPPORTED */

int Tpvm_upkbyte(int numfile,int numline,int masc,char *cp, int nitem, int stride)
{
struct timeval tp,tp2;
int ret;

if((masc&(mselect>>nb_classe))&&(masc_pvm&mselect)) {

  tape_clock(&tp);

  ret=pvm_upkbyte(cp,nitem,stride);

  tape_clock(&tp2);
  tape_clockdiff(&tp2,&tp);

  tape_event(event_upkbyte,taskid,numfile,numline,tp.tv_sec-base_s,tp.tv_usec,
	     "%d %d %d %d %d",ret,tp2.tv_sec,tp2.tv_usec,nitem,stride);
}
else
  ret=pvm_upkbyte(cp,nitem,stride);

return(ret);
}

int Tpvm_upkcplx(int numfile,int numline,int masc,float *xp,int nitem,int stride)
{
struct timeval tp, tp2;
int ret;

if((masc&(mselect>>nb_classe))&&(masc_pvm&mselect)) {

  tape_clock(&tp);
  
  ret=pvm_upkcplx(xp,nitem,stride);

  tape_clock(&tp2);
  tape_clockdiff(&tp2,&tp);

  tape_event(event_upkcplx,taskid,numfile,numline,tp.tv_sec-base_s,tp.tv_usec,
	     "%d %d %d %d %d",ret,tp2.tv_sec,tp2.tv_usec,nitem,stride);
}
else
  ret=pvm_upkcplx(xp,nitem,stride);

return(ret);
}

int Tpvm_upkdcplx(int numfile,int numline,int masc,double *zp,int nitem,int stride)
{
struct timeval tp,tp2;
int ret;

if((masc&(mselect>>nb_classe))&&(masc_pvm&mselect)) {

  tape_clock(&tp);

  ret=pvm_upkdcplx(zp,nitem,stride);

  tape_clock(&tp2);
  tape_clockdiff(&tp2,&tp);
  
  tape_event(event_upkdcplx,taskid,numfile,numline,tp.tv_sec-base_s,tp.tv_usec,
	     "%d %d %d %d %d",ret,tp2.tv_sec,tp2.tv_usec,nitem,stride);
}
else
  ret=pvm_upkdcplx(zp,nitem,stride);

return(ret);
}

int Tpvm_upkdouble(int numfile,int numline,int masc,double *dp,int nitem,int stride)
{
struct timeval tp,tp2;
int ret;

if((masc&(mselect>>nb_classe))&&(masc_pvm&mselect)) {

  tape_clock(&tp);

  ret=pvm_upkdouble(dp,nitem,stride);

  tape_clock(&tp2);
  tape_clockdiff(&tp2,&tp);

  tape_event(event_upkdouble,taskid,numfile,numline,tp.tv_sec-base_s,tp.tv_usec,
	     "%d %d %d %d %d",ret,tp2.tv_sec,tp2.tv_usec,nitem,stride);
}
else
  ret=pvm_upkdouble(dp,nitem,stride);

return(ret);
}

int Tpvm_upkfloat(int numfile,int numline,int masc,float *fp,int nitem,int stride)
{
struct timeval tp,tp2;
int ret;

if((masc&(mselect>>nb_classe))&&(masc_pvm&mselect)) {

  tape_clock(&tp);

  ret=pvm_upkfloat(fp,nitem,stride);

  tape_clock(&tp2);
  tape_clockdiff(&tp2,&tp);

  tape_event(event_upkfloat,taskid,numfile,numline,tp.tv_sec-base_s,tp.tv_usec,
	     "%d %d %d %d %d",ret,tp2.tv_sec,tp2.tv_usec,nitem,stride);
}
else
  ret=pvm_upkfloat(fp,nitem,stride);

return(ret);
}

int Tpvm_upkint(int numfile, int numline, int masc, int *np, int nitem, int stride)
{
struct timeval tp,tp2;
int ret;

if((masc&(mselect>>nb_classe))&&(masc_pvm&mselect)) {

  tape_clock(&tp);

  ret=pvm_upkint(np,nitem,stride);

  tape_clock(&tp2);
  tape_clockdiff(&tp2,&tp);

  tape_event(event_upkint,taskid,numfile,numline,tp.tv_sec-base_s,tp.tv_usec,
	     "%d %d %d %d %d",ret,tp2.tv_sec,tp2.tv_usec,nitem,stride);
}
else
  ret=pvm_upkint(np,nitem,stride);

return(ret);
}

int Tpvm_upklong(int numfile,int numline,int masc,long *np,int nitem,int stride )
{
struct timeval tp,tp2;
int ret;

if((masc&(mselect>>nb_classe))&&(masc_pvm&mselect)) {

  tape_clock(&tp);

  ret=pvm_upklong(np,nitem,stride);

  tape_clock(&tp2);
  tape_clockdiff(&tp2,&tp);

  tape_event(event_upklong,taskid,numfile,numline,tp.tv_sec-base_s,tp.tv_usec,
	     "%d %d %d %d %d",ret,tp2.tv_sec,tp2.tv_usec,nitem,stride);
}
else
  ret=pvm_upklong(np,nitem,stride);

return(ret);
}

int Tpvm_upkshort(int numfile,int numline,int masc,short *np,int nitem,int stride)
{
struct timeval tp,tp2;
int ret;

if((masc&(mselect>>nb_classe))&&(masc_pvm&mselect)) {

  tape_clock(&tp);

  ret=pvm_upkshort(np,nitem,stride);

  tape_clock(&tp2);
  tape_clockdiff(&tp2,&tp);

  tape_event(event_upkshort,taskid,numfile,numline,tp.tv_sec-base_s,tp.tv_usec,
	     "%d %d %d %d %d",ret,tp2.tv_sec,tp2.tv_usec,nitem,stride);\
}
else
  ret=pvm_upkshort(np,nitem,stride);

return(ret);
}

int Tpvm_upkstr(int numfile,int numline,int masc,char *cp)
{
struct timeval tp,tp2;
int ret;

if((masc&(mselect>>nb_classe))&&(masc_pvm&mselect)) {

  tape_clock(&tp);

  ret=pvm_upkstr(cp);

  tape_clock(&tp2);
  tape_clockdiff(&tp2,&tp);

  tape_event(event_upkstr,taskid,numfile,numline,tp.tv_sec-base_s,tp.tv_usec,
	     "%d %d %d",ret,tp2.tv_sec,tp2.tv_usec);
}
else
  ret=pvm_upkstr(cp);

return(ret);
}

int Tpvm_upkuint(int numfile,int numline,int masc,unsigned int *np,int nitem,int stride)
{
struct timeval tp,tp2;
int ret;

if((masc&(mselect>>nb_classe))&&(masc_pvm&mselect)) {

  tape_clock(&tp);

  ret=pvm_upkuint(np,nitem,stride);

  tape_clock(&tp2);
  tape_clockdiff(&tp2,&tp);

  tape_event(event_upkuint,taskid,numfile,numline,tp.tv_sec-base_s,tp.tv_usec,
	     "%d %d %d %d %d",ret,tp2.tv_sec,tp2.tv_usec,nitem,stride);
}
else
  ret=pvm_upkuint(np,nitem,stride);

return(ret);
}

int Tpvm_upkulong(int numfile,int numline,int masc,unsigned long *np,int nitem,int stride)
{
struct timeval tp,tp2;
int ret;

if((masc&(mselect>>nb_classe))&&(masc_pvm&mselect)) {

  tape_clock(&tp);
  
  ret=pvm_upkulong(np,nitem,stride);

  tape_clock(&tp2);
  tape_clockdiff(&tp2,&tp);

  tape_event(event_upkulong,taskid,numfile,numline,tp.tv_sec-base_s,tp.tv_usec,
	     "%d %d %d %d %d",ret,tp2.tv_sec,tp2.tv_usec,nitem,stride);
}
else
  ret=pvm_upkulong(np,nitem,stride);

return(ret);
}

int Tpvm_upkushort (int numfile,int numline,int masc,unsigned short *np,int nitem,int stride)
{
struct timeval tp,tp2;
int ret;

if((masc&(mselect>>nb_classe))&&(masc_pvm&mselect)) {

  tape_clock(&tp);

  ret=pvm_upkushort(np,nitem,stride);

  tape_clock(&tp2);
  tape_clockdiff(&tp2,&tp);

  tape_event(event_upkushort,taskid,numfile,numline,tp.tv_sec-base_s,tp.tv_usec,
	     "%d %d %d %d %d",ret,tp2.tv_sec,tp2.tv_usec,nitem,stride);
}
else
  ret=pvm_upkushort(np,nitem,stride);

return(ret);
}

