/* TAPE/PVM %W% %G% */

#include <sys/time.h>
#include <stdarg.h>
#include "pvm3.h"

#include "tape.h"
#include "tape_globals.h"
#include "tape_events.h"
#include "tape_classes.h"

#define masc_pvm classe_buffer

/* BEGIN: NOT SUPPORTED
int Tpvm_packf(int numfile, int numline, int masc, char *format, ... )
{
va_list ap;
struct timeval tp,tp2;
int ret;

tape_clock(&tp);
va_start(ap, format);
ret=pvm_packf(format,ap);
va_end(ap);
if((masc&(mselect>>nb_classe))&&(masc_pvm&mselect)) {

   tape_clock(&tp2);
   tape_clockdiff(&tp2,&tp);

   tape_event(event_packf,taskid,numfile,numline,tp.tv_sec-base_s,tp.tv_usec,
	      "%d %d %d",ret,tp2.tv_sec,tp2.tv_usec);
 }
return(ret);
}
 END: NOT SUPPORTED */

int Tpvm_pkbyte(int numfile,int numline,int masc,char *xp, int nitem, int stride)
{
struct timeval tp, tp2;
int ret;

if((masc&(mselect>>nb_classe))&&(masc_pvm&mselect)) {

  tape_clock(&tp);

  ret=pvm_pkbyte(xp,nitem,stride);

  tape_clock(&tp2);
  tape_clockdiff(&tp2,&tp);
  
  tape_event(event_pkbyte,taskid,numfile,numline,tp.tv_sec-base_s,tp.tv_usec,
	     "%d %d %d %d %d",ret,tp2.tv_sec,tp2.tv_usec,nitem,stride);
}
else
  ret=pvm_pkbyte(xp,nitem,stride);

return(ret);
}

int Tpvm_pkcplx(int numfile,int numline,int masc,float *cp,int nitem,int stride)
{
struct timeval tp,tp2;
int ret;

if((masc&(mselect>>nb_classe))&&(masc_pvm&mselect)) {

  tape_clock(&tp);

  ret=pvm_pkcplx(cp,nitem,stride);
  
  tape_clock(&tp2);
  tape_clockdiff(&tp2,&tp);
  
  tape_event(event_pkcplx,taskid,numfile,numline,tp.tv_sec-base_s,tp.tv_usec,
	     "%d %d %d %d %d",ret,tp2.tv_sec,tp2.tv_usec,nitem,stride);
}
else
  ret=pvm_pkcplx(cp,nitem,stride);

return(ret);
}

int Tpvm_pkdcplx(int numfile,int numline,int masc,double *zp,int nitem,int stride)
{
struct timeval tp, tp2;
int ret;

if((masc&(mselect>>nb_classe))&&(masc_pvm&mselect)) {

  tape_clock(&tp);
  ret=pvm_pkdcplx(zp,nitem,stride);

  tape_clock(&tp2);
  tape_clockdiff(&tp2,&tp);

  tape_event(event_pkdcplx,taskid,numfile,numline,tp.tv_sec-base_s,tp.tv_usec,
	     "%d %d %d %d %d",ret,tp2.tv_sec,tp2.tv_usec,nitem,stride);
}
else
  ret=pvm_pkdcplx(zp,nitem,stride);

return(ret);
}

int Tpvm_pkdouble(int numfile,int numline,int masc,double *dp,int nitem,int stride)
{
struct timeval tp,tp2;
int ret;

if((masc&(mselect>>nb_classe))&&(masc_pvm&mselect)) {

  tape_clock(&tp);
  ret=pvm_pkdouble(dp,nitem,stride);

  tape_clock(&tp2);
  tape_clockdiff(&tp2,&tp);

  tape_event(event_pkdouble,taskid,numfile,numline,tp.tv_sec-base_s,tp.tv_usec,
	     "%d %d %d %d %d",ret,tp2.tv_sec,tp2.tv_usec,nitem,stride);
}
else
  ret=pvm_pkdouble(dp,nitem,stride);

return(ret);
}

int Tpvm_pkfloat(int numfile,int numline,int masc,float *fp,int nitem,int stride)
{
struct timeval tp,tp2;
int ret;

if((masc&(mselect>>nb_classe))&&(masc_pvm&mselect)) {

  tape_clock(&tp);
  ret=pvm_pkfloat(fp,nitem,stride);

  tape_clock(&tp2);
  tape_clockdiff(&tp2,&tp);
  
  tape_event(event_pkfloat,taskid,numfile,numline,tp.tv_sec-base_s,tp.tv_usec,
	     "%d %d %d %d %d",ret,tp2.tv_sec,tp2.tv_usec,nitem,stride);
 }
else
  ret=pvm_pkfloat(fp,nitem,stride);

return(ret);
}

int Tpvm_pkint(int numfile, int numline, int masc, int *np, int nitem, int stride)
{
struct timeval tp,tp2;
int ret;

if((masc&(mselect>>nb_classe))&&(masc_pvm&mselect)) {

  tape_clock(&tp);

  ret=pvm_pkint(np,nitem,stride);

  tape_clock(&tp2);
  tape_clockdiff(&tp2,&tp);

  tape_event(event_pkint,taskid,numfile,numline,tp.tv_sec-base_s,tp.tv_usec,
	     "%d %d %d %d %d",ret,tp2.tv_sec,tp2.tv_usec,nitem,stride);
}
else
  ret=pvm_pkint(np,nitem,stride);

return(ret);
}

int Tpvm_pklong(int numfile,int numline,int masc,long *np,int nitem,int stride )
{
struct timeval tp,tp2;
int ret;

if((masc&(mselect>>nb_classe))&&(masc_pvm&mselect)) {

  tape_clock(&tp);

  ret=pvm_pklong(np,nitem,stride);

  tape_clock(&tp2);
  tape_clockdiff(&tp2,&tp);
  
  tape_event(event_pklong,taskid,numfile,numline,tp.tv_sec-base_s,tp.tv_usec,
	     "%d %d %d %d %d",ret,tp2.tv_sec,tp2.tv_usec,nitem,stride);
}
else
  ret=pvm_pklong(np,nitem,stride);

return(ret);
}

int Tpvm_pkshort(int numfile,int numline,int masc,short *np,int nitem,int stride)
{
struct timeval tp,tp2;
int ret;

if((masc&(mselect>>nb_classe))&&(masc_pvm&mselect)) {

  tape_clock(&tp);

  ret=pvm_pkshort(np,nitem,stride);

  tape_clock(&tp2);
  tape_clockdiff(&tp2,&tp);

  tape_event(event_pkshort,taskid,numfile,numline,tp.tv_sec-base_s,tp.tv_usec,
	     "%d %d %d %d %d",ret,tp2.tv_sec,tp2.tv_usec,nitem,stride);
}
else
  ret=pvm_pkshort(np,nitem,stride);

return(ret);
}

int Tpvm_pkstr(int numfile,int numline,int masc,char *cp)
{
struct timeval tp,tp2;
int ret;

if((masc&(mselect>>nb_classe))&&(masc_pvm&mselect)) {

  tape_clock(&tp);

  ret=pvm_pkstr(cp);

  tape_clock(&tp2);
  tape_clockdiff(&tp2,&tp);

  tape_event(event_pkstr,taskid,numfile,numline,tp.tv_sec-base_s,tp.tv_usec,
	     "%d %d %d",ret,tp2.tv_sec,tp2.tv_usec);
}
else
  ret=pvm_pkstr(cp);

return(ret);
}

int Tpvm_pkuint(int numfile,int numline,int masc,unsigned int *np,int nitem,int stride)
{
struct timeval tp,tp2;
int ret;

if((masc&(mselect>>nb_classe))&&(masc_pvm&mselect)) {

  tape_clock(&tp);

  ret=pvm_pkuint(np,nitem,stride);

  tape_clock(&tp2);
  tape_clockdiff(&tp2,&tp);

  tape_event(event_pkuint,taskid,numfile,numline,tp.tv_sec-base_s,tp.tv_usec,
	     "%d %d %d %d %d",ret,tp2.tv_sec,tp2.tv_usec,nitem,stride);
}
else
  ret=pvm_pkuint(np,nitem,stride);

return(ret);
}

int Tpvm_pkulong(int numfile,int numline,int masc,unsigned long *np,int nitem,int stride)
{
struct timeval tp,tp2;
int ret;

if((masc&(mselect>>nb_classe))&&(masc_pvm&mselect)) {

  tape_clock(&tp);

  ret=pvm_pkulong(np,nitem,stride);

  tape_clock(&tp2);
  tape_clockdiff(&tp2,&tp);
  
  tape_event(event_pkulong,taskid,numfile,numline,tp.tv_sec-base_s,tp.tv_usec,
	     "%d %d %d %d %d",ret,tp2.tv_sec,tp2.tv_usec,nitem,stride);
}
else
  ret=pvm_pkulong(np,nitem,stride);

return(ret);
}

int Tpvm_pkushort (int numfile,int numline,int masc,unsigned short *np,int nitem,int stride)
{
struct timeval tp,tp2;
int ret;

if((masc&(mselect>>nb_classe))&&(masc_pvm&mselect)) {

  tape_clock(&tp);

  ret=pvm_pkushort(np,nitem,stride);

  tape_clock(&tp2);
  tape_clockdiff(&tp2,&tp);

  tape_event(event_pkushort,taskid,numfile,numline,tp.tv_sec-base_s,tp.tv_usec,
	     "%d %d %d %d %d",ret,tp2.tv_sec,tp2.tv_usec,nitem,stride);
}
else
  ret=pvm_pkushort(np,nitem,stride);

return(ret);
}

