/* TAPE/PVM %W% %G% */

#include <stdio.h>
#include <stdarg.h>
#include <sys/time.h>


#ifndef _TAPE_H_
#define _TAPE_H_

#define TAPE_VERSION "V0.9pl10"

#include "tape_clockstats.h"

#define SIGHANDLER -1  /* tape_end called by signal handler */

/* ProtoGlarp is borrowed from pvm3.h */

#ifdef __ProtoGlarp__
#undef __ProtoGlarp__
#endif
#if defined(__STDC__) || defined(__cplusplus)
#define __ProtoGlarp__(x) x
#else
#define __ProtoGlarp__(x) ()
#endif

#ifdef __cplusplus
extern "C" {
#endif

/* libtape function prototypes */

  /* definite */
void     tape_start           __ProtoGlarp__((int*, char**, int,int, int, int));
void     tape_end             __ProtoGlarp__((int));
/* int      tape_create_control  __ProtoGlarp__((int, int, int, int, int, int, char, char*)); */
int      tape_params          __ProtoGlarp__((int*,int*,int*,int*,int*,char*,char*));
int      tape_ready           __ProtoGlarp__((int));
void     tape_get_params      __ProtoGlarp__((int*, int*, int*, int*, unsigned*, char*));
void     tape_read_op         __ProtoGlarp__((int*, int*, int*, int*, unsigned*, char*));
/* void     tape_send_params     __ProtoGlarp__((int, int, int, int, int, unsigned, char)); */
void     tape_notify_control  __ProtoGlarp__((int));
void     tape_clock           __ProtoGlarp__((struct timeval *));
void     tape_clockdiff       __ProtoGlarp__((struct timeval *,struct timeval *));
void     tape_event           __ProtoGlarp__((int,int,int,int,int,int,char *fmt, ...));
void     tape_v_event         __ProtoGlarp__((long,int,int,int,int,int,int,char *fmt, va_list ap));
void     tape_enroll          __ProtoGlarp__((void));
void     tape_welcome         __ProtoGlarp__((int,int,unsigned,int,int,int));
int      tape_set_mask        __ProtoGlarp__((int,int,int,char*));
int      tape_sm              __ProtoGlarp__((char*));
void     tape_get_mask        __ProtoGlarp__((char*));
int      tape_close_phase     __ProtoGlarp__((int,int,int,int phase_id));
int      tape_open_phase      __ProtoGlarp__((int,int,int,char *name));
void     fatalMallocFailure   __ProtoGlarp__((char*, int));

void correction(char*,char*,int,double,double,int,FILE *);
void nocompcorrection(char*,char*,int,double,double,int,FILE *);

int Tpvm_dummy(int numfile, int numline, int masc, int d1, int d2);

  /* a renommer */
int compactage(char *evt, int evtlen, char *buffer, char compact);
void horloge_reference(struct res_somme **,int,int,int,int);
void calcul_coef_lin(struct res_somme **,int,int,int,int,int,int);
void coef(int,double*,double*,int);
void date_absolue(double slope, double offset, int *s, int *u, int end_sba1);
void fatalMallocFailure(char*,int);

#ifdef __cplusplus
}
#endif

#endif

