
/*******************************************************************************
*
*	Source lex du generateur automatique du fichier Tpvm3.h
*
********************************************************************************
*
*
*   utilisation:
*      Tinclude [-d dir]
*		creation d'un fichier Tpvm3.h dans le repertoire courant
*  a partir du fichier pvm3.h du repertoire dir (repertoire courant par default)
*
*
*/

 #include <string.h>

S  ["\t"" "]*

%%

^\n$ {}

PVM {fprintf(yyout,"TPVM");}

   /* filter out structures */
struct([^{]*)"{" {
	int i;
	char c;

	i=1;
	while(i) {
	   switch(c=input()) {
	      case '{' : i++; break;
	      case '}' : i--; break;
	   }
	}
	while((c=input())!=';');
	while((c=input())!='\n');
	}

   /* filter out the defines */
^#{S}define{S}(PVM_|Pvm).*\n   ;

(pvm_|Pvm)[^(]*(("(("" "*void" "*"))")|("("" "*")")) {
        int i=0;
        while(yytext[i]!='(')
          i++;
        if(yytext[i+1]=='(') { 
          i+=2; yytext[i]=0;
          fprintf(yyout,"T%sint numfile, int numline, int masc ))",yytext); }
        else {
          i++; yytext[i]=0;
          fprintf(yyout,"T%sint numfile, int numline, int masc )",yytext); }
      }

(pvm_|Pvm)[^(]*"((" fprintf(yyout,"T%s int numfile, int numline, int masc,",yytext);

   /* filter out comments */
"/*"([^*]*)((\*[^/]([^*]*))*)"*/".* ;


%%

int main(int argc, char** argv)
{
int i;
char rep[100];
int flag_dir;
char dir[80];

flag_dir=0;
strcpy(dir,".");
i=1;
while(i<argc) {
   if(argv[i][0]=='-') {
      switch(argv[i][1]) {
         case 'd' : {
            if(flag_dir) {
               printf("\nWarning : plusieurs repertoires declares\n");
            }
            else {
               flag_dir++;
               strcpy(dir,argv[++i]);
            }
	    break;
         }
         default : {
            printf("\nWarning : option inconnue\n");
         }
      }
   }
   else {
      printf("Warning : mauvaise option\n");
   }
   i++;
}
strcat(dir,"/pvm3.h");
if(!(yyin=fopen(dir,"r"))) {
  fprintf(stderr,"cannot open %s\n",dir);
  exit(1);
}
if(!(yyout=fopen("Tpvm3.h","w"))) {
  fprintf(stderr,"cannot open ./Tpvm3.h\n");
  exit(2);
}

yylex();
fclose(yyin);
fclose(yyout);
return(0);
}

