#####################################################
# Simple Makefile to instrument 'gexample.f' from the 
# PVM3 distribution (FORTRAN version) 
# ---------------------------------------------------
#                     TAPE/PVM
# E.Maillet, LMC-IMAG, University of Grenoble, France
#####################################################

# include and library directories

PVMLIBDIR = -L$(PVM_ROOT)/lib/$(PVM_ARCH)
PVMINCDIR = -I$(PVM_ROOT)/include
PVMBINDIR = $(PVM_ROOT)/bin/$(PVM_ARCH)

TAPELIBDIR = -L$(TAPE_ROOT)/$(PVM_ARCH)
TAPEINCDIR = -I$(TAPE_ROOT)/include

# allow Fortran source lines up to 100 chars wide
# (non standard option)

FSPECIAL = -qfixed=100

# libraries

PVMLIB = -lfpvm3 -lpvm3 -lgpvm3
TAPELIB = -lftape -ltape

all: gexample gexample_t

clean:
	rm -f gexample gexample_t *.o gexample_t.f

install: gexample gexample_t
	cp gexample gexample_t $(PVMBINDIR)

####################################################
# build non instrumented version (as usual)
####################################################

# link

gexample: gexample.o
	$(FC) $(PVMLIBDIR) $(PVMLIB) gexample.o -o gexample

# compile 

gexample.o: gexample.f
	$(FC) $(PVMINCDIR) -c gexample.f

####################################################      
# build instrumented version 
####################################################

# link

gexample_t: gexample_t.o
	$(FC) $(TAPELIBDIR) $(PVMLIBDIR) gexample_t.o -o gexample_t \
              $(TAPELIB) $(PVMLIB)

# compile instrumented source, we use FSPECIAL
# to have long lines (because of instr. insertion)

gexample_t.o: gexample_t.f
	$(FC) $(FSPECIAL) $(PVMINCDIR) $(TAPEINCDIR) -c gexample_t.f

# build instrumented source from normal source

gexample_t.f: gexample.f
	tapeppf -fDB gexample.f





