/*======================================================*/
/*			  SRTS.C			*/
/*		  Methode Transpose_Split		*/
/*======================================================*/

#include <sys/types.h>
#include <sys/time.h>
#include <fcntl.h>
#include <stdio.h>
#include <string.h>
#include <math.h>
#include "pvm3.h"

#define HOWMANY 1
#define MAXP 4
#define MAXN 512
#define MINN MAXN

#define BR  0
#define NOBR 1
#define Pi 3.1415

#define DEBUG

double *tab_omegaR,*tab_omegaI;
int MonNumero,Parent;
int *numero;
int mytid;
int parenttid;
FILE *fichres;


/*======================================================*/
/*      Procedure for printing matrices                 */
/*======================================================*/
void Affiche(vecR,vecI,nc)
        double *vecR,*vecI;
        int nc;
{
  int i;

  for(i=0;i<nc;i++)
    printf("(%5.2f , %5.2f) | ",vecR[i],vecI[i]);
  printf("\n");
}

/*======================================================*/
/*      Procedure for printing matrices                 */
/*======================================================*/
void AfficheMat(matR,matI,nl,nc)
        double **matR,**matI;
        int nl,nc;
{
  int i;

  printf("\n");
  for(i=0;i<nl;i++)
  {
    printf("%d--",MonNumero);
    Affiche(matR[i],matI[i],nc);
  }
}



/*======================================================*/
/*      Bit Reverse Function                            */
/*======================================================*/
unsigned Inverse(x,r)
        unsigned x,r;
{
  unsigned nveau,l,bit;

  nveau = 0;
  bit = 0;
  for(l=0;l<r;l++)
  {
    bit = x&1;
    nveau = (nveau << 1) + bit;
    x = x >> 1;
  }
  return(nveau);
}

/*======================================================*/
/*      Function for computing the sum of 2 complex     */
/*======================================================*/
void Add(aR,aI,bR,bI,rR,rI)
        double aR,aI,bR,bI;
        double *rR,*rI;
{

  *rR = aR + bR;
  *rI = aI + bI;

}

/*======================================================*/
/*  Fonction de calcul de la difference de 2 complexes  */
/*======================================================*/
void Sub(aR,aI,bR,bI,rR,rI)
        double aR,aI,bR,bI;
        double *rR,*rI;
{
  *rR = aR - bR;
  *rI = aI - bI;
}



/*======================================================*/
/*  Fonction de calcul du produit de 2 complexes        */
/*======================================================*/
void Mul(aR,aI,bR,bI,rR,rI)
        double aR,aI,bR,bI;
        double *rR,*rI;
{
  *rR = (aR * bR)-(aI * bI);
  *rI = (aR * bI)+(aI * bR);
}

/*======================================================*/
/*  Function for comptuting the jth twiddle factor      */
/*======================================================*/
void Omega(j,n,omegR,omegI)
        int j,n;
        double *omegR,*omegI;
{

  *omegR = (double) cos((double)((2*j*Pi)/n));
  *omegI = (double) -sin((double)((2*j*Pi)/n));
}


/*======================================================*/
/*  Fonction de calcul de la FFT d'un vecteur           */
/*======================================================*/
void fft1d_seq(tabR,tabI,n,tb)
        double **tabR,**tabI;
        int n,tb;
{
  int i,j,indb,h,d,nboucle,m;
  double wR,wI,auxR,auxI,pR,pI;

  d = 1;
  h = 2;
  nboucle = n/2;
  while(d<n)
  {
    wR = 1.0;
    wI = 0.0;
    for(j=0;j<d;j++)
    {
      for(i=0;i<nboucle;i++)
      {
        for(indb=0;indb<tb;indb++)
        {
          m = i*h+j;
          Mul(wR,wI,tabR[indb][m+d],tabI[indb][m+d],&pR,&pI);
          Sub(tabR[indb][m],tabI[indb][m],pR,pI,&auxR,&auxI);
          Add(tabR[indb][m],tabI[indb][m],pR,pI,&(tabR[indb][m]),&(tabI[indb][m])
);
          tabR[indb][m+d] = auxR;
          tabI[indb][m+d] = auxI;
        }
      }
      Mul(wR,wI,tab_omegaR[n/h],tab_omegaI[n/h],&wR,&wI);
    }
    nboucle = nboucle/2;
    h*=2;
    d*=2;
  }
}


/*======================================================*/
/*  Procedure de transposition de la matrice.		*/
/*======================================================*/
void TransposeEnvoi(mR,mI,n,P)
        double **mR,**mI;
	int n,P;
{
  int i,q;
  int np;
  int bufid;

  np = n/P;

  for(q=0;q<P;q++)
  {
    if(q!=MonNumero)
    {
      bufid = pvm_initsend(PvmDataRaw);
      for(i=0;i<np;i++)
      {
        pvm_pkdouble(&(mR[i][(q*np)]),np,1);
        pvm_pkdouble(&(mI[i][(q*np)]),np,1);
      }
      pvm_send(numero[q],MonNumero);
    }
  }
}

	
/*======================================================*/
/*  Procedure de transposition de la matrice.		*/
/*======================================================*/
void TransposeRecoit(mtR,mtI,n,P,br)
        double **mtR,**mtI;
	int n,P,br;
{
  int i,j,q,indm,jr,ind_emett;
  int size,bufid,msgtag,tid;
  int r = (int)(log((double)n)/log((double)2.0));
  int np;
 
  np = n/P;
  ind_emett = 0;
  while(ind_emett < (P-1))
  {
    bufid = pvm_recv(-1,-1);
    pvm_bufinfo(bufid,&size,&msgtag,&tid); 
    q = msgtag;
    ind_emett++;
    for(j=(q*np);j<((q+1)*np);j++)
    {
      if(br==BR)
        jr = (int) Inverse(j,r);
      else
        jr = j;
      for(i=0;i<np;i++)
        pvm_upkdouble(&(mtR[i][jr]),1,1);
    }
    for(j=(q*np);j<((q+1)*np);j++)
    {
      if(br==BR)
        jr = (int) Inverse(j,r);
      else
        jr = j;
      for(i=0;i<np;i++)
        pvm_upkdouble(&(mtI[i][jr]),1,1);
    }
  }
}


/*======================================================*/
/*  Procedure de transposition locale de la matrice.	*/
/*======================================================*/
void TransposeLoc(mR,mI,mtR,mtI,n,P,br)
        double **mR,**mI,**mtR,**mtI;
	int n,P,br;
{
  int i,j,ir;
  int np = n/P;
  int r = (int)(log((double)n)/log((double)2.0));

  for(i=0;i<np;i++)
  {
    if(br==BR)
      ir = (int) Inverse((i+MonNumero*np),r);
    else
      ir = i+MonNumero*np;
    for(j=(MonNumero*np);j<((MonNumero+1)*np);j++)
    {
      mtR[j-(MonNumero*np)][ir] = mR[i][j];
      mtI[j-(MonNumero*np)][ir] = mR[i][j];
    }
  }
}

/*======================================================*/
/* 	Procedure for computing the FFT2d using a 	*/
/*	Transpose Split method without overlapping.	*/
/*======================================================*/
void TS_No_Over(aR,aI,n,P)
  double **aR,**aI;
  int n,P;
{
  int np = n/P;
  int i;
  double **atR,**atI;

  atR = (double **) malloc(np * sizeof(double));
  if (atR == 0)
    printf("%d malloc error \n",MonNumero);
  atI = (double **) malloc(np * sizeof(double));
  if (atI == 0)
    printf("%d malloc error \n",MonNumero);
  for(i=0;i<np;i++)
  {
    atR[i] = (double *) malloc(n * sizeof(double));
    if (atR[i] == 0)
      printf("%d malloc error \n",MonNumero);
    atI[i] = (double *) malloc(n * sizeof(double));
    if (atI[i] == 0)
      printf("%d malloc error \n",MonNumero);
  }
  
  fft1d_seq(aR,aI,n,np);

  TransposeEnvoi(aR,aI,n,P);

  TransposeRecoit(atR,atI,n,P,BR);

  TransposeLoc(aR,aI,atR,atI,n,P,BR);

  fft1d_seq(atR,atI,n,np);

  TransposeEnvoi(atR,atI,n,P);

  TransposeRecoit(aR,aI,n,P,NOBR);

  TransposeLoc(atR,atI,aR,aI,n,P,NOBR);

  for(i=0;i<np;i++)
  {
    free(atR[i]);
    free(atI[i]);
  }
  free(atR);
  free(atI);

}
/*======================================================*/
main()
{
  int n,P,q;
  int np;
  int i,j,jr;
  int my_i;
  int r,k;
  double T,MaxT;
  struct timeval tv0,tv1;
  double **aR,**aI;
  short a;

# ifdef _TPVM3_H_
  char phase_name[16];
  int my_phase;
# endif

	/* Enroll in PVM */
  MonNumero = pvm_mytid();
  Parent = pvm_parent();

  P = MAXP;

if(Parent <= 0)
{
  numero = (int *)malloc(P * sizeof(int));

  pvm_spawn("srtsR",0,0,"",P,numero);
 
  pvm_initsend(PvmDataDefault);
  pvm_pkint(numero,P,1); 
  pvm_mcast(numero,P,0);

  for (q = 0; q < P; q++)
  {
    pvm_initsend(PvmDataDefault);
    pvm_pkint(&q,1,1); 
    pvm_send(numero[q],0);
  }

  /* LOOP OVER A SERIES OF FFT'S */
  n=MINN;
  /* for(n=MINN;n<=MAXN;n=n*2) */
  for(my_i=0;my_i<HOWMANY;my_i++)
  {
    MaxT = 0.0;

#   ifdef _TPVM3_H_
    sprintf(phase_name,"FFT%d",my_i);
    my_phase=tape_open_phase(phase_name);
#   endif

    /* loop for 1 single fft */
    for(q=0;q<P;q++)
    {
      pvm_recv(numero[q],1);
      pvm_upkdouble(&T,1,1);
      if(T > MaxT) MaxT = T;
    }

#   ifdef _TPVM3_H_
    tape_close_phase(my_phase);
#   endif

    printf("%d \t %5.3f\n",n,MaxT);
    fflush(stdout);
  }
}
else
{
  numero = (int *)malloc(P * sizeof(int));

  pvm_recv(-1,0);
  pvm_upkint(numero,P,1);

  pvm_recv(-1,0);
  pvm_upkint(&MonNumero,1,1);

  printf("SLAVE NB %d\n",MonNumero); fflush(stdout);

  pvm_joingroup("mongroupeamoi");

  n=MINN;
  /* for(n=MINN;n<=MAXN;n=n*2) */
  for(my_i=0;my_i<HOWMANY;my_i++)
  {

    /* printf("Tache %d taille du pr %d\n",MonNumero,n);
       fflush(stdout); */

    np = n/P;
    r = (int)(log((double)n)/log((double)2.0));
    k = (int)(log((double)P)/log((double)2.0));

        /* Memory allocation */
    tab_omegaR = (double *)malloc(n * sizeof(double));

    tab_omegaI = (double *)malloc(n * sizeof(double));

    aR = (double **) malloc(np * sizeof(double));
    if (aR == 0) {
      printf("%d malloc error \n",MonNumero);
      fflush(stdout); }
    aI = (double **) malloc(np * sizeof(double));
    if (aI == 0) {
      printf("%d malloc error \n",MonNumero);
      fflush(stdout); }
    for(i=0;i<np;i++)
    {
      aR[i] = (double *) malloc(n * sizeof(double));
      if (aR[i] == 0) {
        printf("%d malloc error \n",MonNumero);
        fflush(stdout); }
      aI[i] = (double *) malloc(n * sizeof(double));
      if (aI[i] == 0) {
        printf("%d malloc error \n",MonNumero);
        fflush(stdout); }
    }
    for(i=0;i<np;i++)
      for(j=0;j<n;j++)
      {
        aR[i][Inverse(j,r)]=(MonNumero*n*np)+(i*n)+j;
        aI[i][Inverse(j,r)]=0.0;
      }

        /* Computing the twiddle factors*/
    for(i=0;i<n;i++)
      Omega(i,n,&(tab_omegaR[i]),&(tab_omegaI[i]));

    pvm_barrier("mongroupeamoi",P);

	/* Synchro */

    /*
    for(q=0;q<P;q++)
    {
      if(MonNumero==q)
        pvm_recv(-1,-1);
      else
      {
        pvm_initsend(PvmDataDefault);
        pvm_pkshort(&a,1,1);
        pvm_send(numero[q],1);
      }
    }
    */

    tape_clock(&tv0); 
    TS_No_Over(aR,aI,n,P);
    tape_clock(&tv1);
    T = tv1.tv_sec-tv0.tv_sec+
      (tv1.tv_usec-tv0.tv_usec)*1e-6;

    pvm_initsend(0);
    pvm_pkdouble(&T,1,1);
    pvm_send(Parent,1);

    for(i=0;i<np;i++)
    {
      free(aR[i]);
      free(aI[i]);
    }
    free(aR);
    free(aI);
  }
}

  pvm_exit();
  exit(0);

} 
