#######################################################################
# This script has to be sourced before any invocation of imake or make
#######################################################################

# additional search path for imake ( so it finds your site.def )
# in case your system's default settings (C, Fortran compilers)
# are ok, comment the following line

#setenv IMAKEINCLUDE -I`pwd`

# where TAPE is to be installed

TAPE_ROOT=$PVM_ROOT/tapelib
export TAPE_ROOT

# PVM 3 source tree (only needed if you want FORTRAN support)

if [ "$PVM_SRC_ROOT" = "" ]
then
    PVM_SRC_ROOT=/usr/local/$PVM_VERSION
    export PVM_SRC_ROOT
fi

########### do not change below ###############

TAPELIBDIR=$TAPE_ROOT/$PVM_ARCH
export TAPELIBDIR
TAPEBINDIR=$PVM_ROOT/bin/$PVM_ARCH
export TAPEBINDIR
TAPE_PVM_VERSION=`echo $PVM_VERSION | sed -e 's/\./_/g'`
export TAPE_PVM_VERSION

if [ ! -d $PVM_SRC_ROOT ]
then
   echo "Warning, $PVM_SRC_ROOT, no such directory."
   echo "In case you want Fortran support, the PVM_SRC_ROOT"
   echo "environment variable has to point to the PVM3 source tree."
else
   echo "PVM3 source tree found, you can have Fortran support (see 'config')."
fi

