/* TAPE/PVM %W% %G% */

#include <stdio.h>
#include <string.h>
#include "tape_picl.h"
#include "tape_events.h"

/* identifiers for PICL events */

#define PiclStartTrace     1
#define PiclRecv           6
#define PiclRecvBlocking   7
#define PiclRecvWaking     8
#define PiclSend           4
#define PiclCompStats     11
#define PiclTraceExit     19

/* event identifier of special messages to
 * model idle states in Paragraph
 */ 

#define IdleMsgType       -1

/* flag to generate special events */

int SpecialEvents=1;

void printUsage()
{
   printf("usage: tape2picl [-h] [-f]\n\n");
   printf("Tape input trace on stdin, picl output dumped to stdout.\n");
   printf("Option -h displays this help message.\n");
   printf("Option -f suppresses special event generation.\n");
 }

/* procedure retournant un numero de taches picl a partir d'un numero de tache pvm */
void num_tache_picl(int *no_picl,int no_pvm)
   {
   int j;

   j=-1;
   while (++j<index_fin && tab_task[j].num_task != no_pvm);
   if(j==index_fin) /* tache non repertoriee */
      {
      tab_task[index_fin].num_task=no_pvm;
      tab_task[index_fin].actif=1;
      tab_task[index_fin].idle_time_s=0;
      tab_task[index_fin].idle_time_ms=0;
      index_fin++;
      }
   *no_picl=j;
   }

/* GetGroupDesc(groupname)
 *   return group descriptor of groupname
 *   if groupname does not exist a new descr. is created
 */

struct group_list *
GetGroupDesc(group)
     char *group;
{
  struct group_list *g=groups,*gl=NULL;

  while(g!=NULL)
    {
      if( strcmp(g->group_name,group) )
	{
	  gl=g;
	  g=g->next;
	}
      else
	break;
    }

  if(g==NULL)
    {
      g=(struct group_list *)malloc(sizeof(struct group_list));
      strcpy(g->group_name,group);
      g->nl=NULL;
      g->next=NULL;
      if(gl==NULL)
	groups=g;
      else
	gl->next=g;
    }

  return(g);
}

/* NodeAdd(groupname,node)
 *   add node to groupname
 */

void
NodeAdd(group,node)
     char* group;
     int node;
{
  struct group_list 
    *g;
  struct node_list 
    *n,
    *ln=NULL;

  g=GetGroupDesc(group);

  n=g->nl;

  while(n!=NULL) {
    ln=n;
    n=n->next;
  }

  n=(struct node_list *)malloc(sizeof(struct node_list));
  n->next=NULL;
  n->node=node;

  if(ln==NULL)
    g->nl=n;
  else
    ln->next=n;
}
    

/* NodeDel(groupname,node)
 *   delete a node from groupname
 */

void
NodeDel(group,node)
     char* group;
     int node;
{
  struct group_list
    *g;
  struct node_list
    *n, *ln=NULL;

  g=GetGroupDesc(group);

  n=g->nl;

  while(n!=NULL)
    {
      if(n->node!=node)
	{ 
	  ln=n;
	  n=n->next;
	}
      else
	break;
    }

  if(n==NULL)
    fprintf(stderr,"NodeDel, warning, node %d not in group %s\n",
	    node,group);
  else
    {
      if(ln==NULL)
	{
	  g->nl=n->next;
	  free(n);
	}
      else
	{
	  ln->next=n->next;
	  free(n);
	}
    }
}

/* GenerateIdleState( node, start, end)
 *   generates an idle state on node 'node' starting
 *   at 'start', ending at 'end'
 */ 

void
GenerateIdleState(node,start_s,start_us,end_s,end_us) 
     int node;
     int start_s;
     int start_us;
     int end_s;
     int end_us;
{
  if(SpecialEvents)
    {
      printf("%d %d %d %d %d\n",
	     PiclRecvBlocking, start_s, start_us,
	     node,IdleMsgType );
      printf("%d %d %d %d %d %d %d\n", 
	     PiclRecvWaking, end_s, end_us,
	     node, node, IdleMsgType, 1 );
      printf("%d %d %d %d %d %d %d\n",
	     PiclSend, end_s, end_us,
	     node, node, IdleMsgType, 1 );
      printf("%d %d %d %d %d %d\n", 
	     PiclCompStats, end_s, end_us, 
	     node, 0, 0 );
      printf("%d %d %d %d %d %d\n", 
	     PiclCompStats, end_s, end_us, 
	     node, 0, 0 );
    }
}

void format_picl()
   {
   int nb_cour;
   int task_idf,num_file,num_line,temps_s,temps_ms,retour,dest,msgtag,bytes,dep;
   int num_task_picl_src,num_task_picl_dest;
   int num_task_picl_dep,num_task_picl_mcast;
   int num_task_picl_spawn;
   int temps_passe_s,temps_passe_ms;
   int temps1_s,temps1_ms;
   int temps2_s,temps2_ms;
   int arrived;
   int D_s,D_us;
   int nb_task,no_task_pvm;
   int i;
   int count;
   char carcour;
   char nb_chaine[20];
   char group_name[80];

   while (fscanf(F_pvm,"%d",&nb_cour) != EOF)
      { 
      switch (nb_cour)
         {
        
         case event_trace :
         fscanf(F_pvm,"%d %d %d %d %d\n",
               &task_idf,&temps_passe_s,&temps_passe_ms,&temps_s,&temps_ms);
         if(SpecialEvents)
	   {
         num_tache_picl(&num_task_picl_src,task_idf);
	 if(tab_task[num_task_picl_src].actif)
	   {
            temps2_s=temps_s+temps_passe_s;
            if(temps_ms+temps_passe_ms>=1000000)
               {
	       temps2_s=temps2_s+1;
               temps2_ms=temps_ms+temps_passe_ms-1000000;
               }
            else
	       temps2_ms=temps_ms+temps_passe_ms;
            fprintf(stdout,"%d %d %d %d %d %d\n",PiclCompStats,temps_s,temps_ms
	       ,num_task_picl_src,tab_task[num_task_picl_src].idle_time_s
	       ,tab_task[num_task_picl_src].idle_time_ms);
            fprintf(stdout,"%d %d %d %d %d %d \n",PiclSend,temps_s,temps_ms
	       ,num_task_picl_src,num_task_picl_src,msgtag);
            tab_task[num_task_picl_src].idle_time_s+=temps_passe_s;
            if((tab_task[num_task_picl_src].idle_time_ms+temps_passe_ms)
	       >=1000000)
               {
               tab_task[num_task_picl_src].idle_time_ms+=temps_passe_ms-1000000;
               tab_task[num_task_picl_src].idle_time_s+=1;
               }
            else
               tab_task[num_task_picl_src].idle_time_ms+=temps_passe_ms;
            fprintf(stdout,"%d %d %d %d %d %d\n",PiclCompStats,temps2_s,temps2_ms
	       ,num_task_picl_src,tab_task[num_task_picl_src].idle_time_s
	       ,tab_task[num_task_picl_src].idle_time_ms);
	    }
           }
         break;
    

         case event_send : 
         fscanf(F_pvm,"%d %d %d %d %d %d %d %d %d %d %d\n",
		&task_idf,&num_file,&num_line
		,&temps_s,&temps_ms,&retour,&dest,&D_s,&D_us,&msgtag,&bytes);
         num_tache_picl(&num_task_picl_src,task_idf);
	 if(tab_task[num_task_picl_src].actif)
	    {
            num_tache_picl(&num_task_picl_dest,dest);
            fprintf(stdout,"%d %d %d %d %d %d\n",PiclCompStats,temps_s,temps_ms
	       ,num_task_picl_src,tab_task[num_task_picl_src].idle_time_s
	       ,tab_task[num_task_picl_src].idle_time_ms);
            fprintf(stdout,"%d %d %d %d %d %d %d\n",PiclSend,temps_s,temps_ms
	       ,num_task_picl_src,num_task_picl_dest,msgtag,bytes);
/*
if((tab_task[num_task_picl_src].idle_time_ms+500)>=1000000)
   {
   tab_task[num_task_picl_src].idle_time_ms+=999500;
   tab_task[num_task_picl_src].idle_time_s+=1;
   }
else
   tab_task[num_task_picl_src].idle_time_ms+=500;
if(temps_ms+500>=1000000)
   {
   temps1_s=temps_s+1;
   temps1_ms=temps_ms+500-1000000;
   }
else
   {
   temps1_ms=temps_ms+500;
   temps1_s=temps_s;
   }
*/
            fprintf(stdout,"%d %d %d %d %d %d\n",PiclCompStats,temps_s,temps_ms
	       ,num_task_picl_src,tab_task[num_task_picl_src].idle_time_s
	       ,tab_task[num_task_picl_src].idle_time_ms);
	    }
         break;

         case event_nrecv : 
         fscanf(F_pvm,"%d %d %d %d %d %d %d %d %d %d %d\n",
	     &task_idf,&num_file,&num_line
	    ,&temps_s,&temps_ms,&retour,&D_s,&D_us,&dest,&msgtag,&bytes);
         /* D_s, D_us, overhead of send */
         num_tache_picl(&num_task_picl_src,dest);
	 if(tab_task[num_task_picl_src].actif&&retour>0)
	    {
            num_tache_picl(&num_task_picl_dest,task_idf);
            fprintf(stdout,"%d %d %d %d %d %d\n",PiclCompStats,temps_s,temps_ms
	       ,num_task_picl_dest,tab_task[num_task_picl_src].idle_time_s
	       ,tab_task[num_task_picl_src].idle_time_ms);
            fprintf(stdout,"%d %d %d %d %d %d %d\n",PiclRecv,temps_s,temps_ms
	       ,num_task_picl_dest,num_task_picl_src,msgtag,bytes);
            fprintf(stdout,"%d %d %d %d %d %d\n",PiclCompStats,temps_s,temps_ms
	       ,num_task_picl_dest,tab_task[num_task_picl_src].idle_time_s
	       ,tab_task[num_task_picl_src].idle_time_ms);
	    }
         break;

         case event_recv :
         fscanf(F_pvm,"%d %d %d %d %d %d %d %d %d %d %d %d\n",
		&task_idf,&num_file
		,&num_line,&temps_s,&temps_ms,&retour,&arrived,&temps_passe_s
		,&temps_passe_ms,&dep,&msgtag,&bytes);
         num_tache_picl(&num_task_picl_src,task_idf);
	 if(tab_task[num_task_picl_src].actif)
	    {
            temps2_s=temps_s+temps_passe_s;
            if(temps_ms+temps_passe_ms>=1000000)
               {
	       temps2_s=temps2_s+1;
               temps2_ms=temps_ms+temps_passe_ms-1000000;
               }
            else
	       temps2_ms=temps_ms+temps_passe_ms;
            num_tache_picl(&num_task_picl_dep,dep);
            fprintf(stdout,"%d %d %d %d %d %d\n",PiclCompStats,temps_s,temps_ms
	       ,num_task_picl_src,tab_task[num_task_picl_src].idle_time_s
	       ,tab_task[num_task_picl_src].idle_time_ms);
            fprintf(stdout,"%d %d %d %d %d\n",PiclRecvBlocking,temps_s,temps_ms
	       ,num_task_picl_src,msgtag);
            tab_task[num_task_picl_src].idle_time_s+=temps_passe_s;
            if((tab_task[num_task_picl_src].idle_time_ms+temps_passe_ms)
	       >=1000000)
               {
               tab_task[num_task_picl_src].idle_time_ms+=temps_passe_ms-1000000;
               tab_task[num_task_picl_src].idle_time_s+=1;
               }
            else
               tab_task[num_task_picl_src].idle_time_ms+=temps_passe_ms;
            fprintf(stdout,"%d %d %d %d %d %d %d\n",PiclRecvWaking,temps2_s,temps2_ms
	       ,num_task_picl_src,num_task_picl_dep,msgtag,bytes);
            fprintf(stdout,"%d %d %d %d %d %d\n",PiclCompStats,temps2_s,temps2_ms
	       ,num_task_picl_src,tab_task[num_task_picl_src].idle_time_s
	       ,tab_task[num_task_picl_src].idle_time_ms);
	    }
         break;

         case event_mytid :
         fscanf(F_pvm,"%d %d %d %d %d %d\n",&task_idf,&num_file,&num_line
	    ,&temps_s,&temps_ms,&retour);
         num_tache_picl(&num_task_picl_src,task_idf);
	 if(tab_task[num_task_picl_src].actif)
	    {
            fprintf(stdout,"%d %d %d %d 0 0 0\n",PiclStartTrace,temps_s,temps_ms
	       ,num_task_picl_src);
            fprintf(stdout,"14 %d %d %d 4 4 0\n",temps_s,temps_ms
	       ,num_task_picl_src);
            fprintf(stdout,"%d %d %d %d %d %d\n",PiclCompStats,temps_s,temps_ms
	       ,num_task_picl_src,tab_task[num_task_picl_src].idle_time_s
	       ,tab_task[num_task_picl_src].idle_time_ms);
	    }
         break;

         case event_exit :
         fscanf(F_pvm,"%d %d %d %d %d\n",&task_idf,&num_file,&num_line
	    ,&temps_s,&temps_ms);
         num_tache_picl(&num_task_picl_src,task_idf);
	 if(tab_task[num_task_picl_src].actif)
            fprintf(stdout,"%d %d %d %d 0\n",PiclTraceExit,temps_s,temps_ms,
		    num_task_picl_src);
	 tab_task[num_task_picl_src].actif=0;
         break;

         case event_spawn :
         fscanf(F_pvm,"%d %d %d %d %d %d %d %d ",&task_idf,&num_file,&num_line
	    ,&temps_s,&temps_ms,&retour,&msgtag,&nb_task);
         carcour=getc(F_pvm);
	 i=0;
         while(carcour != '\n')
            { 
            if(carcour != ' ')
               nb_chaine[i++]=carcour;
            else
               { 
               nb_chaine[i]=0;
               no_task_pvm = atoi(nb_chaine);
               i=0;
               num_tache_picl(&num_task_picl_spawn,no_task_pvm);
               }
            carcour=getc(F_pvm);
            }
         break;

         case event_mcast :
         fscanf(F_pvm,"%d %d %d %d %d %d %d %d %d %d %d ",
		&task_idf,&num_file,&num_line
		,&temps_s,&temps_ms,&retour,&D_s,&D_us,&msgtag,&bytes,&nb_task);
         num_tache_picl(&num_task_picl_src,task_idf);
	 if(tab_task[num_task_picl_src].actif)
	    {
            carcour=getc(F_pvm);
            while(carcour != '\n')
               {
	       if(carcour != ' ')
	          nb_chaine[i++]=carcour;
               else
                  {
		  nb_chaine[i]=0;
                  no_task_pvm = atoi(nb_chaine);
                  i=0;
                  num_tache_picl(&num_task_picl_mcast,no_task_pvm);
                  fprintf(stdout,"%d %d %d %d %d %d\n",PiclCompStats,temps_s,temps_ms
		     ,num_task_picl_src,tab_task[num_task_picl_src].idle_time_s
		     ,tab_task[num_task_picl_src].idle_time_ms);
                  fprintf(stdout,"%d %d %d %d %d %d %d\n",PiclSend,temps_s,temps_ms
		     ,num_task_picl_src,num_task_picl_mcast,msgtag,bytes);
/*
if((tab_task[num_task_picl_src].idle_time_ms+500)>=1000000)
   {
   tab_task[num_task_picl_src].idle_time_ms+=999500;
   tab_task[num_task_picl_src].idle_time_s+=1;
   }
else
   tab_task[num_task_picl_src].idle_time_ms+=500;
if(temps_ms+500>=1000000)
   {
   temps1_s=temps_s+1;
   temps1_ms=temps_ms+500-1000000;
   }
else
   {
   temps1_ms=temps_ms+500;
   temps1_s=temps_s;
   }
*/
                  fprintf(stdout,"%d %d %d %d %d %d\n",PiclCompStats,temps_s,temps_ms
		     ,num_task_picl_src,tab_task[num_task_picl_src].idle_time_s
		     ,tab_task[num_task_picl_src].idle_time_ms);
                  }
               carcour=getc(F_pvm);
               }
	    }
         break;
 
         case event_bcast :
         fscanf(F_pvm,"%d %d %d %d %d %d %s %d %d %d %d\n",
		&task_idf,&num_file,&num_line
		,&temps_s,&temps_ms,&retour,group_name,
		&D_s,&D_us,&msgtag,&bytes);
         num_tache_picl(&num_task_picl_src,task_idf);
	 if(tab_task[num_task_picl_src].actif)
	    {
	      struct node_list *n = (GetGroupDesc(group_name))->nl;

              /* printf("**** GROUP-BROADCAST %s : ",group_name); */

              while(n!=NULL)
		{
                  num_task_picl_mcast = n->node;

		  fprintf(stdout,"%d %d %d %d %d %d\n",PiclCompStats,temps_s,temps_ms
		     ,num_task_picl_src,tab_task[num_task_picl_src].idle_time_s
		     ,tab_task[num_task_picl_src].idle_time_ms);
                  fprintf(stdout,"%d %d %d %d %d %d %d\n",PiclSend,temps_s,temps_ms
		     ,num_task_picl_src,num_task_picl_mcast,msgtag,bytes);
                  fprintf(stdout,"%d %d %d %d %d %d\n",PiclCompStats,temps_s,temps_ms
		     ,num_task_picl_src,tab_task[num_task_picl_src].idle_time_s
		     ,tab_task[num_task_picl_src].idle_time_ms);

		  /* printf("%d ",num_task_picl_mcast); */

		  n=n->next;

		}
	      /* printf("\n"); */
	    }
	 break;

         case event_joingroup:
         fscanf(F_pvm,"%d %d %d %d %d %d %s\n",&task_idf,&num_file,&num_line
	    ,&temps_s,&temps_ms,&retour,group_name);
         num_tache_picl(&num_task_picl_src,task_idf);
	 if(tab_task[num_task_picl_src].actif)
	    {
	      NodeAdd(group_name,num_task_picl_src);
	    }
	 break;

         case event_lvgroup:
         fscanf(F_pvm,"%d %d %d %d %d %d %s\n",&task_idf,&num_file,&num_line
	    ,&temps_s,&temps_ms,&retour,group_name);
         num_tache_picl(&num_task_picl_src,task_idf);
	 if(tab_task[num_task_picl_src].actif)
	    {
	      NodeDel(group_name,num_task_picl_src);
	    }
	 break;

         case event_barrier:
         fscanf(F_pvm,"%d %d %d %d %d %d %s %d %d %d\n"
            ,&task_idf,&num_file,&num_line
	    ,&temps_s,&temps_ms,&retour,group_name
            ,&temps1_s,&temps1_ms,&count);
         num_tache_picl(&num_task_picl_src,task_idf);
	 if(tab_task[num_task_picl_src].actif)
	    {
	      temps2_s=temps_s+temps1_s
                       +(temps_ms+temps1_ms)/1000000;
	      temps2_ms=(temps_ms+temps1_ms)%1000000;
	      GenerateIdleState( num_task_picl_src,
				 temps_s, temps_ms,
                                 temps2_s, temps2_ms );
	    }
	 break;

         default :
         carcour=getc(F_pvm);
         while((carcour != '\n')&&(carcour != EOF))
	    carcour=getc(F_pvm);

         }
      }
   }


main(int argc,char **argv)
   {
int i;
struct group_list *g,*gtemp;
struct node_list *n,*ntemp;

for(i=1;i<argc;i++) {
  if(strlen(argv[i])<2) {
     fprintf(stderr,"%s: warning, unknown option %s ignored.\n",
             argv[0],argv[i]);
     exit(1); }
  else {
    switch(argv[i][1]) {
       case 'h': 
          printUsage();
          exit(1);
       case 'f':
          SpecialEvents=0;
          break;
       default:
          fprintf(stderr,"%s: warning, unknown option %s ignored.\n",
                  argv[0], argv[i]);
    }
  }
} 

F_pvm=stdin;
index_fin=0;                                          
format_picl();

/* free data structure for group/node lists */

g=groups;
while(g!=NULL)
  {
    n=g->nl;
    while(n!=NULL)
      {
	ntemp=n;
	n=n->next;
	free(ntemp);
      }
    gtemp=g;
    g=g->next;
    free(gtemp);
  }

}
