/* implementation of special [un]packing functions 
   as type vector is a template class, it has to be explicitly defined for
   each type. int, float, are provided since these are the most used */
#include <pdu.h>

//int vector type
int 
PDU::PDU_pack(vector<int> &v, int stride) {
  int size = v.length();
  pvm_pkint(&size, 1, stride);
  return pvm_pkint((int *)v, v.length(), stride);
}

int
PDU::PDU_unpack(vector<int> &v, int stride) {
  int size;
  pvm_upkint(&size, 1, stride);

  int list[size];
  int out = pvm_upkint(list, size, stride);
  v = vector<int>(size, list);  
  return out;
}

//float vector type
int 
PDU::PDU_pack(vector<float> &v, int stride) {
  int size = v.length();
  pvm_pkint(&size, 1, stride);
  return pvm_pkfloat((float *)v, v.length(), stride);
}

int
PDU::PDU_unpack(vector<float> &v, int stride) {
  int size;
  pvm_upkint(&size, 1, stride);

  float list[size];
  int out = pvm_upkfloat(list, size, stride);
  v = vector<float>(size, list);
  return out;
}
