// This may look like C code, but it is really -*- C++ -*-
/****************************************************************
  (c) 1994 by Daniel COHEN-LAROQUE        

   Version: 0.92
      File: vector.cxx vector.hxx
   Created: Fri Jul 29 11:59:00 GMT+0100 1994
  Revision: Time-stamp: <94/08/30 19:14:18 dev>
     Email: cohen_la@di.epfl.ch
  Platform: LINUX
      Note: adapted from: Copyright (C) 1988 Free Software Foundation
                          written by Doug Lea (dl@rocky.oswego.edu)
****************************************************************/
#ifndef _vec_h
#define _vec_h

#include <String.h>
#include <ostream.h>
#include <fstream.h>
#include <stddef.h>
#include <builtin.h>
#include "defs.h"

template<class T> class vector{
public:
  typedef int (*Comparator)(T&, T&);
  typedef T (*Combiner)(T&, T&);
  typedef void (*Procedure)(T&);

  //Not tested below
  typedef T (*Mapper)(T&);
  typedef int (*Predicate)(T&);

protected:      
  int len;
  T *s;                  

  int gsort(T *base_ptr, int total_elems, Comparator);
  void error(const char *msg);
  void range_error();
  ofstream& OpenVectorFile(String file, String comment);
  /* open an ASCII file, write comment and vector size:
     can be usefull to overload (virtual) ASCII_File function 
     if another format is desired */

public:
  inline vector(): len(0), s(NULL) {};
  vector(int l, T *v);  //Warning v must be allocated, length l
  vector(int l);
  vector(int l, T fill_value);
  vector(String ASCII_FileName);  //e.g. vector<double> foo("result.vec");
  vector(vector&);  //copy constructor
  ~vector();
  
  /* WARNING: insert in the instantiation file 
     'template ostream & operator << (ostream & ,vector<e.g. int> &);'  */
  friend ostream & operator << (ostream &, vector &);

  /* save in a ASCII file, return true if successfull
     FORMAT: comment 1
             comment 2
	     ...
	     % length 
	     data
	     ...        

     Note: -character '%' MUST NOT be present in comments! 
           -comment can include newlines  */
  void ASCII_File(String file, String comment);
  
  inline int length() { return len; }
  void resize(int newlen, T null = 0);  
  //if 'newlen' is larger -->zero padding

  T sum();
  T min();
  T max();
  inline T mean() { return (sum() / length()); }

             /* operators */
  //casting: e.g. float *toto = (float *)my_vector;
  inline operator const T*() const { return (const T*)s; }   
  vector& operator =(vector &a);

  T& operator [](int); //Warning: last element is [length - 1]
  inline T& elem(int n) { return s[n]; }

  vector& operator +(vector &);
  vector& operator +=(vector &v);
  vector& operator -(vector &);
  vector& operator -=(vector &v);
  T operator *(vector &v);  //dot product
  vector& operator *(T right);  //e.g. cout <<foo*3 <<endl;
  vector& operator /(T right);

  int operator ==(vector &);
  inline int operator !=(vector &v) { return !(*this == v); }

  int index(T targ);  //return the index of the first occurence or -1
  vector& vindex(T targ);  //return a vector of all occurences
  void fill(T val, int from = 0, int n = -1);  //if n=-1, assume end of vector
  vector at(int from = 0, int n = -1);
  
  void reverse();
  void sort(Comparator); 
  /* e.g. 
     int Comparator(int &a, int &b) {
       return (a > b)? 1: (a < b)? ~0: 0; 
     } 
     v.sort(Comparator); */

  void apply(Procedure);
  friend vector concat(vector &, vector &);
  friend vector combine(Combiner f, vector &, vector &);
  
  // NOT TESTED YET
  friend T reduce(Combiner f, T &base);
  friend vector map(Mapper f, vector &a);
  friend vector merge(vector &a, vector &b, Comparator f);
};

extern void default_vector_T_error_handler(const char*);
extern one_arg_error_handler_t vector_T_error_handler;

extern one_arg_error_handler_t set_vector_T_error_handler(one_arg_error_handler_t f);
#endif


