/****************************************************************
  (c) 1994 by Daniel COHEN-LAROQUE        

   Version: 0.3
      File: pvm++.h pvm++.cxx
   Created: Sun Jul 24 10:31:52 GMT+0100 1994
  Revision: Time-stamp: <94/08/30 18:43:46 dev>
     Email: cohen_la@di.epfl.ch
  Platform: LINUX
      Note: -GCC 2.6.0, version below won't match
            -vector of type 'int' and 'float' are build in 
             libpvm++.a 
****************************************************************/
#ifndef _pvm_task_h
#define _pvm_task_h 
#include <signal.h>
#include <pvm.h>
#include <pdu.h>

typedef void(*PVM_SignalHandler_t)(PDU &);

class PVM_Task {
/* Note: when the return value is not described, then it is the same one as in the
         pvm standard function */
private:
  const int tid;         //task id 
  const int ptid;        //parent tid
  vector<int> &ctid;     //children


       /* static members: shared by all the objects PVM_Task */

  static int signal_exist;  /* a new object PVM_Task has to know \
			       if another one has already set a handler */

  static int recv_from_tid[NSIG];
  static int msgtag[NSIG];
  static PVM_SignalHandler_t hdlr[NSIG];
  static PDU *pdu[NSIG];  /* the decoded pdu that must be returned \
			     to the handler. Uses pure virtual PDU::unpack */

  //static functions members
  static void setsignal(int);
  static void PVM_handler(int);

protected:
  //scan PVM to know all the children
  void Update_Children();

  //all the spawned tasks killed, monitor on stdout if verbose is TRUE
  void KillAllTasks(bool verbose);

public:
  PVM_Task();  //enroll with PVM, exit if unable to contact local daemon
  virtual ~PVM_Task();  //leave PVM but not exit the program

  inline int my_tid() { return tid; }
  inline int parent_tid() { return ptid; }

  //kill children, perror & exit the program (error code: 1)
  void error(const char *);  
  void context();  //describe environment, like the 'conf' command on console

  void KillTasks(vector<int> &tids);
  inline vector<int>& children();  //children TIDs
  inline int nb_children() { return ctid.length(); }
  //e.g. cout <<class_name.children() <<endl;

  /* spawn acts like pvm_spawn but child_tids vector is returned
     tids must be an allocated vector<int>, initialized to the desired number of
     spawned tasks: vector<int> tids(20); ...  */
  int spawn(char *task, char **argv, int flag, char *where, vector<int> &tids);

  /* create a send buffer and pack pdu in it, returns the NEW sbuf
     which still have to be cleared. Can be usefull to forward without repacking */
  int mkbuf(int encoding, PDU &pdu); 

  int send(int encoding, int tid, int msgtag, PDU &pdu);
  int mcast(int encoding, vector<int> &tids, int msgtag, PDU &pdu);
  int bcast(int encoding, char *group, int msgtag, PDU &pdu);
  int recv(int tid, int msgtag, PDU &pdu);  //synchrone blocking call

  void async_recv(int tid, int msgtag, int signal, PVM_SignalHandler_t, PDU *);
  /*on signal receipt, go straight away into signal_handler function
    which can then use the decoded pdu.
    Note: signal_handler need not to finish by 'return;' in order to continue
          execution of the program, since the defined handler is a redirection  */

  void TimeOut(long seconds, void(*handler)(void));
};
#endif



