/****************************************************************
  (c) 1994 by Daniel COHEN-LAROQUE        

   Version: 0.3
      File: pdu.h pdu.cxx
   Created: Mon Jul 25 13:56:04 GMT+0100 1994
  Revision: Time-stamp: <94/08/30 18:37:48 dev>
     Email: cohen_la@di.epfl.ch
  Platform: LINUX
      Note: as it should jointly be used with pvm++.h,
            applications have to be linked with libpvm++.a
****************************************************************/
#ifndef _pdu_h
#define _pdu_h

#include <pvm.h>
#include <vector.h>

class PDU {
/* Warning: like each pvm standard function, the void* pointer must be
            allocated. This is also true for vector<of_any_type> &reference

	    vector<float> &v;  //not valid
	    vector<float> &v = *new vector<float>;  //valid
	    vector<float> v;  //valid
	    PDU_unpack(v);  
*/
protected:
//PACK FUNCTIONS

  //char
  inline int PDU_pack(char *xp, int nitem, int stride = 1) { 
    return pvm_pkbyte(xp, nitem , stride); }  

  inline int PDU_pack(char *sp) { return pvm_pkstr(sp); }  // NULL terminated
  
  //float & double
  int PDU_pack(vector<float> &v, int stride = 1);
    //Obvious: v must be allocated

  inline int PDU_pack(float f, int stride = 1) {
    return pvm_pkfloat(&f, 1, stride); }

  inline int PDU_pack(float *fp, int nitem, int stride = 1) { 
    return pvm_pkfloat(fp, nitem, stride); }

  inline int PDU_pack(double d, int stride = 1) {
    return pvm_pkdouble(&d, 1, stride); } 

  inline int PDU_pack(double *dp, int nitem, int stride = 1) { 
    return pvm_pkdouble(dp, nitem, stride); }

  //int
  int PDU_pack(vector<int> &v, int stride = 1);

  inline int PDU_pack(int i, int stride = 1) {
    return pvm_pkint(&i, 1, stride); }

  inline int PDU_pack(int *up, int nitem, int stride = 1) { 
    return pvm_pkint(up, nitem, stride); }

  inline int PDU_pack(unsigned int u, int stride = 1) {
    return pvm_pkuint(&u, 1, stride); }

  inline int PDU_pack(unsigned int *up, int nitem, int stride = 1) { 
    return pvm_pkuint(up, nitem, stride); }

  //short
  inline int PDU_pack(short s, int stride = 1) {
    return pvm_pkshort(&s, 1, stride); }

  inline int PDU_pack(short *s, int nitem, int stride = 1) { 
    return pvm_pkshort(s, nitem, stride); }

  inline int PDU_pack(unsigned short us, int stride = 1) {
    return pvm_pkushort(&us, 1, stride); }

  inline int PDU_pack(unsigned short *us, int nitem, int stride = 1) { 
    return pvm_pkushort(us, nitem, stride); }

  //long
  inline int PDU_pack(long l, int stride = 1) {
    return pvm_pklong(&l, 1, stride); }

  inline int PDU_pack(long *l, int nitem, int stride = 1) { 
    return pvm_pklong(l, nitem, stride); }

  inline int PDU_pack(unsigned long ul, int stride = 1) {
    return pvm_pkulong(&ul, 1, stride); }

  inline int PDU_pack(unsigned long *up, int nitem, int stride = 1) { 
    return pvm_pkulong(up, nitem, stride); }

//UNPACK FUNCTIONS

  //char
  inline int PDU_unpack(char *xp, int nitem, int stride = 1) { 
    return pvm_upkbyte(xp, nitem , stride); }  

  inline int PDU_unpack(char *sp) { return pvm_upkstr(sp); }  // NULL terminated

  //float & double
  int PDU_unpack(vector<float> &v, int stride = 1);  
    //v is allocated inside

  inline int PDU_unpack(float *fp, int nitem, int stride = 1) { 
    return pvm_upkfloat(fp, nitem, stride); }
  
  inline int PDU_unpack(double *dp, int nitem, int stride = 1) { 
    return pvm_upkdouble(dp, nitem, stride); }

  //int
  int PDU_unpack(vector<int> &v, int stride = 1);
    //v is allocated inside

  inline int PDU_unpack(int *ip, int nitem = 1, int stride = 1) { 
    return pvm_upkint(ip, nitem, stride); }

  inline int PDU_unpack(unsigned int *up, int nitem = 1, int stride = 1) { 
    return pvm_upkuint(up, nitem, stride); }

  //short
  inline int PDU_unpack(short *up, int nitem = 1, int stride = 1) { 
    return pvm_upkshort(up, nitem, stride); }

  inline int PDU_unpack(unsigned short *up, int nitem = 1, int stride = 1) { 
    return pvm_upkushort(up, nitem, stride); }

  //long
  inline int PDU_unpack(long *up, int nitem = 1, int stride = 1) { 
    return pvm_upklong(up, nitem, stride); }

  inline int PDU_unpack(unsigned long *up, int nitem = 1, int stride = 1) { 
    return pvm_upkulong(up, nitem, stride); }

public:
  /* each derived class MUST implement his own version of pack & unpack
     based on the inline overloaded declarations above */
  virtual void pack() = 0;
  virtual void unpack() = 0;
};

//this class can be usefull when one wants to pass a NULL argument
class PDU_FOO: public PDU {
public:
  inline void pack() {}
  inline void unpack() {}
};

#endif
