// This may look like C code, but it is really -*- C++ -*-
#include <unistd.h>
#include <values.h>
#include <pvm++.h>
#include "token.h"

#define NoSendMask 0
#define NoRecvMask -1
#define TokenMask 1000

main(int argc, char **argv) {
  if(argc < 3) {
    cerr <<"Usage: " <<argv[0] <<" NbTurn  NbMembers" <<endl;
    exit(1);
  }
  int NbTurn = atoi(argv[1]);
  int NbMembers = atoi(argv[2]);

  if(argc == 3) {  //first call to argv[0], spawned or executed from shell
    PVM_Task Launcher;  //enroll with pvm

    vector<int> RingTIDs(NbMembers);
    char *CommandLine[] = {argv[1], argv[2], "foo", NULL};
    //Members are given a supplementary argument to differentiate from Launcher
    Launcher.spawn(argv[0], CommandLine, PvmTaskDefault, NULL, RingTIDs);
    
    //initialize each member: tell who to contact
    for(int i = 0; i < RingTIDs.length(); i++) {
      InitToken Next2Call(RingTIDs[(i + 1) % NbMembers]);
      Launcher.send(PvmDataDefault, RingTIDs[i], NoSendMask, Next2Call);
    }
    
    Token token;  //give token to the 1rst member
    cout <<"I give the token to " <<RingTIDs[0] <<endl;
    Launcher.send(PvmDataDefault, RingTIDs[0], TokenMask, token);

    cout <<"I wait for the token to be back" <<endl;
    Launcher.recv(RingTIDs[0], TokenMask, token);
    cout <<"\aLauncher is happy because the token turned " <<NbTurn <<" times" <<endl;
    //Launcher gets out of the scope, kill children before
  }
  else {  //executed by all the members
    PVM_Task RingMember;

    InitToken Next2Call;  //who have I to call ?
    RingMember.recv(RingMember.parent_tid(), NoRecvMask, Next2Call);

    int count = 0;
    Token token;
    while(true) {
      RingMember.recv(-1, TokenMask, token);
      if(count++ >= NbTurn) break;

      cout <<"count: " <<count <<", #" <<RingMember.my_tid() 
	   <<" passes the token to " <<Next2Call.NextTID <<endl;
      RingMember.send(PvmDataDefault, Next2Call.NextTID, TokenMask, token);
    }

    //trick: only the 1rst member to leave the loop will execute the
    //following lines since the other are stuck at the recv function
    cout <<RingMember.my_tid() <<" Sending back the token to parent" <<endl;
    RingMember.send(PvmDataDefault, RingMember.parent_tid(), TokenMask, token);

    sleep(MAXLONG);  //wait to be killed by parent
  }

  exit(0);
}




