#include <stdlib.h>
#include <MLCG.h>
#include <Normal.h>
#include <Uniform.h>
#include <pvm++.h>
#include "pdu_random.h"

PVM_Task *slave;
PDU_answer *ans;
int me, parent;

double
FlipCoin() {
  MLCG mlcg;
  mlcg.reseed(time(NULL), (long) getpid());
  Uniform unif_MLCG(0.0, 1.0, &mlcg);
  return unif_MLCG();
}

float 
Test_Gaussian_MLCG(PDU_request &pdu) {
  MLCG mlcg;
  mlcg.reseed(time(NULL), (long) getpid());
  Normal gauss_MLCG(pdu.mean_var[0], pdu.mean_var[1], &mlcg);

  float mean = 0.0;
  for(int i = 0; i < pdu.size; i++)
    mean += gauss_MLCG();
  
  return(mean / pdu.size);
}

main() {
  slave = new PVM_Task();
  me = slave->my_tid();
  parent = slave->parent_tid(); 

  pvm_joingroup(SLAVE_GROUP);

  //wait for an order from master
  PDU_request req;
  slave->recv(parent, COMPUTE, req);
  //cout <<"PDU_request received:" <<endl <<req <<endl;

  int whoami = req.tids.index(me);
  if(whoami == -1)
    slave->error("I don't know why I was spawned!");

  //create answer pdu 
  ans = new PDU_answer(whoami, Test_Gaussian_MLCG(req));

  PDU_Retransmit ret(me);  //initialized for the first transmission
  while(ret.who == me) {
    if(FlipCoin() > 0.5) { //simulate lost PDU (communication channel)
      slave->send(PvmDataDefault, parent, RESULT, *ans);

      //send a signal to warn parent to receive answer pdu
      pvm_sendsig(parent, SIGUSR1); 
    }

    //block for possible retransmission
    slave->recv(parent, RETRANSMIT, ret);
  }
}



