// This may look like C code, but it is really -*- C++ -*-
/****************************************************************
  (c) 1994 by Daniel COHEN-LAROQUE        

   Version: 1.0
      File: pdu_random.cxx pdu_random.h
   Created: Mon Jul 25 13:56:04 GMT+0100 1994
  Revision: Time-stamp: <94/08/15 12:27:46 dev>
     Email: cohen_la@di.epfl.ch
  Platform: LINUX
      Note: 
****************************************************************/
#ifndef _pdu_random_h
#define _pdu_random_h
#include <pdu.h>
#include <iostream.h>
#include <vector.h>

//masks
#define COMPUTE 1
#define RESULT  2
#define RETRANSMIT 3
#define SLAVE_GROUP "testers"

class PDU_Retransmit: public PDU {
public:
  int who;
  inline PDU_Retransmit() {}
  inline PDU_Retransmit(int whod): who(whod) {}
  
  inline void pack() { PDU_pack(who); }
  inline void unpack() { PDU_unpack(&who); }
};

class PDU_request: public PDU {
public:
  int size;  //length of random test
  vector<int> &tids;
  vector<float> &mean_var;

  inline PDU_request(): tids(*new vector<int>),\
                        mean_var(*new vector<float>) {}

  inline PDU_request(vector<int> &t_d, vector<float> &m_v_d, int s_d):\
                     size(s_d), tids(t_d), mean_var(m_v_d) {};
  
  void pack();
  void unpack();

  friend ostream & operator << (ostream &, PDU_request &);
};

class PDU_answer: public PDU {
public:
  int from;
  float mean;

  inline PDU_answer() {}
  inline PDU_answer(int f_d, float m_d): from(f_d), mean(m_d) {}

  void pack();
  void unpack();

  friend ostream & operator << (ostream &, PDU_answer &);
};
#endif







