// This may look like C code, but it is really -*- C++ -*-
#include <pvm.h>
#include <string.h>
#include "pdu_random.h"

/////////////////////////////////////////////////////////////////////
//REQUEST
void
PDU_request::pack() {
  PDU_pack(size);
  PDU_pack(tids);
  PDU_pack(mean_var);
}

void
PDU_request::unpack() {
  PDU_unpack(&size);
  PDU_unpack(tids);
  PDU_unpack(mean_var);
}

ostream & operator << (ostream & s, PDU_request &pdu)  {
  s <<"size: " <<pdu.size <<endl
    <<"tids: " <<pdu.tids <<endl
    <<"mean: " <<pdu.mean_var[0] <<endl
    <<"var : " <<pdu.mean_var[1] <<endl;

  return s;
}

/////////////////////////////////////////////////////////////////////
//ANSWER
void
PDU_answer::pack() {
  PDU_pack(&from, 1);
  PDU_pack(&mean, 1);
}

void
PDU_answer::unpack() {
  PDU_unpack(&from, 1);
  PDU_unpack(&mean, 1);
}

ostream & operator << (ostream & s, PDU_answer &pdu)  {
  s <<pdu.from <<"-->" <<pdu.mean;
  return s;
}

