
/*
 * PGPVM version 1.1: ParaGraph extensions for PVM
 *
 * Emory University, Atlanta GA 
 * Authors: Brad B. Topol, V. S. Sunderam, and Anders Alund
 * (C) 1996 All Rights Reserved
 *
 *                              NOTICE
 *
 * Permission to use, copy, modify, and distribute this software and
 * its documentation for any purpose and without fee is hereby granted
 * provided that the above copyright notice appear in all copies and
 * that both the copyright notice and this permission notice appear in
 * supporting documentation.
 *
 * Neither Emory University nor the Authors make any
 * representations about the suitability of this software for any
 * purpose.  This software is provided ``as is'' without express or
 * implied warranty.
 *
 */
#ifndef _PGTRACE_H_
#  define _PGTRACE_H_

#  ifdef __cplusplus
	 extern "C" {
#  endif
    int pg_tids            __ProtoGlarp__(( int *, int ));
    int pg_close           __ProtoGlarp__(( void ));
    int pg_outfile         __ProtoGlarp__(( char * ));
    int pg_chprefix        __ProtoGlarp__(( char * ));
#  ifdef __cplusplus
      }
#  endif

#  ifndef USE_PGTRACE
   int pg_tids(t,n) int *t;int n; {return (0);}
   int pg_close() {return (0);}
   int pg_outfile(t) char *t; {return (0);}
   int pg_chprefix(t) char *t; {return (0);}
#  else
#    define pvm_mytid pg_mytid
#    define pvm_exit pg_exit
#    define pvm_recv pg_recv
#    define pvm_nrecv pg_nrecv
#    define pvm_trecv pg_trecv
#    define pvm_send pg_send
#    define pvm_mcast pg_mcast
/*#define pvm_initsend pg_initsend */
#    define pvm_psend pg_psend
#    define pvm_precv pg_precv
#    ifdef __cplusplus
       extern "C" {
#    endif
     int pg_mytid           __ProtoGlarp__(( void ));
     int pg_exit            __ProtoGlarp__(( void ));
     int pg_recv            __ProtoGlarp__(( int, int ));
     int pg_nrecv           __ProtoGlarp__(( int, int ));
     int pg_trecv           __ProtoGlarp__(( int, int, struct timeval * ));
     int pg_send            __ProtoGlarp__(( int, int ));
     int pg_mcast           __ProtoGlarp__(( int *, int, int ));
     int pg_initsend        __ProtoGlarp__(( int ));
     int pg_psend           __ProtoGlarp__(( int, int, void *, int, int ));
     int pg_precv           __ProtoGlarp__(( int, int, void *, int, int, int *,
                                             int *, int * ));
#    ifdef __cplusplus
       }
#    endif
#  endif
#endif
