
      program slave1 
c PGPVM the next line may need to be modified depending on where
c this directory is located
      include '../../include/fpvm3.h'
c ------------------------------------------------------
c Example fortran program illustrating use of PVM 3
c In this part of the example, we are interested in 
c producing trace events for the communication (barring
c communication to the master node)  Therefore all slaves     
c not only change the communication calls to pgf__ but
c also call pgtids.  Note: when you want to run this 
c application and do not want trace information produced  
c just comment out the pgftids line.
c ------------------------------------------------------
      integer  info, info2, mytid, mtid, msgtype, me
      integer  tids(0:32)
      double precision result, data(100)
      double precision work

c  Enroll this program in PVM 
c  PGPVM change pvmfmytid to pgfmytid
      call pgfmytid( mytid )
c  Get the master's task id
      call pvmfparent( mtid )

c ------- Begin user program -------- 

c     Receive data from host 
      msgtype  = 1 
c PGPVM change pvmfrecv to pgfrecv.  In this case however,
c no tracing information will be produced because pgftids
c has not been called yet
      call pgfrecv( mtid, msgtype, info ) 
c PGPVM no need to change these calls
      call pvmfunpack( INTEGER4, nproc, 1, 1, info )
      call pvmfunpack( INTEGER4, tids, nproc, 1, info )
      call pvmfunpack( INTEGER4, n, 1, 1, info )
      call pvmfunpack( REAL8,    data, n, 1, info ) 
c PGPVM  The perfect place to call pgftids, right after receiving
c     the tids 
      call pgftids( tids, nproc, info2)
 
c     Determine which slave I am (0 -- nproc-1)
      do 5 i=0, nproc
         if( tids(i) .eq. mytid ) me = i
  5   continue
      
c     Do calculations with data
      result = work( me, n, data, tids, nproc ) 
                    
c     Send result to host 
      call pvmfinitsend( PVMDEFAULT, info )
      call pvmfpack( INTEGER4, me, 1, 1, info )
      call pvmfpack( REAL8,    result, 1, 1, info )
      msgtype  = 2 
c PGPVM  change pvmfsend to pgfsend
c tracing information will not be produced because although
c pgftids has been called, communication is not between two 
c tids that were elements of the tids array passed to pgpvm
c via pgftids
      call pgfsend( mtid, msgtype, info ) 

c --------- End user program -------- 

c     Program finished. Leave PVM before exiting 
c PGPVM change pvmfexit to pgfexit.  This surprisingly important
c Please do not forget to do this in your programs 
      call pgfexit(info) 
      stop
      end

      double precision function work( me, n, data, tids, nproc )
c PGPVM the next line may need to be modified depending on where
c this directory is located
      include '../../include/fpvm3.h'
c    --------------------------------------
c     Just a simple routine for illustration
c    --------------------------------------
      double precision data(*), sum, psum
      integer i, n, me, inum
      integer tids(0:*)

      sum = 0.0
      do 10 i=1,n
         sum = sum + me * data(i)
 10   continue
c     ----------------------------------------
c     Pass partial result to neighboring node
c     to illustrate node-to-node communication
c     ----------------------------------------
      call pvmfinitsend( PVMDEFAULT, info )
      call pvmfpack( REAL8, sum, 1, 1, info)
      inum = me+1
      if( inum .eq. nproc ) inum = 0
c PGPVM  change pvmfsend to pgfsend
c PGPVM change pvmfrecv to pgfrecv.  
c tracing information will be produced because pgftids
c has has been called and communication is between two 
c tids that were elements of the tids array passed to pgpvm
c via pgftids
      call pgfsend( tids(inum), 77, info )
      call pgfrecv(  -1, 77, info )
      call pvmfunpack( REAL8, psum, 1, 1, info)

      work = sum + psum
      return
      end
