
/*
 * PGPVM version 1.1: ParaGraph extensions for PVM
 *
 * Emory University, Atlanta GA 
 * Authors: Brad B. Topol, V. S. Sunderam, and Anders Alund
 * (C) 1996 All Rights Reserved
 *
 *                              NOTICE
 *
 * Permission to use, copy, modify, and distribute this software and
 * its documentation for any purpose and without fee is hereby granted
 * provided that the above copyright notice appear in all copies and
 * that both the copyright notice and this permission notice appear in
 * supporting documentation.
 *
 * Neither Emory University nor the Authors make any
 * representations about the suitability of this software for any
 * purpose.  This software is provided ``as is'' without express or
 * implied warranty.
 *
 */
#ifndef _CLOCKSYNC_H_
#define _CLOCKSYNC_H_

#define TRACE_START	 1
#define SEND     	 4
#define RECV		 6
#define RECV_BLOCKING	 7
#define RECV_WAKING	 8
#define COMPSTATS	11
#define TRACE_END	19
#define MAXLINE		50
#define NPROC		528

#define DONE 1
#define MATCHED 1
#define MU 1000
#ifndef	_MIN
#  define _MIN(a,b)	((a)<(b)?(a):(b))
#endif
#ifndef	_MAX
#  define _MAX(a,b)	((a)>(b)?(a):(b))
#endif

typedef struct {
  int sec;
  int usec;
} TimeRec;

#define DEST p1
#define SRC  p1
#define MSG_TAG p2
#define MSG_LEN p3

typedef struct _LineRec {
  struct _LineRec* prev;
  struct _LineRec* next;
  int event_type;
  int node;
  int p1;
  int p2;
  int p3;
  int mark;
  TimeRec orig_time;
  TimeRec adjust_time;
} LineRec;

#endif


