
/*
 *         PVM version 3.3:  Parallel Virtual Machine System
 *               University of Tennessee, Knoxville TN.
 *           Oak Ridge National Laboratory, Oak Ridge TN.
 *                   Emory University, Atlanta GA.
 *      Authors:  A. L. Beguelin, J. J. Dongarra, G. A. Geist,
 *    W. C. Jiang, R. J. Manchek, B. K. Moore, and V. S. Sunderam
 *                   (C) 1992 All Rights Reserved
 *
 *                              NOTICE
 *
 * Permission to use, copy, modify, and distribute this software and
 * its documentation for any purpose and without fee is hereby granted
 * provided that the above copyright notice appear in all copies and
 * that both the copyright notice and this permission notice appear in
 * supporting documentation.
 *
 * Neither the Institutions (Emory University, Oak Ridge National
 * Laboratory, and University of Tennessee) nor the Authors make any
 * representations about the suitability of this software for any
 * purpose.  This software is provided ``as is'' without express or
 * implied warranty.
 *
 * PVM version 3 was funded in part by the U.S. Department of Energy,
 * the National Science Foundation and the State of Tennessee.
 */

/*
 *	ddpro.h
 *
 *	Pvmd-pvmd protocol
 *
$Log: ddpro.h,v $
 * Revision 1.5  1996/05/13  20:24:06  manchek
 * added PVMDISTASK
 *
 * Revision 1.4  1995/05/17  16:06:18  manchek
 * cast DM_FIRST to int.
 * added debugging classes
 *
 * Revision 1.3  1994/07/18  19:19:27  manchek
 * added PDMWAITC
 *
 * Revision 1.2  1994/06/03  20:38:13  manchek
 * version 3.3.0
 *
 * Revision 1.1  1993/08/30  23:26:47  manchek
 * Initial revision
 *
 */


/* protocol version */

#ifndef	DDPROTOCOL
#define	DDPROTOCOL	2315
#endif

#define	DDMINRETRIES	10
#define	DDMAXRTT		9		/* seconds */
#define	DDMINTIMEOUT	(DDMINRETRIES*DDMAXRTT*2)	/* seconds */
#define	DDERRRETRY		300000	/* uSec */
#define	DDPINGTIME		60		/* (sec) between keepalive pings */
#define	DDBAILTIME		300		/* (sec) for new slave to bail if no config */

#define	NEXTSEQNUM(x)		(((x)+1)&0xffff)
#define	SEQNUMCOMPARE(x,y)	((x)<(y)||(((x)>0x8000)&&((y)<0x8000)))

/* message/frag hdr sizes */

#define	DDFRAGHDR		16
#define	DDMSGHDR		16

/* frag flags */

#define	FFDAT			4		/* packet contains data, seq num is valid */
#define	FFFIN			8		/* sender closing connection */
#define	FFACK			16		/* ack num is valid */

/* d-d message flavors */

#define	DM_FIRST		(int)0x80020001	/* first DM_ message */
#define	DM_ADD			(DM_FIRST+0)	/* add hosts to machine */
#define	DM_ADDACK		(DM_FIRST+1)
#define	DM_EXEC			(DM_FIRST+2)	/* start tasks */
#define	DM_EXECACK		(DM_FIRST+3)
#define	DM_SENDSIG		(DM_FIRST+4)	/* signal a task */
#define	DM_HTUPD		(DM_FIRST+5)	/* define new host table */
#define	DM_HTUPDACK		(DM_FIRST+6)
#define	DM_HTCOMMIT		(DM_FIRST+7)	/* switch to new host table */
#define	DM_SLCONF		(DM_FIRST+8)	/* config slave pvmd */
#define	DM_STARTACK		(DM_FIRST+9)	/* pvmd' completed slave startup */
#define	DM_TASK			(DM_FIRST+10)	/* get list of tasks */
#define	DM_TASKACK		(DM_FIRST+11)
#define	DM_DELHOST		(DM_FIRST+12)	/* delete hosts from machine */
#define	DM_DELHOSTACK	(DM_FIRST+13)
#define	DM_NULL			(DM_FIRST+14)	/* null message */
#define	DM_TASKOUT		(DM_FIRST+15)	/* task standard out/err data */
#define	DM_PSTAT		(DM_FIRST+16)	/* query status of task */
#define	DM_PSTATACK		(DM_FIRST+17)
#define	DM_HALT			(DM_FIRST+18)	/* request master pvmd to halt */
#define	DM_MCA			(DM_FIRST+19)	/* define multicast tid */
#define	DM_NOTIFY		(DM_FIRST+20)	/* request notify */
#define	DM_NOTIFYACK	(DM_FIRST+21)
#define	DM_DB			(DM_FIRST+22)	/* name-server request */
#define	DM_DBACK		(DM_FIRST+23)
#define	DM_HTDEL		(DM_FIRST+24)	/* delete hosts from host table */
#define	DM_HOSTSYNC		(DM_FIRST+25)	/* request clock sample */
#define	DM_HOSTSYNCACK	(DM_FIRST+26)
#define	DM_LAST			(DM_FIRST+26)	/* last DM_ message */

/* DM_SLCONF fields - don't use 0 */

#define	DM_SLCONF_EP	1		/* set epath */
#define	DM_SLCONF_BP	2		/* set bpath */
#define	DM_SLCONF_WD	3		/* set wdir */
#define	DM_SLCONF_SCHED	4		/* set scheduler tid */

/* pvmd debug mask */

#define	PDMPACKET		1		/* packet tracing */
#define	PDMMESSAGE		2		/* message tracing */
#define	PDMTASK			4		/* task tracing */
#define	PDMSTARTUP		8		/* new slave startup */
#define	PDMHOST			16		/* host table stuff */
#define	PDMSELECT		32		/* select/fd set stuff */
#define	PDMNET			64		/* ip stuff */
#define	PDMSCHED		256		/* scheduler stuff */
#define	PDMAPPL			512		/* application (scrapped messages and stuff) */
#define	PDMWAITC		1024	/* wait contexts */
#define	PDMMEM			2048	/* shared memory */
#define	PDMSEM			4096	/* semaphores */
#define	PDMLOCK			8192	/* locks */

/* pvmd run states */

#define	PVMDNORMAL		1		/* normal running state */
#define	PVMDHTUPD		2		/* getting host table update */
#define	PVMDSTARTUP		3		/* slave just started, not fully configured */
#define	PVMDPRIME		4		/* am pvmd' */
#define	PVMDHALTING		5		/* stopping rsn */
#define	PVMDSHUTDOWN	6		/* in timeout to halt, waiting for FIN|ACK */
#define	PVMDISTASK		7		/* between fork and exec to spawn task */

