/*
        Adsmith 1.8 :  An Efficient Object-Based DSM Environment on PVM
    
                        Author:  William W. Y. Liang

           Institute of Computer Science & Information Engineering
                   National Taiwan University, Taipei, TW

                   Copyright (C) 1996 All Rights Reserved

                                  NOTICE

      Permission to use, copy, modify, and distribute this software and
      its documentation for any purpose and without fee is hereby granted
      provided that the above copyright notice appear in all copies and
      that both the copyright notice and this permission notice appear in
      supporting documentation.

      The author makes no representations about the suitability of this
      software for any purpose.  This software is provided ``as is''
      without express or implied warranty.
*/

// This file contains those functions which may cause problems on porting
// to other systems. Modify it whenever this happen.

#ifndef __ADSMSYSDEP_H__
#define __ADSMSYSDEP_H__

// -- force exiting --

#include <unistd.h>

void sysdep_exit(int status) {
  _exit(status);
}

// -- set new exception handler --

typedef void (*new_handler)();
extern "C" new_handler set_new_handler (new_handler);

// handler for memory lacking, used by the following function
static void shutdown();
static void lack_memory() {
  cerr<<"Adsmith: Memory lacking..."<<endl;
  shutdown();
  sysdep_exit(-1);
}

void sysdep_set_new_handler() {
  set_new_handler(lack_memory); 
}

#endif // __ADSMSYSDEP_H__
