/*
        Adsmith 1.8 :  An Efficient Object-Based DSM Environment on PVM
    
                        Author:  William W. Y. Liang

           Institute of Computer Science & Information Engineering
                   National Taiwan University, Taipei, TW

                   Copyright (C) 1996 All Rights Reserved

                                  NOTICE

      Permission to use, copy, modify, and distribute this software and
      its documentation for any purpose and without fee is hereby granted
      provided that the above copyright notice appear in all copies and
      that both the copyright notice and this permission notice appear in
      supporting documentation.

      The author makes no representations about the suitability of this
      software for any purpose.  This software is provided ``as is''
      without express or implied warranty.
*/
#include <stdio.h>
#include <iostream.h>
#include "pvm3.h"
#include "adsm.h"
#include "dynarr.h"
#include "hash.h"
#include "cohver.h"

// number of outgoing message to clean
#define CLEAN_OUTMSG_NUM 100
#define CLEAN_INMSG_NUM  100

// Object Status Definition
#define AdsmObjStatusValid		0x0001
#define AdsmObjStatusInit		0x0002
#define AdsmObjStatusInAtomic		0x0004
#define AdsmObjStatusPrefetching	0x0008
#define AdsmObjStatusBulkRefresh	0x0010
#define AdsmObjStatusWriting		0x0020
#define AdsmObjStatusAllocating		0x0040

// Shared Object

class Adsmith;

class AdsmObj {

friend class Adsmith;

// protected:
public:

  char *ident;		// name of the object
  short home;		// home number, between 0~nhost 
  int gindex;		// global index
  int size;		// size of the data
  short hint;		// hint from compiler/programmer
 
  short status;		// status of the object

  short count;		// number of malloc or attach

  char	atomic_type;	// read or write for atomic state
  short collectnum;	// num of collecting process

  VarChainEntry *hash_entry;    //1.8.0d// temporary pointer in hash table
 
  char *data;		// cached data, can be modified
  char *olddata;	// cached data to compare with modified one

public:

  AdsmObj(char *id,int gidx,int sz,short hnt,
          short hm,void *initdata,VarChainEntry *h_entry);
  ~AdsmObj();

  // Ordinary accesses
  void prefresh();
  void refresh();
  void flush();

  // Nsync accesses
  void refresh_now();
  void flush_now();

  // also treated as Nsync access
  void atomic_begin(char rw=AdsmAtomicWrite,short cltnum=0);
  void atomic_end();
  void atomic(char *expr);

  // validation
  void validate(int force=-100);
};

// System Object

class Adsmith {

friend class AdsmObj;

// private:
public:

  int  mytid;			// my tid
  int  ptid;			// parent tid
  int  ldtid;			// local daemon tid
  int  pdtid;			// local pvm daemon tid
  int  mdtid;			// master daemon tid

  short hostno;			// host number
  short procno;			// process number

  char	*arch;			// architecture type
  short	nhost;			// host number
  int	*htab_dtids;		// daemon tids

  int	is_starter;		// is this the first process
  int	active;			// is system active

  short nproc;			// process number
  int   *proc_tids;		// process tids
  short *proc_hostnos;		// process hostnos

  int unique_turn;              // next host where unique object is allocated

  int bulk_refresh;		// in refresh aggregation
  int bulk_prefresh;		// in prefresh aggregation
  int bulk_malloc;		// in malloc aggregation

  int writenum;			// count of pipeline writing
  int readnum;			// count of prefetch
  int allocnum;			// count of allocation

  DynArray<short>    homelist;	// daemons from which data are cached here
  DynArray<int>      childlist;	// list of children's tids
  DynArray<AdsmObj*> *alloclist;// objects to be allocated
  DynArray<AdsmObj*> *writelist;// objects to be written
  DynArray<AdsmObj*> *readlist;	// objects to be read
  DynArray<int>      gndxlist;	// the same as readlist

  unsigned long *cohvec;	// received coherence version vector
  CohVerTab cohvertab;		// newest coherence version table

  VarHashTab hash_tab;		// identifiers' hash table
  int maxobjnum;		// size of objlist
  int objnum;			// number of objects in this process
  AdsmObj **objlist; 		// list of pointer to objects

public:

  Adsmith();				// register into the system
  ~Adsmith();

  unsigned long flag_setting();		// set system control flags
  void startup();			// startup daemons
  void shutdown();			// shutdown the system

  void  getproctids();			// load proc_tids from local daemon
  int   procno2tid(short procno);	// translate proceno to tid
  short tid2procno(int tid);		// translate tid to proceno
  short procno2hostno(short procno);	// translate proceno to hostno

  void *allocate(char *id,int size,short hint,void *init,short home);
  void bulkallocate();
  void doneallocate(AdsmObj *obj=NULL);
  void *attach(int gindex);		// attach #gindex to local address

  AdsmObj *get_sctrl(void *data);	// get share conrotl

  void coherent();			// deal with coherence message

  void bulkprefresh();			// aggregate prefresh
  void donerefresh(int waitindex);	// wait till #waitindex arrive

  void bulkflush();			// aggregate flush
  void doneflush();			// wait flush done

  void check_maxobjnum(int gtsize);	// check size of objlist

};

// aligned on 64bit/word basis to prevent BUS error
#define ALIGNED_AdsmObj_SIZE ((sizeof(AdsmObj)+7)/8)*8

// Message Head

struct MsgHead { int useless; };

// other prototypes

extern "C" int pvm_catchout(FILE *ff);
static ostream& operator<<(ostream& s, MsgHead& m);
