/*
        Adsmith 1.8 :  An Efficient Object-Based DSM Environment on PVM
 
                        Author:  William W. Y. Liang
 
           Institute of Computer Science & Information Engineering
                   National Taiwan University, Taipei, TW
 
                   Copyright (C) 1996 All Rights Reserved
 
                                  NOTICE
 
      Permission to use, copy, modify, and distribute this software and
      its documentation for any purpose and without fee is hereby granted
      provided that the above copyright notice appear in all copies and
      that both the copyright notice and this permission notice appear in
      supporting documentation.
 
      The author makes no representations about the suitability of this
      software for any purpose.  This software is provided ``as is''
      without express or implied warranty.
*/

#ifndef __COMMON_H__
#define __COMMON_H__

#include <iostream.h>
#include <string.h>
#include <values.h>
#include "pvm3.h"
#include "sysdep.h"

// version
#define VERSION "1.8.0i"

// global variable table
#define GLB_TABLE_SIZE  1000

// name length
#define MAX_NAME_LEN 64

// dynamic array grow gap
#define DYN_GAP	8

// hash table size
#define HASH_NUM 1000

// message check tag
#define CHECKCODE	13579	// random number

// special object name header
#define UNIQUE_OBJ      "#U"
#define BARRIER_OBJ     "#B"
#define MUTEX_OBJ       "#M"
#define SEMAPHORE_OBJ   "#S"

// System Channels
#define ADSM_CHANNEL_CMD	MAXINT   // normal channel: for ordered access
#define ADSM_CHANNEL_COHERENCE	MAXINT-1 // coherence channel: Out Of Order (3O)
#define ADSM_CHANNEL_REFRESH	MAXINT-2 // prefetch channel (3O)
#define ADSM_CHANNEL_FLUSH	MAXINT-3 // pipeline write channel (3O)
#define ADSM_CHANNEL_DANGER	MAXINT-4 // data initialize channel: in order
#define ADSM_CHANNEL_EXIT	MAXINT-5 // child exit channel (3O)
#define ADSM_CHANNEL_ALLOCATE	MAXINT-6 // object allocation channel (3O)
#define ADSM_CHANNEL_ACK	MAXINT-7 // acknowledge channel
#define ADSM_CHANNEL_ACK2	MAXINT-7 // acknowledge channel for atomic

// System Control Flags
#define AdsmCtrlDbgApp	0x00000001	// debug application
#define AdsmCtrlDbgDmn	0x00000002	// debug daemon
#define AdsmCtrlDbgTrc	0x00000004	// trace all
#define AdsmCtrlDbgDat	0x00000008	// trace with dumping data
#define AdsmCtrlSttObj	0x00000010	// statistics number of objects
#define AdsmCtrlSttRst	0x00000020	// statistics of rest info
#define AdsmCtrlSttHsh	0x00000040	// statistics of hash table
#define AdsmCtrlMsgTtl	0x00000080	// statistics of message
#define AdsmCtrlMsgCls	0x00000100	// classiy message statistics
#define AdsmCtrlOptHsk	0x00000200	// handshake option
#define AdsmCtrlOptPDR	0x00000400	// pvm daemon routing
#define AdsmCtrlInfVer	0x00000800	// version information 
#define AdsmCtrlTimMod	0x00001000	// timing of modify set
#define AdsmCtrlTimTtl	0x00002000	// timing of total process
#define AdsmCtrlTimPkt	0x00004000	// timing of (un)packing
#define AdsmCtrlTimIdl	0x00008000	// timing of idleness
#define AdsmCtrlOptAck	0x00010000	// acknowledge option
#define AdsmCtrlOptMix	0x00020000	// heterogeneous mode

// Coherence Types
enum AdsmCoherence { 
  ADSM_COHERENCE_INV,
  ADSM_COHERENCE_UPDATE,
  ADSM_COHERENCE_HANDSHAKE
};

// System Commands
enum AdsmCmd { 
  ADSMD_CMD_INIT, 
  ADSMD_CMD_ENROLL, 
  ADSMD_CMD_HANDSHAKE, 
  ADSMD_CMD_REGISTER,
  ADSMD_CMD_ATTACH,
  ADSMD_CMD_UNDECL,
  ADSMD_CMD_MASTERUNDECL, 
  ADSMD_CMD_PROCTIDS, 
  ADSMD_CMD_REFRESH, 
  ADSMD_CMD_REFRESH_NOW,
  ADSMD_CMD_ATOMIC_BEGIN,
  ADSMD_CMD_ATOMIC,
  ADSMD_CMD_FLUSH, 
  ADSMD_CMD_FLUSH_NOW,
  ADSMD_CMD_ACK,
  ADSMD_CMD_ATOMIC_END,
  ADSMD_CMD_P, 
  ADSMD_CMD_LOCK, 
  ADSMD_CMD_BARRIER, 
  ADSMD_CMD_V, 
  ADSMD_CMD_UNLOCK, 
  ADSMD_CMD_EXIT, 
  ADSMD_CMD_SHUTDOWN,
  ADSMD_CMD_DEBUG,
  ADSMD_CMD_STATISTICS,
  ADSMD_CMD_SPAWN 
};

static void shutdown();

static void Exit(char *file=NULL,int line=-1,int halt=1) {
  if (file!=NULL&&line>=0) {
    cerr<<"Exit from "<<file<<" line "<<line<<endl
        <<"Congratulations! you just catched a BUG, "<<endl
        <<"please send a report to wyliang@orchid.ee.ntu.edu.tw "<<endl
        <<"with error messages, and the application source codes or "<<endl
        <<"segments if possible. Thank you very much! "<<endl;
  }

  if (halt) shutdown(); // shutdown the whole system

  sysdep_exit(-1);
}

inline int align(int num,int bound) {
  return (num+bound-1)/bound*bound;
}

inline int default_home(short hashindex,int nhost) {
  return hashindex%nhost;
}

inline void *my_memcpy(void *dest,void *src,size_t n) {
  if (n<=0 || !dest || !src ) return NULL;
  unsigned char *d=(unsigned char*)dest,*s=(unsigned char*)src;
  for (n++; n--; d++,s++) *d=*s;
  return dest;
}

inline char *my_strdup(char *s) {
  if (!s) return NULL;
  int len=strlen(s);
  char *t=new char[len+1];
  for (int i=0; i<=len; i++) t[i]=s[i];
  return t;
}

// string encoding
inline int str_encode(const char *str) {
  int code;
  for (code=0; *str!=0; str++)
    code+=*str;
  return code;
}

// 4 bit to hex character representation
inline char halfbyte2hex(int d) {
  d&=0x0f;
  return d<10?(d+'0'):(d-10+'a');
}

// integer to 4 byte
inline char *int2fourbyte(int i,char *b) {
  unsigned char *c=(unsigned char*)b;
  c[0]=(i&0xff000000)>>24;
  c[1]=(i&0x00ff0000)>>16;
  c[2]=(i&0x0000ff00)>>8;
  c[3]=(i&0x000000ff);
  return b;
}

// 4 byte to integer
inline int fourbyte2int(char *b) {
  unsigned char *c=(unsigned char*)b;
  return (c[0]<<24)|(c[1]<<16)|(c[2]<<8)|c[3];
}

// check if an identifier is unique
inline int unique(char *id) {
  return id[0]==UNIQUE_OBJ[0]&&id[1]==UNIQUE_OBJ[1];
}

inline int is_local(int tid) { 
  static int myhost=-1;
  if (myhost<0) myhost=pvm_tidtohost(pvm_mytid());
  return myhost==pvm_tidtohost(tid); 
}

#endif // __COMMON_H__
