

/*  A Bison parser, made from calc.y
 by  GNU Bison version 1.25
  */

#define YYBISON 1  /* Identify Bison output.  */

#define	CHAR	258
#define	SHORT	259
#define	INT	260
#define	LONG	261
#define	FLOAT	262
#define	DOUBLE	263
#define	UCHAR	264
#define	USHORT	265
#define	UINT	266
#define	ULONG	267
#define	CONST	268
#define	OPND	269
#define	SIN	270
#define	COS	271
#define	TAN	272
#define	ASIN	273
#define	ACOS	274
#define	ATAN	275
#define	SINH	276
#define	COSH	277
#define	TANH	278
#define	ASINH	279
#define	ACOSH	280
#define	ATANH	281
#define	EXP	282
#define	LOG	283
#define	LN	284
#define	POW	285
#define	AE	286
#define	SE	287
#define	ME	288
#define	DE	289
#define	OR	290
#define	AND	291
#define	EQ	292
#define	NE	293
#define	GE	294
#define	LE	295
#define	ERROR	296
#define	RE	297
#define	AA	298
#define	SS	299


/*
        Adsmith 1.0 :  An Efficient Object-Based DSM Environment on PVM
 
                        Author:  William W. Y. Liang
 
           Institute of Computer Science & Information Engineering
                   National Taiwan University, Taipei, TW
 
                   Copyright (C) 1996 All Rights Reserved

                                  NOTICE

      Permission to use, copy, modify, and distribute this software and
      its documentation for any purpose and without fee is hereby granted
      provided that the above copyright notice appear in all copies and
      that both the copyright notice and this permission notice appear in
      supporting documentation.

      The author makes no representations about the suitability of this
      software for any purpose.  This software is provided ``as is''
      without express or implied warranty.
*/

/*--------------------------------------------------------------------------//
// Program Name : parser of calculator for Adsmith atomic operation         //
// Author : William W. Y. Liang, Luke Luo                                   //
// Last Update :11/04                                                       //
//                                                                          //
// Document:                                                                //
//	Interface: calc(char *expression,char *data);                       //
//	Grammar of expression: '[' type ']' expr                            //
//	Provide features: General expression in C.                          //
//	Restriction: Bit operation is not provided.                         //
//	             Nested ?: must use parenthesis.                        //
//	Note: During compuation, all operands are in form of type double.   //
//	      Caller of 'calc' should specify exact data type.              //
//--------------------------------------------------------------------------*/

#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <math.h>
#include <malloc.h>
#include "calc.h"

enum Type {  Char,  Short,  Int,  Long, Float, Double,
            UChar, UShort, UInt, ULong };

double ref();
void   assign(double val);
void   yyerror(char* msg);

static char *target;
static char *errmsg=NULL;
static enum Type type;
static int disable=0;	// guard to assign value to target
#ifndef YYSTYPE
#define YYSTYPE int
#endif
#include <stdio.h>

#ifndef __cplusplus
#ifndef __STDC__
#define const
#endif
#endif



#define	YYFINAL		153
#define	YYFLAG		-32768
#define	YYNTBASE	61

#define YYTRANSLATE(x) ((unsigned)(x) <= 299 ? yytranslate[x] : 72)

static const char yytranslate[] = {     0,
     2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
     2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
     2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
     2,     2,    52,     2,     2,     2,    51,     2,     2,    59,
    60,    49,    47,    42,    48,     2,    50,     2,     2,     2,
     2,     2,     2,     2,     2,     2,     2,    58,     2,    45,
    44,    46,    57,     2,     2,     2,     2,     2,     2,     2,
     2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
     2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
    55,     2,    56,     2,     2,     2,     2,     2,     2,     2,
     2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
     2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
     2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
     2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
     2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
     2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
     2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
     2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
     2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
     2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
     2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
     2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
     2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
     2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
     2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
     2,     2,     2,     2,     2,     1,     2,     3,     4,     5,
     6,     7,     8,     9,    10,    11,    12,    13,    14,    15,
    16,    17,    18,    19,    20,    21,    22,    23,    24,    25,
    26,    27,    28,    29,    30,    31,    32,    33,    34,    35,
    36,    37,    38,    39,    40,    41,    43,    53,    54
};

#if YYDEBUG != 0
static const short yyprhs[] = {     0,
     0,     5,     7,     9,    11,    13,    15,    17,    19,    21,
    23,    25,    29,    33,    37,    41,    45,    49,    53,    55,
    56,    57,    58,    59,    69,    71,    75,    79,    83,    87,
    91,    95,    99,   103,   107,   111,   115,   119,   123,   126,
   129,   132,   134,   137,   140,   143,   146,   148,   150,   154,
   156,   161,   166,   171,   176,   181,   186,   191,   196,   201,
   206,   211,   216,   221,   226,   231
};

static const short yyrhs[] = {    55,
    62,    56,    63,     0,     3,     0,     4,     0,     5,     0,
     6,     0,     7,     0,     8,     0,     9,     0,    10,     0,
    11,     0,    12,     0,    63,    42,    63,     0,    14,    43,
    63,     0,    14,    31,    63,     0,    14,    32,    63,     0,
    14,    44,    63,     0,    14,    33,    63,     0,    14,    34,
    63,     0,    64,     0,     0,     0,     0,     0,    69,    65,
    57,    66,    69,    67,    58,    68,    69,     0,    69,     0,
    69,    35,    69,     0,    69,    36,    69,     0,    69,    37,
    69,     0,    69,    38,    69,     0,    69,    45,    69,     0,
    69,    40,    69,     0,    69,    46,    69,     0,    69,    39,
    69,     0,    69,    47,    69,     0,    69,    48,    69,     0,
    69,    49,    69,     0,    69,    50,    69,     0,    69,    51,
    69,     0,    47,    69,     0,    48,    69,     0,    52,    69,
     0,    70,     0,    14,    53,     0,    14,    54,     0,    53,
    14,     0,    54,    14,     0,    14,     0,    13,     0,    59,
    63,    60,     0,    71,     0,    15,    59,    63,    60,     0,
    16,    59,    63,    60,     0,    17,    59,    63,    60,     0,
    18,    59,    63,    60,     0,    19,    59,    63,    60,     0,
    20,    59,    63,    60,     0,    21,    59,    63,    60,     0,
    22,    59,    63,    60,     0,    23,    59,    63,    60,     0,
    24,    59,    63,    60,     0,    25,    59,    63,    60,     0,
    26,    59,    63,    60,     0,    27,    59,    63,    60,     0,
    29,    59,    63,    60,     0,    28,    59,    63,    60,     0,
    30,    59,    63,    42,    63,    60,     0
};

#endif

#if YYDEBUG != 0
static const short yyrline[] = { 0,
    80,    83,    84,    85,    86,    87,    88,    89,    90,    91,
    92,    95,    97,    98,    99,   100,   101,   102,   103,   106,
   107,   108,   109,   110,   111,   114,   116,   118,   119,   121,
   122,   123,   124,   126,   127,   129,   130,   131,   133,   134,
   135,   136,   139,   140,   141,   142,   144,   145,   147,   148,
   151,   152,   153,   154,   155,   156,   157,   158,   159,   160,
   161,   162,   163,   164,   165,   166
};
#endif


#if YYDEBUG != 0 || defined (YYERROR_VERBOSE)

static const char * const yytname[] = {   "$","error","$undefined.","CHAR","SHORT",
"INT","LONG","FLOAT","DOUBLE","UCHAR","USHORT","UINT","ULONG","CONST","OPND",
"SIN","COS","TAN","ASIN","ACOS","ATAN","SINH","COSH","TANH","ASINH","ACOSH",
"ATANH","EXP","LOG","LN","POW","AE","SE","ME","DE","OR","AND","EQ","NE","GE",
"LE","ERROR","','","RE","'='","'<'","'>'","'+'","'-'","'*'","'/'","'%'","'!'",
"AA","SS","'['","']'","'?'","':'","'('","')'","prog","type","expr","cond","@1",
"@2","@3","@4","expr1","primary","func", NULL
};
#endif

static const short yyr1[] = {     0,
    61,    62,    62,    62,    62,    62,    62,    62,    62,    62,
    62,    63,    63,    63,    63,    63,    63,    63,    63,    65,
    66,    67,    68,    64,    64,    69,    69,    69,    69,    69,
    69,    69,    69,    69,    69,    69,    69,    69,    69,    69,
    69,    69,    70,    70,    70,    70,    70,    70,    70,    70,
    71,    71,    71,    71,    71,    71,    71,    71,    71,    71,
    71,    71,    71,    71,    71,    71
};

static const short yyr2[] = {     0,
     4,     1,     1,     1,     1,     1,     1,     1,     1,     1,
     1,     3,     3,     3,     3,     3,     3,     3,     1,     0,
     0,     0,     0,     9,     1,     3,     3,     3,     3,     3,
     3,     3,     3,     3,     3,     3,     3,     3,     2,     2,
     2,     1,     2,     2,     2,     2,     1,     1,     3,     1,
     4,     4,     4,     4,     4,     4,     4,     4,     4,     4,
     4,     4,     4,     4,     4,     6
};

static const short yydefact[] = {     0,
     0,     2,     3,     4,     5,     6,     7,     8,     9,    10,
    11,     0,     0,    48,    47,     0,     0,     0,     0,     0,
     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
     0,     0,     0,     0,     0,     0,     0,     1,    19,    25,
    42,    50,     0,     0,     0,     0,     0,     0,    43,    44,
     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
     0,     0,     0,     0,     0,     0,    47,    39,    40,    41,
    45,    46,     0,     0,     0,     0,     0,     0,     0,     0,
     0,     0,     0,     0,     0,     0,     0,     0,    14,    15,
    17,    18,    13,    16,     0,     0,     0,     0,     0,     0,
     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
    49,    12,    26,    27,    28,    29,    33,    31,    30,    32,
    34,    35,    36,    37,    38,    21,    51,    52,    53,    54,
    55,    56,    57,    58,    59,    60,    61,    62,    63,    65,
    64,     0,     0,    12,    22,    66,     0,    23,     0,    24,
     0,     0,     0
};

static const short yydefgoto[] = {   151,
    12,    38,    39,    88,   143,   147,   149,    40,    41,    42
};

static const short yypact[] = {   -13,
   248,-32768,-32768,-32768,-32768,-32768,-32768,-32768,-32768,-32768,
-32768,    24,    43,-32768,    45,   -18,    22,    25,    26,    28,
    46,    47,    48,    50,    51,    54,    55,    56,    57,    80,
    81,   105,   105,   105,    89,   127,    43,   104,-32768,   130,
-32768,-32768,    43,    43,    43,    43,    43,    43,-32768,-32768,
    43,    43,    43,    43,    43,    43,    43,    43,    43,    43,
    43,    43,    43,    43,    43,    43,   -15,   -14,   -14,-32768,
-32768,-32768,   -27,    43,   105,   105,   105,   105,   105,   105,
   105,   105,   105,   105,   105,   105,   105,    90,-32768,-32768,
-32768,-32768,-32768,-32768,   -26,    32,    33,    40,    41,    44,
    52,    94,    95,    96,   100,   101,   102,   103,   129,   106,
-32768,-32768,   171,   186,   199,   199,   -43,   -43,   -43,   -43,
   -14,   -14,-32768,-32768,-32768,-32768,-32768,-32768,-32768,-32768,
-32768,-32768,-32768,-32768,-32768,-32768,-32768,-32768,-32768,-32768,
-32768,    43,   105,    91,   155,-32768,    92,-32768,   105,   155,
   149,   172,-32768
};

static const short yypgoto[] = {-32768,
-32768,   -34,-32768,-32768,-32768,-32768,-32768,   -32,-32768,-32768
};


#define	YYLAST		260


static const short yytable[] = {    68,
    69,    70,    73,    83,    84,    85,    86,    87,    89,    90,
    91,    92,    93,    94,    74,    74,    95,    96,    97,    98,
    99,   100,   101,   102,   103,   104,   105,   106,   107,   108,
   109,   110,   111,   127,    85,    86,    87,    49,    50,   112,
    51,     1,   113,   114,   115,   116,   117,   118,   119,   120,
   121,   122,   123,   124,   125,    14,    15,    16,    17,    18,
    19,    20,    21,    22,    23,    24,    25,    26,    27,    28,
    29,    30,    31,    74,    74,    43,    44,    45,    46,    13,
    52,    74,    74,    53,    54,    74,    55,    47,    48,    32,
    33,   128,   129,    74,    34,    35,    36,    49,    50,   130,
   131,    37,    71,   132,    56,    57,    58,   144,    59,    60,
   145,   133,    61,    62,    63,    64,   150,    14,    67,    16,
    17,    18,    19,    20,    21,    22,    23,    24,    25,    26,
    27,    28,    29,    30,    31,    74,    74,    74,    65,    66,
    72,    74,    74,    74,    74,    74,   126,   142,   152,   148,
   146,    32,    33,   134,   135,   136,    34,    35,    36,   137,
   138,   139,   140,    37,    75,    76,    77,    78,    79,    80,
    74,   153,     0,     0,    81,    82,    83,    84,    85,    86,
    87,     0,     0,     0,     0,     0,   -20,     0,   141,    75,
    76,    77,    78,    79,    80,     0,     0,     0,     0,    81,
    82,    83,    84,    85,    86,    87,    76,    77,    78,    79,
    80,     0,     0,     0,     0,    81,    82,    83,    84,    85,
    86,    87,    77,    78,    79,    80,     0,     0,     0,     0,
    81,    82,    83,    84,    85,    86,    87,    79,    80,     0,
     0,     0,     0,    81,    82,    83,    84,    85,    86,    87,
     2,     3,     4,     5,     6,     7,     8,     9,    10,    11
};

static const short yycheck[] = {    32,
    33,    34,    37,    47,    48,    49,    50,    51,    43,    44,
    45,    46,    47,    48,    42,    42,    51,    52,    53,    54,
    55,    56,    57,    58,    59,    60,    61,    62,    63,    64,
    65,    66,    60,    60,    49,    50,    51,    53,    54,    74,
    59,    55,    75,    76,    77,    78,    79,    80,    81,    82,
    83,    84,    85,    86,    87,    13,    14,    15,    16,    17,
    18,    19,    20,    21,    22,    23,    24,    25,    26,    27,
    28,    29,    30,    42,    42,    31,    32,    33,    34,    56,
    59,    42,    42,    59,    59,    42,    59,    43,    44,    47,
    48,    60,    60,    42,    52,    53,    54,    53,    54,    60,
    60,    59,    14,    60,    59,    59,    59,   142,    59,    59,
   143,    60,    59,    59,    59,    59,   149,    13,    14,    15,
    16,    17,    18,    19,    20,    21,    22,    23,    24,    25,
    26,    27,    28,    29,    30,    42,    42,    42,    59,    59,
    14,    42,    42,    42,    42,    42,    57,    42,     0,    58,
    60,    47,    48,    60,    60,    60,    52,    53,    54,    60,
    60,    60,    60,    59,    35,    36,    37,    38,    39,    40,
    42,     0,    -1,    -1,    45,    46,    47,    48,    49,    50,
    51,    -1,    -1,    -1,    -1,    -1,    57,    -1,    60,    35,
    36,    37,    38,    39,    40,    -1,    -1,    -1,    -1,    45,
    46,    47,    48,    49,    50,    51,    36,    37,    38,    39,
    40,    -1,    -1,    -1,    -1,    45,    46,    47,    48,    49,
    50,    51,    37,    38,    39,    40,    -1,    -1,    -1,    -1,
    45,    46,    47,    48,    49,    50,    51,    39,    40,    -1,
    -1,    -1,    -1,    45,    46,    47,    48,    49,    50,    51,
     3,     4,     5,     6,     7,     8,     9,    10,    11,    12
};
/* -*-C-*-  Note some compilers choke on comments on `#line' lines.  */


/* Skeleton output parser for bison,
   Copyright (C) 1984, 1989, 1990 Free Software Foundation, Inc.

   This program is free software; you can redistribute it and/or modify
   it under the terms of the GNU General Public License as published by
   the Free Software Foundation; either version 2, or (at your option)
   any later version.

   This program is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
   GNU General Public License for more details.

   You should have received a copy of the GNU General Public License
   along with this program; if not, write to the Free Software
   Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.  */

/* As a special exception, when this file is copied by Bison into a
   Bison output file, you may use that output file without restriction.
   This special exception was added by the Free Software Foundation
   in version 1.24 of Bison.  */

#ifndef alloca
#ifdef __GNUC__
#define alloca __builtin_alloca
#else /* not GNU C.  */
#if (!defined (__STDC__) && defined (sparc)) || defined (__sparc__) || defined (__sparc) || defined (__sgi)
#include <alloca.h>
#else /* not sparc */
#if defined (MSDOS) && !defined (__TURBOC__)
#include <malloc.h>
#else /* not MSDOS, or __TURBOC__ */
#if defined(_AIX)
#include <malloc.h>
 #pragma alloca
#else /* not MSDOS, __TURBOC__, or _AIX */
#ifdef __hpux
#ifdef __cplusplus
extern "C" {
void *alloca (unsigned int);
};
#else /* not __cplusplus */
void *alloca ();
#endif /* not __cplusplus */
#endif /* __hpux */
#endif /* not _AIX */
#endif /* not MSDOS, or __TURBOC__ */
#endif /* not sparc.  */
#endif /* not GNU C.  */
#endif /* alloca not defined.  */

/* This is the parser code that is written into each bison parser
  when the %semantic_parser declaration is not specified in the grammar.
  It was written by Richard Stallman by simplifying the hairy parser
  used when %semantic_parser is specified.  */

/* Note: there must be only one dollar sign in this file.
   It is replaced by the list of actions, each action
   as one case of the switch.  */

#define yyerrok		(yyerrstatus = 0)
#define yyclearin	(yychar = YYEMPTY)
#define YYEMPTY		-2
#define YYEOF		0
#define YYACCEPT	return(0)
#define YYABORT 	return(1)
#define YYERROR		goto yyerrlab1
/* Like YYERROR except do call yyerror.
   This remains here temporarily to ease the
   transition to the new meaning of YYERROR, for GCC.
   Once GCC version 2 has supplanted version 1, this can go.  */
#define YYFAIL		goto yyerrlab
#define YYRECOVERING()  (!!yyerrstatus)
#define YYBACKUP(token, value) \
do								\
  if (yychar == YYEMPTY && yylen == 1)				\
    { yychar = (token), yylval = (value);			\
      yychar1 = YYTRANSLATE (yychar);				\
      YYPOPSTACK;						\
      goto yybackup;						\
    }								\
  else								\
    { yyerror ("syntax error: cannot back up"); YYERROR; }	\
while (0)

#define YYTERROR	1
#define YYERRCODE	256

#ifndef YYPURE
#define YYLEX		yylex()
#endif

#ifdef YYPURE
#ifdef YYLSP_NEEDED
#ifdef YYLEX_PARAM
#define YYLEX		yylex(&yylval, &yylloc, YYLEX_PARAM)
#else
#define YYLEX		yylex(&yylval, &yylloc)
#endif
#else /* not YYLSP_NEEDED */
#ifdef YYLEX_PARAM
#define YYLEX		yylex(&yylval, YYLEX_PARAM)
#else
#define YYLEX		yylex(&yylval)
#endif
#endif /* not YYLSP_NEEDED */
#endif

/* If nonreentrant, generate the variables here */

#ifndef YYPURE

int	yychar;			/*  the lookahead symbol		*/
YYSTYPE	yylval;			/*  the semantic value of the		*/
				/*  lookahead symbol			*/

#ifdef YYLSP_NEEDED
YYLTYPE yylloc;			/*  location data for the lookahead	*/
				/*  symbol				*/
#endif

int yynerrs;			/*  number of parse errors so far       */
#endif  /* not YYPURE */

#if YYDEBUG != 0
int yydebug;			/*  nonzero means print parse trace	*/
/* Since this is uninitialized, it does not stop multiple parsers
   from coexisting.  */
#endif

/*  YYINITDEPTH indicates the initial size of the parser's stacks	*/

#ifndef	YYINITDEPTH
#define YYINITDEPTH 200
#endif

/*  YYMAXDEPTH is the maximum size the stacks can grow to
    (effective only if the built-in stack extension method is used).  */

#if YYMAXDEPTH == 0
#undef YYMAXDEPTH
#endif

#ifndef YYMAXDEPTH
#define YYMAXDEPTH 10000
#endif

/* Prevent warning if -Wstrict-prototypes.  */
#ifdef __GNUC__
int yyparse (void);
#endif

#if __GNUC__ > 1		/* GNU C and GNU C++ define this.  */
#define __yy_memcpy(TO,FROM,COUNT)	__builtin_memcpy(TO,FROM,COUNT)
#else				/* not GNU C or C++ */
#ifndef __cplusplus

/* This is the most reliable way to avoid incompatibilities
   in available built-in functions on various systems.  */
static void
__yy_memcpy (to, from, count)
     char *to;
     char *from;
     int count;
{
  register char *f = from;
  register char *t = to;
  register int i = count;

  while (i-- > 0)
    *t++ = *f++;
}

#else /* __cplusplus */

/* This is the most reliable way to avoid incompatibilities
   in available built-in functions on various systems.  */
static void
__yy_memcpy (char *to, char *from, int count)
{
  register char *f = from;
  register char *t = to;
  register int i = count;

  while (i-- > 0)
    *t++ = *f++;
}

#endif
#endif



/* The user can define YYPARSE_PARAM as the name of an argument to be passed
   into yyparse.  The argument should have type void *.
   It should actually point to an object.
   Grammar actions can access the variable by casting it
   to the proper pointer type.  */

#ifdef YYPARSE_PARAM
#ifdef __cplusplus
#define YYPARSE_PARAM_ARG void *YYPARSE_PARAM
#define YYPARSE_PARAM_DECL
#else /* not __cplusplus */
#define YYPARSE_PARAM_ARG YYPARSE_PARAM
#define YYPARSE_PARAM_DECL void *YYPARSE_PARAM;
#endif /* not __cplusplus */
#else /* not YYPARSE_PARAM */
#define YYPARSE_PARAM_ARG
#define YYPARSE_PARAM_DECL
#endif /* not YYPARSE_PARAM */

int
yyparse(YYPARSE_PARAM_ARG)
     YYPARSE_PARAM_DECL
{
  register int yystate;
  register int yyn;
  register short *yyssp;
  register YYSTYPE *yyvsp;
  int yyerrstatus;	/*  number of tokens to shift before error messages enabled */
  int yychar1 = 0;		/*  lookahead token as an internal (translated) token number */

  short	yyssa[YYINITDEPTH];	/*  the state stack			*/
  YYSTYPE yyvsa[YYINITDEPTH];	/*  the semantic value stack		*/

  short *yyss = yyssa;		/*  refer to the stacks thru separate pointers */
  YYSTYPE *yyvs = yyvsa;	/*  to allow yyoverflow to reallocate them elsewhere */

#ifdef YYLSP_NEEDED
  YYLTYPE yylsa[YYINITDEPTH];	/*  the location stack			*/
  YYLTYPE *yyls = yylsa;
  YYLTYPE *yylsp;

#define YYPOPSTACK   (yyvsp--, yyssp--, yylsp--)
#else
#define YYPOPSTACK   (yyvsp--, yyssp--)
#endif

  int yystacksize = YYINITDEPTH;

#ifdef YYPURE
  int yychar;
  YYSTYPE yylval;
  int yynerrs;
#ifdef YYLSP_NEEDED
  YYLTYPE yylloc;
#endif
#endif

  YYSTYPE yyval;		/*  the variable used to return		*/
				/*  semantic values from the action	*/
				/*  routines				*/

  int yylen;

#if YYDEBUG != 0
  if (yydebug)
    fprintf(stderr, "Starting parse\n");
#endif

  yystate = 0;
  yyerrstatus = 0;
  yynerrs = 0;
  yychar = YYEMPTY;		/* Cause a token to be read.  */

  /* Initialize stack pointers.
     Waste one element of value and location stack
     so that they stay on the same level as the state stack.
     The wasted elements are never initialized.  */

  yyssp = yyss - 1;
  yyvsp = yyvs;
#ifdef YYLSP_NEEDED
  yylsp = yyls;
#endif

/* Push a new state, which is found in  yystate  .  */
/* In all cases, when you get here, the value and location stacks
   have just been pushed. so pushing a state here evens the stacks.  */
yynewstate:

  *++yyssp = yystate;

  if (yyssp >= yyss + yystacksize - 1)
    {
      /* Give user a chance to reallocate the stack */
      /* Use copies of these so that the &'s don't force the real ones into memory. */
      YYSTYPE *yyvs1 = yyvs;
      short *yyss1 = yyss;
#ifdef YYLSP_NEEDED
      YYLTYPE *yyls1 = yyls;
#endif

      /* Get the current used size of the three stacks, in elements.  */
      int size = yyssp - yyss + 1;

#ifdef yyoverflow
      /* Each stack pointer address is followed by the size of
	 the data in use in that stack, in bytes.  */
#ifdef YYLSP_NEEDED
      /* This used to be a conditional around just the two extra args,
	 but that might be undefined if yyoverflow is a macro.  */
      yyoverflow("parser stack overflow",
		 &yyss1, size * sizeof (*yyssp),
		 &yyvs1, size * sizeof (*yyvsp),
		 &yyls1, size * sizeof (*yylsp),
		 &yystacksize);
#else
      yyoverflow("parser stack overflow",
		 &yyss1, size * sizeof (*yyssp),
		 &yyvs1, size * sizeof (*yyvsp),
		 &yystacksize);
#endif

      yyss = yyss1; yyvs = yyvs1;
#ifdef YYLSP_NEEDED
      yyls = yyls1;
#endif
#else /* no yyoverflow */
      /* Extend the stack our own way.  */
      if (yystacksize >= YYMAXDEPTH)
	{
	  yyerror("parser stack overflow");
	  return 2;
	}
      yystacksize *= 2;
      if (yystacksize > YYMAXDEPTH)
	yystacksize = YYMAXDEPTH;
      yyss = (short *) alloca (yystacksize * sizeof (*yyssp));
      __yy_memcpy ((char *)yyss, (char *)yyss1, size * sizeof (*yyssp));
      yyvs = (YYSTYPE *) alloca (yystacksize * sizeof (*yyvsp));
      __yy_memcpy ((char *)yyvs, (char *)yyvs1, size * sizeof (*yyvsp));
#ifdef YYLSP_NEEDED
      yyls = (YYLTYPE *) alloca (yystacksize * sizeof (*yylsp));
      __yy_memcpy ((char *)yyls, (char *)yyls1, size * sizeof (*yylsp));
#endif
#endif /* no yyoverflow */

      yyssp = yyss + size - 1;
      yyvsp = yyvs + size - 1;
#ifdef YYLSP_NEEDED
      yylsp = yyls + size - 1;
#endif

#if YYDEBUG != 0
      if (yydebug)
	fprintf(stderr, "Stack size increased to %d\n", yystacksize);
#endif

      if (yyssp >= yyss + yystacksize - 1)
	YYABORT;
    }

#if YYDEBUG != 0
  if (yydebug)
    fprintf(stderr, "Entering state %d\n", yystate);
#endif

  goto yybackup;
 yybackup:

/* Do appropriate processing given the current state.  */
/* Read a lookahead token if we need one and don't already have one.  */
/* yyresume: */

  /* First try to decide what to do without reference to lookahead token.  */

  yyn = yypact[yystate];
  if (yyn == YYFLAG)
    goto yydefault;

  /* Not known => get a lookahead token if don't already have one.  */

  /* yychar is either YYEMPTY or YYEOF
     or a valid token in external form.  */

  if (yychar == YYEMPTY)
    {
#if YYDEBUG != 0
      if (yydebug)
	fprintf(stderr, "Reading a token: ");
#endif
      yychar = YYLEX;
    }

  /* Convert token to internal form (in yychar1) for indexing tables with */

  if (yychar <= 0)		/* This means end of input. */
    {
      yychar1 = 0;
      yychar = YYEOF;		/* Don't call YYLEX any more */

#if YYDEBUG != 0
      if (yydebug)
	fprintf(stderr, "Now at end of input.\n");
#endif
    }
  else
    {
      yychar1 = YYTRANSLATE(yychar);

#if YYDEBUG != 0
      if (yydebug)
	{
	  fprintf (stderr, "Next token is %d (%s", yychar, yytname[yychar1]);
	  /* Give the individual parser a way to print the precise meaning
	     of a token, for further debugging info.  */
#ifdef YYPRINT
	  YYPRINT (stderr, yychar, yylval);
#endif
	  fprintf (stderr, ")\n");
	}
#endif
    }

  yyn += yychar1;
  if (yyn < 0 || yyn > YYLAST || yycheck[yyn] != yychar1)
    goto yydefault;

  yyn = yytable[yyn];

  /* yyn is what to do for this token type in this state.
     Negative => reduce, -yyn is rule number.
     Positive => shift, yyn is new state.
       New state is final state => don't bother to shift,
       just return success.
     0, or most negative number => error.  */

  if (yyn < 0)
    {
      if (yyn == YYFLAG)
	goto yyerrlab;
      yyn = -yyn;
      goto yyreduce;
    }
  else if (yyn == 0)
    goto yyerrlab;

  if (yyn == YYFINAL)
    YYACCEPT;

  /* Shift the lookahead token.  */

#if YYDEBUG != 0
  if (yydebug)
    fprintf(stderr, "Shifting token %d (%s), ", yychar, yytname[yychar1]);
#endif

  /* Discard the token being shifted unless it is eof.  */
  if (yychar != YYEOF)
    yychar = YYEMPTY;

  *++yyvsp = yylval;
#ifdef YYLSP_NEEDED
  *++yylsp = yylloc;
#endif

  /* count tokens shifted since error; after three, turn off error status.  */
  if (yyerrstatus) yyerrstatus--;

  yystate = yyn;
  goto yynewstate;

/* Do the default action for the current state.  */
yydefault:

  yyn = yydefact[yystate];
  if (yyn == 0)
    goto yyerrlab;

/* Do a reduction.  yyn is the number of a rule to reduce with.  */
yyreduce:
  yylen = yyr2[yyn];
  if (yylen > 0)
    yyval = yyvsp[1-yylen]; /* implement default value of the action */

#if YYDEBUG != 0
  if (yydebug)
    {
      int i;

      fprintf (stderr, "Reducing via rule %d (line %d), ",
	       yyn, yyrline[yyn]);

      /* Print the symbols being reduced, and their result.  */
      for (i = yyprhs[yyn]; yyrhs[i] > 0; i++)
	fprintf (stderr, "%s ", yytname[yyrhs[i]]);
      fprintf (stderr, " -> %s\n", yytname[yyr1[yyn]]);
    }
#endif


  switch (yyn) {

case 2:
{ type=Char; ;
    break;}
case 3:
{ type=Short; ;
    break;}
case 4:
{ type=Int; ;
    break;}
case 5:
{ type=Long; ;
    break;}
case 6:
{ type=Float; ;
    break;}
case 7:
{ type=Double; ;
    break;}
case 8:
{ type=UChar; ;
    break;}
case 9:
{ type=UShort; ;
    break;}
case 10:
{ type=UInt; ;
    break;}
case 11:
{ type=ULong; ;
    break;}
case 12:
{ yyval=yyvsp[0]; ;
    break;}
case 13:
{ yyval=(int)ref()%(int)yyvsp[0]; assign(yyval); ;
    break;}
case 14:
{ yyval=ref()+yyvsp[0]; assign(yyval); ;
    break;}
case 15:
{ yyval=ref()-yyvsp[0]; assign(yyval); ;
    break;}
case 16:
{ yyval=yyvsp[0];       assign(yyval); ;
    break;}
case 17:
{ yyval=ref()*yyvsp[0]; assign(yyval); ;
    break;}
case 18:
{ yyval=ref()/yyvsp[0]; assign(yyval); ;
    break;}
case 19:
{ yyval=yyvsp[0]; ;
    break;}
case 20:
{ yyval=yyvsp[0]; ;
    break;}
case 21:
{ if (!yyvsp[-1]) disable++; ;
    break;}
case 22:
{ if (!yyvsp[-3]) disable--; ;
    break;}
case 23:
{ if (yyvsp[-5])  disable++; ;
    break;}
case 24:
{ if (yyvsp[-7])  disable--; yyval=yyvsp[-8]?yyvsp[-4]:yyvsp[0]; ;
    break;}
case 25:
{ yyval=yyvsp[0]; ;
    break;}
case 26:
{ yyval=yyvsp[-2]||yyvsp[0]; ;
    break;}
case 27:
{ yyval=yyvsp[-2]&&yyvsp[0]; ;
    break;}
case 28:
{ yyval=yyvsp[-2]==yyvsp[0]; ;
    break;}
case 29:
{ yyval=yyvsp[-2]!=yyvsp[0]; ;
    break;}
case 30:
{ yyval=yyvsp[-2]< yyvsp[0]; ;
    break;}
case 31:
{ yyval=yyvsp[-2]<=yyvsp[0]; ;
    break;}
case 32:
{ yyval=yyvsp[-2]> yyvsp[0]; ;
    break;}
case 33:
{ yyval=yyvsp[-2]>=yyvsp[0]; ;
    break;}
case 34:
{ yyval=yyvsp[-2]+yyvsp[0]; ;
    break;}
case 35:
{ yyval=yyvsp[-2]-yyvsp[0]; ;
    break;}
case 36:
{ yyval=yyvsp[-2]*yyvsp[0]; ;
    break;}
case 37:
{ yyval=yyvsp[-2]/yyvsp[0]; ;
    break;}
case 38:
{ yyval=(int)yyvsp[-2]%(int)yyvsp[0]; ;
    break;}
case 39:
{ yyval=yyvsp[0]; ;
    break;}
case 40:
{ yyval=- yyvsp[0]; ;
    break;}
case 41:
{ yyval=!yyvsp[0]; ;
    break;}
case 42:
{ yyval=yyvsp[0]; ;
    break;}
case 43:
{ yyval=ref(); assign(yyval+1); ;
    break;}
case 44:
{ yyval=ref(); assign(yyval-1); ;
    break;}
case 45:
{ yyval=ref()+1; assign(yyval); ;
    break;}
case 46:
{ yyval=ref()-1; assign(yyval); ;
    break;}
case 47:
{ yyval=ref(); ;
    break;}
case 48:
{ yyval=yyvsp[0]; ;
    break;}
case 49:
{ yyval=yyvsp[-1]; ;
    break;}
case 50:
{ yyval=yyvsp[0]; ;
    break;}
case 51:
{ yyval=sin  (yyvsp[-1]); ;
    break;}
case 52:
{ yyval=cos  (yyvsp[-1]); ;
    break;}
case 53:
{ yyval=tan  (yyvsp[-1]); ;
    break;}
case 54:
{ yyval=asin (yyvsp[-1]); ;
    break;}
case 55:
{ yyval=acos (yyvsp[-1]); ;
    break;}
case 56:
{ yyval=atan (yyvsp[-1]); ;
    break;}
case 57:
{ yyval=sinh (yyvsp[-1]); ;
    break;}
case 58:
{ yyval=cosh (yyvsp[-1]); ;
    break;}
case 59:
{ yyval=tanh (yyvsp[-1]); ;
    break;}
case 60:
{ yyval=asinh(yyvsp[-1]); ;
    break;}
case 61:
{ yyval=acosh(yyvsp[-1]); ;
    break;}
case 62:
{ yyval=atanh(yyvsp[-1]); ;
    break;}
case 63:
{ yyval=exp  (yyvsp[-1]); ;
    break;}
case 64:
{ yyval=log  (yyvsp[-1]); ;
    break;}
case 65:
{ yyval=log10(yyvsp[-1]); ;
    break;}
case 66:
{ yyval=pow  (yyvsp[-3],yyvsp[-1]); ;
    break;}
}
   /* the action file gets copied in in place of this dollarsign */


  yyvsp -= yylen;
  yyssp -= yylen;
#ifdef YYLSP_NEEDED
  yylsp -= yylen;
#endif

#if YYDEBUG != 0
  if (yydebug)
    {
      short *ssp1 = yyss - 1;
      fprintf (stderr, "state stack now");
      while (ssp1 != yyssp)
	fprintf (stderr, " %d", *++ssp1);
      fprintf (stderr, "\n");
    }
#endif

  *++yyvsp = yyval;

#ifdef YYLSP_NEEDED
  yylsp++;
  if (yylen == 0)
    {
      yylsp->first_line = yylloc.first_line;
      yylsp->first_column = yylloc.first_column;
      yylsp->last_line = (yylsp-1)->last_line;
      yylsp->last_column = (yylsp-1)->last_column;
      yylsp->text = 0;
    }
  else
    {
      yylsp->last_line = (yylsp+yylen-1)->last_line;
      yylsp->last_column = (yylsp+yylen-1)->last_column;
    }
#endif

  /* Now "shift" the result of the reduction.
     Determine what state that goes to,
     based on the state we popped back to
     and the rule number reduced by.  */

  yyn = yyr1[yyn];

  yystate = yypgoto[yyn - YYNTBASE] + *yyssp;
  if (yystate >= 0 && yystate <= YYLAST && yycheck[yystate] == *yyssp)
    yystate = yytable[yystate];
  else
    yystate = yydefgoto[yyn - YYNTBASE];

  goto yynewstate;

yyerrlab:   /* here on detecting error */

  if (! yyerrstatus)
    /* If not already recovering from an error, report this error.  */
    {
      ++yynerrs;

#ifdef YYERROR_VERBOSE
      yyn = yypact[yystate];

      if (yyn > YYFLAG && yyn < YYLAST)
	{
	  int size = 0;
	  char *msg;
	  int x, count;

	  count = 0;
	  /* Start X at -yyn if nec to avoid negative indexes in yycheck.  */
	  for (x = (yyn < 0 ? -yyn : 0);
	       x < (sizeof(yytname) / sizeof(char *)); x++)
	    if (yycheck[x + yyn] == x)
	      size += strlen(yytname[x]) + 15, count++;
	  msg = (char *) malloc(size + 15);
	  if (msg != 0)
	    {
	      strcpy(msg, "parse error");

	      if (count < 5)
		{
		  count = 0;
		  for (x = (yyn < 0 ? -yyn : 0);
		       x < (sizeof(yytname) / sizeof(char *)); x++)
		    if (yycheck[x + yyn] == x)
		      {
			strcat(msg, count == 0 ? ", expecting `" : " or `");
			strcat(msg, yytname[x]);
			strcat(msg, "'");
			count++;
		      }
		}
	      yyerror(msg);
	      free(msg);
	    }
	  else
	    yyerror ("parse error; also virtual memory exceeded");
	}
      else
#endif /* YYERROR_VERBOSE */
	yyerror("parse error");
    }

  goto yyerrlab1;
yyerrlab1:   /* here on error raised explicitly by an action */

  if (yyerrstatus == 3)
    {
      /* if just tried and failed to reuse lookahead token after an error, discard it.  */

      /* return failure if at end of input */
      if (yychar == YYEOF)
	YYABORT;

#if YYDEBUG != 0
      if (yydebug)
	fprintf(stderr, "Discarding token %d (%s).\n", yychar, yytname[yychar1]);
#endif

      yychar = YYEMPTY;
    }

  /* Else will try to reuse lookahead token
     after shifting the error token.  */

  yyerrstatus = 3;		/* Each real token shifted decrements this */

  goto yyerrhandle;

yyerrdefault:  /* current state does not do anything special for the error token. */

#if 0
  /* This is wrong; only states that explicitly want error tokens
     should shift them.  */
  yyn = yydefact[yystate];  /* If its default is to accept any token, ok.  Otherwise pop it.*/
  if (yyn) goto yydefault;
#endif

yyerrpop:   /* pop the current state because it cannot handle the error token */

  if (yyssp == yyss) YYABORT;
  yyvsp--;
  yystate = *--yyssp;
#ifdef YYLSP_NEEDED
  yylsp--;
#endif

#if YYDEBUG != 0
  if (yydebug)
    {
      short *ssp1 = yyss - 1;
      fprintf (stderr, "Error: state stack now");
      while (ssp1 != yyssp)
	fprintf (stderr, " %d", *++ssp1);
      fprintf (stderr, "\n");
    }
#endif

yyerrhandle:

  yyn = yypact[yystate];
  if (yyn == YYFLAG)
    goto yyerrdefault;

  yyn += YYTERROR;
  if (yyn < 0 || yyn > YYLAST || yycheck[yyn] != YYTERROR)
    goto yyerrdefault;

  yyn = yytable[yyn];
  if (yyn < 0)
    {
      if (yyn == YYFLAG)
	goto yyerrpop;
      yyn = -yyn;
      goto yyreduce;
    }
  else if (yyn == 0)
    goto yyerrpop;

  if (yyn == YYFINAL)
    YYACCEPT;

#if YYDEBUG != 0
  if (yydebug)
    fprintf(stderr, "Shifting error token, ");
#endif

  *++yyvsp = yylval;
#ifdef YYLSP_NEEDED
  *++yylsp = yylloc;
#endif

  yystate = yyn;
  goto yynewstate;
}


void   yyerror(char* msg) { 
  if (errmsg!=NULL) free(errmsg);
  errmsg=strdup(msg); 
}

double ref() {
  switch (type) {
    case Char:	return (double)(*(char*)target);
    case Short:	return (double)(*(short*)target);
    case Int:	return (double)(*(int*)target);
    case Long:	return (double)(*(long*)target);
    case Float:	return (double)(*(float*)target);
    case Double:return (double)(*(double*)target);
    case UChar:	return (double)(*(unsigned char*)target);
    case UShort:return (double)(*(unsigned short*)target);
    case UInt:	return (double)(*(unsigned int*)target);
    case ULong:	return (double)(*(unsigned long*)target);
  }
  return (double)(*(double*)target);
}

void assign(double val) {
  if (disable>0) return;
  switch (type) {
    case Char:	(*(char*)target)=(char)val; return;
    case Short:	(*(short*)target)=(short)val; return;
    case Int:	(*(int*)target)=(int)val; return;
    case Long:	(*(long*)target)=(long)val; return;
    case Float:	(*(float*)target)=(float)val; return;
    case Double:(*(double*)target)=(double)val; return;
    case UChar:	(*(unsigned char*)target)=(unsigned char)val; return;
    case UShort:(*(unsigned short*)target)=(unsigned short)val; return;
    case UInt:	(*(unsigned int*)target)=(unsigned int)val; return;
    case ULong:	(*(unsigned long*)target)=(unsigned long)val; return;
  }
}

char *adsm_calc(char *expr, void *data) {
  target=(char*)data;
  set_expr(expr);
  return yyparse()==0?0:errmsg;
}

