/*
        Adsmith 1.8 :  An Efficient Object-Based DSM Environment on PVM
 
                        Author:  William W. Y. Liang
 
           Institute of Computer Science & Information Engineering
                   National Taiwan University, Taipei, TW
 
                   Copyright (C) 1996 All Rights Reserved

                                  NOTICE

      Permission to use, copy, modify, and distribute this software and
      its documentation for any purpose and without fee is hereby granted
      provided that the above copyright notice appear in all copies and
      that both the copyright notice and this permission notice appear in
      supporting documentation.

      The author makes no representations about the suitability of this
      software for any purpose.  This software is provided ``as is''
      without express or implied warranty.
*/

#include "modset.h"
#include "dynarr.h"

// Status Macros
#define AdsmdStatusWriting	0x0001
#define AdsmdStatusAllocate	0x0002

// -- Data Structures --

// lock list
struct Tlock_list {
  short	procno;
  char	rwtype;
  struct Tlock_list	*next;
};

// table entry
class GlbVarTab {
public:

  char  	*name;		// name of the object
  int   	size;		// size of the object
  short		hint;		// hint of the object
  short		home;		// home dtid
  char		*data;		// data

  ModifySet 	*lastmodset;	// last modify set
  DynArray<short> *cacherlist;	// cacher list

  Tlock_list	*blkqueue;	// block queue

  short		count;		// barrier arrive number
  short		total;		// barrier count 
  DynArray<short> *barrlist;	// barrier list

  short	status;			// being written

public:

  GlbVarTab(char *nm=NULL,int sz=0,short hi=0,short hm=-1,char *da=NULL);
  ~GlbVarTab();
};

// process structure
class Process {
private:

  int tid;
  short hostno;

public:

  Process() : tid(-1), hostno(-1) {}
  Process(int t,int l=-1) : tid(t), hostno(l) {}

  int get_tid() { return tid; }
  short get_hostno() { return hostno; }

  int operator == (Process &p) { return tid==p.tid; }
};

// for object allocation 
class AllocRec {
private:

  int gindex;
  void *ptr;

public:

  AllocRec() : gindex(-1), ptr(NULL) {}
  AllocRec(int g,void *p) : gindex(g), ptr(p) {}

  int get_gindex() { return gindex; }
  void *get_ptr() { return ptr; }

  int operator == (const AllocRec& a) { return this->gindex==a.gindex; }
};

// -- Prototypes --

// routines
inline void adsmd_check_table_size(int index);
inline int  adsmd_get_gindex();
inline void adsmd_block(int gindex,short requester,char rwtype=0);
inline void adsmd_unblock(int gindex);
inline void adsmd_check_locker(int gindex);
inline int  adsmd_load(char cmd,int gindex,short lpno,int conti);
inline int  adsmd_barrier(int gindex,short ttl);
inline void adsmd_coherence(int gindex);

void adsmd_inc_table_size(int index);
void adsmd_reply_register(DynArray<AllocRec> &existlist);
void adsmd_forward_register(DynArray<AllocRec> *forwardlist);
void adsmd_doneload(char cmd,short lpno);
void adsmd_store(int gindex,int conti,int ack=1);
int  adsmd_donestore(int ack);
void adsmd_statistics();

// command processing routines
void adsmd_cmd_init();
void adsmd_cmd_enroll();
void adsmd_cmd_handshake();
void adsmd_cmd_register();
void adsmd_cmd_attach();
void adsmd_cmd_undecl();
void adsmd_cmd_masterundecl();
void adsmd_cmd_proctids();
void adsmd_cmd_refresh();
void adsmd_cmd_flush();
void adsmd_cmd_acksim();
void adsmd_cmd_p();
void adsmd_cmd_lock();
void adsmd_cmd_barrier();
void adsmd_cmd_v();
void adsmd_cmd_unlock();
void adsmd_cmd_atomic_end();
void adsmd_cmd_atomic_begin();
void adsmd_cmd_atomic();
void adsmd_cmd_shutdown();
int  adsmd_cmd_exit();

// others
char *adsm_calc(char *expr,void *data);

// -- Methods of GlbVarTab --

inline GlbVarTab::GlbVarTab(char *nm,int sz,short hi,short hm,char *da) :
  name(nm), size(sz), hint(hi), home(hm), data(da),
  lastmodset(NULL), cacherlist(NULL), blkqueue(NULL), 
  count(0), total(0), barrlist(NULL), status(0) 
{}

inline GlbVarTab::~GlbVarTab() {
  delete [] name;
  delete [] data;
  delete lastmodset;
  delete cacherlist;
  delete blkqueue;
  delete barrlist;
}
