// Non-standard Adsmith utilities
// Written by William W. Y. Liang

#ifndef __UTILS_H__
#define __UTILS_H__

#include <string.h>
#include <stdio.h>
#include "pvm3.h"
#include "adsm.h"

// Timing utility

#define RESERVED_ID "24la;U-954"	// randomly generated

// to obtain my sequence number, will be initialized only once
inline int get_seqno(char *group="") {
// return adsm_procno();
// Adopt the following old method to allow normal work on using adsmgate.
  static int called=0;
  static int the_seqno;

  if (called) return the_seqno;

  char sname[100];
  sprintf(sname,RESERVED_ID"_%s_seqno",group);

  int tmp=-1; // init will be done only once
  int *seqno=(int*)adsm_malloc(sname,sizeof(int),&tmp);

  adsm_atomic(seqno,"[int] ++@");
  the_seqno=*seqno;

  adsm_free(seqno);

  called=1;

  return the_seqno;
}

// get number of hosts
inline int get_nhost() {
  int nhost,narch;
  struct pvmhostinfo *hostp;
  pvm_config(&nhost,&narch,&hostp);

  return nhost;
}

// retrieve executable name from the string
inline char *execname(char *fullname) {
  char *ename=strrchr(fullname,'/');
  return ename==NULL?fullname:ename+1;
}

#endif // __UTILS_H__
