// Program : Pointer Usage Example Slave Program
// Author  : William W. Y. Liang

#include <iostream.h>
#include "adsm.h"
#include "adsmutil.h"
#include "ptr.h"

main() {
  int seqno=get_seqno();
  int nhost=NHOST>0?NHOST:get_nhost();

  AdsmBarrier Bpointer("barrier for this code");
  Bpointer.barrier(nhost+1);

  // ----- get the pointer -----
  int *S=(int*)adsm_malloc("point to T",sizeof(int));
  adsm_refresh(S); // get the pointer value

  // ----- attach it into local space -----
  typeT *T=(typeT*)adsm_attach(*S); // attach the pointer
  adsm_refresh(T); // get the pointer value
  cout<<"* Attach thru pointer by child "<<seqno<<" : target={"
      <<T->i<<','<<T->f<<'}'<<endl;
}
