// Program : Pointer Usage Example
// Author  : William W. Y. Liang
// Usage   : ptr_master

#include <iostream.h>
#include "pvm3.h"
#include "adsm.h"
#include "adsmutil.h"
#include "ptr.h"

main() {
  int nhost=NHOST>0?NHOST:get_nhost();
  cout<<nhost<<" hosts detected"<<endl;

  // adsm_spawn("ptr_slave",NULL,PvmTaskDebug,NULL,nhost);
  adsm_spawn("ptr_slave",nhost);

  // ----- creat target object -----
  typeT *T=(typeT*)adsm_malloc("target",sizeof(typeT),
    AdsmDataCache|AdsmDataUpdate);
  T->i=2;
  T->f=3.4;
  adsm_flush(T); // flush immediately
  cout<<"* Target={"<<T->i<<','<<T->f<<'}'<<endl;

  // ----- set the pointer -----
  int *S=(int*)adsm_malloc("point to T",sizeof(int),
    AdsmDataCache|AdsmDataUpdate);
  *S=adsm_gid(T); // get global address of T
  adsm_flush(S); // flush

  AdsmBarrier Bpointer("barrier for this code");
  Bpointer.barrier(nhost+1);

  // ----- test free ----
  adsm_free(T);
  typeT *U=(typeT*)adsm_malloc("target",sizeof(typeT));
  adsm_refresh(U);
  cout<<"* Free and Reallocate: target={"<<U->i<<','<<U->f<<'}'<<endl;
}
