// Program : Cord Game Racer Process
// Author  : William W. Y. Liang

#include <iostream.h>
#include <unistd.h>
#include <stdlib.h>
#include "adsm.h"
#include "adsmutil.h"
#include "cord.h"

main() {
  int *cc=(int*)adsm_malloc("cc",sizeof(int));
  int dir=get_seqno()==1?-1:1; // set pull direction

  // race lock
  AdsmMutex Mrace("race lock");

  // race start barrier
  AdsmBarrier Bcord("race barrier");
  Bcord.barrier(3);

  // start to race: child try to pull to 10
  srand(time(NULL)/7);
  while (1) {
    // take a rest : sleep longer if tend to win
    delay((rand()%1000000)/(dir>0?5-*cc:5+*cc));	

    adsm_atomic_begin(cc);

    if (*cc<-3||*cc>3) {
      adsm_atomic_end(cc);
      break;
    }
    *cc+=dir;

    adsm_atomic_end(cc);
  };
}
