// Program : A Pull-Cord Game
// Author  : William W. Y. Liang
// Usage   : cord_monitor

#include <iostream.h>
#include <unistd.h>
#include "pvm3.h"
#include "adsm.h"
#include "cord.h"
      
main() {
  int tmp=0;
  int *cc=(int*)adsm_malloc("cc",sizeof(int),&tmp);

  // spawn child processes
  adsm_spawn("cord_racer",2);

  // race start barrier
  AdsmBarrier Bcord("race barrier");
  Bcord.barrier(3);

  // start to race: monitor
  while (1) {
    delay(100000);
    adsm_refresh_now(cc);

    cout<<"current center position = "<<*cc<<endl;

    if (*cc<-3||*cc>3)
      break;
  }

  // find out the winner
  cout<<(*cc>3?"NTHU":"NCTU")<<" win!"<<endl;
}
