#define NULL 0
#include <dos/malloc.h>

/* xx_mem is a memory allocation routine.  It is called in three
   ways:
	if typ == 0, then n is the number of bytes to claim as
	    globally-shared memory (from which routines can
	    ask for shared memory).  In this case the routine
	    returns the address of the allocated block (NULL,
	    if an allocation failure occurs).

	else if typ == 1, then n is taken to be the amount
	    of shared memory requested.  In this case, the
	    routine returns the address of a block of at least
	    n charecters in length.

	else if typ == 2, then the routine is being asked
	    to return the address of the globally-
	    shared block of memory.  

The view of shared memory supported by xx_mem is that a single
massive chunk of memory is acquired (and handed out by 
xx_mem(1,...) calls).
*/

struct mem_blk {
    char *next;
    long l_mem;
};

char *xx_mem(typ,n)
int typ;
long n;
{
char *share();
char *malloc();
static struct mem_blk *glob_mem =  (struct mem_blk *) NULL;
char *rc;
int i;
char *c;
unsigned mem;
int free;

    switch (typ)
    {
    case 0:  /* initialize */
	/* pad & malloc */
	mem = n+sizeof(struct mem_blk);
	if ((c = malloc(mem))== NULL)
	{
	    /* node code does not support printf --- */
		printf("*** malloc failed during shared memory initialization ***\n");
		printf("asking for %d bytes \n",n+sizeof(struct mem_blk));
		/* */
	    exit(3);
	}
	else
	{
	    glob_mem = (struct mem_blk *) c;
	    glob_mem->next = c + sizeof(struct mem_blk);
	    glob_mem->l_mem = n;

	    rc = glob_mem->next;
	}
	break;

    case 1:
	{
		i = (n + 7) & (~007);
		free = glob_mem->l_mem;
		if (free < i)
		{
			/* node code does not support printf --- */
			printf("*** global allocation failure ***\n");
			printf("*** attempted %d bytes, %d left\n",
			   n,glob_mem->l_mem);
			/* */
			rc = NULL;
		}
		else
		{
			rc = glob_mem->next;
			glob_mem->next += n; 
			glob_mem->l_mem -= n; 
			/* B  */
			printf("allocated %d bytes of shared memory\n",i);
			printf("at %d\n",rc);
			/* E */
		}
	}
	break;


    case 2:
	rc = (char *) glob_mem;
	break;

    }
    return(rc);
}
	
zfix_(n)
int n;
{
char *malloc();

    free(malloc(n));
}
