#define NULL 0
#include "cnode.def"
#define MAXCOUNT 500000
#include <dos/malloc.h>

/* xx_mem is a memory allocation routine.  It is called in three
   ways:
	if typ == 0, then n is the number of bytes to claim as
	    globally-shared memory (from which routines can
	    ask for shared memory).  In this case the routine
	    returns the address of the allocated block (NULL,
	    if an allocation failure occurs).

	else if typ == 1, then n is taken to be the amount
	    of shared memory requested.  In this case, the
	    routine returns the address of a block of at least
	    n charecters in length.

	else if typ == 2, then the routine is being asked
	    to return the address of the globally-
	    shared block of memory.  

The view of shared memory supported by xx_mem is that a single
massive chunk of memory is acquired (and handed out by 
xx_mem(1,...) calls).
*/
long xxx;
struct mem_blk {
    char *next;
    long l_mem;
};
static struct mem_blk *glob_mem =  (struct mem_blk *) NULL;
char *c;
int memi;
char s[256];
unsigned mem;
int memfree;

char *xx_mem(typ,n)
int typ;
int  n;
{
char *rc;

	syslog(0,"enter xx_mem");
    switch (typ)
    {
    case 0:  /* initialize */
	/* pad & malloc */
	mem = n+sizeof(struct mem_blk);
	syslog(0,"computed size of malloc");
		if ((c = malloc(mem))== NULL) 
	{
	    /* node code does not support printf ---  */
		syslog(0,"Malloc failed ");
		sprintf(s,"*** malloc failed during shared memory initialization ***\n");
		syslog(0,s);
		sprintf(s,"asking for %d bytes \n",n+sizeof(struct mem_blk));
		syslog(0,s);
		/* */
	    exit(3);
	}
	else
	{
		syslog(0,"malloc successful ");
	    glob_mem = (struct mem_blk *) c;
	    glob_mem->next = c + sizeof(struct mem_blk);
	    glob_mem->l_mem = n;

		syslog(0,"after glob assignments malloc successful ");
		sprintf(s,"address of c = %d",&c[0]);
		syslog(0,s);
	    rc = glob_mem->next;
	}
		syslog(0,"after glob before break malloc successful ");
	break;

    case 1:
	{
		memi = (n + 7) & (~007);
		memfree = glob_mem->l_mem;
		if (memfree < memi)
		{
			/* node code does not support printf ---  */
			sprintf(s,"*** global allocation failure ***\n");
			syslog(0,s);
			sprintf(s,"*** attempted %d bytes, %d left\n",
			   n,glob_mem->l_mem);
			syslog(0,s);
			/* */
			rc = NULL;
		}
		else
		{
			rc = glob_mem->next;
			glob_mem->next += n; 
			glob_mem->l_mem -= n; 
			/* B   */
			sprintf(s,"allocated %d bytes of shared memory\n",memi);
			syslog(0,s);
			sprintf(s,"at %d\n",rc);
			syslog(0,s);
			/* E */
		}
	}
	break;


    case 2:
	rc = (char *) glob_mem;
	break;

    }
	syslog(0,"returning from xx_mem");
    return(rc);
}
	
