#include <stdio.h> 

#define BOOL            int
#define TRUE            1
#define FALSE           0

#define ROWS		100
#define COLUMNS		100
#define ROWS_PER_SUB	50
#define COLUMNS_PER_SUB	50

#define PROCS_PER_COL	(ROWS / ROWS_PER_SUB)
#define PROCS_PER_ROW	(COLUMNS / COLUMNS_PER_SUB)
#define N_PROCS		(PROCS_PER_ROW * PROCS_PER_COL)

ENV(,,1000)

/* message types */
#define CNTL            0
#define C_BOUNDARY	1
#define R_BOUNDARY	2
#define ANSWER      	3

BEGIN_MSG_TYPES
    MSG_TYPE(CNTL,
        struct cntl_rec {
		int row;
		int col;
                PROC_ID upper_neighbor;
		PROC_ID right_neighbor;
		PROC_ID lower_neighbor;
		PROC_ID left_neighbor;
		int iterations;
		double bounded_subgrid[ROWS_PER_SUB+2][COLUMNS_PER_SUB+2];
        };
    )

    MSG_TYPE(C_BOUNDARY,
        struct c_boundary {
                double col[ROWS_PER_SUB];
	};
    )

    MSG_TYPE(R_BOUNDARY,
	struct r_boundary {
        	double row[COLUMNS_PER_SUB];
	};
    )

    MSG_TYPE(ANSWER,
        struct answer_rec {
		double subgrid[ROWS_PER_SUB][COLUMNS_PER_SUB];
        };
    )
END_MSG_TYPES

slave()
{

    struct cntl_rec rec1;

    double grid1[ROWS_PER_SUB+2][COLUMNS_PER_SUB+2];
    double grid2[ROWS_PER_SUB+2][COLUMNS_PER_SUB+2];
    double *current_grid, *next_grid, *temp;
    PROC_ID master_id, proc_id;
    int i, j, n, msg_type;

    RECEIVE(&master_id, &msg_type, &rec1, match_type(CNTL))
    for (i=0; i < (ROWS_PER_SUB + 2); i++) 
        for (j=0; j < (COLUMNS_PER_SUB + 2); j++) 
            grid1[i][j] = rec1.bounded_subgrid[i][j];

    current_grid = grid1;
    next_grid = grid2;
    for (n=rec1.iterations, i=0; i < n; i++) {
        compute1_iter(current_grid,next_grid);

	if (!((i + 1) == n))   /* if not the last iteration */
	{
	    if (!upper_bound(rec1.row))
		send_row(next_grid, 1, &(rec1.upper_neighbor));
	    if (!lower_bound(rec1.row))
		send_row(next_grid, ROWS_PER_SUB, &(rec1.lower_neighbor));
	    if (!left_bound(rec1.col))
		send_col(next_grid, 1, &(rec1.left_neighbor));
	    if (!right_bound(rec1.col))
		send_col(next_grid, COLUMNS_PER_SUB, &(rec1.right_neighbor));

	    if (!upper_bound(rec1.row))
		receive_row(next_grid, 0, &(rec1.upper_neighbor));
	    if (!lower_bound(rec1.row))
		receive_row(next_grid, (ROWS_PER_SUB + 1), &(rec1.lower_neighbor));
	    if (!left_bound(rec1.col))
		receive_col(next_grid, 0, &(rec1.left_neighbor));
	    if (!right_bound(rec1.col))
		receive_col(next_grid, (COLUMNS_PER_SUB + 1), &(rec1.right_neighbor));
	}

        temp = current_grid;
        current_grid = next_grid;
        next_grid = temp;
    }
    send_answer(current_grid, &master_id);
}

send_row(grid, row, proc_id)
double grid[ROWS_PER_SUB+2][COLUMNS_PER_SUB+2];
int row;
PROC_ID *proc_id;
{
    SEND(proc_id, R_BOUNDARY, &(grid[row][1]))
}

send_col(grid, col, proc_id)
double grid[ROWS_PER_SUB+2][COLUMNS_PER_SUB+2];
int col;
PROC_ID *proc_id;
{
    double temp_col[ROWS_PER_SUB];
    int i, j;

    for (i=1; i <= ROWS_PER_SUB; i++)
	    temp_col[i-1] = grid[i][col];
    SEND(proc_id, C_BOUNDARY, temp_col)
}

receive_row(grid, row, proc_id)
double grid[ROWS_PER_SUB+2][COLUMNS_PER_SUB+2];
int row;
PROC_ID *proc_id;
{
    PROC_ID senders_id;
    int msg_type;

    RECEIVE(&senders_id, &msg_type, &(grid[row][1]),
	    (match_id(proc_id) && match_type(R_BOUNDARY)))
}

receive_col(grid, col, proc_id)
double grid[ROWS_PER_SUB+2][COLUMNS_PER_SUB+2];
int col;
PROC_ID *proc_id;
{
    double temp_col[ROWS_PER_SUB];
    PROC_ID senders_id;
    int i, j,msg_type;

    RECEIVE(&senders_id, &msg_type, temp_col,
	    (match_id(proc_id) && match_type(C_BOUNDARY)))

    for (i=1; i <= ROWS_PER_SUB; i++)
	    grid[i][col] = temp_col[i-1];
}

send_answer(grid, master_id)
double grid[ROWS_PER_SUB+2][COLUMNS_PER_SUB+2];
PROC_ID *master_id;
{
    struct answer_rec rec1;

    int i, j;

    for (i=1; i <= ROWS_PER_SUB; i++)
	for (j=1; j <= COLUMNS_PER_SUB; j++)
	    rec1.subgrid[i-1][j-1] = grid[i][j];
    SEND(master_id, ANSWER, &rec1)
}

compute1_iter(current,next)
double current[ROWS_PER_SUB+2][COLUMNS_PER_SUB+2];
double next[ROWS_PER_SUB+2][COLUMNS_PER_SUB+2];
{
    int i, j;

    for (i=1; i <= (ROWS_PER_SUB); i++)
	for (j=1; j <= COLUMNS_PER_SUB; j++)
	    next[i][j] = (current[i-1][j] + 
			  current[i+1][j] + 
			  current[i][j-1] + 
			  current[i][j+1]) / 4.0;
}

