#include <stdio.h> 
#include <assert.h>

#define BOOL            int
#define TRUE            1
#define FALSE           0

#define ROWS		100
#define COLUMNS		100
#define ROWS_PER_SUB	50
#define COLUMNS_PER_SUB	50

#define PROCS_PER_COL	(ROWS / ROWS_PER_SUB)
#define PROCS_PER_ROW	(COLUMNS / COLUMNS_PER_SUB)
#define N_PROCS		(PROCS_PER_ROW * PROCS_PER_COL)

ENV(,,1000)

/* message types */
#define CNTL            0
#define C_BOUNDARY	1
#define R_BOUNDARY	2
#define ANSWER      	3

BEGIN_MSG_TYPES
    MSG_TYPE(CNTL,
        struct cntl_rec {
		int row;
		int col;
                PROC_ID upper_neighbor;
		PROC_ID right_neighbor;
		PROC_ID lower_neighbor;
		PROC_ID left_neighbor;
		int iterations;
		double bounded_subgrid[ROWS_PER_SUB+2][COLUMNS_PER_SUB+2];
        };
    )

    MSG_TYPE(C_BOUNDARY,
        struct c_boundary {
                double col[ROWS_PER_SUB];
	};		
    )

    MSG_TYPE(R_BOUNDARY,
	struct r_boundary {
        	double row[COLUMNS_PER_SUB];
	};
    )

    MSG_TYPE(ANSWER,
        struct answer_rec {
		double subgrid[ROWS_PER_SUB][COLUMNS_PER_SUB];
        };
    )
END_MSG_TYPES

main()
{

    struct cntl_rec rec1;
    struct answer_rec rec2;

    PROC_ID process_id[N_PROCS], proc_id;
    double grid[ROWS+2][COLUMNS+2];
    int proc, i, j, f_row, f_col,msg_type;

    INITENV 

    gridinit(grid,ROWS+2,COLUMNS+2);

    printf("Enter the number of iterations: ");
    scanf("%d",&(rec1.iterations));		

    REMOTE_CREATE(grid_of_procs, process_id)

    for (proc=0; proc < N_PROCS; proc++) {
	rec1.row = first_row(proc);
	rec1.col = first_column(proc);
	if (!upper_bound(rec1.row)) {
	    i = rec1.row - ROWS_PER_SUB;
	    j = which_proc(i,rec1.col);
	    COPY_ID(&rec1.upper_neighbor, &process_id[j])
	}
	if (!lower_bound(rec1.row)) {
	    i = rec1.row + ROWS_PER_SUB;
	    j = which_proc(i,rec1.col);
	    COPY_ID(&rec1.lower_neighbor, &process_id[j])
	}
	if (!right_bound(rec1.col)) {
	    i = rec1.col + COLUMNS_PER_SUB;
	    j = which_proc(rec1.row,i);
	    COPY_ID(&rec1.right_neighbor, &process_id[j])
	}
	if (!left_bound(rec1.col)) {
	    i = rec1.col - COLUMNS_PER_SUB;
	    j = which_proc(rec1.row,i);
	    COPY_ID(&rec1.left_neighbor, &process_id[j])
	}

	for (i=(rec1.row - 1); i <= (rec1.row + ROWS_PER_SUB); i++) 
	{

	    for (j=(rec1.col - 1); j <= (rec1.col + COLUMNS_PER_SUB); j++)
	    {
		rec1.bounded_subgrid[(i - (rec1.row - 1))][(j - (rec1.col - 1))] =
		    grid[i][j];
	    }
	}
	SENDR(&(process_id[proc]), CNTL, &rec1);
    }

    for (proc=0; proc < N_PROCS; proc++) {
	RECEIVE(&proc_id, &msg_type, &rec2, 
		(match_id(&(process_id[proc])) && match_type(ANSWER)))
	f_row = first_row(proc);
	f_col = first_column(proc);
	for (i=0; i < ROWS_PER_SUB; i++) 
	    for (j=0; j < COLUMNS_PER_SUB; j++)
		grid[f_row + i][f_col + j] = rec2.subgrid[i][j];
    }
    printgrid(grid,ROWS+2,COLUMNS+2);

    printf("successful completion\n");
    WAIT_FOR_END(3)
}

first_row(proc)
int proc;
{
    return(((proc / PROCS_PER_ROW) * ROWS_PER_SUB) + 1);
}

first_column(proc)
int proc;
{
    return(((proc % PROCS_PER_ROW) * COLUMNS_PER_SUB) + 1);
}

which_proc(row,column)
int row,column;
{
    return((((row - 1) / ROWS_PER_SUB) * PROCS_PER_ROW) + 
	   ((column - 1) / COLUMNS_PER_SUB));
}

upper_bound(row)
int row;
{
    return((row == 1));
}

lower_bound(row)
int row;
{
    return((row == (ROWS - ROWS_PER_SUB + 1)));
}

right_bound(column)
int column;
{
    return((column == (COLUMNS - COLUMNS_PER_SUB + 1)));
}

left_bound(column)
int column;
{
    return((column == 1));
}

gridinit(m,x,y)              /* initialize the grid */
double m[ROWS+2][COLUMNS+2];
int x,y;
{
int i, j;

    /* initialize the interior of the grid to zero */

    for (i=1; i <= x-1; i++)
        for (j=1; j <= y-1; j++)
        {
            m[i][j] = 0;
        }
    for (j=0; j <= y; j++)
    {
        m[0][j] = phi(1,j+1);
        m[x][j]= phi(x+1,j+1);
    }
    for (i=1; i < x; i++)
    {
        m[i][0] = phi(i+1,1);
        m[i][y] = phi(i+1,y+1);
    }
}

phi(x,y)

/*   the function phi, where phi(x,y) = x*x - y*y + x*y  */

int x,y;
{
      return((x * x) - (y * y) + (x * y));   
}

printgrid(grid,r,c)

/* print the grid */

double grid[ROWS+2][COLUMNS+2];
int r,c;
{
    int i,j;

    for (i = 0; i < r; i++)
	for (j = 0; j < c; j++)
	    printf("grid[%3d][%3d] = %10.5f\n",i,j,grid[i][j]);
}
