/* Host version of Monitor Macros */

define(MAXTRACE,1)
define(ENDLAB,5283) dnl
define(MLABEL,4222) dnl
define(NODE_PID,2) dnl

/*  delay(<monitor>,<queue>)
*/
define(DELAY,
        `$1.count[$2]++;
         $1.lock = 0;   
         $1.queue[$2] = 1;   
         '
      )

/*  continue(<monitor>,<queue>)
*/
define(CONTINUE,
           `if ($1.count[$2] == 0)
            {
                $1.lock = 0;
            }
            else
            {
                ($1.count[$2])--;
                $1.queue[$2] = 0;
            }
            goto `L'ENDLAB;'
      )

/*  menter(<monitor>)
*/
define(MENTER,
      `{
           ($1.lock) = 1;
       }'
      )

/*  mexit(<monitor>)
*/
define(MEXIT,
           `$1.lock = 0;
           `L'ENDLAB: ;
            define(`ENDLAB',eval(ENDLAB+1))'
      )

/*  decvar(<monitor>,<queues>,<extra_code_for_more_variables>)
*/
define(DECVAR,
           `struct $1TYP {                                                    
              char  lock;
               ifelse(eval($2 > 0),1,int count[$2];,)
               ifelse(eval($2 > 0),1, char queue[$2];,)
               $3                       
           } $1;'
       )

/*  moninit(<monitor>,<queues>)
*/
define(MONINIT,
        `{
         int q_num;
         ifelse(eval($2 > 0),1,
	     for (q_num=0; q_num < $2; q_num++)
	     {
		 $1.count[q_num] = 0;
		 $1.queue[q_num] = 0;
		 $1.queue[q_num] = 1;
	     },,)
	     $1.lock = 0;
         }'
      )
    
/* clock(<clock_val>)
*/
define(CLOCK,
	`{
	 long xtime;
             xtime = *timer; 
	     $1 = xtime;
	 }'
      )

define(TRACE_STRUCT,`
struct zz_trace_entry {
    int id;
    int typ;
    int data;
};
struct zz_trace_struct {
    int next_entry;
    struct zz_trace_entry trace_table[MAXTRACE];
};
')

define(BUFF_SIZE,256)

/* env(<max_procs>,<sh_mem>,<sr_buffs>)) */
define(ENV,`
    define(`MAX_PROCS',`ifelse($1,,50,$1)')
    define(`SH_MEM',`ifelse($2,,30000,$2)')
    define(`SR_BUFFS',`ifelse($3,,50,$3)')
int xx_my_id;	/* overwritten by each process */
char *share();
int xxwaiti;
char *xx_mem();
typedef int p_LOCK;
int xx_type;
char s[256];

/* begin intel message passing declarations */

int ipsc_cid,ipsc_type,ipsc_node,ipsc_pid;
int ipsc_cnt;

struct ipsc_msg {
	int  type;
	int  pid;
	int  ln;
	int  ack;
	char buf[8192];
	}; 
struct ipsc_msg *ipsc_buf;
struct ipsc_msg ipsc_msg;

struct ipsc_null {
	int  type;
	int  pid;
	int  ln;
	int  ack;
	}; 
struct ipsc_null null_msg;

/* end intel message passing declarations */

struct xx_cluster *xx_cmem;

struct xx_msg {
    struct xx_msg *link;
    int sender;
    int type;
    int ack;
    struct xx_buffer *first_buff;
};

struct xx_buffer {
    struct xx_buffer *link;
    int ln;			/* # characters of buff that are data */
    char buff[BUFF_SIZE];
};

typedef int PROC_ID;

struct xx_process {
    long cpid;  /* take the process id from unix */
    DECVAR(msg_q_monitor,1)
    struct xx_msg *first_msg,*last_msg;
};

struct xx_cluster {

    LOCKDEC(avl_lock)
    struct xx_buffer *avail_buffs;
    struct xx_msg *avail_msgs;
    LOCKDEC(proc_table)
    struct xx_process *active_processes[MAX_PROCS];
};
')

/* initenv(<global_memory>)
*/
define(INITENV,`
{
long i,j,k;
struct xx_buffer *xx_b1;
struct xx_msg *xx_m1;

    ifelse($1,,,`define(`SH_MEM',`ifelse($2,,30000,$2)')')
    i = SH_MEM;
    j = SR_BUFFS;
    i += j * (BUFF_SIZE + sizeof(struct xx_msg));
    xx_mem(0, SH_MEM );
	printf("DEBUG -- after xx_mem \n");

    /* begin cube stuff */

	ipsc_pid = mypid();

    ipsc_cid = copen(ipsc_pid);

    ipsc_buf = &(ipsc_msg);

    /* end cube stuff */
    xx_cmem = (struct xx_cluster *) 
		  G_MALLOC(sizeof(struct xx_cluster));
	printf("DEBUG -- after xx_mem \n");
    /* now allocate and format the buffer pool */


    k = SR_BUFFS ;
    i = k * BUFF_SIZE;
    xx_cmem->avail_buffs = (struct xx_buffer *) G_MALLOC(i);
	printf("DEBUG -- after xx_mem \n");
    for (j=0,xx_b1=xx_cmem->avail_buffs; j < k; j++,xx_b1++)
	xx_b1->link = xx_b1+1;
    xx_b1--;
    xx_b1->link = 0;

    /* initialize msg avail */
    k = SR_BUFFS ;
    i = k * sizeof(struct xx_msg);
    xx_cmem->avail_msgs = (struct xx_msg *) G_MALLOC(i);
	printf("DEBUG -- after xx_mem \n");
    for (j=0,xx_m1=xx_cmem->avail_msgs; j < k; j++,xx_m1++)
	xx_m1->link = xx_m1+1;
    xx_m1--;
    xx_m1->link = 0;

    /* initialize table of active processes */
    for (i=1; i < MAX_PROCS; i++)
	xx_cmem->active_processes[i] = 0;

    /* now put in the entry for the master */
    {
    struct xx_process *p1;

	xx_cmem->active_processes[0] = p1 =
	    (struct xx_process *) G_MALLOC(sizeof(struct xx_process));
	printf("DEBUG -- after xx_mem \n");
	p1->first_msg = p1->last_msg = 0;
	p1->cpid = 0x8000;
    }
    xx_my_id = 0;
}
')

/* who_am_i(<proc_id>) */
define(WHO_AM_I,`
    {
    long ipsc_id;
    int xx_i;

	ipsc_id = 0x8000;
	for (xx_i=0; 
	     (ipsc_id != xx_cmem->active_processes[xx_i]->cpid);
	     xx_i++)
	    ;
	*($1) = xx_i;
    }
')

/* where_am_i(<node>) */
define(WHERE_AM_I,`*($1) = 0;')

/* char *G_MALLOC(<size>)
*/
define(G_MALLOC,
	 `xx_mem(1,$1);'
      )

define(G_AREA,`xx_mem(2,0);')

define(MEM_BLK,`
struct mem_blk {
    char *next;
    int l_mem;
};
      ')
define(LOG_EVENT,`lgevnt(xx_cmem->trace_data,xx_my_id,$1,$2);')
define(DUMP_TRACE,`dtrc(xx_cmem->trace_data);')
define(WAIT_FOR_END,`for(xxwaiti=1;xxwaiti<=$1;xxwaiti++) wait(0);')

define(LOAD,`
    if (*($1) == 0)
	*($2) = 1000;
    else
    {
	exit(3);
    }
')

/* send_r(<process_id>,<msg_type>,<msg>[,<ln>]) */
define(SENDR,`
{
PROC_ID xx_proc;
int ack_type;
	sprintf(s,"doing a send");
	syslog(0,s);
    SEND($1,$2,$3,$4,ack)
	sprintf(s,"doing a receive");
	syslog(0,s);
    RECEIVE(&xx_proc,&ack_type,, (match_id($1) && match_type(9999)))
}
')

/* send(<process_id>,<msg_type>,<msg>[,<ln>][,<ack_requested>]) */
define(SEND,`
    {

	strncpy(ipsc_msg.buf,ifelse($3,,null_msg,$3),
		ifelse($4,,sizeof(ifelse($3,,null_msg,$3)),$4));
	ipsc_msg.type = $2;
	ipsc_msg.pid = *($1);
	ipsc_msg.ln = ifelse($4,,sizeof(ifelse($3,,null_msg,$3)),$4);
	ipsc_msg.ack = ifelse($5,,0,1);
	
	sprintf(s,"doing a send to %d ",ipsc_msg.pid);
	syslog(0,s);
	sendmsg(ipsc_cid,3,ifelse($3,,null_msg,ipsc_buf),
		ifelse($4,,sizeof(ifelse($3,,null_msg,$3))+8,$4+8),*($1),*($1));
	sprintf(s,"after a send to %d type %s",ipsc_msg.pid,ipsc_buf);
	syslog(0,s);

    }
')


define(match_id,`(xx_m1->sender == *($1))')
define(match_type,`(xx_m1->type == $1)')

/* receive(<process_id>,<msg_type>,<msg>,<cond>[,<ln>]) */
define(RECEIVE,`
    {
    int xx_i,xx_n;
    char *xx_c1,*xx_c2;
    struct xx_buffer *xx_b1,*xx_b2;
    struct xx_msg *xx_m1,**xx_mp;
    struct xx_process *to_proc;
    int xx_found,xx_len,xx_rem;

	to_proc = xx_cmem->active_processes[xx_my_id];
	xx_found = 0;
	xx_mp = &(to_proc->first_msg);
	while (!xx_found)
	{
	    
	    while (*xx_mp) 
	    {



	    xx_m1 = *xx_mp;

	    *($1) = ipsc_buf->pid;
	    *($2) = ipsc_buf->type;
	    if ($4)
	    {
		/* now we copy from buffers into msg area 
		*/
		ifelse($5,,,*($5)=0;)
			xx_b2=0;
			for (xx_b1=xx_m1->first_buff,xx_c1 = ((char *) ifelse($3,,0,$3)); 
			     (xx_b1);
			     xx_b1=xx_b1->link)
			{
			    for (xx_i=xx_b1->ln, xx_c2=xx_b1->buff;
				 (xx_i);
				 xx_i--)
			    {
					ifelse($3,,,*(xx_c1++) = *(xx_c2++);)
			    }
			    ifelse($5,,,*($5) += xx_b1->ln;)
			    xx_b2 = xx_b1;
			}
		xx_found = 1;
		if (to_proc->last_msg == *xx_mp)
		    to_proc->last_msg = ((struct xx_msg *) xx_mp);
		*xx_mp = (*xx_mp)->link;
		if (!(to_proc->first_msg))
		    to_proc->last_msg = 0;
	    }
	    else
	    {
			xx_mp = &((*xx_mp)->link);
	    }
	 }
	if (!xx_found)
		{
		sprintf(s,"doing a recv of type %d",xx_type);
		syslog(0,s);
			recvmsg(ipsc_cid,&xx_type,ipsc_buf,ifelse($5,,
				ifelse($3,,8,sizeof(*($3))+8),$5+8),
				&ipsc_cnt,&ipsc_node,&ipsc_pid);
		sprintf(s,"got a message from %d",ipsc_node);
		syslog(0,s);
			
			
			/* begin ------- copy into buffers */
		
				xx_len = ipsc_cnt - 8;
			if (xx_len)
			{
				xx_n = (xx_len + (BUFF_SIZE - 1)) / BUFF_SIZE;
				xx_b1 = xx_cmem->avail_buffs;
				for (xx_b2=xx_b1, xx_i=xx_n; 
					(xx_b2) && (--xx_i); 
					xx_b2=xx_b2->link);
				if (!xx_b2)
				{
					exit(3);
				}
				xx_cmem->avail_buffs = xx_b2->link;
				xx_b2->link = 0;
			}
			else
				xx_b1=0;

			xx_m1 = xx_cmem->avail_msgs;
			xx_cmem->avail_msgs = xx_m1->link;

			xx_m1->first_buff = xx_b1;

			xx_m1->link = 0;
			xx_m1->sender = ipsc_msg.pid;
			xx_m1->type = ipsc_msg.type;
			xx_m1->ack = ipsc_msg.ack;

			if (xx_len)
			{
				for (xx_b2=xx_b1,xx_rem=xx_len,xx_c1=((char *) ipsc_msg.buf);
					 xx_rem;
					 xx_b2 = xx_b2->link)
				{
					if (xx_rem > BUFF_SIZE)
					xx_i = BUFF_SIZE;
					else
					xx_i = xx_rem;

					xx_rem = xx_rem - xx_i;
					xx_b2->ln = xx_i;

					for (xx_c2=xx_b2->buff; xx_i--;)
					*(xx_c2++) = *(xx_c1++);
				}
			}

			if (to_proc->first_msg)
			{
					to_proc->last_msg->link = xx_m1;
					to_proc->last_msg = xx_m1;
			}
			else
				 to_proc->first_msg = to_proc->last_msg = xx_m1;

			/* end ----- copy into buffers just in time to copy out ? */
	}
	}
	if (xx_m1->ack)
	{
	    SEND($1,9999)
	}
	xx_m1->link = xx_cmem->avail_msgs;
	xx_cmem->avail_msgs = xx_m1;
	if (xx_b2)
	{
	    xx_b2->link = xx_cmem->avail_buffs;
	    xx_cmem->avail_buffs = xx_m1->first_buff;
	}
    }
')

/* remote_create(<proc_group>,<proc_ids>) */
define(REMOTE_CREATE,`
{
    $1();
}
')

/* process_group(<group_name>,<proc_ids>) */
define(PROCESS_GROUP,`
      $1()
{
')

/* process_entry(<filename>,<node_number>,<proc_ids>) */
define(PROCESS_ENTRY,`
    load($1,$2,$3);
')

/* process_group_end */
define(PROCESS_GROUP_END,`
}
')

/* copy_id(<to_id>,<from_id>)
define(COPY_ID,` *($1) = *($2);')

/* type(<msg_type>,<C_structure>) */
define(MSG_TYPE,`
	ifelse($2,EMPTY,,`
	    $2
	    define(`I',`eval(index($2,`{')-1)')
	    define(`TYPE_LEN_$1',sizeof(substr($2,0,I))) 
	                 ')
')
define(BEGIN_MSG_TYPES,)
define(END_MSG_TYPES,)

