#include <X11/Xlib.h>
#include <X11/Xutil.h>
#include <stdio.h>
#include "u_defines.h"

struct win_info {
  Window window;
  int width;
  int height;
  int x;
  int y;
  int opt1;
  int opt2;
};

extern struct win_info windows[];

extern int proc_no,        /* processor number of node to be redrawn*/
           no_el,          /* number of elements on node            */
           rec_type,       /* record type of traceline              */
           local_el[],     /* array of elements on node             */
           in[],           /* index of first element on each node   */
           in2[],          /* index of first element on each node   */
           lengthnode[],   /* no of elements on each node           */
           order[], most;


u_draw()

{    int shift;  /* amount the number of elements on node has changed */

     if (rec_type==USER && most != 0) {

/*draw elements on node */
         drawrectangle(proc_no,no_el,local_el);

/*if number of elements on node has changed, adjust index of first el on node */
/*and redraw indices */
         if (lengthnode[proc_no]!=no_el) {
            shift=no_el-lengthnode[proc_no];
            lengthnode[proc_no]+=shift;
            drawindex(proc_no,shift);
            }
     }
}
extern Display *mydisplay;  /*Variables used*/
extern Window u_window;     /*for XWindow   */
extern GC u_gc[];           /*Displays      */
extern int num_nodes;       /*Number of processors used*/
extern int colist[],        /*Array of color of each element*/
           highest[],       /*Largest element on each node*/
           invg[],          /*Inv gray order of each node number*/
           u_height,        /* window height        */
           depth,           /* depth of window      */
           widthscale;      /* width of each node   */
extern int heightscale;   /* heightscale          */



drawrectangle(node,num,temp)
int node,num,temp[MAXEL];
/* node number, number of elements, array of elements on node */

{        int colheight,   /* rect. height         */
             x,x1,        /* x coord of rect.     */
             y,           /* y coord of rect.     */
             gcnum,       /* gcnum                */
             big,         /* largest element      */
             i,           /* loop control var     */
             wscale;      /* width of rectangle   */

/* erase node's previous elements */
       if (windows[92].opt1==1)
         x1=widthscale*order[node]+MAR_SIZE+1;
       else
         x1=widthscale*order[node]+MAR_SIZE+1;
       y=(u_height-(u_height*highest[order[node]])/most+MAR_SIZE);
       colheight=(u_height*highest[order[node]])/most;
       XFillRectangle(mydisplay,u_window,u_gc[65],x1,y,widthscale,
                        colheight);

/* draw new elements */
      if (num!=0){
       wscale=widthscale/num;
       big=0;
       for (i=0; i<num; i++) {
          x=x1+i*wscale;
          y=u_height-(u_height*temp[i])/most+MAR_SIZE;
          colheight=(u_height*temp[i])/most;
          if (depth == 1)
             gcnum=0;
          else 
             gcnum=order[colist[temp[i]]]+1;
          XFillRectangle(mydisplay,u_window,u_gc[gcnum],x,y,wscale,
                         colheight);
          if (temp[i]>big)
            big=temp[i];
          }
       highest[order[node]]=big;
        }
}

extern int u_height1;       /*Height of window */

drawindex(node,shift)
int node,shift; 
/*node that was redrawn, change in number of elements on that node*/

{
   int i,  /*loop control variable*/
       x,  /*x coordinate of rect */
       y,  /*y coordinate of rect */
       t,  /*width of rect        */
       h,  /*height of rect       */
       start,temp;
   char s[8];/*string used for printing index numbers*/

/*write new index values for all nodes after node that was redrawn*/
   if (windows[92].opt1==1)
     start=node+1; 
   else 
     start=node+1;
   for (i=start; i<num_nodes; i++){
       if(i%4==0 || num_nodes<=16){
          x=i*widthscale+MAR_SIZE + 1;
          y=u_height1-.5*MAR_SIZE - 2+MAR_SIZE;
          in[(i)]+=shift;
          in2[i]+=shift;
          if (windows[92].opt1==1) 
           sprintf(s,"%2d",in[(i)]);
          else
           sprintf(s,"%2d",in2[i]);
          XDrawImageString(mydisplay,u_window,u_gc[0],x,y,s,strlen(s));
       }
   }
}

