#include <X11/Xlib.h>
#include <X11/Xutil.h>
#include <X11/Xatom.h>
#include <stdio.h>
#include "u_defines.h"

int u_win = 1;              /*Global variable to signal user defined window*/
int u_scroll = 0;
GC u_gc[MAXNODE+4];   
extern Display *mydisplay;  
Window u_window, menu_win, button_win;        
extern Font font1;   
unsigned long u_foreground, u_background;
extern int depth,matrix_dim, num_nodes; 
extern int color[], task_colors[]; 
int uopen, win_height, win_width;
extern Cursor hand_cursor;

u_init()
{
 /* declarations */
        XSizeHints u_hint;    /*Variables*/
        int i, j, sextant, new1, new2, new3, myscreen;
       float val, temp1, temp2, hue, sat, fract;

        if (num_nodes>MAXNODE)
          u_win=0;
        else
	  u_win=1;

        uopen=0;

        myscreen = DefaultScreen(mydisplay);

/* pixel values */
        u_background = WhitePixel(mydisplay, myscreen);
        u_foreground = BlackPixel(mydisplay, myscreen);


/* default program-specified window position and size */
	if(matrix_dim<=32) win_height = win_width = matrix_dim*16+1;
	else if(matrix_dim<=64) win_height = win_width = matrix_dim*8+1;
	else if(matrix_dim<=128) win_height = win_width = matrix_dim*4+1;
	else if(matrix_dim<=256) win_height = win_width = matrix_dim*2+1;
	else win_height = win_width = matrix_dim*1+1;
	if(matrix_dim==0)win_height = win_width = 100;
        u_hint.x = 0; u_hint.y = 0;
	u_hint.width = 30+win_width; u_hint.height = 30+win_height;
        u_hint.flags = PPosition | PSize;
        u_window = XCreateSimpleWindow(mydisplay,
                DefaultRootWindow(mydisplay),
                u_hint.x, u_hint.y, u_hint.width, u_hint.height,
                2, u_foreground, u_background);
        XChangeProperty(mydisplay, u_window, XA_WM_NAME,
                XA_STRING, 8, PropModeReplace, "Matrix", 6);
        menu_win = XCreateSimpleWindow(mydisplay, DefaultRootWindow(mydisplay),
                u_hint.x, u_hint.y, 98, 24, 2, u_foreground, u_background);
        XChangeProperty(mydisplay, menu_win, XA_WM_NAME,
                XA_STRING, 8, PropModeReplace, "User Menu", 9);
        button_win = XCreateSimpleWindow(mydisplay, menu_win,
                2, 2, 90, 16, 2, u_foreground, u_background);

/*initialize gc's*/
        for (i=0; i<=MAXNODE+4; i++){
          u_gc[i] = XCreateGC(mydisplay, DefaultRootWindow(mydisplay), 0, 0);
          XSetBackground(mydisplay,u_gc[i],u_background);
          XSetFont(mydisplay, u_gc[i], font1);
          }
        XSetForeground(mydisplay,u_gc[0],u_foreground);
        XSetForeground(mydisplay,u_gc[65], u_background);
    XSelectInput(mydisplay, u_window, ExposureMask |StructureNotifyMask);
    XSelectInput(mydisplay, menu_win, ExposureMask |StructureNotifyMask);
    XSelectInput(mydisplay, button_win, ExposureMask |StructureNotifyMask|
      ButtonPressMask);
    XDefineCursor(mydisplay, u_window, hand_cursor);
    XDefineCursor(mydisplay, menu_win, hand_cursor);
    XDefineCursor(mydisplay, button_win, hand_cursor);

/* color allocations*/
    if (depth  >1) {
        for (i=1;i<=num_nodes;i++) {
            j=(i-1);
            XSetForeground(mydisplay,u_gc[i], task_colors[(j%8)*8+j/8]);
            }
        XSetForeground(mydisplay,u_gc[66], color[7]);
        XSetForeground(mydisplay,u_gc[67], color[10]);
	}

}

