#include <stdio.h>
#include <ctype.h>
#include <stdlib.h>
#include <math.h>
#include <X11/Xlib.h>
#include <X11/Xutil.h>
#include <X11/Xatom.h>
#include "defines.h"

struct win_info {
  Window window;
  int width;
  int height;
  int x;
  int y;
  int opt1;
  int opt2;
};

extern Display *mydisplay;
extern struct win_info windows[];
extern GC gc[];
extern FILE *tfptr;
extern char unit_str[], stop_str[], start_str[], trace_node_str[], *key_words[],            rec_start_str[], rec_stop_str[];
Region sptm_clip_region, crit_clip_region;
XPoint sptm_clip_points[4], crit_clip_points[4];
int max_dist, min_time, max_time, max_load_count, max_load_vol, max_count, 
    min_lth, max_vol, *tsks_prog, max_vol_node[MAXP], max_count_node[MAXP], 
    max_load_count_node, tsks_dim, task_num, max_load_vol_node, current_node, 
    max_node, current_link, count_node[MAXP], vol_node[MAXP], total_tasks, 
    current_lth, max_lth, load_vol, load_count, exit_count, *start_task, 
    *task_counter, *task_time, min_type, max_type, psta_dim, hype_num_nodes, 
    win_edge[7], right_scale[7], **task, num_mesh_dim, poss_mesh_dim[16], 
    close_count, ****sendpoint, **cum_vol, **msg_count, k_x[MAXP], k_y[MAXP], 
    *task_count, max_queue_count[MAXP][MAXP], ***ntwk_load, anim_num_nodes, 
    true_num_nodes, ***ntwk_total, start_idle[MAXP], max_exit_time;
extern int time_sec, order[], psta_lth_bin[], ninf_center, stop_time, **ns_inv, 
	   proc_width, num_nodes, time_unit, scale_width, scroll_width[], 
	   trace_node, comm_max_load, queu_max_load, raw_time, begin_of_file, 
	   ninf_height, radius, win_size, k_center_x, k_center_y, lth_bin[], 
	   anim_center_x, start_time, ntwk_stages, ntwk_nodes, rec_stop_time, 
	   time_microsec, max_hops, rec_start_time, state[], meter_max_load, 
	   start_ovhd[], start_busy[], prev_state[], paired_comp[], is_env, 
           anim_center_y, anim_rad;

extern float user_anim_x[128], user_anim_y[128];
extern BOD_STRUCT cur_streak[];
BOD_STRUCT max_streaks;

struct ns_pt {
        int n;
        int s;
};

struct ns_pt *pt_array;

preprocess()
{
 
     char line[MAXLINE];
     int msg_type, firstline, i, j, k, temp, queue_count[MAXP][MAXP];
     static float last_time;
     float current_time, current_min_time, current_max_time;
     int bdcst_load_count, bdcst_count_node, bdcst_load_vol, bdcst_max_count,
	 bdcst_vol_node, bdcst_queue_count[MAXP], bdcst_max_queue_count[MAXP],
	 buf, loop, bdcst_max_count_node, bdcst_max_vol_node, bdcst_max_vol,
	 e_type, seen_it[MAXP];
     double log_two();

     printf("preprocessing file\n");
     bdcst_load_count=bdcst_count_node=bdcst_load_vol=bdcst_max_count=
     bdcst_vol_node=bdcst_max_count_node=bdcst_max_vol_node=bdcst_max_vol=0;
     true_num_nodes=0;
     for(i=0; i<MAXP; i++){
         bdcst_queue_count[i]=bdcst_max_queue_count[i]=0;
	 max_count_node[i]=max_vol_node[i] = 0;
         state[i]=prev_state[i]= -1;
         cur_streak[i].busy=cur_streak[i].busy_ovhd=cur_streak[i].ovhd_idle=
         cur_streak[i].idle=0;
     }
     for(i=0; i<MAXP; i++)
       for(j=0; j<MAXP; j++)
         max_queue_count[i][j] = queue_count[i][j] = 0;
     for(i=0; i<MAXP; i++)
         max_count_node[i] = max_vol_node[i] = seen_it[i]=0;
     max_exit_time = max_count = current_max_time = max_load_count_node = 
     max_load_vol_node = 0;
     max_vol = max_node = 0;
     current_min_time = 10000000000000.0; min_lth = 1000000000; max_lth = 0; 
     min_type=1000000000; max_type=0;
     max_streaks.busy=max_streaks.busy_ovhd=max_streaks.idle=
     max_streaks.ovhd_idle=0;
     time_unit = 1;
     firstline = 1;
     total_tasks = 0;
     begin_of_file = 1;
   last_time = -1000000000.0;
     while (fgets(line, MAXLINE, tfptr)) {

         u_preprocess(line, &firstline);
	 if(firstline==1){
	   last_time = -1000000000.0;
	   if(!isdigit(line[0])&&strncmp(line,"-",1)!=0){
	     printf("ParaGraph does not support verbose files.\nQuitting...\n");
	     exit(1);
	   }
	 firstline=0;
	 }
	 if(isdigit(line[0])||strncmp(line,"-",1)==0){
         sscanf(line, "%d %d %f %d", &e_type, &k, &current_time, &current_node);
         raw_time=(int)(1000000.0*current_time);
         current_time = (1000000.0* current_time)/(float)time_unit;
         if (current_time>current_max_time)
              current_max_time = current_time;
         if(k>=0){
           sscanf(line,"%*d %d", &task_num);
           if (task_num > total_tasks)
             total_tasks = task_num;
         }else{
         if(current_node!=HOST){
           if(k!=RECVBLOCK&&k!=WAIT&&k!=RECVENDW&&k!=IDLE&&k!=TSTART){
            if(e_type==EVENTENTRY){
              state[current_node]=2;
            }else if(e_type==EVENTEXIT){
              state[current_node]=1;
            }
           }else if(k!=TSTART){
            if(e_type==EVENTENTRY){
              state[current_node]=0;
            }else if(e_type==EVENTEXIT){
              state[current_node]=1;
            }
           }
         }
	 switch (k) {
 
         case TSTART:
	 case CLOSE:
             if (current_time<current_min_time){
	         current_min_time = current_time;
	     }
             if (current_node!= HOST) {
	     if(current_node>=MAXP){
	       printf("Tracefile contains more than MAXP=%d nodes.\n", MAXP);
	       exit(1);
	     }
             if(seen_it[current_node]==0){
	       seen_it[current_node]=1;
	       true_num_nodes++;
	     }
               if (current_node>max_node)
	           max_node = current_node;
	       state[current_node]=1;
               if(k==TSTART&&e_type==EVENTENTRY) state[current_node]=1;
               else state[current_node]=0;
	     }
             if (e_type==EVENTEXIT && current_time>max_exit_time)
               max_exit_time = current_time;
             break;
 
         case RECV:
         case RECVENDV:
         case RECVENDW:
             if(e_type==EVENTEXIT){
               sscanf(line,"%*d %*d %*f %*d %*d %*d %*s %d %d %d",
                   &current_lth, &msg_type, &current_link);
             if(current_node>=MAXP){
               printf("Tracefile contains more than MAXP=%d nodes.\n", MAXP);
               exit(1);
             }
             if (current_node!= HOST && current_link != HOST) {
	     if(seen_it[current_node]==0){
	       seen_it[current_node]=1;
	       true_num_nodes++;
	     }
	         load_count--;
	         count_node[current_node]--;
	         load_vol-=current_lth;
	         vol_node[current_node]-=current_lth;
		 queue_count[current_link][current_node]--;
                 if (current_time<current_min_time){
	             current_min_time = current_time;
		 }
                 if (current_node>max_node)
	             max_node = current_node;
		 if(msg_type>max_type) max_type=msg_type;
		 if(msg_type<min_type) min_type=msg_type;
	     }
             }
             break;
 
         case SEND:
         case SENDBEGIN:
             if(e_type==EVENTENTRY){
              sscanf(line,"%*d %*d %*f %*d %*d %*d %*s %d %d %d",
                 &current_lth, &msg_type, &current_link);
	     if(current_node>=MAXP){
	       printf("Tracefile contains more than MAXP=%d nodes.\n", MAXP);
	       exit(1);
	     }
             if (current_node!= HOST && current_link != HOST) {
	     if(seen_it[current_node]==0){
	       seen_it[current_node]=1;
	       true_num_nodes++;
	     }
		if(current_link!=ALL){
	         load_count++;
	         count_node[current_link]++;
	         load_vol+=current_lth;
	         vol_node[current_link]+=current_lth;
		 if (++queue_count[current_node][current_link]>max_queue_count[current_node][current_link])
		   max_queue_count[current_node][current_link] =
		      queue_count[current_node][current_link];
                 if (count_node[current_link]> max_count_node[current_link])
	             max_count_node[current_link] = count_node[current_link];
                 if (vol_node[current_link]>max_vol_node[current_link])
	             max_vol_node[current_link] = vol_node[current_link];
                 if (load_vol>max_vol)
	             max_vol = load_vol;
                 if (load_count>max_count)
	             max_count = load_count;
                }else{
	         bdcst_load_count++;
	         bdcst_count_node++;
	         bdcst_load_vol+=current_lth;
	         bdcst_vol_node+=current_lth;
		 if (++bdcst_queue_count[current_node]>bdcst_max_queue_count[current_node])
		   bdcst_max_queue_count[current_node] =
		      bdcst_queue_count[current_node];
                 if (bdcst_count_node> bdcst_max_count_node)
	             bdcst_max_count_node = bdcst_count_node;
                 if (bdcst_vol_node>bdcst_max_vol_node)
	             bdcst_max_vol_node = bdcst_vol_node;
                 if (bdcst_load_vol>bdcst_max_vol)
	             bdcst_max_vol = bdcst_load_vol;
                 if (bdcst_load_count>bdcst_max_count)
	             bdcst_max_count = bdcst_load_count;
		}

		 if(msg_type>max_type) max_type=msg_type;
		 if(msg_type<min_type) min_type=msg_type;
                 if (current_time<current_min_time){
	             current_min_time = current_time;
		 }
                 if (current_node>max_node)
	             max_node = current_node;
                 if (current_lth<min_lth)
	             min_lth = current_lth;
                 if (current_lth>max_lth)
	             max_lth = current_lth;
	     }
             }
             break;
         case RECVBLOCK:
             if(e_type==EVENTEXIT){
               sscanf(line,"%*d %*d %*f %*d %*d %*d %*s %d %d %d",
                 &current_lth, &msg_type, &current_link);
	     if(current_node>=MAXP){
	       printf("Tracefile contains more than MAXP=%d nodes.\n", MAXP);
	       exit(1);
	     }
             if (current_node!= HOST && current_link != HOST) {
            state[current_node]=1;
	     if(seen_it[current_node]==0){
	       seen_it[current_node]=1;
	       true_num_nodes++;
	     }
	         load_count--;
		 queue_count[current_link][current_node]--;
	         count_node[current_node]--;
	         load_vol-=current_lth;
	         vol_node[current_node]-=current_lth;
                 if (current_time<current_min_time){
	             current_min_time = current_time;
		 }
                 if (current_time>current_max_time)
                     current_max_time = current_time;
                 if (current_node>max_node)
	             max_node = current_node;
                 if (current_lth<min_lth)
	             min_lth = current_lth;
                 if (current_lth>max_lth)
	             max_lth = current_lth;
		 if(msg_type>max_type) max_type=msg_type;
		 if(msg_type<min_type) min_type=msg_type;
	     }
             }
             break;

         default:
	     if(current_node!=HOST){
	     if(seen_it[current_node]==0){
	       seen_it[current_node]=1;
	       true_num_nodes++;
	     }
	     if(current_node>=MAXP){
	       printf("Tracefile contains more than MAXP=%d nodes.\n", MAXP);
	       exit(1);
	     }
                 if (current_time<current_min_time){
	             current_min_time = current_time;
		 }
                 if (current_node>max_node)
	             max_node = current_node;
	     }
             break;
	 }
         if(current_node!=HOST){
           if(current_time>last_time){
             for(i=0; i<MAXP; i++){
               if(i!=current_node){
                 if(state[i]==1){
                   cur_streak[i].busy+=raw_time-start_busy[i];
                   if(cur_streak[i].busy>max_streaks.busy)
                     max_streaks.busy=cur_streak[i].busy;
                   cur_streak[i].busy_ovhd+=raw_time-start_busy[i];
                   if(cur_streak[i].busy_ovhd>max_streaks.busy_ovhd)
                     max_streaks.busy_ovhd=cur_streak[i].busy_ovhd;
                   start_busy[i]=raw_time;
                 }
                 if(state[i]==2){
                   cur_streak[i].ovhd_idle+=raw_time-start_ovhd[i];
                   if(cur_streak[i].ovhd_idle>max_streaks.ovhd_idle)
                     max_streaks.ovhd_idle=cur_streak[i].ovhd_idle;
                   cur_streak[i].busy_ovhd+=raw_time-start_ovhd[i];
                   if(cur_streak[i].busy_ovhd>max_streaks.busy_ovhd)
                     max_streaks.busy_ovhd=cur_streak[i].busy_ovhd;
                   start_ovhd[i]=raw_time;
                 }
                 if(state[i]==0){
                   cur_streak[i].idle+=raw_time-start_idle[i];
                   if(cur_streak[i].idle>max_streaks.idle)
                     max_streaks.idle=cur_streak[i].idle;
                   cur_streak[i].ovhd_idle+=raw_time-start_idle[i];
                   if(cur_streak[i].ovhd_idle>max_streaks.ovhd_idle)
                     max_streaks.ovhd_idle=cur_streak[i].ovhd_idle;
                   start_idle[i]=raw_time;
                 }
               }
             }
           }
           if(prev_state[current_node]==1){
             cur_streak[current_node].busy+=raw_time-start_busy[current_node];
             if(cur_streak[current_node].busy>max_streaks.busy)
               max_streaks.busy=cur_streak[current_node].busy;
             cur_streak[current_node].busy_ovhd+=raw_time-
	       start_busy[current_node];
             if(cur_streak[current_node].busy_ovhd>max_streaks.busy_ovhd)
               max_streaks.busy_ovhd=cur_streak[current_node].busy_ovhd;
           }
           if(prev_state[current_node]==2){
             cur_streak[current_node].ovhd_idle+=raw_time-
	       start_ovhd[current_node];
             if(cur_streak[current_node].ovhd_idle>max_streaks.ovhd_idle)
               max_streaks.ovhd_idle=cur_streak[current_node].ovhd_idle;
             cur_streak[current_node].busy_ovhd+=raw_time-
	       start_ovhd[current_node];
             if(cur_streak[current_node].busy_ovhd>max_streaks.busy_ovhd)
               max_streaks.busy_ovhd=cur_streak[current_node].busy_ovhd;
           }
           if(prev_state[current_node]==0){
             cur_streak[current_node].idle+=raw_time-start_idle[current_node];
             if(cur_streak[current_node].idle>max_streaks.idle)
               max_streaks.idle=cur_streak[current_node].idle;
             cur_streak[current_node].ovhd_idle+=raw_time-
	       start_idle[current_node];
             if(cur_streak[current_node].ovhd_idle>max_streaks.ovhd_idle)
               max_streaks.ovhd_idle=cur_streak[current_node].ovhd_idle;
           }
           if(state[current_node]==0)
             start_idle[current_node]=raw_time;
           if(state[current_node]==1)
             start_busy[current_node]=raw_time;
           if(state[current_node]==2)
             start_ovhd[current_node]=raw_time;
           if(prev_state[current_node]!=state[current_node]){
             if(state[current_node]==0){
               cur_streak[current_node].busy=0;
               cur_streak[current_node].busy_ovhd=0;
             }else if(state[current_node]==1){
               cur_streak[current_node].idle=0;
               cur_streak[current_node].ovhd_idle=0;
             }else if(state[current_node]==2){
               cur_streak[current_node].idle=0;
               cur_streak[current_node].busy=0;
             }
           }

           prev_state[current_node]=state[current_node];
         }

	 if(current_time<last_time){
	   printf("Tracefile not in increasing order by timestamps.\n");
	   printf("Quitting...\n");
	   exit(1);
	}
	last_time=current_time;
     } 
     }
    }
     max_node++;
     close_count = exit_count=true_num_nodes;
     num_nodes=max_node;
     if(max_node <= 4){
	hype_num_nodes = 4;
	windows[PROF].width = 260;
     }
     else if (max_node<=8){
	hype_num_nodes = 8;
	windows[PROF].width = 330;
     }
     else if (max_node <= 16){
	hype_num_nodes = 16;
	windows[PROF].width = 400;
     }
     else if (max_node <= 32){
	hype_num_nodes = 32;
	windows[PROF].width = 390;
     }
     else if (max_node <= 64){
	hype_num_nodes = 64;
	windows[PROF].width = 385;
     }
     else if (max_node <= 128){
	hype_num_nodes = 128;
	windows[PROF].width = 447;
     }
     else if (max_node <= 256){
	hype_num_nodes = 256;
	windows[PROF].width = 574;
     }
     else if (max_node <= 512){
	hype_num_nodes = 512;
	windows[PROF].width = 573;
     }
     else {
        if (windows[SOPT].opt1) {
            XClearArea(mydisplay, windows[TFIL].window, 38, 0, 197, 30, False);
            XClearArea(mydisplay, windows[TFIL].window, 0, 28, 235, 30, False);
	    XDrawImageString(mydisplay, windows[TFIL].window,
	        gc[CLOK], 38, 22, "number of nodes too large", 26);
            fclose(tfptr);
        } else {
   	    printf("Tracefile has %d nodes. ParaGaph is limited to %d nodes\n",
	      num_nodes, MAXP);
	    exit(1);
        }
     }
     num_mesh_dim=0;
     anim_num_nodes=num_nodes;
     if(num_nodes/2>32) buf=32;
     else buf=num_nodes/2;
     for(i=1; i<=buf; i++){
       if(num_nodes%i==0&&num_nodes/i<=32){
         poss_mesh_dim[num_mesh_dim]=i;
         num_mesh_dim++;
       }
     }
     if(num_nodes<32){
       poss_mesh_dim[num_mesh_dim]=num_nodes;
       num_mesh_dim++;
     }
     if(num_mesh_dim==0){
       anim_num_nodes=32*(int)ceil(((double)num_nodes)/32.0);
       if(anim_num_nodes/2>32) buf=32;
       else buf=anim_num_nodes/2;
       for(i=1; i<=buf; i++){
         if(anim_num_nodes%i==0&&anim_num_nodes/i<=32){
           poss_mesh_dim[num_mesh_dim]=i;
           num_mesh_dim++;
         }
       }
       if(anim_num_nodes<32){
         poss_mesh_dim[num_mesh_dim]=anim_num_nodes;
         num_mesh_dim++;
       }
     }
     if(windows[ORDB].opt1==1 && num_nodes!=hype_num_nodes)
       for (j = 0; j < MAXP; j++)
	 order[j] = j;
     windows[NMSB].opt2=windows[MTYB].opt2=poss_mesh_dim[num_mesh_dim/2];
     windows[NMSB].opt1=windows[MTYB].opt1=num_mesh_dim/2;
     windows[DIMB].opt1=0;
     for(i=1; i<num_nodes/2; i++){
       if(num_nodes%i==0) windows[DIMB].opt1++;
     }
     windows[DIMB].opt2=(int)sqrt((double)num_nodes);
     max_load_count+=(num_nodes-1)*bdcst_max_count;
     max_count+=(num_nodes-1)*bdcst_max_count;
     max_vol+=(num_nodes-1)*bdcst_max_vol;
     for(i=0; i<num_nodes; i++){
       max_count_node[i]+=bdcst_max_count_node;
       max_vol_node[i]+=bdcst_max_vol_node;
       for(j=0; j<num_nodes; j++)
         max_queue_count[i][j]+=bdcst_max_queue_count[i];
     }
     windows[TRNB].opt1 = num_nodes;
     if(windows[SNDB].opt1>=num_nodes)
     windows[SNDB].opt1 = num_nodes-1;
     switch(windows[DSTB].opt1){
       case 0:
	 max_dist=(int)ceil(log_two((double)num_nodes));
	 break;
       case 1:
	 max_dist=num_nodes/windows[DIMB].opt2 + windows[DIMB].opt2 - 2;
	 break;
       case 2:
	 max_dist=(num_nodes/windows[DIMB].opt2 + windows[DIMB].opt2) / 2;
	 break;
       case 3:
	 max_dist=2*(int)ceil(log_two((double)num_nodes));
	 break;
       case 4:
	 max_dist=(int)ceil(log_two((double)num_nodes));
	 break;
       case 5:
	 max_dist=1;
	 break;
     }
     if(min_type<0) min_type=0;
     if(max_type<=0) max_type=1;
     win_size=512;
     if(max_exit_time==0)  max_exit_time = current_max_time;
     current_max_time = max_exit_time;
     temp = ceil(log10((double)(current_max_time-current_min_time)/290.0)) ;
     for (i = 1 ; i < temp ; i++)
         time_unit *= 10 ;
     sprintf(unit_str, "%d", time_unit);
     min_time = (int)(current_min_time/time_unit);
     max_time = (int)(current_max_time/time_unit-min_time);
     start_time = 0;
     sprintf(start_str, "%d", start_time);
     sprintf(rec_start_str, "%d", rec_start_time);
     trace_node = num_nodes;
     sprintf(trace_node_str, "all");
     rec_stop_time=stop_time = max_time+1;
     sprintf(stop_str, "%d", stop_time);
     sprintf(rec_stop_str, "%d", rec_stop_time);
     for(i=0; i<num_nodes; i++)
       for(j=0; j<num_nodes; j++){
	 if (max_queue_count[i][j]<=0) max_queue_count[i][j]=1;
       }
     total_tasks++;
     if ((task = (int **)malloc(num_nodes*sizeof(int *)))!=NULL){
     for(i=0; i<num_nodes; i++)
           if ((task[i]=(int *)malloc(50*sizeof(int)))==NULL){
	     printf("memory allocation failed: %d bytes requested for task\n",
			   50*sizeof(int));
	     exit(1);
	   }
     }else {
       printf("memory allocation failed: %d bytes requested for task\n",
		   num_nodes*sizeof(int));
       exit(1);
     }
     if ((msg_count = (int **)malloc(num_nodes*sizeof(int *)))!=NULL){
     for(i=0; i<num_nodes; i++)
           if ((msg_count[i]=(int *)malloc(num_nodes*sizeof(int)))==NULL){
	     printf("memory allocation failed: %d bytes requested for msg_count\n", num_nodes*sizeof(int));
	     exit(1);
	   }
     }else {
       printf("memory allocation failed: %d bytes requested for msg_count\n",
		   num_nodes*sizeof(int));
       exit(1);
     }
     if ((cum_vol = (int **)malloc(num_nodes*sizeof(int *)))!=NULL){
     for(i=0; i<num_nodes; i++)
           if ((cum_vol[i]=(int *)malloc(num_nodes*sizeof(int)))==NULL){
	    printf("memory allocation failed: %d bytes requested for cum_vol\n",
	     num_nodes*sizeof(int));
	    exit(1);
	   }
	   else for(j=0; j<num_nodes; j++)
	     cum_vol[i][j]=0;
     }else {
       printf("memory allocation failed: %d bytes requested for cum_vol\n",
		   num_nodes*sizeof(int));
	 exit(1);
       }
     if ((sendpoint = (int ****)malloc(num_nodes*sizeof(int ***)))!=NULL){
     for(i=0; i<num_nodes; i++)
           if ((sendpoint[i]=(int ***)malloc(num_nodes*sizeof(int **)))!=NULL){
             for(j=0; j<num_nodes; j++)
                if ((sendpoint[i][j]=(int **)malloc((max_queue_count[i][j]+1)*
		     sizeof(int *)))!=NULL){
                 for(k=0; k<max_queue_count[i][j]+1; k++)
                  if ((sendpoint[i][j][k]=(int *)malloc(2*sizeof(int)))==NULL){
	           printf("memory allocation failed: %d bytes requested for sendpoint\n", 2*sizeof(int));
		  exit(1);
		  }
                }else{
	           printf("memory allocation failed: %d bytes requested for sendpoint\n", max_queue_count[i][j]*sizeof(int));
		  exit(1);
		}
	     }else {
	       printf("memory allocation failed: %d bytes requested for sendpoint\n", num_nodes*sizeof(int));
	       exit(1);
	     }
     }else {
       printf("memory allocation failed: %d bytes requested for sendpoint\n", 
	     num_nodes*sizeof(int));
       exit(1);
     }
     if ((tsks_prog = (int *)malloc(total_tasks*sizeof(int))) == NULL){
	 printf("memory allocation failed: %d bytes requested for tsks_prog\n", 
		 total_tasks*sizeof(int));
	 exit(1);
     }
     if ((task_count = (int *)malloc(total_tasks*sizeof(int))) == NULL){
	 printf("memory allocation failed: %d bytes requested for task_count\n", 
		 total_tasks*sizeof(int));
	 exit(1);
     }
     if ((task_counter = (int *)malloc(total_tasks*sizeof(int))) == NULL){
	 printf("memory allocation failed: %d bytes requested for task_counter\n", total_tasks*sizeof(int));
	 exit(1);
     }
     if ((start_task = (int *)malloc(total_tasks*sizeof(int))) == NULL){
	 printf("memory allocation failed: %d bytes requested for start_task\n", 
		 total_tasks*sizeof(int));
	 exit(1);
     }
     if ((task_time = (int *)malloc(total_tasks*sizeof(int))) == NULL){
	 printf("memory allocation failed: %d bytes requested for task_time\n", 
		 total_tasks*sizeof(int));
	 exit(1);
     }
     ntwk_nodes=num_nodes;
     ms_net(windows[NTYB].opt1, &ntwk_nodes, &ntwk_stages);
     if ((ntwk_load = (int ***)malloc(ntwk_stages*sizeof(int **))) == NULL){
	 printf("memory allocation failed: %d bytes requested for ntwk_load\n", 
		 ntwk_stages*sizeof(int));
	 exit(1);
     }
     for(i=0; i<ntwk_stages; i++){
       if ((ntwk_load[i] = (int **)malloc(ntwk_nodes*sizeof(int *))) == NULL){
	 printf("memory allocation failed: %d bytes requested for ntwk_load\n", 
		 ntwk_nodes*sizeof(int));
	 exit(1);
       }
       for(j=0; j<ntwk_nodes; j++){
       if ((ntwk_load[i][j] = (int *)malloc(2*sizeof(int))) == NULL){
	 printf("memory allocation failed: %d bytes requested for ntwk_load\n", 
		 2*sizeof(int));
	 exit(1);
       }else{
          ntwk_load[i][j][0]=0;
          ntwk_load[i][j][1]=0;
       }
       }
     }
     if ((ntwk_total = (int ***)malloc(ntwk_stages*sizeof(int **))) == NULL){
	 printf("memory allocation failed: %d bytes requested for ntwk_total\n", 
		 ntwk_stages*sizeof(int));
	 exit(1);
     }
     for(i=0; i<ntwk_stages; i++){
       if ((ntwk_total[i] = (int **)malloc(ntwk_nodes*sizeof(int *))) == NULL){
	 printf("memory allocation failed: %d bytes requested for ntwk_total\n",
		 ntwk_nodes*sizeof(int));
	 exit(1);
       }
       for(j=0; j<ntwk_nodes; j++){
       if ((ntwk_total[i][j] = (int *)malloc(2*sizeof(int))) == NULL){
	 printf("memory allocation failed: %d bytes requested for ntwk_total\n",
		 2*sizeof(int));
	 exit(1);
       }else{
          ntwk_total[i][j][0]=0;
          ntwk_total[i][j][1]=0;
       }
       }
     }
     if ((pt_array = (struct ns_pt *)malloc((max_hops+1)*
          sizeof(struct ns_pt))) == NULL){
       printf("memory allocation failed: %d bytes requested for pt_array\n", 
	 (max_hops+1)*sizeof(struct ns_pt));
       exit(1);
     }
  for(i=0; i<num_nodes; i++)
if (total_tasks <= 600){
    windows[TSMY].width=windows[TSKC].width=(600/total_tasks)*total_tasks+60;
}
for(i=0; i<num_nodes; i++){
  user_anim_x[i]=((float)anim_center_x-(anim_rad-25)*cos(PI/2+2*PI*i/
    num_nodes))/((float)windows[ANIM].width);
  user_anim_y[i]=((float)anim_center_y-5-(anim_rad-25)*sin(PI/2+2*PI*i/
    num_nodes))/((float)windows[ANIM].height);
}
if(num_nodes<=16){
  loop=num_nodes;
}else if (num_nodes<=128){ 
  loop=16;
}else loop=0;
     for (j = 0; j < loop; j++){
         if (cos(PI/2+2*PI*j/loop)>.0000000001)
             k_x[j] = k_center_x-(int)(radius*cos(PI/2+2*PI*j/loop)) - 24;
         else if (cos(PI/2+2*PI*j/loop)<-.0000000001)
             k_x[j] = k_center_x-(int)(radius*cos(PI/2+2*PI*j/loop)) + 8;
         else k_x[j] = k_center_x-3;
         if (sin(PI/2+2*PI*j/loop)>.0000000001)
             k_y[j] = k_center_y-(int)(radius*sin(PI/2+2*PI*j/loop)) - 7;
         else if (sin(PI/2+2*PI*j/loop)<-.0000000001)
             k_y[j] = k_center_y-(int)(radius*sin(PI/2+2*PI*j/loop)) + 15;
         else k_y[j] = k_center_y-(int)(radius*sin(PI/2+2*PI*j/loop)) + 7;
         if (sin(PI/2+2*PI*j/loop)==1)
             k_y[j] = k_center_y-(int)(radius*sin(PI/2+2*PI*j/loop)) - 10;
         if (sin(PI/2+2*PI*j/loop)==-1)
             k_y[j] = k_center_y-(int)(radius*sin(PI/2+2*PI*j/loop)) + 18;
     }
    sptm_clip_points[0].x = sptm_clip_points[1].x = 31;
    sptm_clip_points[0].y = sptm_clip_points[3].y = 16;
    sptm_clip_points[1].y = sptm_clip_points[2].y = windows[SPTM].height-16;
    sptm_clip_points[2].x = sptm_clip_points[3].x = win_edge[SPTM-5];
    sptm_clip_region = XPolygonRegion(sptm_clip_points, 4, 0);
    crit_clip_points[0].x = crit_clip_points[1].x = 31;
    crit_clip_points[0].y = crit_clip_points[3].y = 16;
    crit_clip_points[1].y = crit_clip_points[2].y = windows[CRIT].height-16;
    crit_clip_points[2].x = crit_clip_points[3].x = win_edge[CRIT-5];
    crit_clip_region = XPolygonRegion(crit_clip_points, 4, 0);
    for (i=0; i<64; i++)
        XSetRegion(mydisplay, gc[SPC0 + i], sptm_clip_region);
    for (i=0; i<5; i++)
        XSetRegion(mydisplay, gc[SPT0 + i], sptm_clip_region);
     XSetRegion(mydisplay, gc[CRTP], crit_clip_region);
     XSetRegion(mydisplay, gc[NCRP], crit_clip_region);
     for (i=0; i<total_tasks; i++) *(tsks_prog+i)=0;
     tsks_dim = ceil(sqrt((double)total_tasks));
     psta_dim = ceil(sqrt((double)num_nodes));
     right_scale[UTLG-5] = (windows[UTLG].width-60)/(win_size/scale_width);
     right_scale[TSKG-5] = (windows[TSKG].width-60)/(win_size/scale_width);
     right_scale[CRIT-5] = (windows[CRIT].width-60)/(win_size/scale_width);
     right_scale[SPTM-5] = (windows[SPTM].width-60)/(win_size/scale_width);
     right_scale[NINF-5] = (windows[NINF].width-60)/(win_size/scale_width);
     right_scale[UTLC-5] = (windows[UTLC].width-60)/(win_size/scale_width);
     right_scale[TRAF-5] = (windows[TRAF].width-80)/(win_size/scale_width);
     if (!windows[SCRB].opt1)
	 for(i=TSKG; i<= TRAF; i++)
	     scroll_width[i-5] = win_size / scale_width;
     if(!max_lth) max_lth=1;
     if (min_lth > max_lth) min_lth = max_lth;
     lth_bin[0] = min_lth + (max_lth - min_lth) / 5; 
     lth_bin[1] = min_lth + 2 * (max_lth - min_lth) / 5;
     lth_bin[2] = min_lth + 3 * (max_lth - min_lth) / 5;
     lth_bin[3] = min_lth + 4 * (max_lth - min_lth) / 5;
     if(!max_count)max_count=1;
     max_load_count = max_count;
     max_load_vol = max_vol;
     for (i=0; i<num_nodes; i++) {
	 if (max_load_count_node<max_count_node[i])
	     max_load_count_node = max_count_node[i];
	 if (max_load_vol_node<max_vol_node[i])
	     max_load_vol_node = max_vol_node[i];
     }
     psta_lth_bin[0] = min_lth + (max_load_vol_node - min_lth) / 5;
     psta_lth_bin[1] = min_lth + 2 * (max_load_vol_node - min_lth) / 5;
     psta_lth_bin[2] = min_lth + 3 * (max_load_vol_node - min_lth) / 5;
     psta_lth_bin[3] = min_lth + 4 * (max_load_vol_node - min_lth) / 5;
     if (windows[SIZB].opt1 == 0)
	 comm_max_load = max_count;
     else comm_max_load = max_vol;
     if(comm_max_load==0) comm_max_load=1;
     if (windows[MTRB].opt1 == 0)
	 meter_max_load = max_count;
     else meter_max_load = max_vol;
     if(!meter_max_load) meter_max_load=1;
     if (windows[MESB].opt1 == 0)
	 queu_max_load = max_load_count_node;
     else queu_max_load = max_load_vol_node;
     if(!queu_max_load) queu_max_load=1;
     firstline = 1;
}
