.TH ParaGraph L "8 June 1994"
.UC 4
.SH NAME
ParaGraph - performance visualization of parallel programs
.SH SYNOPSIS
PG [-c | -g | -m] [-d hostname:0.0] [-e envfile] [-f tracefile] [-l layoutfile] [-n windowname] [-o orderfile] [-r rgbfile]
.SH DESCRIPTION
ParaGraph is a graphical display system for visualizing the behavior
and performance of parallel programs on message-passing parallel
computers.  It takes as input execution trace data provided by PICL
(Portable Instrumented Communication Library), developed at Oak Ridge
National Laboratory and available from netlib.  PICL optionally
produces an execution trace during an actual run of a parallel program
on a message-passing machine, and the resulting trace data can then be
replayed pictorially with ParaGraph to display a dynamic, graphical
depiction of the behavior of the parallel program.  ParaGraph provides
several distinct visual perspectives from which to view processor
utilization, communication traffic, and other performance data in an
attempt to gain insights that might be missed by any single view.
.PP
ParaGraph is based on the X Window System and runs on a wide variety of
graphical workstations.  It uses no X toolkit and requires only Xlib.
Although ParaGraph is most effective in color, it also works on
monochrome and grayscale monitors.  It has a graphical, menu-oriented
user interface that accepts user input via mouse clicks and
keystrokes.  The execution of ParaGraph is event driven, including both
user-generated X Window events and trace events in the input data file
provided by PICL.  Thus, ParaGraph displays a dynamic depiction of the
parallel program while also providing responsive interaction with the
user.  Menu selections determine the execution behavior of ParaGraph
both statically (e.g., initial selection of parameter values) and
dynamically (e.g., pause/resume, single-step mode).  ParaGraph
preprocesses the input tracefile to determine relevant parameters
(e.g., time scale, number of processors) automatically before the
graphical simulation begins, but these values can be overridden by the
user, if desired.
.PP
ParaGraph currently provides about 25 different displays or views, all
based on the same underlying trace data, but each giving a distinct
perspective.  Some of these displays change dynamically in place, with
execution time in the original run represented by simulation time in
the replay.  Other displays represent execution time in the original
run by one space dimension on the screen.  The latter displays scroll
as necessary (by a user-controllable amount) as visual simulation time
progresses.  The user can view as many of the displays simultaneously
as will fit on the screen, and all visible windows are updated
appropriately as the tracefile is read.  The displays can be resized
within reasonable bounds.  Most of the displays depict up to 512
processors in the current implementation, although a few are limited to
128 processors and one is limited to 16.
.PP
ParaGraph is extensible so that users can add new displays of their own
design that can be viewed along with those views already provided.
This capability is intended primarily to support application-specific
displays that augment the insight that can be gained from the generic
views provided by ParaGraph.  Sample application-specific displays are
supplied with the source code.  If no user-supplied display is desired,
then dummy "stub" routines are linked with ParaGraph instead.
.PP
The ParaGraph source code comes with several sample tracefiles for
use in demonstrating the package and verifying its correct installation.
To create your own tracefiles for viewing with ParaGraph, you will need
PICL, which is also available from netlib.  The tracing option of PICL
produces a tracefile with records in node order.  For graphical
animation with ParaGraph, the tracefile needs to be sorted into time
order, which can be accomplished with the Unix sort command:
.sp
% sort +1n -2 +2n -3 +0n -1 tracefile.raw > tracefile.trf
.PP
When using PICL to produce tracefiles for viewing with ParaGraph, set
tracelevel(1,1,0) to produce the trace events required by ParaGraph.
You may also want to define tasks using the traceblockbegin and
traceblockend commands of PICL to delimit sections of code and assign
them task numbers to be depicted by ParaGraph in some of its displays
as an aid in correlating the visual simulation with your parallel
program.  ParaGraph does not depict a "host" processor graphically and
ignores all trace events involving the host, so tracing on the host is
not encouraged when the tracefile is to be viewed using ParaGraph.
.SH OPTIONS
The following command-line options are supported by ParaGraph.
.br
-c	to force color display mode.
.br
-d	to specify a hostname and screen (e.g., hostname:0.0)
.br
	for remote display across a network.
.br
-e	to specify an environment file (default: .pgrc).
.br
-f	(or no switch) to specify a tracefile directory path or filename.
.br
-g	to force grayscale display mode.
.br
-l	to specify an animation layout file (default: .pganim).
.br
-m	to force monochrome display mode.
.br
-n	to specify a name for the base window (default: ParaGraph).
.br
-o	to specify an order file (default: .pgorder).
.br
-r	to specify a file containing RGB values of task colors
.br
	(default: .pgcolors).
.sp
By default, ParaGraph automatically detects the appropriate display
mode (color, grayscale, or monochrome), but a particular display mode
can be forced, if desired, by the corresponding command-line option.
This facility is useful, for example, in making black-and-white
hardcopies from a color monitor.
.SH FILES
The following environment files can optionally be supplied by the user
to customize ParaGraph's appearance and behavior.  The default
filenames given below can be changed by the appropriate command-line
options.
.br
 .pgrc\0\0\0\0\0	defines the initial state of ParaGraph upon
 \0\0\0\0\0\0\0\0\0\0	invocation, including which menus and
 \0\0\0\0\0\0\0\0\0\0	displays are open and various options.
.br
 .pgorder\0\0\0\0	defines an optional order or alternative
 \0\0\0\0\0\0\0\0\0\0	names for the processors.
.br
 .pgcolors\0	defines the color scheme to be used for
 \0\0\0\0\0\0\0\0\0\0	identifying tasks.
.br
 .pganim\0\0\0\0\0	defines an animation layout file.
.PP
The following files are provided in the ParaGraph distribution from netlib.
.br
 *.c\0\0\0\0\0\0	several C source files.
.br
 *.h\0\0\0\0\0\0	several include files.
.br
 Makefile.*	sample makefiles for several machine
 \0\0\0\0\0\0\0\0\0\0	configurations, which should be modified to
 \0\0\0\0\0\0\0\0\0\0	incorporate the local location for Xlib, etc.
.br
 manual.tex	a user guide in Latex format.
.br
 pg.man\0\0\0	a Unix man page.
.br
 tracefiles	a directory containing several sample
 \0\0\0\0\0\0\0\0\0\0	tracefiles.
.br
 u_*\0\0\0\0\0\0	several directories containing example
 \0\0\0\0\0\0\0\0\0\0	application-specific displays.
.SH SEE ALSO
A machine-readable manual for ParaGraph, in Latex format, is provided
along with the source code from netlib.  Additional information is
contained in the article "Visualizing Performance of Parallel Programs"
in the September 1991 issue of IEEE Software, pages 29-39, and in the
technical report ORNL/TM-11813.  Documentation for PICL is available
from netlib and in the technical reports ORNL/TM-11130, ORNL/TM-11616,
and ORNL/TM-12125.
.SH BUGS
Some of the displays are not repaired when re-exposed after having been
partially obscured.  Changing parameters dynamically while the visual
animation is active may give erratic results.  The apparent speed of
visual animation is determined primarily by the drawing speed of the
workstation and is not necessarily uniformly proportional to the
original execution speed of the parallel program.
.SH AUTHORS
Michael T. Heath and Jennifer E. Finger
