#include <stdio.h>
#include <math.h>
#include <sys/types.h>
#include <sys/stat.h>
#include <X11/Xlib.h>
#include <X11/Xutil.h>
#include <X11/Xatom.h>
#include <dirent.h>
#include <unistd.h>
#include "defines.h"

struct win_info {
  Window window;
  int width;
  int height;
  int x;
  int y;
  int opt1;
  int opt2;
};

extern Display *mydisplay;
extern struct win_info windows[];
extern GC gc[];
extern Font font1, font2;
extern XSizeHints windowhints[];
extern XEvent myevent;
extern FILE *envptr, *tfptr, *recptr[18];
extern char rec_filename[], dump_command1[], dump_command2[], print_command[],
	    pat_str[], dir_str[], dname[], envname[], filename[];
extern int prev_count,util_count,order[], k_init[], **cum_vol, win_edge[],
           left_scale[], right_scale[], scale_width, scroll_width[], prev_ptr[],
           prev_draw[], state[], anim_state[], cur_time, stop_time, prev_time, 
	   dest, num_nodes, max_load_count_node, max_load_vol_node, comm_count,
	   queu_max_load, comm_vol, max_load_count, max_load_vol, max_count, 
	   max_vol, comm_max_load,go_flag, u_win, vol_bin[6], queu_vol[MAXP], 
	   which_map, queu_count[MAXP], **msg_count, node, paired_comp[], skip, 
	   prev_place, util_diff_count, spin, sum_ovhd[], sum_busy[], 
	   start_ovhd[], exit_count, pct_busy[], max_time, pct_ovhd[], 
	   start_busy[], **task, phpt_first_point, *task_counter, *start_task, 
	   *task_time, kx[MAXP], ky[MAXP],*task_count, total_tasks, 
	   *tsks_prog, max_sent[], max_rcvd[], msg_sent[], msg_rcvd[],
	   meter_max_load, max_queu_count[], max_queu_vol[], first_util, 
	   first_comm, cum_util, cum_comm, is_ord, prev_comm_count, 
	   max_prof_count, count_idle[], count_ovhd[], count_busy[], 
	   crit_count, max_node, paused, send_vol[], send_count[], step_inc, 
	   ****sendpoint, crit_node_count, phpt_height, phpt_width, anim_x[], 
	   quest_key_input, anim_y[], first_trace_exit, proc_width, 
	   proc_height, pct_busy_sum[], pct_ovhd_sum[], prev_diff_count, 
	   end_of_file, info_line, num_info_lines, crit_node[], num_mesh_dim, 
	   poss_mesh_dim[], key_index, anim_xl[], anim_yl[], num_wds, anim_rad,
	   anim_center_x, anim_center_y, win_size, opencount, hype_num_nodes, 
	   user_order[], ntwk_nodes, no_files, ntwk_stages, ***ntwk_load, 
	   max_hops, sliderwidth, **node_stage, **ns_inv, true_num_nodes, 
	   net_op_change, ***ntwk_total, start_idle[], k_center_x, k_center_y, 
	   max_queue_count[MAXP][MAXP], first_button, prev_state[], min_sent[],
	   min_rcvd[], close_count, first_file, flbr_width, max_dist, anim_read; 

extern MMT_STRUCT dist[], tmes[], tran[];
extern BOD_STRUCT cur_streak[], max_streak[];

int begin_of_file, task_ptr[MAXP], pct_idle[MAXP], trace_place, first_draw, 
    first_not_draw, last_queue_count[MAXP], lastf, streak_last_top[MAXP], 
    longf, streak_last_bottom[MAXP], moving;

extern char *getenv(), files[100][90], stop_str[], displayname[], wrd[5][50], 
	    number[MAXP][4];
char linestr[MAXLINE]; 
extern float user_anim_x[], user_anim_y[];
float node_util[MAXP];

extern float current_util_pct[];
struct ns_pt {
        int n;
        int s;
};

extern struct ns_pt *pt_array;

int alphasort();

/* function invoked by button press events */

button(which)
    int which;
{
    int ginv(), rotate(), direction, i, j, k, ibuf, jbuf;
    char line[100], file_buf[256], command[75], buf[10], cbuf[256];
    struct stat sbuf;
    DIR *dirp;
    struct dirent *dp;
    double log_two();
	
    if (first_button){
      first_button=0;
      for(i=ANIM; i<=MENU; i++){
        windowhints[i].flags = PPosition | PSize;
        XSetNormalHints(mydisplay, windows[i].window, &windowhints[i]);
      }
    }

    if(myevent.xbutton.button==Button1) direction=0;
    else direction=1;

    switch (which) {

    case CRTB:
	/* caution: offset of 37 is dependent on order in defines.h */
	if (windows[which - 37].opt1) {
	    XUnmapWindow(mydisplay, windows[which - 37].window);
	    windows[which - 37].opt1 = 0;
	    opencount--;
	    expose(CLOB);
	    expose(which);
	} else {
	    XMapWindow(mydisplay, windows[which - 37].window);
	    XMapSubwindows(mydisplay, windows[which - 37].window);
	    windows[which - 37].opt1 = 1;
	    opencount++;
	    expose(CLOB);
	    expose(which);
	    if (tfptr!=NULL) backwards();
	}
	break;

    case STTB:
	/* caution: offset of 37 is dependent on order in defines.h */
	if (windows[which - 37].opt1) {
	    XUnmapWindow(mydisplay, windows[which - 37].window);
	    windows[which - 37].opt1 = 0;
	    opencount--;
	    expose(CLOB);
	    expose(which);
	} else {
	    XMapWindow(mydisplay, windows[which - 37].window);
	    if(num_nodes>8)
	    XMapSubwindows(mydisplay, windows[which - 37].window);
	    windows[which - 37].opt1 = 1;
	    opencount++;
	    expose(CLOB);
	    expose(which);
	    if (tfptr!=NULL) backwards();
	}
	break;

    /* buttons on the menu for displays with buttons */
    case UTGB:
    case UTCB:
    case CLKB:
    case STKB:
    case TRCB:
    case UTSB:
    case UTMB:
    case PHPB:
    case INFB:
    case HYPB:
    case KIVB:
    case MTXB:
    case STMB:
    case TSMB:
    case TSGB:
    case FBRB:
    case QUEB:
    case TSCB:
    case TRFB:
    case PSTB:
    case NIFB:
    case ROPB:
    case CMNB:
    case CMMB:
    case TMNB:
    case UMNB:
    case OMNB:
    case TSTB:
    case PRFB:
    case LGNB:
    case SLDB:
	if (windows[which - 37].opt1){
	    XUnmapWindow(mydisplay, windows[which - 37].window);
	    windows[which - 37].opt1 = 0;
	    opencount--;
	    expose(CLOB);
	    expose(which);
	} else {
	    XMapWindow(mydisplay, windows[which - 37].window);
	    XMapSubwindows(mydisplay, windows[which - 37].window);
	    windows[which - 37].opt1 = 1;
	    opencount++;
	    expose(CLOB);
	    expose(which);
	}
	break;

    case OPTB:
	if (windows[which - 37].opt1){
	    XUnmapWindow(mydisplay, windows[which - 37].window);
	    windows[which - 37].opt1 = 0;
	    opencount--;
	    expose(CLOB);
	    expose(which);
	} else {
	    XMapWindow(mydisplay, windows[which - 37].window);
	    XMapSubwindows(mydisplay, windows[which - 37].window);
            if(windows[DSTB].opt1!=1 && windows[DSTB].opt1!=2){
              XUnmapWindow(mydisplay, windows[DIMB].window);
              XUnmapWindow(mydisplay, windows[COLB].window);
              XResizeWindow(mydisplay, windows[DSTB].window, 266, 21);
            }else XResizeWindow(mydisplay, windows[DSTB].window, 152, 21);
	    windows[which - 37].opt1 = 1;
	    opencount++;
	    expose(CLOB);
	    expose(which);
	}
	break;
    case USRB:
	    expose(which);
	break;
    case NTWB:
	if (windows[which - 37].opt1){
	    XUnmapWindow(mydisplay, windows[which - 37].window);
	    windows[which - 37].opt1 = 0;
	    opencount--;
	    expose(CLOB);
	    expose(which);
	} else {
	    XMapWindow(mydisplay, windows[which - 37].window);
	    switch(windows[NTYB].opt1){
	     case NTWK_MESH:
	      XMapSubwindows(mydisplay, windows[which - 37].window);
	     break;

	     case CROSSBAR:
	     case BINARY_TREE:
	     case QUADTREE:
	       XMapWindow(mydisplay, windows[NTYB].window);
	     break;

	     default:
	       XMapWindow(mydisplay, windows[NTYB].window);
	       XMapWindow(mydisplay, windows[SHNB].window);
	       XMapWindow(mydisplay, windows[NOPB].window);
	     break;
	    }
	    windows[which - 37].opt1 = 1;
	    opencount++;
	    expose(CLOB);
	    expose(which);
	}
	break;

    case ANMB:
	if (windows[which - 37].opt1){
	    XUnmapWindow(mydisplay, windows[which - 37].window);
	    windows[which - 37].opt1 = 0;
	    opencount--;
	    expose(CLOB);
	    expose(which);
	} else {
	    XMapWindow(mydisplay, windows[which - 37].window);
            if(windows[ATYB].opt1==1){
              XMapWindow(mydisplay, windows[MORB].window);
              XMapWindow(mydisplay, windows[MTYB].window);
            }
            if(windows[ATYB].opt1==2){
              XMapWindow(mydisplay, windows[ASVB].window);
              XMapWindow(mydisplay, windows[ARDB].window);
            }
            XMapWindow(mydisplay, windows[ATYB].window);
	    windows[which - 37].opt1 = 1;
	    opencount++;
	    expose(CLOB);
	    expose(which);
	}
	break;

    case ANIR:
	if(windows[ANIR].opt1){
	  windows[ANIR].opt1=0;
	  fclose(recptr[ANIM]);
	} else{
	  windows[ANIR].opt1=1;
	  sprintf(file_buf, "%s.anim", rec_filename);
	  if((recptr[ANIM] = fopen(file_buf, "w")) == NULL){
	    printf("can not open %s for writing\n", file_buf);
	    windows[ANIR].opt1=0;
	  }else{
	    fprintf(recptr[ANIM], "time node state [sender/receiver]\n");
	  }
	}
	expose(ANIR);
	break;

    case HYPR:
	if(windows[HYPR].opt1){
	  windows[HYPR].opt1=0;
	  fclose(recptr[HYPE]);
	} else{
	  windows[HYPR].opt1=1;
	  sprintf(file_buf, "%s.hype", rec_filename);
	  if((recptr[HYPE] = fopen(file_buf, "w")) == NULL){
	    printf("can not open %s for writing\n", file_buf);
	    windows[HYPR].opt1=0;
	  }else{
	    fprintf(recptr[HYPE], "time node state [sender/receiver]\n");
	  }
	}
	expose(HYPR);
	break;

    case NTWR:
	if(windows[NTWR].opt1){
	  windows[NTWR].opt1=0;
	  fclose(recptr[NTWK]);
	} else{
	  windows[NTWR].opt1=1;
	  sprintf(file_buf, "%s.ntwk", rec_filename);
	  if((recptr[NTWK] = fopen(file_buf, "w")) == NULL){
	    printf("can not open %s for writing\n", file_buf);
	    windows[NTWR].opt1=0;
	  }else{
	    fprintf(recptr[NTWK], "time node state [sender/receiver]\n");
	  }
	}
	expose(NTWR);
	break;

    case MTRR:
	if(windows[MTRR].opt1){
	  windows[MTRR].opt1=0;
	  fclose(recptr[MTRX]);
	} else{
	  windows[MTRR].opt1=1;
	  sprintf(file_buf, "%s.mtrx", rec_filename);
	  if((recptr[MTRX] = fopen(file_buf, "w")) == NULL){
	    printf("can not open %s for writing\n", file_buf);
	    windows[MTRR].opt1=0;
	  }else{
	    fprintf(recptr[MTRX], 
	      "time node to/from sender/receiver lth type dist\n");
	  }
	}
	expose(MTRR);
	break;

    case TSSR:
	if(windows[TSSR].opt1){
	  windows[TSSR].opt1=0;
	  fclose(recptr[TSKS]);
	} else{
	  windows[TSSR].opt1=1;
	  sprintf(file_buf, "%s.tsks", rec_filename);
	  if((recptr[TSKS] = fopen(file_buf, "w")) == NULL){
	    printf("can not open %s for writing\n", file_buf);
	    windows[TSSR].opt1=0;
	  }else{
	    fprintf(recptr[TSKS], "time task status\n");
	  }
	}
	expose(TSSR);
	break;

    case TSGR:
	if(windows[TSGR].opt1){
	  windows[TSGR].opt1=0;
	  fclose(recptr[TSKG]);
	} else{
	  windows[TSGR].opt1=1;
	  sprintf(file_buf, "%s.tskg", rec_filename);
	  if((recptr[TSKG] = fopen(file_buf, "w")) == NULL){
	    printf("can not open %s for writing\n", file_buf);
	    windows[TSGR].opt1=0;
	  }else{
	    fprintf(recptr[TSKG], "time node task\n");
	  }
	}
	expose(TSGR);
	break;

    case SPTR:
	if(windows[SPTR].opt1){
	  windows[SPTR].opt1=0;
	  fclose(recptr[SPTM]);
	} else{
	  windows[SPTR].opt1=1;
	  sprintf(file_buf, "%s.sptm", rec_filename);
	  if((recptr[SPTM] = fopen(file_buf, "w")) == NULL){
	    printf("can not open %s for writing\n", file_buf);
	    windows[SPTR].opt1=0;
	  }else{
	    fprintf(recptr[SPTM], 
	      "time node state [to/from sender/receiver lth type dist]\n");
	  }
	}
	expose(SPTR);
	break;

    case CRIR:
	if(windows[CRIR].opt1){
	  windows[CRIR].opt1=0;
	  fclose(recptr[CRIT]);
	} else{
	  windows[CRIR].opt1=1;
	  sprintf(file_buf, "%s.crit", rec_filename);
	  if((recptr[CRIT] = fopen(file_buf, "w")) == NULL){
	    printf("can not open %s for writing\n", file_buf);
	    windows[CRIR].opt1=0;
	  }else{
	    fprintf(recptr[CRIT], "time critical_node\n");
	    fprintf(recptr[CRIT], " 0 %d\n", crit_node[crit_count]);
	  }
	}
	expose(CRIR);
	break;

    case UTGR:
	if(windows[UTGR].opt1){
	  windows[UTGR].opt1=0;
	  fclose(recptr[UTLG]);
	} else{
	  windows[UTGR].opt1=1;
	  sprintf(file_buf, "%s.utlg", rec_filename);
	  if((recptr[UTLG] = fopen(file_buf, "w")) == NULL){
	    printf("can not open %s for writing\n", file_buf);
	    windows[UTGR].opt1=0;
	  }else{
	    fprintf(recptr[UTLG], "time node state\n");
	  }
	}
	expose(UTGR);
	break;

    case UTCR:
	if(windows[UTCR].opt1){
	  windows[UTCR].opt1=0;
	  fclose(recptr[UTLC]);
	} else{
	  windows[UTCR].opt1=1;
	  sprintf(file_buf, "%s.utlc", rec_filename);
	  if((recptr[UTLC] = fopen(file_buf, "w")) == NULL){
	    printf("can not open %s for writing\n", file_buf);
	    windows[UTCR].opt1=0;
	  }else{
	    fprintf(recptr[UTLC], "time #busy #idle #ovhd\n");
	  }
	}
	expose(UTCR);
	break;

    case NINR:
	if(windows[NINR].opt1){
	  windows[NINR].opt1=0;
	  fclose(recptr[NINF]);
	} else{
	  windows[NINR].opt1=1;
	  sprintf(file_buf, "%s.ninf", rec_filename);
	  if((recptr[NINF] = fopen(file_buf, "w")) == NULL){
	    printf("can not open %s for writing\n", file_buf);
	    windows[NINR].opt1=0;
	  }else{
	    fprintf(recptr[NINF],
	      "time node to/from sender/receiver lth type dist\n");
	  }
	}
	expose(NINR);
	break;

    case TRAR:
	if(windows[TRAR].opt1){
	  windows[TRAR].opt1=0;
	  fclose(recptr[TRAF]);
	} else{
	  windows[TRAR].opt1=1;
	  sprintf(file_buf, "%s.traf", rec_filename);
	  if((recptr[TRAF] = fopen(file_buf, "w")) == NULL){
	    printf("can not open %s for writing\n", file_buf);
	    windows[TRAR].opt1=0;
	  }else{
	    fprintf(recptr[TRAF], "time msg_count msg_vol\n");
	  }
	}
	expose(TRAR);
	break;

    case PSTR:
	if(windows[PSTR].opt1){
	  windows[PSTR].opt1=0;
	  fclose(recptr[PSTA]);
	} else{
	  windows[PSTR].opt1=1;
	  sprintf(file_buf, "%s.psta", rec_filename);
	  if((recptr[PSTA] = fopen(file_buf, "w")) == NULL){
	    printf("can not open %s for writing\n", file_buf);
	    windows[PSTR].opt1=0;
	  }else{
	    fprintf(recptr[PSTA], "time node [task] status [receiver/sender lth type dist]\n");
	  }
	}
	expose(PSTR);
	break;

    case QUER:
	if(windows[QUER].opt1){
	  windows[QUER].opt1=0;
	  fclose(recptr[QUEU]);
	} else{
	  windows[QUER].opt1=1;
	  sprintf(file_buf, "%s.queu", rec_filename);
	  if((recptr[QUEU] = fopen(file_buf, "w")) == NULL){
	    printf("can not open %s for writing\n", file_buf);
	    windows[QUER].opt1=0;
	  }else{
	    fprintf(recptr[QUEU], "time node msg_count msg_vol\n");
	  }
	}
	expose(QUER);
	break;

    case TSCR:
	if(windows[TSCR].opt1){
	  windows[TSCR].opt1=0;
	  fclose(recptr[TSKC]);
	} else{
	  windows[TSCR].opt1=1;
	  sprintf(file_buf, "%s.tskc", rec_filename);
	  if((recptr[TSKC] = fopen(file_buf, "w")) == NULL){
	    printf("can not open %s for writing\n", file_buf);
	    windows[TSCR].opt1=0;
	  }else{
	    fprintf(recptr[TSKC], "time task #nodes\n");
	  }
	}
	expose(TSCR);
	break;

    case UTSR:
	if(windows[UTSR].opt1){
	  windows[UTSR].opt1=0;
	  fclose(recptr[UTLS]);
	} else{
	  windows[UTSR].opt1=1;
	  sprintf(file_buf, "%s.utls", rec_filename);
	  if((recptr[UTLS] = fopen(file_buf, "w")) == NULL){
	    printf("can not open %s for writing\n", file_buf);
	    windows[UTSR].opt1=0;
	  }else{
	    fprintf(recptr[UTLS], "time node %%busy %%ovhd %%idle\n");
	  }
	}
	expose(UTSR);
	break;

    case PHPR:
	if(windows[PHPR].opt1){
	  windows[PHPR].opt1=0;
	  fclose(recptr[PHPT]);
	} else{
	  windows[PHPR].opt1=1;
	  sprintf(file_buf, "%s.phpt", rec_filename);
	  if((recptr[PHPT] = fopen(file_buf, "w")) == NULL){
	    printf("can not open %s for writing\n", file_buf);
	    windows[PHPR].opt1=0;
	  }else{
	    fprintf(recptr[PHPT], "time %%util %%comm\n");
	  }
	}
	expose(PHPR);
	break;

    case KIVR:
	if(windows[KIVR].opt1){
	  windows[KIVR].opt1=0;
	  fclose(recptr[KIVT]);
	} else{
	  windows[KIVR].opt1=1;
	  sprintf(file_buf, "%s.kivt", rec_filename);
	  if((recptr[KIVT] = fopen(file_buf, "w")) == NULL){
	    printf("can not open %s for writing\n", file_buf);
	    windows[KIVR].opt1=0;
	  }else{
	    fprintf(recptr[KIVT], "time node %%busy\n");
	  }
	}
	expose(KIVR);
	break;

    case ASVB:
	if(anim_read!=2){
	  XMapWindow(mydisplay, windows[ANFL].window);
	  anim_read=1;
	}
	XFillRectangle(mydisplay, windows[ASVB].window, gc[ERAS], 0, 0, 90, 16);
	XDrawImageString(mydisplay, windows[ASVB].window, gc[MENU], 3, 13,
	   "WRITE FILE", 10);
	break;

    case ARDB:
	if(anim_read!=1){
	  XMapWindow(mydisplay, windows[ANFL].window);
	  anim_read=2;
	}
	XFillRectangle(mydisplay, windows[ARDB].window, gc[ERAS], 0, 0, 90, 16);
	XDrawImageString(mydisplay, windows[ARDB].window, gc[MENU], 3, 13,
	   "READ FILE", 9);
	break;

    case YESB:
	XUnmapWindow(mydisplay, windows[QEST].window);
	if((envptr=fopen(".pgrc", "w"))==NULL)
	  printf("Sorry, can not open file .pgrc for writing.\n");
	else{
          write_file();
	}
	XFillRectangle(mydisplay, windows[ENVB].window, gc[ERAS], 0, 0, 90, 16);
	XDrawImageString(mydisplay, windows[ENVB].window, gc[MENU], 21, 10,
	   "Save Env", strlen("Save Env"));
	break;

    case STAB:
           windows[STAB].opt1=(myevent.xbutton.x*num_nodes)/132;
           if(windows[STAB].opt1>num_nodes-8) windows[STAB].opt1=num_nodes-8;
	   expose(STAB);
	   expose(STTS);
	break;
    case SLID:
	if(myevent.xbutton.x>6&&myevent.xbutton.x<6+sliderwidth&&
	   myevent.xbutton.y>6&&myevent.xbutton.y<26){
	     windows[SLID].opt1=myevent.xbutton.x-6;
	     expose(SLID);
	   }
	break;
    case NMOB:
	windows[NMOB].opt1=rotate(windows[NMOB].opt1, 2, direction);
        for(j=0; j<ntwk_stages; j++){
          for(i=0; i<ntwk_nodes; i++){
	    free(ntwk_load[j][i]);
	    free(ntwk_total[j][i]);
	  }
	  free(ntwk_load[j]);
	  free(ntwk_total[j]);
	}
        free(ntwk_load);
        free(ntwk_total);
	if(ntwk_stages!=0){
        for(j=0; j<ntwk_nodes; j++){
	    free(node_stage[j]);
	    free(ns_inv[j]);
	  }
	free(node_stage);
	free(ns_inv);
	}
	ntwk_stages=0;
        ntwk_nodes=num_nodes;
        ms_net(windows[NTYB].opt1, &ntwk_nodes, &ntwk_stages);
        if ((ntwk_load = (int ***)malloc(ntwk_stages*sizeof(int **))) == NULL){
          printf("memory allocation failed: %d bytes requested \n",
                    ntwk_stages*sizeof(int));
            exit(1);
        }
        for(i=0; i<ntwk_stages; i++){
          if ((ntwk_load[i] = (int **)malloc(ntwk_nodes*sizeof(int *)))== NULL){
          printf("memory allocation failed: %d bytes requested \n",
                    ntwk_nodes*sizeof(int));
            exit(1);
          }
          for(j=0; j<ntwk_nodes; j++){
          if ((ntwk_load[i][j] = (int *)malloc(2*sizeof(int))) == NULL){
          printf("memory allocation failed: %d bytes requested \n",
                    2*sizeof(int));
            exit(1);
          }else{
	    ntwk_load[i][j][0]=0;
	    ntwk_load[i][j][1]=0;
	  }
        }
	}
        if ((ntwk_total = (int ***)malloc(ntwk_stages*sizeof(int **))) == NULL){
          printf("memory allocation failed: %d bytes requested \n",
                    ntwk_stages*sizeof(int));
            exit(1);
        }
        for(i=0; i<ntwk_stages; i++){
          if ((ntwk_total[i] = (int **)malloc(ntwk_nodes*sizeof(int *)))==NULL){
          printf("memory allocation failed: %d bytes requested \n",
                    ntwk_nodes*sizeof(int));
            exit(1);
          }
          for(j=0; j<ntwk_nodes; j++){
          if ((ntwk_total[i][j] = (int *)malloc(2*sizeof(int))) == NULL){
          printf("memory allocation failed: %d bytes requested \n",
                    2*sizeof(int));
            exit(1);
          }else{
	    ntwk_total[i][j][0]=0;
	    ntwk_total[i][j][1]=0;
	  }
        }
	}
	expose(NMOB);
	net_op_change=1;
	expose(NTWK);
	break;

    case NMSB:
	windows[NMSB].opt1=rotate(windows[NMSB].opt1, num_mesh_dim, direction);
	windows[NMSB].opt2=poss_mesh_dim[windows[NMSB].opt1];
        for(j=0; j<ntwk_stages; j++){
          for(i=0; i<ntwk_nodes; i++){
	    free(ntwk_load[j][i]);
	    free(ntwk_total[j][i]);
	  }
	  free(ntwk_load[j]);
	  free(ntwk_total[j]);
	}
        free(ntwk_load);
        free(ntwk_total);
        for(j=0; j<ntwk_nodes; j++){
	    free(node_stage[j]);
	    free(ns_inv[j]);
	  }
	free(node_stage);
	free(ns_inv);
	ntwk_stages=0;
        ntwk_nodes=num_nodes;
        ms_net(windows[NTYB].opt1, &ntwk_nodes, &ntwk_stages);
        if ((ntwk_load = (int ***)malloc(ntwk_stages*sizeof(int **))) == NULL){
          printf("memory allocation failed: %d bytes requested \n",
                    ntwk_stages*sizeof(int));
            exit(1);
        }
        for(i=0; i<ntwk_stages; i++){
          if ((ntwk_load[i] = (int **)malloc(ntwk_nodes*sizeof(int *)))== NULL){
          printf("memory allocation failed: %d bytes requested \n",
                    ntwk_nodes*sizeof(int));
            exit(1);
          }
          for(j=0; j<ntwk_nodes; j++){
          if ((ntwk_load[i][j] = (int *)malloc(2*sizeof(int))) == NULL){
          printf("memory allocation failed: %d bytes requested \n",
                    2*sizeof(int));
            exit(1);
          }else{
	    ntwk_load[i][j][0]=0;
	    ntwk_load[i][j][1]=0;
	  }
        }
	}
        if ((ntwk_total = (int ***)malloc(ntwk_stages*sizeof(int **))) == NULL){
          printf("memory allocation failed: %d bytes requested \n",
                    ntwk_stages*sizeof(int));
            exit(1);
        }
        for(i=0; i<ntwk_stages; i++){
          if ((ntwk_total[i] = (int **)malloc(ntwk_nodes*sizeof(int *)))==NULL){
          printf("memory allocation failed: %d bytes requested \n",
                    ntwk_nodes*sizeof(int));
            exit(1);
          }
          for(j=0; j<ntwk_nodes; j++){
          if ((ntwk_total[i][j] = (int *)malloc(2*sizeof(int))) == NULL){
          printf("memory allocation failed: %d bytes requested \n",
                    2*sizeof(int));
            exit(1);
          }else{
	    ntwk_total[i][j][0]=0;
	    ntwk_total[i][j][1]=0;
	  }
        }
	}
	expose(NMSB);
	expose(NTWK);
	break;

    case MORB:
	windows[MORB].opt1=rotate(windows[MORB].opt1, 2, direction);
	expose(MORB);
	expose(ANIM);
	break;

    case MTYB:
	windows[MTYB].opt1=rotate(windows[MTYB].opt1, num_mesh_dim, direction);
	windows[MTYB].opt2=poss_mesh_dim[windows[MTYB].opt1];
	expose(MTYB);
	expose(ANIM);
	break;

    case ATYB:
	windows[ATYB].opt1=rotate(windows[ATYB].opt1, 3, direction);
	switch(windows[ATYB].opt1){
          case 1:	
	    XMapWindow(mydisplay, windows[MTYB].window);
	    XMapWindow(mydisplay, windows[MORB].window);
	    XUnmapWindow(mydisplay, windows[ASVB].window);
	    XUnmapWindow(mydisplay, windows[ARDB].window);
	  break;

          case 0:	
	    XUnmapWindow(mydisplay, windows[MTYB].window);
	    XUnmapWindow(mydisplay, windows[MORB].window);
	    XUnmapWindow(mydisplay, windows[ASVB].window);
	    XUnmapWindow(mydisplay, windows[ARDB].window);
	  break;

          case 2:	
	    XMapWindow(mydisplay, windows[ASVB].window);
	    XMapWindow(mydisplay, windows[ARDB].window);
	    XUnmapWindow(mydisplay, windows[MTYB].window);
	    XUnmapWindow(mydisplay, windows[MORB].window);
            moving = -1;
	  break;
	}
	expose(ATYB);
	expose(ANIM);
	break;

    case QNOB:
	quest_key_input=1;
	XUnmapSubwindows(mydisplay, windows[QEST].window);
	break;

    /* stop on error? */
    case PERR:
	windows[PERR].opt1=rotate(windows[PERR].opt1, 2, direction);

	expose(PERR);
	break;

    /* stop on tracemark/tracemsg? */
    case TSTP:
	windows[TSTP].opt1=rotate(windows[TSTP].opt1, 2, direction);

	expose(TSTP);
	break;

    /* ordering of nodes: natural or gray? */
    case ORDB:
	windows[ORDB].opt1=rotate(windows[ORDB].opt1, (is_ord)?(3):(2), 
	  direction);

	switch (windows[ORDB].opt1) {
	case 0:
	    for (j = 0; j < MAXP; j++)
		order[j] = j;
	    break;
	case 1:
	    if(num_nodes==hype_num_nodes)
	    for (j = 0; j < MAXP; j++)
		order[j] = ginv(j);
	    break;
	case 2:
	    for (j = 0; j < MAXP; j++)
		order[j] = user_order[j];
	    break;
	}
	expose(ORDB);
	if (num_nodes<=16) hype_setup();
	for (j = ANIM; j <= CMMT; j++)
	    if (windows[j].opt1)
		expose(j);
	if (u_win>0)
		u_reset();
	break;

    case FLBR:
	if(myevent.xbutton.y>88){
          if((ibuf=flbr_width/(longf*6+8))==0) ibuf=1;;
          jbuf=(int)ceil(((double)no_files)/((double)ibuf));  
	  if(windows[FLBR].opt2!=-1)
          XDrawImageString(mydisplay, windows[FLBR].window,gc[MENU],
            4+(windows[FLBR].opt2/jbuf)*(longf*6+8), 101+
	    (windows[FLBR].opt2% jbuf)*18, files[windows[FLBR].opt2],
            strlen(files[windows[FLBR].opt2]));
          XClearArea(mydisplay, windows[TFIL].window, 66, 0, 250, 30, False);
          XClearArea(mydisplay, windows[TFIL].window, 0, 18, 250, 45, False);
          XDrawImageString(mydisplay, windows[TFIL].window,
              gc[MENU], 66, 14, dname, strlen(dname));
          windows[FLBR].opt2=(myevent.xbutton.x/(longf*6+8))*jbuf+
	    (myevent.xbutton.y-88)/18;
	  sprintf(filename, "%s/%s", dname, files[windows[FLBR].opt2]);  
          XDrawImageString(mydisplay, windows[FLBR].window,gc[ERAS],
            4+(windows[FLBR].opt2/jbuf)*(longf*6+8), 101+
	    (windows[FLBR].opt2%jbuf)*18, files[windows[FLBR].opt2],
            strlen(files[windows[FLBR].opt2]));
	sprintf(cbuf, "%s/%s", dname, files[windows[FLBR].opt2]);
	stat(cbuf, &sbuf);
	if((sbuf.st_mode & S_IFMT) ==S_IFREG){
	  if(tfptr!=NULL) fclose(tfptr);
          if ((tfptr = fopen(filename, "r")) == NULL) {
            XClearArea(mydisplay, windows[TFIL].window, 66, 0, 250, 30, False);
            XClearArea(mydisplay, windows[TFIL].window, 0, 18, 250, 45, False);
            XDrawImageString(mydisplay, windows[TFIL].window,
                gc[MENU], 66, 14, "Can't open file", 15);
          } else {
            if(!first_file){
              for(j=0; j<ntwk_stages; j++){
                  for(i=0; i<ntwk_nodes; i++){
                    free(ntwk_load[j][i]);
                    free(ntwk_total[j][i]);
		  }
                  free(ntwk_load[j]);
                  free(ntwk_total[j]);
              }
              for(i=0; i<ntwk_nodes; i++){
                  free(node_stage[i]);
                  free(ns_inv[i]);
              }
              free(node_stage);
              free(ns_inv);
              free(ntwk_load);
              free(ntwk_total);
              free(pt_array);
              for(i=0; i<num_nodes; i++){
                free(task[i]);
                free(msg_count[i]);
                free(cum_vol[i]);
                for(j=0; j<num_nodes; j++){
                  for(k=0; k<max_queue_count[i][j]+1; k++)
		    free(sendpoint[i][j][k]);
                  free(sendpoint[i][j]);
                }
                free(sendpoint[i]);
	      }
              free(msg_count);
              free(cum_vol);
              free(task);
              free(sendpoint);
              free(tsks_prog);
              free(task_counter);
              free(task_count);
              free(start_task);
              free(task_time);
            }
            first_file=0;
            if(fgets(line, MAXLINE, tfptr)!=NULL){
              if(!isdigit(line[0])&&strncmp(line,"-",1)!=0){
                XClearArea(mydisplay, windows[TFIL].window, 66, 0, 250, 30, 
		  False);
                XClearArea(mydisplay, windows[TFIL].window, 0, 18, 250, 45, 
		  False);
                XDrawImageString(mydisplay, windows[TFIL].window,
                    gc[MENU], 66, 14, "Not a tracefile", 15);
                XDrawImageString(mydisplay, windows[FLBR].window,gc[MENU],
                  4+(windows[FLBR].opt2/jbuf)*(longf*6+8), 101+
		  (windows[FLBR].opt2%jbuf)*18, files[windows[FLBR].opt2], 
		  strlen(files[windows[FLBR].opt2]));
                for (j = 0; j < 256; j++) {
                    dir_str[j] = NULL;
                }
                fclose(tfptr);
                for(i=0; i<256; i++)
                  filename[i]=NULL;
                windows[FLBR].opt2= -1;
		first_file=1;
                return;
              }else{
                rewind(tfptr);
                preprocess();
              }
            }
            if(windows[CRIT].opt1) backwards();
            XResizeWindow(mydisplay, windows[TSKC].window, windows[TSKC].width,
                windows[TSKC].height);
            XResizeWindow(mydisplay, windows[PROF].window, windows[PROF].width,
                windows[PROF].height);
            XMoveWindow(mydisplay, windows[CPFB].window, (windows[PROF].width-
		60)/2+75, windows[PROF].height-19);
            XResizeWindow(mydisplay, windows[TSMY].window, windows[TSMY].width,
                windows[TSMY].height);
            if(num_nodes>8){
	      XResizeWindow(mydisplay, windows[STTS].window, 
		windowhints[STTS].width, windowhints[STTS].height);
	      XMapSubwindows(mydisplay, windows[STTS].window);
	    } else XUnmapSubwindows(mydisplay, windows[STTS].window);
            u_reinit();
            reset();
            if (windows[MTRX].opt1)
                for(i=LGND; i<= LGN3; i++)
                    expose(i);
            expose(SCLB);
            if (windows[SOPT].opt1) {
                expose(STOP);
                expose(STAR);
                expose(STMU);
                expose(TRCT);
                expose(TRCN);
		expose(DIMB);
            }
            for(i=ANIM; i<=TRAC; i++)
                if (windows[i].opt1)
                    expose(i);
            }
	    if(windows[TRAF].opt1) expose(TRNB);
	    if(windows[NINF].opt1) expose(SNDB);
	  }else if((sbuf.st_mode & S_IFMT) ==S_IFDIR){
	    sprintf(cbuf, "%s/%s", dname, files[windows[FLBR].opt2]);
            if ((dirp = opendir(cbuf)) == NULL) {
           /*     XClearArea(mydisplay, windows[TFIL].window, 66, 0, 250, 30, 
		    False);
                XClearArea(mydisplay, windows[TFIL].window, 0, 18, 250, 45, 
			 False);
                XDrawImageString(mydisplay, windows[TFIL].window,
                    gc[MENU], 66, 14, "Can't access directory", 22);
                for (j = 0; j < 256; j++) {
                    dir_str[j] = NULL;
                }*/
            }else{
                strcpy(dname, cbuf);
                strcpy(dir_str, cbuf);
                windows[FLBR].opt2= -1;
                expose(TFIL);
                no_files=0;
                while((dp=readdir(dirp))!=NULL){
                 sprintf(cbuf, "%s/%s", dname, dp->d_name);
		 if(choose(dp->d_name)){
		   ibuf = alpha_shuffle(dp->d_name);
                   if(filename[0]!=NULL){
                     sprintf(cbuf, "%s/%s", dname, dp->d_name);
                     if(!strcmp(filename, cbuf))
                       windows[FLBR].opt2=ibuf;
                   }
                   if((ibuf=strlen(dp->d_name))>longf)
                     longf=ibuf;
                   no_files++;
                  }
		}
		if(no_files==0) no_files = 1;
                if((ibuf=flbr_width/(longf*6+8))==0) ibuf=1;;
                jbuf=(int)ceil(((double)no_files)/((double)ibuf));
                XResizeWindow(mydisplay, windows[FLBR].window, flbr_width+4, 
		  88+jbuf*18);
                expose(FLBR);
            }
	  }
	}
	break;

    case QUEU:
	if(myevent.xbutton.x>30 && myevent.xbutton.x <windows[QUEU].width-29 &&
	   myevent.xbutton.y>23 && myevent.xbutton.y<windows[QUEU].height-33){
	    if(windows[MESB].opt1==0) j = max_load_count_node;
	    else j = max_load_vol_node;
	    if(windows[ORDB].opt1){
	      i=gray0((myevent.xbutton.x-30)/((windows[QUEU].width-59)/
		num_nodes));
	    }else{
	      i=(myevent.xbutton.x-30)/((windows[QUEU].width-59)/num_nodes);
	    }
	      sprintf(buf, "msg queues (%d,%d)", i, j-
		(j*(myevent.xbutton.y-23))/(windows[QUEU].height-56));
	  if(info_line<=num_info_lines){
            XDrawString(mydisplay,windows[INFO].window,gc[CLOK], 9, 
	      38+18*info_line, buf,strlen(buf));
            info_line++;	
	  }else{
           XCopyArea(mydisplay, windows[INFO].window, windows[INFO].window, 
	       gc[CLOK], 0, 46, 200, 18*num_info_lines, 0, 28);
           XClearArea(mydisplay, windows[INFO].window, 0, 28 + 
	       18*num_info_lines, 200, 16, False);
           XDrawString(mydisplay, windows[INFO].window, gc[CLOK], 9, 
              38+18*num_info_lines, buf,strlen(buf));
	  }
	}
        break;


    case CRIT:
	if(myevent.xbutton.x>20 && myevent.xbutton.x <win_edge[CRIT-5] && 
	   myevent.xbutton.y>15+(windows[CRIT].height-30)/((num_nodes+1)*2) && 
	   myevent.xbutton.y<windows[CRIT].height-15-(windows[CRIT].height-30)/
	   ((num_nodes+1)*2)){
	    if(windows[ORDB].opt1){
	      j=gray0(num_nodes-1-(myevent.xbutton.y-15-
		(windows[CRIT].height-30)/((num_nodes+1)*2))/
	        ((windows[CRIT].height-30-2*(windows[CRIT].height-30)/
		((num_nodes+1)*2))/num_nodes));
	    }else{
	      j=num_nodes-1-(myevent.xbutton.y-15-
		(windows[CRIT].height-30)/((num_nodes+1)*2))/
	        ((windows[CRIT].height-30-2*(windows[CRIT].height-30)/
		((num_nodes+1)*2))/num_nodes);
	    }
	    if(myevent.xbutton.x>prev_draw[CRIT-5])
	      sprintf(buf, "crit path (%d,%d)", prev_time+(myevent.xbutton.x-
	      prev_draw[CRIT-5])/(win_size/scale_width), j);
	    else sprintf(buf, "crit path (%d,%d)", prev_time-
	      (prev_draw[CRIT-5]-myevent.xbutton.x)/(win_size/scale_width), j);
	  if(info_line<=num_info_lines){
            XDrawString(mydisplay,windows[INFO].window, gc[CLOK], 9, 
	      38+18*info_line, buf,strlen(buf));
            info_line++;	
	  }else{
           XCopyArea(mydisplay, windows[INFO].window, windows[INFO].window, 
	       gc[CLOK], 0, 46, 200, 18*num_info_lines, 0, 28);
           XClearArea(mydisplay, windows[INFO].window, 0, 28+18*num_info_lines,
               200, 16, False);
           XDrawString(mydisplay, windows[INFO].window, gc[CLOK], 9, 
              38+18*num_info_lines, buf,strlen(buf));
	  }
	}
        break;

    case SPTM:
	if(myevent.xbutton.x>20 && myevent.xbutton.x <win_edge[SPTM-5] && 
	   myevent.xbutton.y>15+(windows[SPTM].height-30)/((num_nodes+1)*2) && 
	   myevent.xbutton.y<windows[SPTM].height-15-(windows[SPTM].height-30)/
	   ((num_nodes+1)*2)){
	    if(windows[ORDB].opt1){
	      j=gray0(num_nodes-1-(myevent.xbutton.y-15-
		(windows[SPTM].height-30)/((num_nodes+1)*2))/
	        ((windows[SPTM].height-30-2*(windows[SPTM].height-30)/
		((num_nodes+1)*2))/num_nodes));
	    }else{
	      j=num_nodes-1-(myevent.xbutton.y-15-
		(windows[SPTM].height-30)/((num_nodes+1)*2))/
	        ((windows[SPTM].height-30-2*(windows[SPTM].height-30)/
		((num_nodes+1)*2))/num_nodes);
	    }
	    if(myevent.xbutton.x>prev_draw[SPTM-5])
	      sprintf(buf, "spacetime (%d,%d)", prev_time+(myevent.xbutton.x-
	      prev_draw[SPTM-5])/(win_size/scale_width), j);
	    else sprintf(buf, "spacetime (%d,%d)", prev_time-
	      (prev_draw[SPTM-5]-myevent.xbutton.x)/(win_size/scale_width), j);
	  if(info_line<=num_info_lines){
            XDrawString(mydisplay, windows[INFO].window, gc[CLOK], 9, 
	      38+18*info_line, buf,strlen(buf));
            info_line++;	
	  }else{
           XCopyArea(mydisplay, windows[INFO].window, windows[INFO].window, 
	       gc[CLOK], 0, 46, 200, 18*num_info_lines, 0, 28);
           XClearArea(mydisplay, windows[INFO].window, 0, 28 + 
	     18*num_info_lines, 200, 16, False);
           XDrawString(mydisplay,windows[INFO].window, gc[CLOK], 9, 
              38+18*num_info_lines, buf,strlen(buf));
	  }
	}
        break;

    case PROF:
	if(myevent.xbutton.x>29 && myevent.xbutton.x <windows[PROF].width-30 && 
	   myevent.xbutton.y>21 && myevent.xbutton.y<windows[PROF].height-21){
	  sprintf(buf, "profile (%d,%d)", (myevent.xbutton.x-29)/
	    ((windows[PROF].width-59)/(num_nodes+1)), max_prof_count-
	    (max_prof_count*(myevent.xbutton.y-21))/(windows[PROF].height-42));
	  if(info_line<=num_info_lines){
            XDrawString(mydisplay, windows[INFO].window, gc[CLOK], 9, 
	      38+18*info_line, buf,strlen(buf));
            info_line++;	
	  }else{
           XCopyArea(mydisplay, windows[INFO].window, windows[INFO].window, 
	       gc[CLOK], 0, 46, 200, 18*num_info_lines, 0, 28);
           XClearArea(mydisplay, windows[INFO].window, 0, 28+18*num_info_lines,
               200, 16, False);
           XDrawString(mydisplay, windows[INFO].window, gc[CLOK], 9, 
              38+18*num_info_lines, buf,strlen(buf));
	  }
	}
        break;

    case TSKG:
	if(myevent.xbutton.x>30 && myevent.xbutton.x <win_edge[TSKG-5] && 
	   myevent.xbutton.y>14 && myevent.xbutton.y<windows[TSKG].height-48){
	    if(windows[ORDB].opt1){
	      j=gray0(num_nodes-1-(num_nodes*(myevent.xbutton.y-14))/
	        (windows[TSKG].height-62));
	    }else{
	      j=num_nodes-1-(num_nodes*(myevent.xbutton.y-14))/
		(windows[TSKG].height-62);
	    }
	    if(myevent.xbutton.x>prev_draw[TSKG-5])
	      sprintf(buf, "task gantt (%d,%d)", prev_time+(myevent.xbutton.x-
	      prev_draw[TSKG-5])/(win_size/scale_width), j);
	    else sprintf(buf, "task gantt (%d,%d)", prev_time-
	      (prev_draw[TSKG-5]-myevent.xbutton.x)/(win_size/scale_width), j);
	  if(info_line<=num_info_lines){
            XDrawString(mydisplay, windows[INFO].window, gc[CLOK], 9, 
	      38+18*info_line, buf,strlen(buf));
            info_line++;	
	  }else{
           XCopyArea(mydisplay, windows[INFO].window, windows[INFO].window, 
	       gc[CLOK], 0, 46, 200, 18*num_info_lines, 0, 28);
           XClearArea(mydisplay, windows[INFO].window, 0, 28+18*num_info_lines,
               200, 16, False);
           XDrawString(mydisplay, windows[INFO].window, gc[CLOK], 9, 
              38+18*num_info_lines, buf,strlen(buf));
	  }
	}
	break;
    case TSMY:
	if(myevent.xbutton.x>30 && myevent.xbutton.x <windows[TSMY].width-29 && 
	   myevent.xbutton.y>23 && myevent.xbutton.y<windows[TSMY].height-61){
	      sprintf(buf, "task summary (%d,%d)", (myevent.xbutton.x-30)/
		((windows[TSMY].width-59)/total_tasks), 100-
		(100*(myevent.xbutton.y-23))/(windows[TSMY].height-84));
	  if(info_line<=num_info_lines){
            XDrawString(mydisplay, windows[INFO].window, gc[CLOK], 9, 
	      38+18*info_line, buf,strlen(buf));
            info_line++;	
	  }else{
           XCopyArea(mydisplay, windows[INFO].window, windows[INFO].window, 
	       gc[CLOK], 0, 46, 200, 18*num_info_lines, 0, 28);
           XClearArea(mydisplay, windows[INFO].window, 0, 28+18*num_info_lines,
               200, 16, False);
           XDrawString(mydisplay, windows[INFO].window, gc[CLOK], 9, 
              38+18*num_info_lines, buf,strlen(buf));
	  }
	}
	break;
    case TSKC:
	if(myevent.xbutton.x>29 && myevent.xbutton.x <windows[TSKC].width-29 && 
	   myevent.xbutton.y>19 && myevent.xbutton.y<windows[TSKC].height-61){
	      sprintf(buf, "task count (%d,%d)", (myevent.xbutton.x-29)/
		((windows[TSKC].width-58)/total_tasks), num_nodes-
		(num_nodes*(myevent.xbutton.y-19))/(windows[TSKC].height-82));
	  if(info_line<=num_info_lines){
            XDrawString(mydisplay, windows[INFO].window, gc[CLOK], 9, 
	      38+18*info_line, buf,strlen(buf));
            info_line++;	
	  }else{
           XCopyArea(mydisplay, windows[INFO].window, windows[INFO].window, 
	       gc[CLOK], 0, 46, 200, 18*num_info_lines, 0, 28);
           XClearArea(mydisplay, windows[INFO].window, 0, 28+18*num_info_lines,
               200, 16, False);
           XDrawString(mydisplay, windows[INFO].window, gc[CLOK], 9, 
              38+18*num_info_lines, buf,strlen(buf));
	  }
	}
	break;
    case UTLS:
	if(myevent.xbutton.x>30 && myevent.xbutton.x <windows[UTLS].width-30 && 
	   myevent.xbutton.y>23 && myevent.xbutton.y<windows[UTLS].height-74){
	    if(windows[ORDB].opt1){
	      i=gray0((myevent.xbutton.x-30)/((windows[UTLS].width-60)/
		num_nodes));
	    }else{
	      i=(myevent.xbutton.x-30)/((windows[UTLS].width-60)/num_nodes);
	    }
	      sprintf(buf, "util summary (%d,%d)", i, 100-
		(100*(myevent.xbutton.y-23))/(windows[UTLS].height-97));
	  if(info_line<=num_info_lines){
            XDrawString(mydisplay, windows[INFO].window, gc[CLOK], 9, 
	      38+18*info_line, buf,strlen(buf));
            info_line++;	
	  }else{
           XCopyArea(mydisplay, windows[INFO].window, windows[INFO].window, 
	       gc[CLOK], 0, 46, 200, 18*num_info_lines, 0, 28);
           XClearArea(mydisplay, windows[INFO].window, 0, 28+18*num_info_lines,
               200, 16, False);
           XDrawString(mydisplay, windows[INFO].window, gc[CLOK], 9, 
              38+18*num_info_lines, buf,strlen(buf));
	  }
	}
        break;

    case UTLG:
	if(myevent.xbutton.x>30 && myevent.xbutton.x <win_edge[UTLG-5] && 
	   myevent.xbutton.y>14 && myevent.xbutton.y<windows[UTLG].height-48){
	    if(windows[ORDB].opt1){
	      j=gray0(num_nodes-1-(myevent.xbutton.y-14)/
	        ((windows[UTLG].height-62)/num_nodes));
	    }else{
	      j=num_nodes-1-(myevent.xbutton.y-14)/((windows[UTLG].height-62)/
	        num_nodes);
	    }
	    if(myevent.xbutton.x>prev_draw[UTLG-5])
	      sprintf(buf, "util gantt (%d,%d)", prev_time+(myevent.xbutton.x-
	      prev_draw[UTLG-5])/(win_size/scale_width), j);
	    else sprintf(buf, "util gantt (%d,%d)", prev_time-
	      (prev_draw[UTLG-5]-myevent.xbutton.x)/(win_size/scale_width), j);
	  if(info_line<=num_info_lines){
            XDrawString(mydisplay, windows[INFO].window, gc[CLOK], 9, 
	      38+18*info_line, buf,strlen(buf));
            info_line++;	
	  }else{
           XCopyArea(mydisplay, windows[INFO].window, windows[INFO].window, 
	       gc[CLOK], 0, 46, 200, 18*num_info_lines, 0, 28);
           XClearArea(mydisplay, windows[INFO].window, 0, 28+18*num_info_lines,
               200, 16, False);
           XDrawString(mydisplay, windows[INFO].window, gc[CLOK], 9, 
              38+18*num_info_lines, buf,strlen(buf));
	  }
	}
        break;
    case TRAF:
	if(myevent.xbutton.x>40 && myevent.xbutton.x <win_edge[TRAF-5] && 
	   myevent.xbutton.y>20 && myevent.xbutton.y<windows[TRAF].height-16){
	    if(myevent.xbutton.x>prev_draw[TRAF-5])
	      sprintf(buf, "comm traffic (%d,%d)", prev_time+(myevent.xbutton.x-
	      prev_draw[TRAF-5])/(win_size/scale_width), comm_max_load-
	      comm_max_load*(myevent.xbutton.y-20)/(windows[TRAF].height-36));
	    else sprintf(buf, "comm traffic (%d,%d)", prev_time-
	      (prev_draw[TRAF-5]-myevent.xbutton.x)/(win_size/scale_width), 
	      comm_max_load-comm_max_load*(myevent.xbutton.y-20)/
	      (windows[TRAF].height-36));
	  if(info_line<=num_info_lines){
            XDrawString(mydisplay, windows[INFO].window, gc[CLOK], 9, 
	      38+18*info_line, buf,strlen(buf));
            info_line++;	
	  }else{
           XCopyArea(mydisplay, windows[INFO].window, windows[INFO].window, 
	       gc[CLOK], 0, 46, 200, 18*num_info_lines, 0, 28);
           XClearArea(mydisplay, windows[INFO].window, 0, 28+18*num_info_lines,
               200, 16, False);
           XDrawString(mydisplay, windows[INFO].window, gc[CLOK], 9, 
              38+18*num_info_lines, buf,strlen(buf));
	  }
	}
        break;
    case MTRX:
	if(myevent.xbutton.x>16 && myevent.xbutton.x <windows[MTRX].width-16 && 
	   myevent.xbutton.y>16 && myevent.xbutton.y<windows[MTRX].height-16){
	if(windows[ORDB].opt1){
	  i=gray0((myevent.xbutton.x-16)/((windows[MTRX].width-32)/num_nodes));
	  j=gray0((myevent.xbutton.y-16)/((windows[MTRX].height-32)/num_nodes));
	}else{
	  i=(myevent.xbutton.x-16)/((windows[MTRX].width-32)/num_nodes);
	  j=(myevent.xbutton.y-16)/((windows[MTRX].height-32)/num_nodes);
	}
	  sprintf(buf, "comm matrix (%d,%d)", i,j);
	  if(info_line<=num_info_lines){
            XDrawString(mydisplay, windows[INFO].window, gc[CLOK], 9, 
	      38+18*info_line, buf,strlen(buf));
            info_line++;	
	  }else{
           XCopyArea(mydisplay, windows[INFO].window, windows[INFO].window, 
	       gc[CLOK], 0, 46, 200, 18*num_info_lines, 0, 28);
           XClearArea(mydisplay, windows[INFO].window, 0, 28+18*num_info_lines,
               200, 16, False);
           XDrawString(mydisplay, windows[INFO].window, gc[CLOK], 9, 
              38+18*num_info_lines, buf,strlen(buf));
	  }
	}
        break;
    case ANIM:
	if(windows[INFO].opt1){
	for(i=0; i<num_nodes; i++)
	  if(myevent.xbutton.x>anim_x[order[i]] && 
	     myevent.xbutton.x <anim_x[order[i]]+proc_width && 
	     myevent.xbutton.y>anim_y[order[i]] && 
	     myevent.xbutton.y<anim_y[order[i]]+proc_height){
	    if ((prev_ptr[i]) >= 0)
	      sprintf(buf, "animation %d %d %d %d %d", cur_time, i, 
	        task[i][prev_ptr[i]], queu_count[i], send_count[i]);
	    else sprintf(buf, "animation %d %d no %d %d", cur_time, i, 
	      queu_count[i], msg_sent[i]);
	  if(info_line<=num_info_lines){
            XDrawString(mydisplay, windows[INFO].window, gc[CLOK], 9, 
	      38+18*info_line, buf,strlen(buf));
            info_line++;	
	  }else{
           XCopyArea(mydisplay, windows[INFO].window, windows[INFO].window, 
	       gc[CLOK], 0, 46, 200, 18*num_info_lines, 0, 28);
           XClearArea(mydisplay, windows[INFO].window, 0, 28+18*num_info_lines,
               200, 16, False);
           XDrawString(mydisplay, windows[INFO].window, gc[CLOK], 9, 
              38+18*num_info_lines, buf,strlen(buf));
	  }
	    break;
	}
	}
        if(windows[ATYB].opt1==2){
	  if(moving==-1){
	  for(i=0; i<num_nodes; i++)
	    if(myevent.xbutton.x>anim_x[order[i]] && 
	       myevent.xbutton.x <anim_x[order[i]]+proc_width && 
	       myevent.xbutton.y>anim_y[order[i]] && 
	       myevent.xbutton.y<anim_y[order[i]]+proc_height){
	      moving=i;
              XFillArc(mydisplay, windows[ANIM].window, gc[MENU], 
		anim_x[order[i]], anim_y[order[i]], proc_width, proc_height, 
		0, 23040);
              XDrawArc(mydisplay, windows[ANIM].window, gc[MENU], 
		anim_x[order[i]], anim_y[order[i]], proc_width, proc_height, 
		0, 23040);
              XDrawString(mydisplay, windows[ANIM].window, gc[ERAS], 
		anim_x[order[i]] + proc_width/2 - 3*strlen(number[i]), 
		anim_y[order[i]] + proc_height/2+4, number[i], 
		strlen(number[i]));
	    }
	  }else{
            user_anim_x[order[moving]]=((float)myevent.xbutton.x)/
	      ((float)windows[ANIM].width);
            user_anim_y[order[moving]]=((float)myevent.xbutton.y)/
	      ((float)windows[ANIM].height);
	    anim_x[order[moving]]=(int)(user_anim_x[moving]*
	      ((float)windows[ANIM].width))-10;
	    anim_y[order[moving]]=(int)(user_anim_y[moving]*
	      ((float)windows[ANIM].height))-10;
	    anim_xl[order[moving]]=(int)(user_anim_x[moving]*
	      ((float)windows[ANIM].width));
	    anim_yl[order[moving]]=(int)(user_anim_y[moving]*
	      ((float)windows[ANIM].height));

	    moving= -1;
            expose(ANIM);
	  }
        }
        break;
    case PHPT:
	if(myevent.xbutton.x>29 && myevent.xbutton.x <phpt_width+31 && 
	   myevent.xbutton.y>29 && myevent.xbutton.y<phpt_height+31){
	    sprintf(buf, "phase portrait (%d,%d)", (myevent.xbutton.x-29)/
	    (phpt_width/100), (phpt_height+31-myevent.xbutton.y)/
	    (phpt_height/100));
	  if(info_line<=num_info_lines){
            XDrawString(mydisplay, windows[INFO].window, gc[CLOK], 9, 
	      38+18*info_line, buf,strlen(buf));
            info_line++;	
	  }else{
           XCopyArea(mydisplay, windows[INFO].window, windows[INFO].window, 
	       gc[CLOK], 0, 46, 200, 18*num_info_lines, 0, 28);
           XClearArea(mydisplay, windows[INFO].window, 0, 28+18*num_info_lines,
               200, 16, False);
           XDrawString(mydisplay, windows[INFO].window, gc[CLOK], 9, 
              38+18*num_info_lines, buf,strlen(buf));
	  }
	}
        break;
    case UTLC:
	if(myevent.xbutton.x>30 && myevent.xbutton.x <win_edge[UTLC-5] && 
	   myevent.xbutton.y>windows[UTLC].height-56-num_nodes*
	   ((windows[UTLC].height-69)/num_nodes) && 
	   myevent.xbutton.y<windows[UTLC].height-56){
	    if(myevent.xbutton.x>prev_draw[UTLC-5])
	        sprintf(buf, "util count (%d,%d)", prev_time+(myevent.xbutton.x-
		prev_draw[UTLC-5])/(win_size/scale_width),(windows[UTLC].height+
		(windows[UTLC].height-69)/(2*num_nodes)-56-myevent.xbutton.y)/
		((windows[UTLC].height-69)/ num_nodes));
	    else sprintf(buf, "util count (%d,%d)",prev_time-(prev_draw[UTLC-5]-
		myevent.xbutton.x)/(win_size/scale_width),(windows[UTLC].height+
		(windows[UTLC].height-69)/(2*num_nodes)-56-myevent.xbutton.y)/
		((windows[UTLC].height-69)/ num_nodes));
	  if(info_line<=num_info_lines){
            XDrawString(mydisplay, windows[INFO].window, gc[CLOK], 9, 
	      38+18*info_line, buf,strlen(buf));
            info_line++;	
	  }else{
           XCopyArea(mydisplay, windows[INFO].window, windows[INFO].window, 
	     gc[CLOK], 0, 46, 200, 18*num_info_lines, 0, 28);
           XClearArea(mydisplay, windows[INFO].window, 0, 28+18*num_info_lines,
               200, 16, False);
           XDrawString(mydisplay, windows[INFO].window, gc[CLOK], 9, 
              38+18*num_info_lines, buf,strlen(buf));
	  }
	}
        break;
    case NOPB:
	windows[NOPB].opt1=rotate(windows[NOPB].opt1, 2, direction);
	expose(NOPB);
	net_op_change=1;
	expose(NTWK);
	break;
    case SHNB:
	windows[SHNB].opt1=rotate(windows[SHNB].opt1, 2, direction);
	expose(NTWK);
	expose(SHNB);
	break;
    case NTYB:
	windows[NTYB].opt1=rotate(windows[NTYB].opt1, 9, direction);
	switch(windows[NTYB].opt1)
	{
	case NTWK_MESH:
	  XMapWindow(mydisplay, windows[NOPB].window);
	  XMapWindow(mydisplay, windows[NMSB].window);
	  XMapWindow(mydisplay, windows[NMOB].window);
	  XMapWindow(mydisplay, windows[SHNB].window);
	break;
	case BINARY_TREE:
	case QUADTREE:
	case CROSSBAR:
	  XUnmapWindow(mydisplay, windows[NMSB].window);
	  XUnmapWindow(mydisplay, windows[NMOB].window);
	  XUnmapWindow(mydisplay, windows[NOPB].window);
	  XUnmapWindow(mydisplay, windows[SHNB].window);
	break;
	case BUTTERFLY:
	case GRAY_CODE:
	case HYPERCUBE:
	case OMEGA:
	case BASELINE:
	  XMapWindow(mydisplay, windows[NOPB].window);
	  XMapWindow(mydisplay, windows[SHNB].window);
	  XUnmapWindow(mydisplay, windows[NMSB].window);
	  XUnmapWindow(mydisplay, windows[NMOB].window);
	break;
	}
	if(tfptr!=NULL){
          for(i=0; i<ntwk_stages; i++){
            for(j=0; j<ntwk_nodes; j++){
	      free(ntwk_load[i][j]);
	      free(ntwk_total[i][j]);
	    }
	    free(ntwk_load[i]);
	    free(ntwk_total[i]);
	  }
          free(ntwk_load);
          free(ntwk_total);
          free(pt_array);
          for(j=0; j<ntwk_nodes; j++){
             free(node_stage[j]);
             free(ns_inv[j]);
          }
          free(node_stage);
          free(ns_inv);
	}
	ntwk_stages=0;
        ntwk_nodes=num_nodes;
        ms_net(windows[NTYB].opt1, &ntwk_nodes, &ntwk_stages);
        if ((ntwk_load = (int ***)malloc(ntwk_stages*sizeof(int **))) == NULL){
          printf("memory allocation failed: %d bytes requested \n",
                    ntwk_stages*sizeof(int));
            exit(1);
        }
        for(i=0; i<ntwk_stages; i++){
          if ((ntwk_load[i] = (int **)malloc(ntwk_nodes*sizeof(int *)))==NULL){
          printf("memory allocation failed: %d bytes requested \n",
                    ntwk_nodes*sizeof(int));
            exit(1);
          }
          for(j=0; j<ntwk_nodes; j++){
          if ((ntwk_load[i][j] = (int *)malloc(2*sizeof(int))) == NULL){
          printf("memory allocation failed: %d bytes requested \n",
                    2*sizeof(int));
            exit(1);
          }else{
	    ntwk_load[i][j][0]=0;
	    ntwk_load[i][j][1]=0;
	  }
        }
	}
        if ((ntwk_total = (int ***)malloc(ntwk_stages*sizeof(int **))) == NULL){
          printf("memory allocation failed: %d bytes requested \n",
                    ntwk_stages*sizeof(int));
            exit(1);
        }
        for(i=0; i<ntwk_stages; i++){
          if ((ntwk_total[i] = (int **)malloc(ntwk_nodes*sizeof(int *)))==NULL){
          printf("memory allocation failed: %d bytes requested \n",
                    ntwk_nodes*sizeof(int));
            exit(1);
          }
          for(j=0; j<ntwk_nodes; j++){
          if ((ntwk_total[i][j] = (int *)malloc(2*sizeof(int))) == NULL){
          printf("memory allocation failed: %d bytes requested \n",
                    2*sizeof(int));
            exit(1);
          }else{
	    ntwk_total[i][j][0]=0;
	    ntwk_total[i][j][1]=0;
	  }
        }
	}
        if ((pt_array = (struct ns_pt *)malloc((max_hops+1)*
             sizeof(struct ns_pt))) == NULL){
          printf("memory allocation failed: %d bytes requested \n",
            (max_hops+1)*sizeof(struct ns_pt));
          exit(1);
        }
	net_op_change=1;
	expose(NTYB);
	expose(NTWK);
        break;

    /* hypercube construction */
    case HTYB:
	windows[HTYB].opt1=rotate(windows[HTYB].opt1, 22, direction);
	expose(HTYB);
	expose(HYPE);
        break;

    /* scrolling choices: one pixel, 1/4 "screen", 1/2 screen, 
       3/4 screen, full screen */
    case SCRB:

	windows[SCRB].opt1=rotate(windows[SCRB].opt1, 5, direction);

	switch (windows[SCRB].opt1) {
	    /* if scale_width is less than 512, smooth scrolling will
	       actually jump back 2, 4 or 8 pixels */

	case 0:
	    for(i=TSKG; i<=TRAF; i++)
	        scroll_width[i-5] = win_size / scale_width;
	    break;
	case 1:
	    for(i=TSKG; i<=TRAF; i++) {
	        scroll_width[i-5] = (win_edge[i-5]-30)/4; }  
	    break;
	case 2:
	    for(i=TSKG; i<=TRAF; i++) {
	        scroll_width[i-5] = (win_edge[i-5]-30)/2; }  /* halfway back */ 
	    break;
	case 3:
	    for(i=TSKG; i<=TRAF; i++) {
	        scroll_width[i-5] = (3*(win_edge[i-5]-30))/4; }
	    break;
	case 4:
	    scroll_width[NINF-5] = win_edge[NINF-5]-32; 
	    scroll_width[TRAF-5] = win_edge[TRAF-5]-42; 
	    scroll_width[UTLG-5] = win_edge[UTLG-5]-32; 
	    scroll_width[CRIT-5] = win_edge[CRIT-5]-32; 
	    scroll_width[SPTM-5] = win_edge[SPTM-5]-32; 
	    scroll_width[UTLC-5] = win_edge[UTLC-5]-32; 
	    scroll_width[TSKG-5] = win_edge[TSKG-5]-32; 
	    break;
	}
	expose(SCRB);
	break;

    /* message counts or lengths for queues display? */
    case MESB:
	windows[MESB].opt1=rotate(windows[MESB].opt1, 2, direction);
        if(!windows[MESB].opt1)
          queu_max_load = max_load_count_node;
        else windows[MESB].opt1 = max_load_vol_node; 
	expose(QUEU);
	expose(MESB);
	break;

    case CODB:
	windows[CODB].opt1=rotate(windows[CODB].opt1, 3, direction);

        expose(CODB);
	if (windows[LGND].opt1){
            expose(LGND);
	}
	break;

    /* busy, overhead, or idle for profile display? */
    case CPFB:
	windows[CPFB].opt1=rotate(windows[CPFB].opt1, 3, direction);
        expose(CPFB);
	if (windows[PROF].opt1 && end_of_file)
            expose(PROF);
	break;

    /* message count or volume for communication meter display? */
    case MTRB:
	windows[MTRB].opt1=rotate(windows[MTRB].opt1, 2, direction);
        expose(MTRB);
	break;

   case SRKB:
	windows[SRKB].opt1=rotate(windows[SRKB].opt1, 2, direction);

        expose(SRKB);
        expose(STRK);
        break;

    case KVTB:
	windows[KVTB].opt1=rotate(windows[KVTB].opt1, 2, direction);

        expose(KVTB);
        break;

    /* message count or length for traffic display? */
    case SIZB:
	windows[SIZB].opt1=rotate(windows[SIZB].opt1, 2, direction);

	if(comm_max_load==0) comm_max_load=1;
	expose(TRAF);
	expose(SIZB);
	break;

    /* choice of displays on node info */
    case STYB:
	windows[STYB].opt1=rotate(windows[STYB].opt1, 4, direction);
	expose(NINF);
	expose(STYB);
	break;

    /* which node for traffic display? */
    case TRNB:
	windows[TRNB].opt1=rotate(windows[TRNB].opt1, num_nodes+1, direction);
	sprintf(buf, "%d", windows[TRNB].opt1);
	expose(TRNB);
	if (windows[TRAF].opt1)
	    expose(TRAF);
	break;

    /* which node for node info display? */
    case SNDB:
	windows[SNDB].opt1=rotate(windows[SNDB].opt1, num_nodes, direction);
        expose(SNDB);
	break;

    case COLB:
	windows[COLB].opt1=rotate(windows[COLB].opt1, 2, direction);
	expose(COLB);
	break;

    case DIMB:
	if(direction){
	  if(windows[DIMB].opt2==num_nodes) windows[DIMB].opt2=1;
	  else for(i=windows[DIMB].opt2+1; i<=num_nodes; i++){
	    if(num_nodes%i==0){
	      windows[DIMB].opt2=i;
	      break;
	    }
	  }
	}else{
	  if(windows[DIMB].opt2==1) windows[DIMB].opt2=num_nodes;
	  else for(i=windows[DIMB].opt2-1; i>0; i--){
	    if(num_nodes%i==0){
	      windows[DIMB].opt2=i;
	      break;
	    }
	  }
	}
	if(windows[DSTB].opt1==1) 
	  max_dist=num_nodes/windows[DIMB].opt2 + windows[DIMB].opt2 - 2;
	else if (windows[DSTB].opt1==2) 
	  max_dist=(num_nodes/windows[DIMB].opt2 + windows[DIMB].opt2) / 2;
	expose(LGND);
	expose(DIMB);
	break;

    case DSTB:
	windows[DSTB].opt1=rotate(windows[DSTB].opt1, 6, direction);
        if(windows[DSTB].opt1!=1 && windows[DSTB].opt1!=2){
          XUnmapWindow(mydisplay, windows[DIMB].window);
          XUnmapWindow(mydisplay, windows[COLB].window);
          XResizeWindow(mydisplay, windows[DSTB].window, 266, 21);
        }else{
          XMapWindow(mydisplay, windows[DIMB].window);
          XMapWindow(mydisplay, windows[COLB].window);
          XResizeWindow(mydisplay, windows[DSTB].window, 152, 21);
	  expose(COLB);
	  expose(DIMB);
        }
        switch(windows[DSTB].opt1){
          case 0:
            max_dist=(int)ceil(log_two((double)num_nodes));
            break;
          case 1:
            max_dist=num_nodes/windows[DIMB].opt2 + windows[DIMB].opt2 - 2;
            break;
          case 2:
            max_dist=(num_nodes/windows[DIMB].opt2 + windows[DIMB].opt2) / 2;
            break;
          case 3:
            max_dist=2*(int)ceil(log_two((double)num_nodes));
            break;
          case 4:
            max_dist=(int)ceil(log_two((double)num_nodes));
            break;
          case 5:
            max_dist=1;
            break;
        }
        if(windows[LGND].opt1) expose(LGND);
	expose(DSTB);
	break;

    /* scale width for scrolling windows */
    case SCLB:
	windows[SCLB].opt1=rotate(windows[SCLB].opt1, 4, direction);

	switch (windows[SCLB].opt1) {
	case 0:
	    scale_width = win_size;
	    break;
	case 1:
	    scale_width = win_size/2;
	    break;
	case 2:
	    scale_width = win_size/4;
	    break;
	case 3:
	    scale_width = win_size/8;
	    break;
	}
        right_scale[UTLG-5] = left_scale[UTLG-5] + (windows[UTLG].width-60)/
          (win_size/scale_width);
        right_scale[TSKG-5] = left_scale[TSKG-5] + (windows[TSKG].width-60)/
          (win_size/scale_width);
        right_scale[CRIT-5] = left_scale[CRIT-5] + (windows[CRIT].width-60)/
          (win_size/scale_width);
        right_scale[SPTM-5] = left_scale[SPTM-5] + (windows[SPTM].width-60)/
          (win_size/scale_width);
        right_scale[NINF-5] = left_scale[NINF-5] + (windows[NINF].width-60)/
          (win_size/scale_width);
        right_scale[UTLC-5] = left_scale[UTLC-5] + (windows[UTLC].width-60)/
          (win_size/scale_width);
        right_scale[TRAF-5] = left_scale[TRAF-5] + (windows[TRAF].width-80)/
          (win_size/scale_width);

	expose(SCLB);
	if (!windows[SCRB].opt1)
	    for(i=TSKG; i<=TRAF; i++)
	        scroll_width[i-5] = win_size / scale_width;
	for(j=TSKG; j<=TRAF; j++) {
	    if (windows[j].opt1)
	        expose(j); 
	}
	break;

    /* pause/resume button on menu */
    case PAUB:
	if(tfptr!=NULL){
	if (end_of_file == 0) {
	    /* as long as we are not at eof */
	    if (go_flag == 1 && cur_time < stop_time){
		go_flag = 0;
		paused=1;
	    /* if animating and we haven't hit the start time, stop (pause) */
	    }else{
		go_flag = 1;
		paused=0;
	    }
	    /* not animating (pause is in effect) or we have stopped at the
	       stop time; start up from there (resume) */

            expose(PAUB);
            expose(STTS);

	    if (cur_time >= stop_time) {
		/* change back to default stop time if we resume after having
		   hit user-selected stop time */
		stop_time = max_time+1;
		expose(STOP);
	    }
	}
	}
	break;

    /* step button on menu */
    case STPB:
	go_flag = 2;
	/* so that it will not run straight through */

        if(begin_of_file){
	  reset();
	  begin_of_file=0;
	}
	if (cur_time >= stop_time) {
	    XSetFont(mydisplay, gc[MENU], font2);
	    /* if we have hit stop time change back to default */
	    stop_time = max_time+1;
	    sprintf(stop_str, "%d", stop_time);
	    XDrawImageString(mydisplay, windows[STOP].window, gc[MENU],
		84, 14, stop_str, 6);
	    XSetFont(mydisplay, gc[MENU], font1);
	}
	if (tfptr != NULL) {
	  for(i=0; i<step_inc; i++){
          while(skip){
	    /* just read one line every time button is hit */
	    if (fgets(linestr, MAXLINE, tfptr) != NULL && end_of_file != 1) {
		/* read through a traceline and collect needed data */
		   scan(linestr);
            if(key_index==SEND&&dest==ALL){
              for(i=0; i<node; i++){
              dest=i;
              draw();
              }
              for(i=node+1; i<num_nodes; i++){
              dest=i;
              draw();
              }
            } else {
	      draw();
	    }
              expose(STTS);
	    } else {
		/* end of file - stop and reset everything */
		skip = 0;
		/* do nothing state */
		go_flag = 0;
		end_of_file = 1;
	        draw_end();
	        begin_of_file=1;
		i=step_inc+1;
	    }
	  }
	  if(end_of_file){
	    end_of_file=0;
	    break;
	  }else{
	  skip = 1;
	  }
	 }
	}
	/* no file to be read; can't start; beep at user */
	else
	    XBell(mydisplay, 100);

	break;

    case CLOB:
        if (opencount>0){
	  for(i=ANIM; i<=OMEN; i++)
	    if(windows[i].opt1){
	      button(i+37);
	    }
	}else{
          if((envptr=fopen(envname, "r"))!=NULL){
	    first_button=1;
            parse_env(envptr);
            for(i=ANIM; i<=MENU; i++){
              windowhints[i].flags = USPosition | PSize;
              XSetNormalHints(mydisplay, windows[i].window, &windowhints[i]);
            }
	    if(windows[ANIM].opt1){
		opencount++;
		expose(CLOB);
	        XMoveResizeWindow(mydisplay, windows[ANIM].window, 
		  windows[ANIM].x, windows[ANIM].y, windows[ANIM].width, 
		  windows[ANIM].height);
	        XMapWindow(mydisplay, windows[ANIM].window);
                XMapWindow(mydisplay, windows[ANIM].window);
                if(windows[ATYB].opt1==1){
                  XMapWindow(mydisplay, windows[MORB].window);
                  XMapWindow(mydisplay, windows[MTYB].window);
                }
                if(windows[ATYB].opt1==2){
                  XMapWindow(mydisplay, windows[ASVB].window);
                  XMapWindow(mydisplay, windows[ARDB].window);
                }
	    }
            for(i=HYPE; i<=CMMT; i++){
	      if(windows[i].opt1){
		opencount++;
		expose(CLOB);
	        XMoveResizeWindow(mydisplay, windows[i].window, windows[i].x, 
		  windows[i].y, windows[i].width, windows[i].height);
	        XMapWindow(mydisplay, windows[i].window);
	        XMapSubwindows(mydisplay, windows[i].window);
	      }
	    }
            for(i=TRAC; i<=OMEN; i++){
	      if(windows[i].opt1){
		opencount++;
		expose(CLOB);
	        XMoveWindow(mydisplay, windows[i].window, windows[i].x, 
		  windows[i].y);
	        XMapWindow(mydisplay, windows[i].window);
	        XMapSubwindows(mydisplay, windows[i].window);
	      }
            }
	    expose(LGND);
	    expose(CMMB);
	    expose(HTYB);
	    expose(SNDB);
	    expose(STYB);
	    expose(SIZB);
	    expose(MESB);
	    expose(CPFB);
	    expose(SINC);
	    expose(ORDB);
	    expose(SCRB);
	    expose(SPRT);
	    expose(ATYB);
	    expose(TSTP);
	    fclose(envptr);
	  }
	}
	break;

    /* run button on menu */
    case RUNB:
	if (tfptr != NULL) {
	    /* as long as we've got something, restart from beginning any
	       time start is hit */
	    net_op_change=0;
	    reset();
	    if (cur_time < stop_time)
		go_flag = 1;
	}
	/* no file to be read; can't start; beep at user */
	else
	    XBell(mydisplay, 100);
	break;

    /* screendump button on menu */
    case SDPB:
	/* screen dump and print */

	for(i=0; i<75; i++)
	    command[i] = NULL;

        strcat(command, dump_command1);
        if (displayname[0]==NULL)
            strcat(command, getenv("DISPLAY"));
        else strcat(command, displayname);
        strcat(command, dump_command2);
        strcat(command, print_command);
        printf("command: %s\n", command);
	system(command);
	for(j=0; j<=75; j++)
	    command[j]=NULL;
	break;

    /*save environment button on menu*/
    case ENVB:
	/*save relevant information in .pgrc file*/
	 XFillRectangle(mydisplay, windows[ENVB].window, gc[MENS], 0, 0, 
	   90, 16);
	 XDrawString(mydisplay, windows[ENVB].window, gc[MENU], 21, 10,
	    "Save Env", strlen("Save Env"));
	 if(access(".pgrc", F_OK)==0){
	  if((envptr=fopen(".pgrc", "w"))==NULL)
	    printf("Sorry, can not open file .pgrc for writing.\n");
	  else{
            write_file();
	  XFillRectangle(mydisplay, windows[ENVB].window, gc[ERAS], 0, 0, 
	    90, 16);
	  XDrawImageString(mydisplay, windows[ENVB].window, gc[MENU], 21, 10,
	    "Save Env", strlen("Save Env"));
	  }
	 }else{
	  XMapWindow(mydisplay, windows[QEST].window);
	  XMapSubwindows(mydisplay, windows[QEST].window);
	 }
	 break;
    case RSTB:
         reset();
         go_flag = 0;
         for(i=ANIM; i<=OMEN; i++)
           if(windows[i].opt1) expose(i);
         break;

    /* quit button on menu */
    case QITB:
	/* close everything down */

	go_flag = -1;
	XDestroyWindow(mydisplay, windows[MENU].window);
	XCloseDisplay(mydisplay);
	if(filename[0]!=NULL){
	  fclose(tfptr);
          for(j=0; j<ntwk_stages; j++){
              for(i=0; i<ntwk_nodes; i++){
                free(ntwk_load[j][i]);
                free(ntwk_total[j][i]);
              }
              free(ntwk_load[j]);
              free(ntwk_total[j]);
          }
          for(i=0; i<ntwk_nodes; i++){
              free(node_stage[i]);
              free(ns_inv[i]);
          }
          free(node_stage);
          free(ns_inv);
          free(ntwk_load);
          free(ntwk_total);
          free(pt_array);
          for(i=0; i<num_nodes; i++){
            free(task[i]);
            free(msg_count[i]);
            free(cum_vol[i]);
            for(j=0; j<num_nodes; j++){
              for(k=0; k<max_queue_count[i][j]+1; k++)
                free(sendpoint[i][j][k]);
              free(sendpoint[i][j]);
            }
            free(sendpoint[i]);
          }
          free(msg_count);
          free(cum_vol);
          free(task);
          free(sendpoint);
          free(tsks_prog);
          free(task_counter);
          free(task_count);
          free(start_task);
          free(task_time);
	}
	exit(0);
	break;
    default:
	break;
    }
}

int ginv(i)
    int i;

/* inverse Gray code */
{
    int k;
    k = i;
    while (k > 0) {
	k >>= 1;
	i ^= k;
    }
    return (i);
}

int gray0 (i)
        int i ;

/* Gray code */

{
        return( (i>>1)^i ) ;
}

/* reset all variables, etc., that need to be reset at end of run to begin
   next run */
reset()
{
    int i, j, k;

    u_reset();
    for(i=ANIM; i<=PHPT; i++){
     if(windows[i+REC_OFF].opt1){
       fclose(recptr[i]);
       windows[i+REC_OFF].opt1=0;
       button(i+REC_OFF);
     }
    }
    rewind(tfptr);
    /* back to beginning of file */
    spin=0;
    first_draw=1;
    first_not_draw=1;
    prev_time = 0;
    first_util = first_comm = 1;
    cum_util = cum_comm = prev_comm_count = 0;
    prev_place = 0;
    crit_count = crit_node_count;
    trace_place = 0;
    first_trace_exit = 1;
    which_map = 0;
    phpt_first_point = 1;
    max_prof_count = 0;
    close_count=exit_count = true_num_nodes;
    end_of_file = 0;
    skip = 1;
    cur_time = 0;
    prev_draw[SPTM-5] = 31;
    prev_draw[CRIT-5] = 31;
    prev_draw[TSKG-5] = 31;
    prev_draw[UTLG-5] = 31;
    prev_draw[NINF-5] = 31;
    prev_draw[UTLC-5] = 31;
    prev_draw[TRAF-5] = 41;
    prev_count = util_count = 0;
    prev_diff_count = util_diff_count = 0;
    comm_count = 0;
    comm_vol = 0;
    for(i=0; i<num_nodes; i++){
	state[i] = anim_state[i] = 0;
        msg_sent[i] = msg_rcvd[i] = 0;
        max_sent[i] = max_rcvd[i] = 0;
	min_sent[i] = min_rcvd[i] = 1000000000;
	dist[i].min.sent = dist[i].min.rcvd = 1000000000;
	tmes[i].min.sent = tmes[i].min.rcvd = 1000000000;
	tran[i].min.sent = tran[i].min.rcvd = 1000000000;
	dist[i].max.sent = dist[i].max.rcvd = 0;
	tmes[i].max.sent = tmes[i].max.rcvd = 0;
	tran[i].max.sent = tran[i].max.rcvd = 0;
        max_queu_count[i] = max_queu_vol[i] = 0;
	dist[i].total.sent = dist[i].total.rcvd = 0;
	tmes[i].total.sent = tmes[i].total.rcvd = 0;
	tran[i].total.sent = tran[i].total.rcvd = 0;
        last_queue_count[i] = 0;
	queu_count[i] = queu_vol[i] = 0;
        paired_comp[i] = 0;
	send_vol[i] = send_count[i] = 0;
	pct_idle[i] = pct_ovhd[i] = pct_busy[i] = 0;
	sum_ovhd[i] = sum_busy[i] = 0;
	start_idle[i]=start_ovhd[i] = start_busy[i] = 0;
        task_ptr[i] = -1;
	pct_busy_sum[i] = pct_ovhd_sum[i] = 0;
        streak_last_bottom[i]=streak_last_top[i]=0;
        cur_streak[i].busy=cur_streak[i].busy_ovhd=cur_streak[i].ovhd_idle=
        cur_streak[i].idle=0;
        max_streak[i].busy=max_streak[i].busy_ovhd=max_streak[i].ovhd_idle=
	max_streak[i].idle=0;
        prev_state[i]= -1;
    }
    for(i=0; i<num_nodes+1; i++)
	count_idle[i] = count_ovhd[i] = count_busy[i] = 0;
    for (i=0; i<total_tasks; i++){
        *(tsks_prog+i)=0;
        *(start_task+i)=stop_time;
        *(task_time+i)=stop_time;
        *(task_counter+i)=0;
        *(task_count+i)=0;
    }
    for (i = TSKG-5; i <= TRAF-5; i++) {
         left_scale[i] = 0;
    }
    right_scale[UTLG-5] = (windows[UTLG].width-60)/(win_size/scale_width);
    right_scale[TSKG-5] = (windows[TSKG].width-60)/(win_size/scale_width);
    right_scale[CRIT-5] = (windows[CRIT].width-60)/(win_size/scale_width);
    right_scale[SPTM-5] = (windows[SPTM].width-60)/(win_size/scale_width);
    right_scale[NINF-5] = (windows[NINF].width-60)/(win_size/scale_width);
    right_scale[UTLC-5] = (windows[UTLC].width-60)/(win_size/scale_width);
    right_scale[TRAF-5] = (windows[TRAF].width-80)/(win_size/scale_width);

    for(i=0; i<ntwk_stages; i++)
      for(j=0; j<ntwk_nodes; j++){
	ntwk_load[i][j][0]=ntwk_load[i][j][1]=0;
	ntwk_total[i][j][0]=ntwk_total[i][j][1]=0;
      }

    vol_bin[0] = vol_bin[1] = vol_bin[2] = 0;
    vol_bin[3] = vol_bin[4] = vol_bin[5] = 0;
    for (i = 0; i < num_nodes; i++) {
	for (j = 0; j < num_nodes; j++) {
            sendpoint[i][j][0][0] = 0;
            sendpoint[i][j][0][1] = 0;
	    cum_vol[i][j] = 0;
	    msg_count[i][j] = 0;
	}
	kx[i] = k_center_x;
	ky[i] = k_center_y;
	current_util_pct[i] = node_util[i] = 0;
	k_init[i] = 0;
    }

    /* clear all open windows */
    for (j = ANIM; j <= CLOK; j++)
	if (windows[j].opt1) {
	    XClearWindow(mydisplay, windows[j].window);
	    expose(j);
	}
    if (windows[LGND].opt1) {
        expose(LGND);
        expose(CODB);
    }
    if(windows[ANIM].opt1&&windows[ATYB].opt1==1) expose(MTYB);
    if(windows[NTWK].opt1&&windows[NTYB].opt1==NTWK_MESH) expose(NMSB);

    if(windows[UTLS].opt1)
    for (i=0; i<num_nodes; i++)
      XFillRectangle(mydisplay, windows[UTLS].window, gc[UTLI],
      31+i*((windows[UTLS].width-62)/num_nodes), 24,
      (windows[UTLS].width-62)/num_nodes, (windows[UTLS].height-99));

    paused = 0;
    expose(PAUB);
}
slide()
{
  if(myevent.xmotion.x>5&&myevent.xmotion.x<5+sliderwidth&&
    myevent.xmotion.y>6&&myevent.xmotion.y<26){
      windows[SLID].opt1=myevent.xbutton.x-6;
      XFillRectangle(mydisplay, windows[SLID].window, gc[SLID], 6, 6, 
	windows[SLID].opt1, 18);
      XFillRectangle(mydisplay, windows[SLID].window, gc[ERAS], 7+
	windows[SLID].opt1, 6, sliderwidth-windows[SLID].opt1-3, 18);
  }
}
write_file()
{
  int i;

  fprintf(envptr, "%d %d %d %d %d %d %d\n", ANIM, windows[ANIM].opt1,
    windows[ANIM].width, windows[ANIM].height, windows[ANIM].x, windows[ANIM].y,
    windows[ATYB].opt1);
  fprintf(envptr, "%d %d %d %d %d %d %d\n", HYPE, windows[HYPE].opt1,
    windows[HYPE].width, windows[HYPE].height, windows[HYPE].x,
    windows[HYPE].y, windows[HTYB].opt1);
  fprintf(envptr, "%d %d %d %d %d %d\n", MTRX, windows[MTRX].opt1,
    windows[MTRX].width, windows[MTRX].height, windows[MTRX].x,
    windows[MTRX].y);
  fprintf(envptr, "%d %d %d %d %d %d %d\n", KIVT, windows[KIVT].opt1,
    windows[KIVT].width, windows[KIVT].height, windows[KIVT].x,
    windows[KIVT].y, windows[KVTB].opt1);
  for(i=TSKS; i<=UTLC; i++)
    fprintf(envptr, "%d %d %d %d %d %d\n", i, windows[i].opt1,
      windows[i].width, windows[i].height, windows[i].x, windows[i].y);
  fprintf(envptr, "%d %d %d %d %d %d %d %d\n", NINF, windows[NINF].opt1,
    windows[NINF].width, windows[NINF].height, windows[NINF].x,
    windows[NINF].y, windows[SNDB].opt1, windows[STYB].opt1);
  fprintf(envptr, "%d %d %d %d %d %d %d\n", TRAF, windows[TRAF].opt1,
    windows[TRAF].width, windows[TRAF].height, windows[TRAF].x,
    windows[TRAF].y, windows[SIZB].opt1);
  fprintf(envptr, "%d %d %d %d %d %d\n", PSTA, windows[PSTA].opt1,
    windows[PSTA].width, windows[PSTA].height, windows[PSTA].x, 
    windows[PSTA].y);
  fprintf(envptr, "%d %d %d %d %d %d %d\n", QUEU, windows[QUEU].opt1,
    windows[QUEU].width, windows[QUEU].height, windows[QUEU].x,
    windows[QUEU].y, windows[MESB].opt1);
  for(i=TSKC; i<=PHPT; i++)
    fprintf(envptr, "%d %d %d %d %d %d\n", i, windows[i].opt1,
      windows[i].width, windows[i].height, windows[i].x, windows[i].y);
  fprintf(envptr, "%d %d %d %d %d %d %d %d\n", NTWK, windows[NTWK].opt1,
    windows[NTWK].width, windows[NTWK].height, windows[NTWK].x,
    windows[NTWK].y, windows[NTYB].opt1, windows[NOPB].opt1);
  fprintf(envptr, "%d %d %d %d %d %d %d\n", PROF, windows[PROF].opt1,
    windows[PROF].width, windows[PROF].height, windows[PROF].x,
    windows[PROF].y, windows[CPFB].opt1);
  fprintf(envptr, "%d %d %d %d %d %d %d\n", STRK, windows[STRK].opt1,
    windows[STRK].width, windows[STRK].height, windows[STRK].x,
    windows[STRK].y, windows[SRKB].opt1);
  fprintf(envptr, "%d %d %d %d %d %d\n", UTMT, windows[UTMT].opt1,
    windows[UTMT].width, windows[UTMT].height, windows[UTMT].x, 
    windows[UTMT].y);
  fprintf(envptr, "%d %d %d %d %d %d %d\n", CMMT, windows[CMMT].opt1,
    windows[CMMT].width, windows[CMMT].height, windows[CMMT].x,
    windows[CMMT].y, windows[MTRB].opt1);
  fprintf(envptr, "%d %d %d %d %d %d\n", SLID, windows[SLID].opt1,
    windows[SLID].width, windows[SLID].height, windows[SLID].x, 
    windows[SLID].y);
  fprintf(envptr, "%d %d %d %d %d %d\n", TRAC, windows[TRAC].opt1,
    windows[TRAC].width, windows[TRAC].height, windows[TRAC].x, 
    windows[TRAC].y);
  fprintf(envptr, "%d %d %d %d %d %d\n", STTS, windows[STTS].opt1,
    windows[STTS].width, windows[STTS].height, windows[STTS].x, 
    windows[STTS].y);
  for(i=CLOK; i<=INFO; i++)
    fprintf(envptr, "%d %d %d %d\n", i, windows[i].opt1, windows[i].x, 
    windows[i].y);
  fprintf(envptr, "%d %d %d %d %d\n", LGND, windows[LGND].opt1,
    windows[LGND].x, windows[LGND].y, windows[CODB].opt1);
  fprintf(envptr, "%d %d %d %d %d\n", FLBR, windows[FLBR].opt1,
    windows[FLBR].x, windows[FLBR].y);
  for(i=TMEN; i<=OMEN; i++)
    fprintf(envptr, "%d %d %d %d\n", i, windows[i].opt1, windows[i].x, 
    windows[i].y);
  fprintf(envptr, "%d %d %d\n", MENU, windows[MENU].x, windows[MENU].y);
  fprintf(envptr, "%d %d\n", SINC, step_inc);
  fprintf(envptr, "%d %d\n", ORDB, windows[ORDB].opt1);
  fprintf(envptr, "%d %d\n", SCRB, windows[SCRB].opt1);
  fprintf(envptr, "%d %d\n", DSTB, windows[DSTB].opt1);
  fprintf(envptr, "%d %s\n", SPRT, print_command);
  fprintf(envptr, "%d %d\n", TSTP, windows[TSTP].opt1);
  fprintf(envptr, "%d %s\n", PATB, pat_str);
  fclose(envptr);
}
ms_net(net, n_p, n_s)
        int net, *n_p, *n_s;
{
/*
        Generate nodes for multistage network.
        Input: network choice and number of processors.
        net = 0 : Butterfly
              1 : Gray Code
              2 : Hypercube
              3 : Omega
              4 : Baseline
              5 : Binary Tree
              6 : Quadtree
              7 : Mesh
              8 : Crossbar
        Output: number of processors, number of stages, node_stage
        array and its inverse ns_inv.  Number of processors returned
        in n_p may be altered; for example it will be next higher power
        of two for some networks if input number is not already a power
        of two.  node_stage array contains appropriate values for
        printing processor numbers, while ns_inv array contains
        values needed for locating drawing points.
*/
        int s, p, log_p, half_p, i, j, k, q, ck, qk;
        extern int max_hops, **node_stage, **ns_inv;

switch (net) {

case 0 :        /* butterfly */
case 1 :        /* gray code */
case 2 :        /* hypercube */
case 3 :        /* omega     */
case 4 :        /* baseline  */
        log_p = -1;
        for (i = *n_p; i > 0; i>>=1) log_p++;
        p = 1<<log_p;
        if (p < *n_p) {
                p <<= 1;
                log_p++;
        }
        s = log_p + 1;
        half_p = p/2;
        max_hops = log_p;
        break;

case 5 :        /* binary tree */
        log_p = -1;
        for (i = *n_p; i > 0; i>>=1) log_p++;
        p = 1<<log_p;
        if (p < *n_p) {
                p <<= 1;
                log_p++;
        }
        s = log_p + 1;
        max_hops = 2*log_p;
        break;

case 6 :        /* quadtree */
        log_p = -1;
        for (i = *n_p; i > 0; i>>=1) log_p++;
        p = 1<<log_p;
        if (p < *n_p) {
                p <<= 1;
                log_p++;
        }
        s = log_p/2 + log_p%2 + 1;
        max_hops = 2*(s-1);
        break;

case 7 :        /* mesh */
/*
   The values defined here for p, s, and col_maj with the mesh layout
   are just plausible values to use for testing; the true values should
   be determined according to the user's preference and set during the
   call to ms_net by user interaction analogous to that with the mesh
   layout option in Animation (i.e., the user will choose the desired
   aspect ratio and col- or row-major order using buttons).
*/
        log_p = -1;
        for (i = *n_p; i > 0; i>>=1) log_p++;
        s = num_nodes/windows[NMSB].opt2;
        p = windows[NMSB].opt2;
        max_hops = p + s - 2;
        break;

case 8 :        /* crossbar */
        p = *n_p + 1;
        s = p;
        max_hops = (*n_p)*2;
        break;
}

node_stage = (int **)malloc(p*sizeof(int *));
for (i = 0; i < p; i++)
        node_stage[i] = (int *)malloc(s*sizeof(int));
ns_inv = (int **)malloc(p*sizeof(int *));
for (i = 0; i < p; i++)
        ns_inv[i] = (int *)malloc(s*sizeof(int));

switch (net) {

case 0 :        /* butterfly */
        for (j = 0; j < s; j++) {
                for (i = 0; i < p; i++) {
                        node_stage[i][j] = i;
                }
        }
        break;

case 1 :        /* gray code */
        for (j = 0; j < s; j++) {
                for (i = 0; i < p; i++) {
                        node_stage[i][j] = (i>>1)^i;
                }
        }
        break;

case 2 :        /* hypercube */
        j = 0;
        for (i = 0; i < p ; i++)
                node_stage[i][j] = i;
        ck = half_p;
        for (j = 1; j < s; j++) {
                node_stage[0][j] = 0;
                node_stage[1][j] = ck;
                i = 2;
                qk = 1;
                for (q = 2; q < p; q *= 2) {
                        if (qk == ck) qk *= 2;
                        for (k = 0; k < q; k++) {
                                node_stage[i][j] = node_stage[i-q][j] + qk;
                                i++;
                        }
                        qk *= 2;
                }
                ck /= 2;
        }
        break;

case 3 :        /* omega */
        j = 0;
        for (i = 0; i < p ; i++)
                node_stage[i][j] = i;
        for (j = 1; j < s; j++) {
                for (i = 0; i < p; i++) {
                        k = node_stage[i][j-1];
                        node_stage[i][j] = k%2 ? (k-1)/2 + half_p : k/2;
                }
        }
        break;

case 4 :        /* baseline */
        j = s - 1;
        for (i = 0; i < p ; i++)
                node_stage[i][j] = i;
        ck = 1;
        for (j = s - 2; j >= 0; j--) {
                for (i = 0; i < 2*ck; i++) {
                        k = node_stage[i][j+1];
                        node_stage[i][j] = k < ck ? 2*k : 2*(k-ck) + 1;
                }
                ck *= 2;
                i = ck;
                for (q = ck; q < p; q *= 2) {
                        for (k = 0; k < q; k++) {
                                node_stage[i][j] = node_stage[i-q][j] + q;
                                i++;
                        }
                }
        }
        break;

case 5 :        /* binary tree */
case 6 :        /* quadtree    */
case 7 :        /* mesh        */
case 8 :        /* crossbar    */
        for (j = 0; j < s; j++) {
                for (i = 0; i < p; i++) {
                        node_stage[i][j] = i;
                }
        }
        break;

}
        for (j = 0; j < s; j++) {
                for (i = 0; i < p; i++) {
                        k = node_stage[i][j];
                        ns_inv[k][j] = i;
                }
        }
        if (net == 7) { /* redefine values for mesh */
                for (j = 0; j < s; j++) {
                        for (i = 0; i < p; i++) {
                                node_stage[i][j] = windows[NMOB].opt1 ?
                                        j*p + i : i*s + j;
                        }
                }
        }
        *n_p = p;
        *n_s = s;
}
frame()
{

  int ibuf, jbuf;

  if(myevent.xmotion.y>88){
    if((ibuf=flbr_width/(longf*6+8))==0) ibuf=1;;
    jbuf=(int)ceil(((double)no_files)/((double)ibuf));
    XDrawRectangle(mydisplay, windows[FLBR].window, gc[ERAS],
      2+(lastf/jbuf)*(longf*6+8), 46+(lastf%jbuf)*18, 
      longf*6+16, 16);
    lastf=(myevent.xmotion.x/(longf*6+8))*jbuf+
      (myevent.xmotion.y-88)/18;
    XDrawRectangle(mydisplay, windows[FLBR].window, gc[MENU],
      2+(lastf/jbuf)*(longf*6+8), 46+(lastf%jbuf)*18, 
      longf*6+16, 16);
  }
}
int rotate(what, num, dir)
  int what, num, dir;
{
  int val;

  if(dir) val=(what+1)%num;
  else val=(num+what-1)%num;
  return(val);
}
int choose(fname)
  char *fname;
{
  int i, j, k, m, n;
  char subwrd[50];

  for(i=0; i<num_wds; i++){
    k=0;
    for(j=0; k<strlen(fname) && j<strlen(wrd[i]); j++){
      if(wrd[i][j]!='*' && wrd[i][j]!='?'){
	if(fname[k]!=wrd[i][j]) break;
	else k++;
	if(j==strlen(wrd[i])-1 && k==strlen(fname)) return(1);
      }else if(wrd[i][j]=='*'){
	if(j!=strlen(wrd[i])-1){
	  for(m=j+1; m<strlen(wrd[i]); m++){
	    if(wrd[i][m]=='*' || wrd[i][m]=='?') break;
	    else subwrd[m-j-1]=wrd[i][m];
	  }
            while(k<strlen(fname)){
	      if(fname[k]==subwrd[0]){
		for(n=0; n<m-j && fname[k+n]==subwrd[n] && 
		    k+n<strlen(fname); n++);
		  if(n==m-j-1) {
		    if(k==strlen(fname)-1) return(1);
		    else break;
		  }
	      }
	      k++;
	    }
	  if(k==strlen(fname)) break;
	} else return(1);
	for(m=0; m<50; m++)
	  subwrd[m]=NULL;
      }else if(wrd[i][j]=='?'){
	k++;
	if(j==strlen(wrd[i])-1) return(1);
      }
    }
  }

  return(0);
}
double log_two(x)

double x;

{
        return(log(x)/0.69314718056);
}
