################################################################################

proc Setup { } {
   global entry1 entry2 pd pdname hostfile prefs
   
#-------------------------------------------------------------------------------
#  ADD HOST

   .f2.setup.menu add command -label "Add Host..." -acc "Ctrl-h" \
      -command {AddHostButton}

#-------------------------------------------------------------------------------
#  ADD HOSTS FROM HOSTFILE

   .f2.setup.menu add command -label "Add from Hostfile..." -command {
      .f4.l.listbox selection clear 0 end
      .f4.r.listbox selection clear 0 end
      TextWrite .f5.text ""
      IncrUndo
      AddHostFile .
      if {$nahf > 0} {
	 HostListboxWrite
	 HostListboxScroll1
	 GraphUpdate
         TextWrite .f5.text "$nahf hosts added from $hostfile"
      }
   }

#-------------------------------------------------------------------------------
#  COPY HOST

   .f2.setup.menu add command -label "Copy Host" -command {
      set index10 ""
      set index10 [.f4.l.listbox curselection]

      if {$index10!=""} {
	 TextWrite .f5.text ""
         IncrUndo
         foreach item $pdname {
            lappend pd($item) [lindex $pd($item) $index10]
         }
	 HostListboxWrite
	 HostListboxScroll1
	 GraphUpdate
	 UpdateButtons
      } else {
	 TextWrite .f5.text \
	    "You must first select a host from the Host list" 
      }
   }

#-------------------------------------------------------------------------------
#  MODIFY HOST

   .f2.setup.menu add command -label "Modify Host" -command {
      set index2 ""
      set index2 [.f4.l.listbox curselection]

      if {$index2!=""} {
	 TextWrite .f5.text ""
	 HostListboxScroll2 $index2
         AddHost [lindex $pd(hosts) $index2] [lindex $pd(cmnds) $index2] "MOD" $index2 .
      } else {
	 TextWrite .f5.text \
	    "You must first select a host from the Host list" 
      }
   }

#-------------------------------------------------------------------------------
#  DELETE HOST

   .f2.setup.menu add command -label "Delete Host" -command {
      .f4.r.listbox selection clear 0 end
      set index1 ""
      set index1 [.f4.l.listbox curselection]

      if {$index1!=""} {
	 TextWrite .f5.text ""
	 HostListboxScroll2 $index1
	 set pick 0
         if {$prefs(CONFIRM)=="On"} {set pick [Dialog .d {PADE Question} \
            {Delete the host and all its commands and files?} \
            questhead 0 {Yes} {No}]}

         if {$pick==0} {
            IncrUndo
            foreach item $pdname {
               set pd($item) [lreplace $pd($item) $index1 $index1]
            }
            HostListboxWrite
            GraphUpdate
            FilesListboxWrite
            UpdateButtons
         }
      } else {
	 TextWrite .f5.text \
	    "You must first select a host from the Host list" 
      }
   }

#-------------------------------------------------------------------------------
#  SETUP FILES

   .f2.setup.menu add separator
   .f2.setup.menu add command -label "Setup Files..." -acc "Ctrl-f" \
      -command {SetupFilesButton}
}

################################################################################

proc AddHost {hstnam hstcmd astmpmode astmpindex astmpfromw {w .addhst}} {
   global pd colors lastcmd
   global entry1 entry2 env ahmode ahindex ahfromw
   
   set ahmode $astmpmode
   set ahindex $astmpindex
   set ahfromw $astmpfromw

#  CHECK IF THE WINDOW EXISTS, IF NOT CREATE IT
   if {![winfo exists .addhst]} {

   catch {destroy $w}
   toplevel $w
   if {$ahmode=="ADD"} {
      wm title $w "PADE Add Host"
      wm iconname $w "Add Host"
   } elseif {$ahmode=="MOD"} {
      wm title $w "PADE Modify Host"
      wm iconname $w "Modify Host"
   }
   wm geometry $w +200+625
   wm iconbitmap $w @$env(PADE_ROOT)/pade/pade_icon.xbm
   $w config -cursor {arrow red white}

   tkwait visibility $w

   frame   $w.f1 -bd 1 -relief raised
   frame   $w.f2 -bd 1 -relief raised
   frame   $w.f3 -bd 1 -relief raised
   frame   $w.f4 -bd 1 -relief raised

   label   $w.f1.msg -text "Host name:"
   entry   $w.f1.entry -textvariable hostname -relief sunken -width 55
   pack    $w.f1.msg -side left -expand 1 -padx 2m -pady 5m -anchor w
   pack    $w.f1.entry -side right -expand 1 -padx 2m -pady 5m -anchor e
   $w.f1.entry delete 0 end
   $w.f1.entry insert 0 $hstnam

   label   $w.f2.msg -text "Host commands:"
   entry   $w.f2.entry -textvariable compilecmd -relief sunken -width 55
   pack    $w.f2.msg -side left -expand 1 -padx 2m -pady 5m -anchor w
   pack    $w.f2.entry -side left -expand 1 -padx 2m -pady 5m -anchor e
   $w.f2.entry delete 0 end
   $w.f2.entry insert 0 $hstcmd

   text	   $w.f3.text -height 1 -fg $colors(TEXT) -width 1 -state disabled \
      -relief flat
   pack    $w.f3.text -fill x -expand 1

#------------------------------------------------------------------------------
#  CLEAR NAME
   button  $w.f4.clear1 -text "Clear Name" -command {
      TextWrite .addhst.f3.text ""
      .addhst.f1.entry delete 0 end
      set hostname ""
      focus .addhst.f1.entry
   }

#------------------------------------------------------------------------------
#  CLEAR COMMANDS
   button  $w.f4.clear2 -text "Clear Commands" -command {
      TextWrite .addhst.f3.text ""
      .addhst.f2.entry delete 0 end
      set compilecmd ""
      focus .addhst.f2.entry
   }

#------------------------------------------------------------------------------
#  LAST COMMAND
   button  $w.f4.lastcmd -text "Last Command" -command {
      TextWrite .addhst.f3.text ""
      .addhst.f2.entry delete 0 end
      .addhst.f2.entry insert 0 $lastcmd
   }

#------------------------------------------------------------------------------
#  APPLY
   button  $w.f4.apply -text "Apply" -command {
      TextWrite .addhst.f3.text ""
      set hostname [string trim $hostname]
      set entry1 $hostname
      set iblank 0

#  check for blanks in host name
      if {[string first " " $hostname]!=-1} {
         TextWrite .addhst.f3.text "The host name has a blank in it"
         return
      }
      set entry2 $compilecmd
      set lastcmd $compilecmd

#  host name is valid
      if {$entry1!=""} {
         if {[winfo exists .selsav]} {destroy .selsav}
         IncrUndo

#  adding host
         if {$ahmode=="ADD"} {
            lappend pd(hosts) $entry1
            lappend pd(cmnds) $entry2
            if {$entry2 == ""} {
               lappend pd(hslct) 0
            } else {
               lappend pd(hslct) 1
            }
            lappend pd(files) {}
            lappend pd(fslct) {}

#  modifying host
         } elseif {$ahmode=="MOD"} {
            set pd(hosts) [lreplace $pd(hosts) $ahindex $ahindex $entry1]
            set pd(cmnds) [lreplace $pd(cmnds) $ahindex $ahindex $entry2]
            if {$entry2 == ""} {
               set pd(hslct) [lreplace $pd(hslct) $ahindex $ahindex 0]
            } 
         }

#  print messages
         if {$ahmode=="ADD"} {
            set len [expr [llength $pd(hosts)]-1]
            .f4.l.listbox selection set $len $len
            focus .addhst.f1.entry
         } elseif {$ahmode=="MOD"} {
            .f4.l.listbox selection set $ahindex $ahindex
           if {[winfo exists .graph]} {
               TextWrite .graph.f2.text "Modified host: $entry1"
            }
         }

#  update things
         HostListboxWrite
         HostListboxScroll1
         .f4.r.listbox selection clear 0 end
         GraphUpdate
	 UpdateButtons
	 FilesListboxWrite
	 if {$lastcmd != ""} {
	    .addhst.f4.lastcmd configure -state normal
	 } else {
	    .addhst.f4.lastcmd configure -state disabled
	 }

#  destroy window if modifying
         if {$ahmode=="MOD"} {destroy .addhst}
      }
   }

#------------------------------------------------------------------------------
#  CLOSE
   button  $w.f4.close -text "Close" -command {
      destroy .addhst
   }

#------------------------------------------------------------------------------
   pack  $w.f4.clear1 $w.f4.clear2 $w.f4.lastcmd $w.f4.apply $w.f4.close \
      -side left -expand 1 -padx 3m -pady 4m -ipadx 2m -ipady 1m
   pack  $w.f1 $w.f2 $w.f3 -anchor w -fill x
   pack  $w.f4 -fill x

   focus $w.f1.entry

   bind $w.f1.entry <Return> {
      set hostname [string trim $hostname]
      focus .addhst.f2.entry
   }
   bind $w.f1.entry <Tab> {
      set hostname [string trim $hostname]
      focus .addhst.f2.entry
   }
   bind $w.f2.entry <Return> {set compilecmd [string trim $compilecmd]}
   bind $w.f2.entry <Tab> {
      focus .addhst.f1.entry
      set compilecmd [string trim $compilecmd]
   }
   
   ConfigColorText $w
   if {$lastcmd != ""} {
      $w.f4.lastcmd configure -state normal
   } else {
      $w.f4.lastcmd configure -state disabled
   }
   tkwait window $w
   
#------------------------------------------------------------------------------
#  The window is already opened, so just update with the variables that were
#  passed in.

   } else {
      $w.f1.entry delete 0 end
      $w.f1.entry insert 0 $hstnam
      $w.f2.entry delete 0 end
      $w.f2.entry insert 0 $hstcmd
      focus $w.f1.entry
      if {$ahmode=="ADD"} {
	 wm title $w "PADE Add Host"
	 wm iconname $w "Add Host"
      } elseif {$ahmode=="MOD"} {
	 wm title $w "PADE Modify Host"
	 wm iconname $w "Modify Host"
      }
   }
}

################################################################################

proc AddHostFile {fromw} {
   global pd
   global hostfile nahf prefs

   set hosttemp [fileselect "Select a hostfile" $prefs(FILE_PATH)/]
   if {$hosttemp!="" && ![file isfile $hosttemp]} {
      if {$fromw == "."} {
	 TextWrite .f5.text "$hosttemp is not a file"
      } elseif {$fromw == ".graph"} {
	 TextWrite $fromw.f2.text "$hosttemp is not a file"
      }
   } else {
      set hostfile $hosttemp
   }

   set nahf 0
   if {$hostfile!=""} {
      set f_hostfile [open "$hostfile" r]
      set notdone [gets $f_hostfile line]
      while {$notdone >= 0} {
	 set write 0
	 if {$line!=""} {
            set line [string trim $line]
            set fblank [string first " " $line]
            if {$fblank == -1} {
               set write 1
            } else {
               set fchar [string index $line 0]
               if {$fchar!="#" && $fchar!="*" } {
        	  set line [lindex [split $line " "] 0]
        	  set write 1
               }
            }
	 } 
	 if {$write} {
            if {[winfo exists .selsav]} {destroy .selsav}
            lappend pd(hosts) $line
            lappend pd(cmnds) {}
            lappend pd(hslct) 1
            lappend pd(files) {}
            lappend pd(fslct) {}
            incr nahf
	 }
	 set notdone [gets $f_hostfile line]
      }
   }
   HostListboxWrite
   UpdateButtons
}

################################################################################

proc AddHostButton { } {
   global entry1
   
   .f4.l.listbox selection clear 0 end
   .f4.r.listbox selection clear 0 end
   TextWrite .f5.text ""
   set entry1 ""
   AddHost "" "" "ADD" "" .
}

################################################################################

proc SetupFilesButton { } {
   
   set index3 ""
   set index3 [.f4.l.listbox curselection]

   if {$index3!=""} {
      TextWrite .f5.text ""
      .f4.r.listbox selection clear 0 end
      AddFiles $index3
      .f4.l.listbox selection set $index3 $index3
   } else {
      TextWrite .f5.text \
	 "You must first select a host from the Host list" 
   }
}

