################################################################################

proc PrefsMenu { } {
   global entry1 nterm nweb nfbd pcmd uname prefs penv

#------------------------------------------------------------------------------
#  TERMINAL

   .f2.file.menu.prefs add cascade \
      -label "Terminal" -menu .f2.file.menu.prefs.term

   menu .f2.file.menu.prefs.term -tearoff 0

   set term_data dtterm
   if {$uname == "IRIX"}   {lappend term_data xwsh}
   set nomatch 1
   foreach item $term_data {if {$item==$prefs(TERM)} {set nomatch 0}}
   if {$nomatch} {lappend term_data $prefs(TERM)}

   set nterm 0
   foreach item $term_data {
      incr nterm
      .f2.file.menu.prefs.term add radiobutton -label $item\
	  -variable prefs(TERM) -value $item -command {
	 if {[FindCmd $prefs(TERM)]} {
            TextWrite .f5.text "Terminal is: $prefs(TERM)"
            set otherterm {}
	 } else {
	    TextWrite .f5.text \
	       "$prefs(TERM) not found in PATH environment variable"
            set otherterm {}
	 }
	 PvmmakeButtons
      }
   }

   .f2.file.menu.prefs.term add separator
   .f2.file.menu.prefs.term add radiobutton -label Other: -variable otherterm \
      -value Other -command {
      EntryBox 170 218 {Enter Terminal command:} ""
      if {$entry1 != ""} {
	 set prefs(TERM) $entry1
	 .f2.file.menu.prefs.term entryconfigure [expr $nterm+1] \
	    -label "Other: $prefs(TERM)"
         TextWrite .f5.text "Terminal is: $prefs(TERM)"
 	 PvmmakeButtons
     }
   }

#------------------------------------------------------------------------------
#  Web BROWSER

   .f2.file.menu.prefs add cascade \
      -label "Web Browser" -menu .f2.file.menu.prefs.web

   menu .f2.file.menu.prefs.web -tearoff 0

   set web_data {netscape}
   set nomatch 1
   foreach item $web_data {if {$item==$prefs(WEB)} {set nomatch 0}}
   if {$nomatch} {lappend web_data $prefs(WEB)}

   set nweb 0
   foreach item $web_data {
      incr nweb
      .f2.file.menu.prefs.web add radiobutton -label $item -variable prefs(WEB) \
	 -value $item -command {
	 if {[FindCmd $prefs(WEB)]} {
            TextWrite .f5.text "Web Browser is: $prefs(WEB)"
            .f2.help.menu entryconfigure 0 -state normal
            set otherweb {}
	 } else {
	    TextWrite .f5.text \
	       "$prefs(WEB) not found in PATH environment variable"
            .f2.help.menu entryconfigure 0 -state disabled
            set otherweb {}
	 }
      }
   }

   .f2.file.menu.prefs.web add separator
   .f2.file.menu.prefs.web add radiobutton -label Other: -variable otherweb \
      -value Other -command {
      EntryBox 170 218 {Enter Web Browser command:} ""
      if {$entry1 != ""} {
	 set prefs(WEB) $entry1
	 .f2.help.menu entryconfigure 0 -state normal
	 .f2.file.menu.prefs.web entryconfigure [expr $nweb+1] \
	    -label "Other: $prefs(WEB)"
         TextWrite .f5.text "Web browser is: $prefs(WEB)"
     }
   }

#------------------------------------------------------------------------------
#  FILE BROWSER DIRECTORY

   .f2.file.menu.prefs add cascade \
      -label "File Browser Default Path" -menu .f2.file.menu.prefs.fbd

   menu .f2.file.menu.prefs.fbd -tearoff 0

   set fbd_data ""
   if {$penv(PWD) != ""} {lappend fbd_data $penv(PWD)}
   if {$penv(HOME) != ""} {lappend fbd_data $penv(HOME)}
   set nomatch 1
   foreach item $fbd_data {if {$item==$prefs(FILE_PATH)} {set nomatch 0}}
   if {$nomatch} {lappend fbd_data $prefs(FILE_PATH)}

   set nfbd 0
   foreach item $fbd_data {
      incr nfbd
      .f2.file.menu.prefs.fbd add radiobutton -label $item\
	  -variable prefs(FILE_PATH) -value $item -command {
	 if {[file isdirectory $prefs(FILE_PATH)] || \
	    $prefs(FILE_PATH) == ""} {
            TextWrite .f5.text "File browser default path is: $prefs(FILE_PATH)"
            set otherfbd {}
	 } else {
	    TextWrite .f5.text \
	       "$prefs(FILE_PATH) is not a directory"
            set otherfbd {}
	 }
      }
   }

   .f2.file.menu.prefs.fbd add separator
   .f2.file.menu.prefs.fbd add radiobutton -label Other: -variable otherfbd \
      -value Other -command {
      EntryBox 170 218 {Enter File Browser default path:} ""
      if {$entry1 != ""} {
	 if {[file isdirectory $entry1]} {
	    set prefs(FILE_PATH) $entry1
	    .f2.file.menu.prefs.fbd entryconfigure [expr $nfbd+1] \
	       -label "Other: $prefs(FILE_PATH)"
            TextWrite .f5.text "File browser default path is: $prefs(FILE_PATH)"
            set otherfbd {}
	 } else {
	    TextWrite .f5.text \
	       "$entry1 is not a directory"
            set otherfbd {}
	 }
     }
   }

#------------------------------------------------------------------------------
#  CONFIRMATION DIALOG

   .f2.file.menu.prefs add cascade \
      -label "Confirmation Dialog" -menu .f2.file.menu.prefs.confirm

   menu .f2.file.menu.prefs.confirm -tearoff 0

   set confirm_data {On Off}
   foreach item $confirm_data {
      .f2.file.menu.prefs.confirm add radiobutton -label $item \
	 -variable prefs(CONFIRM) -value $item -command {
	 TextWrite .f5.text "Confirmation dialog is: $prefs(CONFIRM)"
      }
   }

#------------------------------------------------------------------------------
#  SAVE PREFERENCES
   .f2.file.menu.prefs add separator
   .f2.file.menu.prefs add command -label "Save Preferences" -command {
      SavePrefs
      TextWrite .f5.text "Preferences saved to ~/.paderc"
   }
}

################################################################################

proc SortAll {fromw} {
   global pd pdname
   
   $fromw config -cursor {watch red white}
   if {$fromw == "."} {.f4.r.listbox selection clear 0 end}
   update idletasks
   IncrUndo

#  sort hosts and find their host index in unsorted list
   set spd(hosts) [lsort $pd(hosts)]
   set shostind ""
   set maxhost -1
   foreach item $spd(hosts) {
      set isort -1
      foreach jtem $pd(hosts) {
         incr isort
         if {$item == $jtem} {
            set sortadd 1
            foreach ktem $shostind {
               if {$ktem == $isort} {set sortadd 0}
            }
            if {$sortadd} {
               lappend shostind $isort
               if {$isort > $maxhost} {set maxhost $isort}
            }
         }
      }
   }
   if {[expr $maxhost+1] != [llength $shostind]} {
      $fromw config -cursor {arrow red white}
      if {$fromw == "."} {
	 TextWrite .f5.text "Error sorting hosts"
      } elseif {$fromw == "."} {
	 TextWrite .graph.f2.text "Error sorting hosts"
      }
      update idletasks
      return
   }         

#  sort files and compile according to host index
   set spd(files) ""
   set spd(fslct) ""
   set spd(cmnds) ""
   set spd(hslct) ""
   DoLoop i 0 $maxhost {
      if {$fromw == "."} {
	 TextWrite .f5.text "Sorting host: [lindex $pd(hosts) $i]"
      } elseif {$fromw == ".graph"} {
	 TextWrite .graph.f2.text "Sorting host: [lindex $pd(hosts) $i]"
      }
      update idletasks
      lappend spd(cmnds) [lindex $pd(cmnds) [lindex $shostind $i]]
      lappend spd(hslct) [lindex $pd(hslct) [lindex $shostind $i]]

      set us(files) [lindex $pd(files) [lindex $shostind $i]]
      set us(fslct) [lindex $pd(fslct) [lindex $shostind $i]]
      set isort -1
      set usl(files) ""
      foreach item $us(files) {
         incr isort
         if {$isort%2 == 0} {lappend usl(files) $item}
      }
      set sl(files) [lsort $usl(files)]

      set sfileind ""
      set maxfile -1
      foreach item $sl(files) {
         set isort -1
         foreach jtem $usl(files) {
            incr isort
            if {$item == $jtem} {
               set sortadd 1
               foreach ktem $sfileind {
                  if {$ktem == $isort} {set sortadd 0}
               }
               if {$sortadd} {
                  lappend sfileind $isort
                  if {$isort > $maxfile} {set maxfile $isort}
               }
            }
         }
      }
      if {[expr $maxfile+1] != [llength $sfileind]} {
         $fromw config -cursor {arrow red white}
	 if {$fromw == "."} {
	    TextWrite .f5.text "Error sorting files"
	 } elseif {$fromw == "."} {
	    TextWrite .graph.f2.text "Error sorting files"
	 }
	 update idletasks
         return
      }         
      set ss(files) ""
      set ss(fslct) ""
      DoLoop j 0 $maxfile {
         lappend ss(files) [lindex $us(files) [expr 2*[lindex $sfileind $j]]]
         lappend ss(files) [lindex $us(files) [expr 2*[lindex $sfileind $j]+1]]
         lappend ss(fslct) [lindex $us(fslct) [expr 2*[lindex $sfileind $j]]]
         lappend ss(fslct) [lindex $us(fslct) [expr 2*[lindex $sfileind $j]+1]]
      }
      lappend spd(files) $ss(files)
      lappend spd(fslct) $ss(fslct)
   }

   foreach item $pdname {
      set pd($item) $spd($item)
   }

   HostListboxWrite
   FilesListboxWrite
   GraphUpdate
   UpdateButtons
   $fromw config -cursor {arrow red white}
   if {$fromw == "."} {
      TextWrite .f5.text ""
   } elseif {$fromw == ".graph"} {
      TextWrite .graph.f2.text ""
   }
   update idletasks
}

################################################################################

proc UpdateButtons { } {
   PadeButtons
   PVMButtons
   PvmmakeButtons
   FilesButtons
   GraphButtons
}

################################################################################

proc PadeButtons { } {
   global pd nundo pcmd napp

   if {$pd(hosts) == ""} {
      .f2.sort configure -state disabled
      .f2.setup.menu entryconfigure 3 -state disabled
      .f2.setup.menu entryconfigure 4 -state disabled
      .f2.setup.menu entryconfigure 5 -state disabled
      .f2.setup.menu entryconfigure 7 -state disabled
      .f2.file.menu entryconfigure 1 -state disabled
      .f2.file.menu entryconfigure 3 -state disabled
      .f2.file.menu entryconfigure 4 -state disabled
   } else {
      .f2.sort configure -state normal
      .f2.setup.menu entryconfigure 3 -state normal
      .f2.setup.menu entryconfigure 4 -state normal
      .f2.setup.menu entryconfigure 5 -state normal
      .f2.setup.menu entryconfigure 7 -state normal
      .f2.file.menu entryconfigure 1 -state normal
      .f2.file.menu entryconfigure 3 -state normal
      .f2.file.menu entryconfigure 4 -state normal
   }

   if {$nundo > 1} {
      .f2.undo configure -state normal
   } else {
      .f2.undo configure -state disabled
   }

   if {$pcmd(man)} {
      .f2.help.menu entryconfigure 1 -state normal
   } else {
      .f2.help.menu entryconfigure 1 -state disabled
   }
   
   if {$napp != 0} {
      .f2.apps.menu entryconfigure 1 -state normal
      .f2.apps.menu entryconfigure 2 -state normal
      .f2.apps.menu entryconfigure 4 -state normal
   } else {
      .f2.apps.menu entryconfigure 1 -state disabled
      .f2.apps.menu entryconfigure 2 -state disabled
      .f2.apps.menu entryconfigure 4 -state disabled
   }
}

################################################################################

proc PVMButtons { } {
   global hostfile pd penv pcmd

   if {$penv(PVM_ROOT) == "" || !$pcmd(pvm)} {
      .f2.pvm.menu entryconfigure 1 -state disabled
   }

   if {$penv(PVM_ROOT) == "" || !$pcmd(pvmd3)} {
      .f2.pvm.menu entryconfigure 2 -state disabled
   }

   if {!$pcmd(xpvm)} {
      .f2.pvm.menu entryconfigure 3 -state disabled
   }

   if {!$pcmd(pvmstat)} {.f2.pvm.menu entryconfigure 5 -state disabled}

   if {!$pcmd(pvmtidy)} {.f2.pvm.menu entryconfigure 6 -state disabled}

#   if {$hostfile != "" && [file isfile $hostfile]}
   if {$hostfile != ""} {
      set hostfilelab [file tail $hostfile]
      .f2.pvm.menu entryconfigure 8 -label "Pick Hostfile: $hostfilelab"
      .f2.pvm.menu entryconfigure 11 -state normal
   } else {
      .f2.pvm.menu entryconfigure 8 -label "Pick Hostfile..."
      .f2.pvm.menu entryconfigure 11 -state disabled
   }

   if {$pd(hosts) != ""} {
      .f2.pvm.menu entryconfigure 10 -state normal
   } else {
      .f2.pvm.menu entryconfigure 10 -state disabled
   }
}

###############################################################################

proc PvmmakeButtons { } {
   global pvmmakefile pcmd prefs pd
   
   if {$pd(hosts) != ""} {
      .f2.pvmmake.menu entryconfigure 1 -state normal
      .f2.pvmmake.menu entryconfigure 2 -state normal
   } else {
      .f2.pvmmake.menu entryconfigure 1 -state disabled
      .f2.pvmmake.menu entryconfigure 2 -state disabled
   }

   if {$pvmmakefile != "" && [file isfile $pvmmakefile]} {
      set pvmmakelab [file tail $pvmmakefile]
      .f2.pvmmake.menu entryconfigure 4 \
         -label "Pick Config File: $pvmmakelab"
      .f2.pvmmake.menu entryconfigure 6 -state normal
       if {$pcmd(pvmmake)} {
          .f2.pvmmake.menu entryconfigure 8 -state normal
          .f2.pvmmake.menu entryconfigure 9 -state normal
          .f2.pvmmake.menu entryconfigure 11 -state normal
          .f2.pvmmake.menu entryconfigure 12 -state normal
       } else {
          .f2.pvmmake.menu entryconfigure 8 -state disabled
          .f2.pvmmake.menu entryconfigure 9 -state disabled
          .f2.pvmmake.menu entryconfigure 12 -state disabled
          .f2.pvmmake.menu entryconfigure 13 -state disabled
       }
   } else {
      .f2.pvmmake.menu entryconfigure 4 -label "Pick Config File..."
      .f2.pvmmake.menu entryconfigure 6 -state disabled
      .f2.pvmmake.menu entryconfigure 8 -state disabled
      .f2.pvmmake.menu entryconfigure 9 -state disabled
      .f2.pvmmake.menu entryconfigure 11 -state disabled
      .f2.pvmmake.menu entryconfigure 12 -state disabled
   }
   
   .f2.pvmmake.menu entryconfigure 8 -label "Run  (in $prefs(TERM))"
   .f2.pvmmake.menu entryconfigure 11 -label "Save Config File and Run  (in $prefs(TERM))"
   .f2.apps.menu entryconfigure 5 -label "Run  (in $prefs(TERM))"
}

################################################################################

proc SetHostFile { } {
   global hostfile hosttemp sethostfile_ok

   if {$hosttemp != ""} {
      if {[file isdirectory $hosttemp] == "0"} {
         set hostfile $hosttemp
         set sethostfile_ok 1
      } else {
         TextWrite .f5.text "$hosttemp IS NOT A FILE"
         set sethostfile_ok 0
      }
   } else {
      set sethostfile_ok 1
   }

   PVMButtons

   return $sethostfile_ok
}

################################################################################

proc HostListboxWrite { } {
   global pd

   if {[winfo exists .]} {
      .f4.l.listbox delete 0 end
      foreach item $pd(hosts) {.f4.l.listbox insert end $item}
      .f4.r.listbox delete 0 end
      foreach item $pd(cmnds) {.f4.r.listbox insert end $item}
   }
}   

################################################################################

proc HostListboxScroll1 { } {
   .f4.l.listbox see end
   .f4.r.listbox see end
}

################################################################################

proc HostListboxScroll2 {index} {
   .f4.l.listbox see $index
   .f4.r.listbox see $index 
}

################################################################################

proc ScrollBoth {lists args} {
   foreach l $lists {
      eval {$l yview} $args
   }
}

################################################################################

proc IncrUndo { } {
   global pd pdsave pdname nundo

   incr nundo
   foreach item $pdname {
      set pdsave($item,$nundo) $pd($item)
   }
}

################################################################################

proc DecrUndo { } {
   global pd pdsave pdname nundo af af_index

   if {$nundo > 0} {
      if {[winfo exists .selsav]} {destroy .selsav}
      foreach item $pdname {
	 set pd($item) $pdsave($item,$nundo)
      }
      if {[winfo exists .addfiles]} {
         set af(files) [lindex $pd(files) $af_index]
         set af(fslct) [lindex $pd(fslct) $af_index]
      }
      incr nundo -1
   }
}

################################################################################

proc PdChanged { } {
   global pd pdopen pdname

   set pdchanged 0
   foreach item $pdname {
      if {$pdchanged == 0} {
         if {[string compare $pdopen($item) $pd($item)] != 0} {set pdchanged 1}
      }
   }
   return $pdchanged
}

################################################################################

proc PadeNew { } {
   global pd pdopen pdname
   global padefile pvmmakefile 
   
   TextWrite .f5.text ""
   if {[PdChanged]} {
      set pick [Dialog .d {PADE Question} \
         {Save current work before Clearing?} questhead 0 {Yes} {No} {Cancel}]
      if {$pick==0} {
         SavePadeFile 0
      } elseif {$pick==2} {
         return
      }
   }
   if {$pd(hosts) != ""} {IncrUndo}
   foreach item $pdname {
      set pd($item) ""
      set pdopen($item) ""
   }
   set padefile ""
   set pvmmakefile ""

   HostListboxWrite
   FilesListboxWrite
   UpdateButtons
   GraphUpdate
}

################################################################################

proc PadeOpen { } {
   global pd
   
   if {$pd(hosts) != ""} {IncrUndo}
   if {[winfo exists .addfiles]} {destroy .addfiles}
   if {[winfo exists .addfil]} {destroy .addfil}
   OpenPadeFile 1

   HostListboxWrite
   UpdateButtons
   GraphUpdate
}

################################################################################

proc PadeSave { } {
   SavePadeFile 0
   PvmmakeButtons
}

################################################################################

proc PadeExit { } {
   global pd penv pcmd prefs
   TextWrite .f5.text ""
   if {[PdChanged] && $pd(hosts) != ""} {
      set pick [Dialog .d {PADE Question} \
         {Save current work before Exiting?} questhead 0 {Yes} {No} {Cancel}]
      if {$pick==0} {
         SavePadeFile 0
      } elseif {$pick==2} {
         return
      }
   }

   exit
}

################################################################################

proc PadeShortcuts { } {

   bind all <Control-n> {PadeNew}
   bind all <Control-o> {PadeOpen}
   bind all <Control-s> {PadeSave}
   bind all <Control-q> {PadeExit}
   bind all <Control-h> {AddHostButton}
   bind all <Control-f> {SetupFilesButton}
    
}

################################################################################

proc AppRunButton { } {
   global prefs apps pause_cmd
   
   set appdex [.f2.apps.menu.run index active]
   exec $prefs(TERM) -geometry 80x30+170+218 -sl 20000 \
      -title "PADE App" -e sh -c "[lindex $apps $appdex]; $pause_cmd" &
}

################################################################################

proc AppModButton { } {
   global apps entry1
   
   set appdex [.f2.apps.menu.mod index active]
   EntryBox 170 218 {Enter application command:} [lindex $apps $appdex]
   if {$entry1 != ""} {
      set apps [lreplace $apps $appdex $appdex $entry1]
      .f2.apps.menu.mod entryconfigure $appdex -label $entry1
      .f2.apps.menu.del entryconfigure $appdex -label $entry1
      .f2.apps.menu.run entryconfigure [expr $appdex +1] -label $entry1
      SavePrefs
   } 
}

################################################################################

proc AppDelButton { } {
   global apps entry1 napp
   
   set appdex [.f2.apps.menu.del index active]
   set apps [lreplace $apps $appdex $appdex]
   incr napp -1
   .f2.apps.menu.mod delete $appdex
   .f2.apps.menu.del delete $appdex
   .f2.apps.menu.run delete [expr $appdex +1]
   SavePrefs
   PadeButtons
}
